/*
 * Decompiled with CFR 0.152.
 */
package com.wb.tool;

import com.wb.tool.Query;
import com.wb.util.DbUtil;
import com.wb.util.JsonUtil;
import com.wb.util.StringUtil;
import com.wb.util.WebUtil;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class Updater {
    public HttpServletRequest request;
    public String jndi;
    public String type;
    public String transaction;
    public boolean batchUpdate;
    public boolean uniqueUpdate = true;
    public String isolation;
    public String tableName;
    public String sqlInsert;
    public String sqlUpdate;
    public String sqlDelete;
    public String paramInsert;
    public String paramUpdate;
    public String paramDelete;
    public String mode;
    public boolean ignoreBlob = false;
    public boolean useExistFields = true;
    public String whereFields;
    public JSONObject fieldsMap;

    public void run() throws Exception {
        String sql;
        JSONArray destroyData = null;
        JSONArray createData = null;
        JSONArray updateData = null;
        JSONObject fields = null;
        if (StringUtil.isEmpty(this.mode)) {
            String params = WebUtil.fetch(this.request, StringUtil.select(this.paramDelete, "destroy"));
            if (!StringUtil.isEmpty(params)) {
                destroyData = new JSONArray(params);
                if (this.useExistFields && fields == null && destroyData.length() > 0) {
                    fields = destroyData.getJSONObject(0);
                    this.param2Request(this.request, fields);
                }
            }
            if (!StringUtil.isEmpty(params = WebUtil.fetch(this.request, StringUtil.select(this.paramInsert, "create")))) {
                createData = new JSONArray(params);
                if (this.useExistFields && fields == null && createData.length() > 0) {
                    fields = createData.getJSONObject(0);
                }
            }
            if (!StringUtil.isEmpty(params = WebUtil.fetch(this.request, StringUtil.select(this.paramUpdate, "update")))) {
                updateData = new JSONArray(params);
                if (this.useExistFields && fields == null && updateData.length() > 0) {
                    fields = updateData.getJSONObject(0);
                }
            }
        } else {
            JSONArray data;
            if (this.useExistFields) {
                fields = WebUtil.fetch(this.request);
                data = new JSONArray().put((Object)fields);
            } else {
                data = new JSONArray().put((Object)WebUtil.fetch(this.request));
            }
            if (this.mode.equals("delete")) {
                destroyData = data;
            } else if (this.mode.equals("update")) {
                updateData = data;
            } else {
                createData = data;
            }
        }
        if ((destroyData == null ? 0 : destroyData.length()) + (createData == null ? 0 : createData.length()) + (updateData == null ? 0 : updateData.length()) == 0) {
            return;
        }
        Query query = new Query();
        Connection connection = DbUtil.getConnection(this.request, this.jndi);
        boolean isCommit = "commit".equals(this.transaction);
        if ((isCommit || StringUtil.isEmpty(this.transaction)) && connection.getAutoCommit()) {
            this.transaction = "start";
        }
        if ("start".equals(this.transaction)) {
            DbUtil.startTransaction(connection, this.isolation);
        }
        query.request = this.request;
        query.jndi = this.jndi;
        query.type = this.type;
        query.batchUpdate = this.batchUpdate;
        query.transaction = "none";
        query.uniqueUpdate = this.uniqueUpdate;
        if (!StringUtil.isEmpty(this.tableName)) {
            JSONObject whereFieldsObj = StringUtil.isEmpty(this.whereFields) ? fields : JsonUtil.fromCSV(this.whereFields);
            String[] sqls = DbUtil.buildSQLsWb(this.jndi, this.tableName, this.ignoreBlob, 1, this.request, fields, whereFieldsObj, this.fieldsMap);
            if (StringUtil.isEmpty(this.sqlInsert)) {
                this.sqlInsert = sqls[0];
            }
            if (StringUtil.isEmpty(this.sqlUpdate)) {
                this.sqlUpdate = sqls[1];
            }
            if (StringUtil.isEmpty(this.sqlDelete)) {
                this.sqlDelete = sqls[2];
            }
        }
        if (!(StringUtil.isEmpty(this.sqlDelete) || "-".equals(this.sqlDelete) || destroyData == null || destroyData.length() <= 0 || (sql = this.sqlDelete).isEmpty())) {
            query.sql = sql;
            query.arrayData = destroyData;
            query.run();
        }
        if (!(StringUtil.isEmpty(this.sqlUpdate) || "-".equals(this.sqlUpdate) || updateData == null || updateData.length() <= 0 || (sql = this.sqlUpdate).isEmpty())) {
            query.sql = sql;
            query.arrayData = updateData;
            query.run();
        }
        if (!(StringUtil.isEmpty(this.sqlInsert) || "-".equals(this.sqlInsert) || createData == null || createData.length() <= 0 || (sql = this.sqlInsert).isEmpty())) {
            query.sql = sql;
            query.arrayData = createData;
            query.run();
            query.close();
        }
        if (isCommit) {
            connection.commit();
            connection.setAutoCommit(true);
        }
    }

    private void param2Request(HttpServletRequest request, JSONObject params) {
        Map defaultMap = params.toMap();
        Enumeration attributeNames = request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            if (!defaultMap.containsKey(attributeName)) continue;
            defaultMap.remove(attributeName);
        }
        for (Map.Entry entry : defaultMap.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            request.setAttribute(key, value);
        }
    }
}

