/*
 * Decompiled with CFR 0.152.
 */
package com.wb.tool;

import com.wb.common.Resource;
import com.wb.common.ScriptBuffer;
import com.wb.common.Var;
import com.wb.tool.Flow;
import com.wb.util.DateUtil;
import com.wb.util.DbUtil;
import com.wb.util.JsonUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Route {
    private static final Logger log = LoggerFactory.getLogger(Route.class);
    public JSONObject flow;
    private JSONArray allNodes;
    private JSONArray connections;
    private JSONObject data;
    private static boolean isNeedFlowPush = false;

    static {
        isNeedFlowPush = Var.getBool("sys.flow.isNeedFlowPush");
        log.info("\u662f\u5426\u9700\u8981\u6d41\u7a0b\u63a8\u9001isNeedFlowPush:" + isNeedFlowPush);
    }

    public Route(JSONObject jo, JSONObject tpl) {
        this.flow = tpl;
        this.allNodes = this.getNodes(tpl);
        this.connections = tpl.getJSONArray("conn");
        jo.put("FLOW_XTPL", (Object)tpl.toString());
        this.data = jo;
    }

    public JSONArray getCurrentNodes() {
        return (JSONArray)this.data.opt("CURRENT_NODES");
    }

    public void move(String src, String dst) throws Exception {
        JSONArray currentNodes = this.getCurrentNodes();
        int fromIndex = JsonUtil.indexOf(currentNodes, src);
        if (fromIndex == -1) {
            throw new Exception("Node \"" + src + "\" is not active.");
        }
        JSONObject dstObj = JsonUtil.findObject(this.allNodes, "label", dst);
        if (dstObj == null) {
            throw new Exception("Node \"" + dst + "\" does not exist.");
        }
        currentNodes.put(fromIndex, (Object)dst);
    }

    public void to(String name) throws Exception {
        String[] names = new String[]{name};
        this.deactivateAll();
        this.activate(names);
    }

    public void activate(String[] names) throws Exception {
        JSONArray currentNodes = this.getCurrentNodes();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            JSONObject obj = JsonUtil.findObject(this.allNodes, "label", n3);
            if (obj == null) {
                throw new Exception("Node \"" + n3 + "\" does not exist.");
            }
            if (JsonUtil.indexOf(currentNodes, n3) == -1) {
                currentNodes.put((Object)n3);
            }
            ++n2;
        }
    }

    public void deactivate(String[] names) {
        JSONArray currentNodes = this.getCurrentNodes();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            int i = JsonUtil.indexOf(currentNodes, n3);
            if (i != -1) {
                currentNodes.remove(i);
            }
            ++n2;
        }
    }

    public void deactivateAll() {
        JSONArray currentNodes = this.getCurrentNodes();
        int j = currentNodes.length();
        int i = j - 1;
        while (i >= 0) {
            currentNodes.remove(i);
            --i;
        }
    }

    public void pause() {
        this.data.put("paused", true);
    }

    public void resume() {
        this.data.put("paused", false);
    }

    public void remove(HttpServletRequest request) throws Exception {
        Flow.remove((String)this.get("ROUTE_ID"), request);
    }

    public boolean isPaused() {
        return this.data.optBoolean("paused", false);
    }

    public void set(String name, Object value) throws Exception {
        if (value instanceof Date) {
            value = DateUtil.dateToStr((Date)value);
        } else if (value instanceof InputStream) {
            String id = SysUtil.getId();
            Resource.set(id, this.getBytes((InputStream)value));
            value = "@@blob." + id;
        } else if (value instanceof byte[]) {
            String id = SysUtil.getId();
            Resource.set(id, (byte[])value);
            value = "@@byte." + id;
        } else if (value instanceof Object[]) {
            value = new JSONArray((Object)((Object[])value)).toString();
        }
        this.data.put(name, value);
    }

    public void set(HttpServletRequest request) throws Exception {
        JSONObject items = WebUtil.fetch(request);
        Set es = items.entrySet();
        for (Map.Entry e : es) {
            this.set((String)e.getKey(), e.getValue());
        }
    }

    public Object get(String name) {
        Object value = this.data.opt(name);
        if (value instanceof String) {
            String prefix = (String)value;
            if (prefix.startsWith("@@blob.")) {
                value = new ByteArrayInputStream(Resource.getBytes(prefix.substring(7), null));
            } else if (prefix.startsWith("@@byte.")) {
                value = Resource.getBytes(prefix.substring(7), null);
            }
        }
        return value;
    }

    public JSONObject get() {
        return this.data;
    }

    private byte[] getBytes(InputStream is) throws Exception {
        ByteArrayOutputStream bos;
        try {
            bos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)is, (OutputStream)bos);
        }
        finally {
            is.close();
        }
        return bos.toByteArray();
    }

    public boolean forward(HttpServletRequest request) throws Exception {
        int j = this.connections.length();
        String activeNode = this.getCurrentNodes().optString(0);
        String[] nodes = new String[]{""};
        this.set("xLastNode", activeNode);
        int i = 0;
        while (i < j) {
            JSONObject xprop;
            String condi;
            JSONObject jo = this.connections.getJSONObject(i);
            if (jo.optString("src").equals(activeNode) && (StringUtil.isEmpty(condi = (xprop = jo.optJSONObject("xprop")).optString("\u6761\u4ef6")) || Boolean.parseBoolean(ScriptBuffer.run(request, WebUtil.replaceParams(request, "return " + condi)).toString()))) {
                nodes[0] = jo.optString("dst");
                this.deactivateAll();
                this.activate(nodes);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean backward(HttpServletRequest request) throws Exception {
        return false;
    }

    private JSONArray getNodes(JSONObject template) {
        JSONArray nodes = new JSONArray();
        JSONArray list = template.getJSONArray("list");
        int j = list.length();
        int i = 0;
        while (i < j) {
            JSONObject obj = list.getJSONObject(i);
            if (obj.getBoolean("isObj")) {
                obj.remove("box");
                nodes.put((Object)obj);
            }
            ++i;
        }
        return nodes;
    }

    public void commit(HttpServletRequest request) throws Exception {
        Connection conn = null;
        PreparedStatement st = null;
        Date date = new Date();
        String routeId = this.data.optString("ROUTE_ID");
        String userId = this.data.optString("sys.user", "-");
        JSONArray currentNodes = this.getCurrentNodes();
        String activeNode = currentNodes == null ? "" : currentNodes.optString(0);
        try {
            conn = DbUtil.getConnection(request);
            st = conn.prepareStatement("delete from WB_ROUTE where ROUTE_ID=?");
            st.setString(1, routeId);
            st.executeUpdate();
            DbUtil.close(st);
            st = conn.prepareStatement("insert into WB_ROUTE values(?,?,?,?,?,?,?,?)");
            st.setString(1, routeId);
            st.setString(2, this.data.optString("FLOW_ID"));
            st.setTimestamp(3, new Timestamp(date.getTime()));
            st.setString(4, userId);
            st.setString(5, activeNode);
            st.setString(6, this.data.optString("TITLE", "-"));
            st.setString(7, this.data.optString("STATUS", "-"));
            DbUtil.setText(st, 8, this.data.toString());
            st.executeUpdate();
            this.set("MODIFY_DATE", date);
            this.set("USER_ID", userId);
            this.set("ACTIVE_NODE", activeNode);
            Route.sync(conn, routeId, this.data.optString("FLOW_ID"), date, userId, activeNode, this.data.optString("STATUS", "-"), this.data);
        }
        catch (Throwable throwable) {
            DbUtil.close(st);
            throw throwable;
        }
        DbUtil.close(st);
    }

    public static void syncBak(Connection conn, String routeId, String flowId, Date datetime, String userId, String activeNode, String status, JSONObject data) throws Exception {
        ArrayList<String> users = Route.getUsersFromObject(data.optString("xDoUser"));
        Route.updatePartBak(conn, "WB_ROUTE_PART", users, routeId, flowId, datetime, userId, activeNode, status, data, 1);
        users = Route.getUsersFromObject(data.optString("xCcUser"));
        Route.updatePartBak(conn, "WB_ROUTE_PART", users, routeId, flowId, datetime, userId, activeNode, status, data, 2);
        users = Route.getUsersFromArray(data.optString("xProcessUsers1"));
        Route.updatePartBak(conn, "WB_ROUTE_PART", users, routeId, flowId, datetime, userId, activeNode, status, data, 3);
        users = new ArrayList();
        users.add("dmy");
        Route.updatePartBak(conn, "WB_ROUTE_PART", users, routeId, flowId, datetime, userId, activeNode, status, data, 4);
        Route.updateRouteLine(conn, routeId, new JSONArray(StringUtil.select(data.optString("xRouteLine"), "[]")));
    }

    public static void sync(Connection conn, String routeId, String flowId, Date datetime, String userId, String activeNode, String status, JSONObject data) throws Exception {
        try {
            Class<?> FlowUtil = null;
            Method getFlowInst = null;
            Method doThreadExecute = null;
            Object preFlowInst = null;
            if (isNeedFlowPush) {
                FlowUtil = Class.forName("ks.fintech.flowpush.v2.utils.FlowUtil");
                getFlowInst = FlowUtil.getMethod("getFlowInst", String.class, Connection.class);
                doThreadExecute = FlowUtil.getMethod("doThreadExecute", Object.class, Object.class);
                preFlowInst = getFlowInst.invoke(FlowUtil.newInstance(), routeId, conn);
            }
            ArrayList<String> users = Route.getUsersFromObject(data.optString("xDoUser"));
            String sid = Route.clearToDo(conn, routeId, activeNode);
            Route.updatePart(conn, routeId, flowId, datetime, activeNode, status, data, sid);
            Route.addTypeUser(conn, users, 1, routeId, status, data);
            users = Route.getUsersFromObject(data.optString("xCcUser"));
            Route.addTypeUser(conn, users, 2, routeId, status, data);
            users = Route.getUsersFromArray(data.optString("xProcessUsers1"));
            Route.addTypeUser(conn, users, 3, routeId, status, data);
            users = new ArrayList();
            users.add("dmy");
            Route.addTypeUser(conn, users, 4, routeId, status, data);
            Route.updateRouteLine(conn, routeId, new JSONArray(StringUtil.select(data.optString("xRouteLine"), "[]")));
            if (isNeedFlowPush) {
                Object flowInst = getFlowInst.invoke(FlowUtil.newInstance(), routeId, conn);
                doThreadExecute.invoke(null, preFlowInst, flowInst);
            }
        }
        catch (Exception e) {
            log.error("Route-->sync", (Throwable)e);
        }
    }

    private static void updateRouteLine(Connection conn, String routeId, JSONArray routeLine) throws Exception {
        try (PreparedStatement st = null;){
            st = conn.prepareStatement("delete from WB_ROUTE_LINE where ROUTE_ID=? ");
            st.setString(1, routeId);
            st.executeUpdate();
            DbUtil.close(st);
            st = conn.prepareStatement("insert into WB_ROUTE_LINE (SID,ROUTE_ID, NODE,REC_DATE,DO_USER,EXP_USER ,ACT,XMEMO,OP_FLAG)   values(" + StringUtil.repeat("?,", 8) + "?)");
            int j = routeLine.length();
            int i = 0;
            while (i < j) {
                JSONObject obj = routeLine.getJSONObject(i);
                if (obj.has("node")) {
                    st.setString(1, SysUtil.getId());
                    st.setString(2, routeId);
                    st.setString(3, obj.optString("node"));
                    st.setTimestamp(4, obj.optTimestamp("datetime"));
                    st.setString(5, obj.optString("user"));
                    st.setString(6, obj.optString("xPerson"));
                    st.setString(7, obj.optString("act"));
                    st.setString(8, obj.optString("xMemo"));
                    st.setString(9, obj.optString("opFlag"));
                    st.addBatch();
                }
                ++i;
            }
            st.executeBatch();
        }
    }

    private static ArrayList<String> getUsersFromObject(String usersText) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtil.isEmpty(usersText)) {
            return list;
        }
        JSONObject users = new JSONObject(usersText);
        Set es = users.entrySet();
        for (Map.Entry e : es) {
            if (e.getValue() == JSONObject.NULL) {
                throw new Exception("\u627e\u4e0d\u5230\u6709\u6548\u7684\u63a5\u6536\u4eba");
            }
            list.add((String)e.getValue());
        }
        return list;
    }

    private static ArrayList<String> getUsersFromArray(String usersText) {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtil.isEmpty(usersText)) {
            return list;
        }
        JSONObject users = new JSONObject(usersText);
        HashSet<String> userMap = new HashSet<String>();
        Set es = users.entrySet();
        for (Map.Entry e : es) {
            JSONArray arr = (JSONArray)e.getValue();
            int j = arr.length();
            int i = 0;
            while (i < j) {
                userMap.add(arr.getString(i));
                ++i;
            }
        }
        list.addAll(userMap);
        return list;
    }

    private static void updatePartBak(Connection conn, String tablename, ArrayList<String> users, String routeId, String flowId, Date datetime, String userId, String activeNode, String status, JSONObject data, int type) throws Exception {
        try (Statement st = null;){
            if (type == 1) {
                st = conn.prepareStatement("delete from WB_ROUTE_PART where ROUTEID=? and TYPE<>2");
                st.setString(1, routeId);
                st.executeUpdate();
                DbUtil.close(st);
            }
            if (type < 3 && ("3".equals(data.optString("STATUS")) || "\u5f85\u5b50\u6d41\u7a0b\u5904\u7406".equals(status) || "99".equals(status) || "3".equals(status) || "\u5e9f\u5f03".equals(status))) {
                return;
            }
            st = conn.prepareStatement("insert into WB_ROUTE_PART(sid,routeid,recdate,xnormalnodetext,node,flow,flowid,lastuser,xlastbatchform,xstarteduser,defaultform,xmainrouteid,status,user_id,xdouser,routeline,allparams,type) values(" + StringUtil.repeat("?,", 17) + "?)");
            int j = users.size();
            int i = 0;
            while (i < j) {
                st.setString(1, SysUtil.getId());
                st.setString(2, routeId);
                st.setTimestamp(3, new Timestamp(datetime.getTime()));
                st.setString(4, data.optString("xNormalNodeText"));
                st.setString(5, activeNode);
                st.setString(6, data.optString("xNodeShowTitle"));
                st.setString(7, flowId);
                st.setString(8, data.optString("xLastProcessUser"));
                String flowXtpl = data.optString("FLOW_XTPL");
                if (!flowXtpl.isEmpty()) {
                    flowXtpl = JsonUtil.findObject(new JSONObject(flowXtpl).optJSONArray("list"), "label", activeNode).optJSONObject("xprop").optString("\u6279\u91cf\u5904\u7406\u8868\u5355");
                }
                st.setString(9, flowXtpl);
                st.setString(10, data.optString("xStartedUser"));
                st.setString(11, data.optString("xFlowDefaultForm"));
                st.setString(12, data.optString("xMainRouteId"));
                String statusValue = !StringUtil.isEmpty(status) ? status : ("\u7ed3\u675f".equals(activeNode) ? "\u7ed3\u675f" : "\u8fdb\u884c\u4e2d");
                st.setString(13, statusValue);
                st.setString(14, users.get(i));
                DbUtil.setText((PreparedStatement)st, 15, data.optString("xDoUser"));
                DbUtil.setText((PreparedStatement)st, 16, data.optString("xRouteLine"));
                DbUtil.setText((PreparedStatement)st, 17, data.toString());
                st.setInt(18, type);
                st.addBatch();
                ++i;
            }
            st.executeBatch();
        }
    }

    private static void updatePart(Connection conn, String routeId, String flowId, Date datetime, String activeNode, String status, JSONObject data, String sid) throws Exception {
        try (Statement st = null;){
            sid = sid == null ? SysUtil.getId() : sid;
            st = conn.prepareStatement("insert into WB_ROUTE_PART(sid,routeid,recdate,xnormalnodetext,node,flow,flowid,lastuser,xlastbatchform,xstarteduser,defaultform,xmainrouteid,status,user_id,xdouser,routeline,allparams,type) values(" + StringUtil.repeat("?,", 17) + "?)");
            st.setString(1, sid);
            st.setString(2, routeId);
            st.setTimestamp(3, new Timestamp(datetime.getTime()));
            st.setString(4, data.optString("xNormalNodeText"));
            st.setString(5, activeNode);
            st.setString(6, data.optString("xNodeShowTitle"));
            st.setString(7, flowId);
            st.setString(8, data.optString("xLastProcessUser"));
            String flowXtpl = data.optString("FLOW_XTPL");
            if (!flowXtpl.isEmpty()) {
                flowXtpl = JsonUtil.findObject(new JSONObject(flowXtpl).optJSONArray("list"), "label", activeNode).optJSONObject("xprop").optString("\u6279\u91cf\u5904\u7406\u8868\u5355");
            }
            st.setString(9, flowXtpl);
            st.setString(10, data.optString("xStartedUser"));
            st.setString(11, data.optString("xFlowDefaultForm"));
            st.setString(12, data.optString("xMainRouteId"));
            String statusValue = !StringUtil.isEmpty(status) ? status : ("\u7ed3\u675f".equals(activeNode) ? "\u7ed3\u675f" : "\u8fdb\u884c\u4e2d");
            st.setString(13, statusValue);
            st.setString(14, "-");
            DbUtil.setText((PreparedStatement)st, 15, data.optString("xDoUser"));
            DbUtil.setText((PreparedStatement)st, 16, data.optString("xRouteLine"));
            DbUtil.setText((PreparedStatement)st, 17, data.toString());
            st.setInt(18, 0);
            st.executeUpdate();
        }
    }

    private static void addTypeUser(Connection conn, ArrayList<String> users, int type, String partId, String status, JSONObject data) throws Exception {
        try (Statement st = null;){
            if (type < 3 && ("3".equals(data.optString("STATUS")) || "\u5f85\u5b50\u6d41\u7a0b\u5904\u7406".equals(status) || "99".equals(status) || "3".equals(status) || "\u5e9f\u5f03".equals(status))) {
                return;
            }
            if (users != null && !users.isEmpty()) {
                st = conn.prepareStatement("insert into WB_ROUTE_PART_TYPE_USER(SID,USER_ID,TYPE,ROUTEID) values(?,?,?,?)");
                for (String user : users) {
                    st.setString(1, SysUtil.getId());
                    st.setString(2, user);
                    st.setInt(3, type);
                    st.setString(4, partId);
                    st.addBatch();
                }
                st.executeBatch();
            }
        }
    }

    private static String clearToDo(Connection conn, String routeId, String activeNode) throws Exception {
        String sid = Route.getPreSid(conn, routeId, activeNode);
        try (PreparedStatement st = null;){
            st = conn.prepareStatement("delete from WB_ROUTE_PART where ROUTEID=? and TYPE=0");
            st.setString(1, routeId);
            st.executeUpdate();
            DbUtil.close(st);
            if (Var.getBool("sys.controls.savePartTypeUser")) {
                st = conn.prepareStatement("INSERT INTO WB_ROUTE_PART_TYPE_USER_BAK(SID,USER_ID,TYPE,ROUTEID)  SELECT SID,USER_ID,TYPE,ROUTEID FROM WB_ROUTE_PART_TYPE_USER where ROUTEID=? and TYPE<>2");
                st.setString(1, routeId);
                st.executeUpdate();
            }
            st = conn.prepareStatement("delete from WB_ROUTE_PART_TYPE_USER where ROUTEID=?");
            st.setString(1, routeId);
            st.executeUpdate();
        }
        return sid;
    }

    private static String getPreSid(Connection conn, String routeId, String activeNode) throws SQLException {
        try (PreparedStatement st = null;){
            String node;
            String sql = "select sid,node from WB_ROUTE_PART where ROUTEID=?";
            st = conn.prepareStatement(sql);
            st.setString(1, routeId);
            ResultSet executeQuery = st.executeQuery();
            if (executeQuery != null && executeQuery.next() && (node = executeQuery.getString(2)).equals(activeNode)) {
                String sid;
                String string = sid = executeQuery.getString(1);
                return string;
            }
        }
        return null;
    }

    public static void syncRouteLine(HttpServletRequest request) throws Exception {
        ResultSet rs = (ResultSet)DbUtil.run(request, "select ROUTE_ID,ROUTE_CONTENT from WB_ROUTE");
        Connection conn = DbUtil.getConnection(request);
        while (rs.next()) {
            String routeId = rs.getString(1);
            String content = DbUtil.getText(rs, 2);
            JSONObject jo = new JSONObject(content);
            JSONArray routeLine = new JSONArray(jo.optString("xRouteLine"));
            Route.updateRouteLine(conn, routeId, routeLine);
        }
    }
}

