/*
 * Decompiled with CFR 0.152.
 */
package com.wb.tool;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import com.ks.fintech.bw.support.SensitiveInfoFieldUtil;
import com.wb.common.DataPermBuffer;
import com.wb.common.Str;
import com.wb.common.Var;
import com.wb.common.XwlBuffer;
import com.wb.splogic.ParamsValMap;
import com.wb.splogic.util.AbstractDpControl;
import com.wb.splogic.util.ActionFactory;
import com.wb.thread.ExecLog;
import com.wb.tool.Console;
import com.wb.util.DbUtil;
import com.wb.util.JsonUtil;
import com.wb.util.LogUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import ks.fintech.bw.impl.role.KsResultSetImpl;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Query {
    private static final Logger logger = LoggerFactory.getLogger(Query.class);
    public HttpServletRequest request;
    public String sql;
    public String jndi;
    public String arrayName;
    public JSONArray arrayData;
    public boolean batchUpdate;
    public String type;
    public String loadParams;
    public String transaction;
    public String isolation;
    public boolean uniqueUpdate;
    public String errorText;
    private String debugSql;
    private String formattedSql;
    private ArrayList<Object[]> paramList;
    private ArrayList<String> paramValList;
    private int paramCount;
    private PreparedStatement statement;
    private Map<String, Object> paramValMap;

    public Object run() throws Exception {
        String functionId = "";
        String xwl = this.request.getParameter("xwl");
        String title = "";
        Serializable result = null;
        StringBuilder exceptionMsg = new StringBuilder();
        long beginTime = 0L;
        long endTime = 0L;
        try {
            Object logic;
            if (StringUtils.isNotEmpty((String)xwl)) {
                if (StrUtil.endWithIgnoreCase((CharSequence)xwl, (CharSequence)".xwl")) {
                    xwl = StrUtil.subPre((CharSequence)xwl, (int)xwl.indexOf(".xwl"));
                }
                title = XwlBuffer.get(String.valueOf(xwl) + ".xwl", true).optString("title");
                if (StringUtils.indexOf((String)xwl, (String)"/") > -1 && StringUtils.countMatches((String)xwl, (String)"/") >= 2) {
                    String[] su = StringUtils.split((String)xwl, (String)"/");
                    functionId = su[su.length - 2];
                    xwl = StringUtils.substringBeforeLast((String)xwl, (String)"/");
                } else {
                    functionId = xwl;
                }
            } else {
                xwl = this.request.getRequestURI();
            }
            this.checkProperties();
            boolean hasArray = this.arrayData != null || !StringUtil.isEmpty(this.arrayName);
            this.sql = this.sql.trim();
            this.replaceMacros();
            Connection connection = DbUtil.getConnection(this.request, this.jndi);
            boolean isCommit = "commit".equals(this.transaction);
            if (isCommit) {
                if (connection.getAutoCommit()) {
                    this.transaction = "start";
                }
            } else if (StringUtil.isEmpty(this.transaction) && (this.uniqueUpdate || hasArray) && connection.getAutoCommit()) {
                this.transaction = "start";
            }
            if ("start".equals(this.transaction)) {
                DbUtil.startTransaction(connection, this.isolation);
            }
            if (StringUtil.isEmpty(this.type)) {
                this.type = this.sql.startsWith("{") ? "call" : "execute";
            }
            boolean isCall = "call".equals(this.type);
            if (Var.getBool("sys.spLogic.isSpLogic") && isCall && (logic = this.runLogic(isCall, this.sql, this.request)) != null) {
                Object object = logic;
                return object;
            }
            try {
                this.statement = isCall ? connection.prepareCall(this.formattedSql) : connection.prepareStatement(this.formattedSql);
                if (Var.fetchSize != -1) {
                    this.statement.setFetchSize(Var.fetchSize);
                }
                WebUtil.setObject(this.request, SysUtil.getId(), this.statement);
                this.regParameters();
                beginTime = System.currentTimeMillis();
                if (hasArray) {
                    this.executeBatch();
                } else {
                    List impressionList;
                    if (Var.debug) {
                        this.printSql();
                    }
                    if (Var.sqlDebug) {
                        exceptionMsg.append("SQL\u3010" + StringUtil.toLine(this.formattedSql) + "\u3011");
                    }
                    if ("query".equals(this.type)) {
                        impressionList = SensitiveInfoFieldUtil.getdRole2ImpressionMap((List)SensitiveInfoFieldUtil.getDRoles((HttpServletRequest)this.request));
                        result = new KsResultSetImpl(this.statement.executeQuery(), impressionList);
                        WebUtil.setObject(this.request, SysUtil.getId(), result);
                    } else if ("update".equals(this.type)) {
                        int affectedRows = this.statement.executeUpdate();
                        result = affectedRows;
                        if (this.uniqueUpdate && affectedRows != 1) {
                            this.notUnique();
                        }
                    } else {
                        HashMap<String, Object> map;
                        boolean autoLoadParams;
                        boolean bl = autoLoadParams = StringUtil.isEmpty(this.loadParams) || "auto".equals(this.loadParams);
                        if (this.statement.execute()) {
                            if (autoLoadParams) {
                                this.loadParams = "none";
                            }
                            impressionList = SensitiveInfoFieldUtil.getdRole2ImpressionMap((List)SensitiveInfoFieldUtil.getDRoles((HttpServletRequest)this.request));
                            result = new KsResultSetImpl(this.statement.getResultSet(), impressionList);
                            WebUtil.setObject(this.request, SysUtil.getId(), result);
                        } else {
                            if (autoLoadParams) {
                                this.loadParams = "load";
                            }
                            int affectedRows = this.statement.getUpdateCount();
                            result = affectedRows;
                            if (this.uniqueUpdate && affectedRows != 1) {
                                this.notUnique();
                            }
                        }
                        if (isCall && this.paramCount > 0 && (map = this.getOutParameter("load".equals(this.loadParams))).size() > 0) {
                            if (map.containsKey("return")) {
                                throw new IllegalArgumentException("Invalid output parameter name \"return\"");
                            }
                            map.put("return", result);
                            result = map;
                        }
                    }
                }
                if (isCommit) {
                    connection.commit();
                    connection.setAutoCommit(true);
                }
                endTime = System.currentTimeMillis();
                this.checkError(result);
            }
            catch (SQLException e) {
                logger.error("", (Throwable)e);
                LogUtil.error(e.getMessage());
                if (Var.sqlDebug) {
                    exceptionMsg.append(e.getMessage());
                }
                throw new Exception(e);
            }
            catch (Exception e) {
                exceptionMsg.append(e.getMessage());
                throw new Exception(e);
            }
        }
        finally {
            endTime = System.currentTimeMillis();
            ThreadUtil.execute((Runnable)new ExecLog(this.type, functionId, WebUtil.fetch(this.request, "sys.username"), this.sql, title, xwl, this.paramValMap, "0", StringUtils.defaultIfBlank((String)exceptionMsg.toString(), (String)"\u6267\u884c\u6210\u529f\uff01"), endTime - beginTime));
        }
        return result;
    }

    private void checkProperties() {
        String[] isolations;
        String[] types;
        String[] params;
        String[] trans;
        if (!StringUtil.isEmpty(this.transaction) && StringUtil.indexOf(trans = new String[]{"start", "commit", "none"}, this.transaction) == -1) {
            throw new IllegalArgumentException("Invalid transaction \"" + this.transaction + "\".");
        }
        if (!StringUtil.isEmpty(this.loadParams) && StringUtil.indexOf(params = new String[]{"auto", "load", "none"}, this.loadParams) == -1) {
            throw new IllegalArgumentException("Invalid loadParams \"" + this.loadParams + "\".");
        }
        if (!StringUtil.isEmpty(this.type) && StringUtil.indexOf(types = new String[]{"query", "update", "execute", "call"}, this.type) == -1) {
            throw new IllegalArgumentException("Invalid type \"" + this.type + "\".");
        }
        if (!StringUtil.isEmpty(this.isolation) && StringUtil.indexOf(isolations = new String[]{"readCommitted", "readUncommitted", "repeatableRead", "serializable"}, this.isolation) == -1) {
            throw new IllegalArgumentException("Invalid isolation \"" + this.isolation + "\".");
        }
    }

    private void executeBatch() throws Exception {
        JSONArray ja;
        if (this.arrayData == null) {
            Object obj = WebUtil.fetchObject(this.request, this.arrayName);
            if (obj instanceof JSONArray) {
                ja = (JSONArray)obj;
            } else {
                if (obj == null) {
                    return;
                }
                String val = obj.toString();
                if (val.isEmpty()) {
                    return;
                }
                ja = new JSONArray(val);
            }
        } else {
            ja = this.arrayData;
        }
        int j = ja.length();
        if (j == 0) {
            return;
        }
        int i = 0;
        while (i < j) {
            JSONObject jo = ja.getJSONObject(i);
            int k = 0;
            while (k < this.paramCount) {
                Object[] param = this.paramList.get(k);
                String name = (String)param[0];
                if (!((Boolean)param[2]).booleanValue() && jo.has(name)) {
                    Object valObj = JsonUtil.opt(jo, name);
                    DbUtil.setObject(this.statement, k + 1, (Integer)param[1], valObj);
                    if (Var.debug) {
                        this.paramValList.set(k, StringUtil.toString(valObj));
                    }
                }
                ++k;
            }
            if (Var.debug) {
                this.printSql();
            }
            if (this.batchUpdate) {
                this.statement.addBatch();
            } else {
                int affectedRows = this.statement.executeUpdate();
                if (this.uniqueUpdate && affectedRows != 1) {
                    this.notUnique();
                }
            }
            ++i;
        }
        if (this.batchUpdate) {
            this.statement.executeBatch();
        }
    }

    private void notUnique() {
        throw new RuntimeException(Str.format(this.request, "updateNotUnique"));
    }

    private void replaceMacros() {
        StringBuilder buf = new StringBuilder();
        int startPos = 0;
        int endPos = 0;
        int lastPos = 0;
        while ((startPos = this.sql.indexOf("{?", startPos)) > -1 && (endPos = this.sql.indexOf("?}", endPos)) > -1) {
            buf.append(this.sql.substring(lastPos, startPos));
            startPos += 2;
            buf.append("'{?");
            buf.append(this.sql.substring((endPos += 2) - 1, endPos));
            buf.append('\'');
            lastPos = endPos;
        }
        buf.append(this.sql.substring(lastPos));
        this.debugSql = buf.toString();
        this.formattedSql = StringUtil.replaceAll(this.debugSql, "'{?}'", "?");
    }

    private void regParameters() throws Exception {
        int index = 1;
        int startPos = 0;
        int endPos = 0;
        this.paramList = new ArrayList();
        this.paramValMap = new LinkedHashMap<String, Object>();
        if (Var.debug) {
            this.paramValList = new ArrayList();
        }
        CallableStatement callStatement = this.statement instanceof CallableStatement ? (CallableStatement)this.statement : null;
        boolean isCall = callStatement != null;
        while ((startPos = this.sql.indexOf("{?", startPos)) > -1 && (endPos = this.sql.indexOf("?}", endPos)) > -1) {
            int type;
            Integer typeObj;
            String paraName;
            int dotPos;
            boolean isOutParam;
            String param = this.sql.substring(startPos += 2, endPos);
            endPos += 2;
            String orgParam = param;
            boolean bl = isOutParam = isCall && param.startsWith("@");
            if (isOutParam) {
                boolean hasSub;
                String typeText;
                dotPos = (param = param.substring(1)).indexOf(46);
                if (dotPos == -1) {
                    typeText = "varchar";
                    paraName = param;
                } else {
                    typeText = param.substring(0, dotPos);
                    paraName = param.substring(dotPos + 1);
                }
                boolean bl2 = hasSub = typeText.indexOf(61) != -1;
                if (hasSub) {
                    typeObj = DbUtil.getFieldType(StringUtil.getNamePart(typeText));
                    if (typeObj == null) {
                        throw new Exception("Invalid type " + typeText);
                    }
                    type = typeObj;
                    int subType = Integer.parseInt(StringUtil.getValuePart(typeText));
                    callStatement.registerOutParameter(index, type, subType);
                } else {
                    typeObj = DbUtil.getFieldType(typeText);
                    if (typeObj == null) {
                        throw new Exception("Invalid type " + typeText);
                    }
                    type = typeObj;
                    callStatement.registerOutParameter(index, type);
                }
                if (Var.debug) {
                    this.paramValList.add(orgParam);
                }
            } else {
                dotPos = param.indexOf(46);
                if (dotPos == -1) {
                    type = 12;
                    paraName = param;
                } else {
                    typeObj = DbUtil.getFieldType(param.substring(0, dotPos));
                    if (typeObj == null) {
                        type = 12;
                        paraName = param;
                    } else {
                        type = typeObj;
                        paraName = param.substring(dotPos + 1);
                    }
                }
                Object obj = WebUtil.fetchObject(this.request, paraName);
                if (Var.filterDataPermission) {
                    obj = this.filterDataPermission(obj, paraName, WebUtil.fetch(this.request, "sys.username"));
                }
                DbUtil.setObject(this.statement, index, type, obj);
                if (Var.debug) {
                    this.paramValList.add(StringUtil.toString(obj));
                }
                this.paramValMap.put(paraName, obj);
            }
            Object[] paramObjects = new Object[]{paraName, type, isOutParam};
            this.paramList.add(paramObjects);
            ++index;
        }
        this.paramCount = this.paramList.size();
    }

    private Object filterDataPermission(Object paramValue, String paraName, String username) {
        if (DataPermBuffer.exitType(paraName)) {
            ArrayList<String> permissionList = DataPermBuffer.getPermissionData(username, paraName);
            if (paramValue != null) {
                List<String> paramValueList = Arrays.asList(ObjectUtils.toString((Object)paramValue).split(","));
                if (permissionList != null) {
                    ArrayList<String> newValue = new ArrayList<String>();
                    for (String pv : paramValueList) {
                        if (!permissionList.contains(pv)) continue;
                        newValue.add(pv);
                    }
                    paramValue = CollUtil.join(newValue, (CharSequence)",");
                } else {
                    paramValue = null;
                }
            } else if (permissionList != null) {
                paramValue = CollUtil.join(permissionList, (CharSequence)",");
            }
        }
        return paramValue;
    }

    private HashMap<String, Object> getOutParameter(boolean loadOutParams) throws Exception {
        loadOutParams = this.loadParam(loadOutParams);
        CallableStatement st = (CallableStatement)this.statement;
        HashMap<String, Object> map = new HashMap<String, Object>();
        int i = 0;
        while (i < this.paramCount) {
            Object[] param = this.paramList.get(i);
            if (((Boolean)param[2]).booleanValue()) {
                if (!loadOutParams) {
                    map.put("outParams", st);
                    return map;
                }
                Object object = DbUtil.getObject(st, i + 1, (int)((Integer)param[1]));
                if (object instanceof ResultSet) {
                    WebUtil.setObject(this.request, SysUtil.getId(), object);
                    List impressionList = SensitiveInfoFieldUtil.getdRole2ImpressionMap((List)SensitiveInfoFieldUtil.getDRoles((HttpServletRequest)this.request));
                    object = new KsResultSetImpl((ResultSet)object, impressionList);
                }
                map.put((String)param[0], object);
            }
            ++i;
        }
        return map;
    }

    private boolean loadParam(boolean loadOutParams) throws SQLException {
        if (!loadOutParams) {
            boolean hiveRs;
            ResultSet rs = this.statement.getResultSet();
            boolean bl = hiveRs = rs != null && "org.apache.hive.jdbc.HiveQueryResultSet".equalsIgnoreCase(rs.getClass().getName());
            if (hiveRs) {
                return true;
            }
        }
        return loadOutParams;
    }

    private void checkError(Object object) throws Exception {
        ResultSet rs;
        if (!StringUtil.isEmpty(this.errorText) && object instanceof ResultSet && (rs = (ResultSet)object).next()) {
            throw new RuntimeException(this.errorText);
        }
    }

    private void printSql() {
        String sql = this.debugSql;
        String xwl = StrUtil.isNotBlank((CharSequence)this.request.getParameter("xwl")) ? this.request.getParameter("xwl") : this.request.getRequestURI();
        for (String s : this.paramValList) {
            sql = StringUtil.replaceFirst(sql, "{?}", s);
        }
        logger.debug("\u6a21\u5757\u3010{}\u3011\u6267\u884c\u7684SQL\u8bed\u53e5:{}", (Object)xwl, (Object)StringUtil.toLine(sql));
        Console.log(this.request, sql);
    }

    public void close() {
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                logger.error("", (Throwable)e);
            }
        }
    }

    public Object runLogic(boolean isCall, String sql, HttpServletRequest request) {
        String substring = sql.substring(sql.indexOf(" ") + 1, sql.indexOf("("));
        if (substring.indexOf(".") != -1) {
            substring = substring.substring(substring.indexOf(".") + 1, substring.length());
        }
        try {
            AbstractDpControl createAction = ActionFactory.createAction(substring);
            if (createAction != null) {
                logger.debug("\u5f00\u59cb\u6267\u884csp\u903b\u8f91\u3010{}\u3011", (Object)substring);
                Map<String, Object> date = ParamsValMap.getDate(isCall, sql, request);
                Object data = createAction.getData(request, date, this.jndi);
                return data;
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return null;
    }
}

