/*
 * Decompiled with CFR 0.152.
 */
package com.wb.tool;

import com.wb.tool.Route;
import com.wb.util.DbUtil;
import com.wb.util.JsonUtil;
import com.wb.util.SysUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class Flow {
    public static Route start(String workflowId, HttpServletRequest request) throws Exception {
        return Flow.start(workflowId, null, request);
    }

    public static Route start(String workflowId, String[] startNodes, HttpServletRequest request) throws Exception {
        String workflow = Flow.getContent(workflowId, true, request);
        Date date = new Date();
        if (workflow == null) {
            throw new Exception("Workflow \"" + workflowId + "\" does not exist.");
        }
        JSONObject template = new JSONObject(workflow);
        JSONObject jo = new JSONObject();
        JSONArray nodes = startNodes == null ? Flow.getStartNodes(template) : new JSONArray((Object)startNodes);
        if (nodes.length() == 0) {
            throw new Exception("Please select some nodes to start the route.");
        }
        Route route = new Route(jo, template);
        route.set("CURRENT_NODES", nodes);
        route.set("ACTIVE_NODE", nodes.optString(0));
        route.set("ROUTE_ID", SysUtil.getId());
        route.set("FLOW_ID", workflowId);
        route.set("CREATE_DATE", date);
        route.set("MODIFY_DATE", date);
        return route;
    }

    private static JSONArray getStartNodes(JSONObject template) throws Exception {
        JSONArray list = template.getJSONArray("list");
        JSONArray currentNodes = new JSONArray();
        JSONObject obj = JsonUtil.findObject(list, "label", "\u5f00\u59cb");
        if (obj == null) {
            HashSet<String> nodes = new HashSet<String>();
            JSONArray conn = template.getJSONArray("conn");
            int j = conn.length();
            int i = 0;
            while (i < j) {
                obj = conn.getJSONObject(i);
                nodes.add(obj.getString("dst"));
                ++i;
            }
            j = list.length();
            i = 0;
            while (i < j) {
                String name;
                obj = list.getJSONObject(i);
                if (obj.getBoolean("isObj") && !nodes.contains(name = obj.getString("label"))) {
                    currentNodes.put((Object)name);
                }
                ++i;
            }
        } else {
            currentNodes.put((Object)"\u5f00\u59cb");
        }
        return currentNodes;
    }

    public static Route create(String routeId, HttpServletRequest request) throws Exception {
        String route = Flow.getContent(routeId, false, request);
        if (route == null) {
            throw new Exception("Route \"" + routeId + "\" does not exist.");
        }
        JSONObject routeObj = new JSONObject(route);
        String tpl = routeObj.optString("FLOW_XTPL");
        if (tpl == null) {
            throw new Exception("The workflow does not exist.");
        }
        return new Route(routeObj, new JSONObject(tpl));
    }

    public static Route create(String routeText, JSONObject flowJson) {
        return new Route(new JSONObject(routeText), flowJson);
    }

    public static void remove(String routeId, HttpServletRequest request) throws Exception {
        Connection conn = null;
        PreparedStatement st = null;
        try {
            conn = DbUtil.getConnection(request);
            st = conn.prepareStatement("delete from WB_ROUTE where ROUTE_ID=?");
            st.setString(1, routeId);
            st.executeUpdate();
        }
        catch (Throwable throwable) {
            DbUtil.close(st);
            throw throwable;
        }
        DbUtil.close(st);
    }

    public static JSONObject get(String id, HttpServletRequest request) {
        return new JSONObject(Flow.getContent(id, true, request));
    }

    public static String getContent(String id, boolean isFlow, HttpServletRequest request) {
        ResultSet rs;
        PreparedStatement st;
        block5: {
            String string;
            String patchRoute = Flow.pathForGetContent(request, isFlow);
            if (patchRoute != null) {
                return patchRoute;
            }
            Connection conn = null;
            st = null;
            rs = null;
            try {
                conn = DbUtil.getConnection(request);
                st = isFlow ? conn.prepareStatement("select FLOW_CONTENT from WB_FLOW where FLOW_ID=?") : conn.prepareStatement("select ROUTE_CONTENT from WB_ROUTE where ROUTE_ID=?");
                st.setString(1, id);
                rs = st.executeQuery();
                if (!rs.next()) break block5;
                string = (String)DbUtil.getObject(rs, 1, 2005);
            }
            catch (Throwable e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(st);
                    throw throwable;
                }
            }
            DbUtil.close(rs);
            DbUtil.close(st);
            return string;
        }
        DbUtil.close(rs);
        DbUtil.close(st);
        return null;
    }

    public static String pathForGetContent(HttpServletRequest request, boolean isFlow) {
        String routeId = request.getParameter("xRouteId");
        if (isFlow && routeId != null) {
            ResultSet rs;
            PreparedStatement st;
            block5: {
                String string;
                Connection conn = null;
                st = null;
                rs = null;
                try {
                    conn = DbUtil.getConnection(request);
                    st = conn.prepareStatement("select ROUTE_CONTENT from WB_ROUTE where ROUTE_ID=?");
                    st.setString(1, routeId);
                    rs = st.executeQuery();
                    if (!rs.next()) break block5;
                    String route = (String)DbUtil.getObject(rs, 1, 2005);
                    string = (String)new JSONObject(route).opt("FLOW_XTPL");
                }
                catch (Throwable e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        DbUtil.close(rs);
                        DbUtil.close(st);
                        throw throwable;
                    }
                }
                DbUtil.close(rs);
                DbUtil.close(st);
                return string;
            }
            DbUtil.close(rs);
            DbUtil.close(st);
            return null;
        }
        return null;
    }
}

