/*
 * Decompiled with CFR 0.152.
 */
package com.wb.tool;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.linuxense.javadbf.DBFField;
import com.linuxense.javadbf.DBFWriter;
import com.wb.common.Base;
import com.wb.common.KVBuffer;
import com.wb.common.ScriptBuffer;
import com.wb.common.Var;
import com.wb.tool.ExcelObject;
import com.wb.util.ColorKit;
import com.wb.util.DateUtil;
import com.wb.util.JsonUtil;
import com.wb.util.SqlUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import com.wb.util.ZipUtil;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import ks.fintech.framework.sql.DbUtils;
import ks.fintech.framework.sql.SqlExecutor;
import ks.fintech.framework.utils.OfficeUtils;
import ks.fintech.framework.utils.SpringContextUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;

public class DataOutput {
    private static Log log = LogFactory.getLog(DataOutput.class);
    private static Map<String, Short> colorShortMap = new HashMap<String, Short>();
    private static Font redFont = null;
    private static final String HEADERPROP = "header";
    private static final String DATAINDEXPROP = "dataIndex";
    private static final String ITEMSPROP = "items";
    private static final String HIDDENPROP = "hidden";
    private static final String TEXTPROP = "text";
    private static final String CELLY = "y";
    private static final String INSTRUCTFLAG = "!!";
    private static final String HEADERSTARTFLAG = "&";
    private static final String TMPSHEETNAME = "tmp";
    private static final String NAMEPROP = "name";
    private static final String SQLPROP = "sql";
    private static final String SPPREFIX = "{call";
    private static final String KEYFIELDSPROP = "keyFields";
    private static final String FIELDPROP = "field";
    private static final String KEYNAMEPROP = "keyName";

    public static void outputExcel(HttpServletRequest request, HttpServletResponse response, JSONArray headers, JSONArray records, String title, JSONObject reportInfo, String dateFormat, String timeFormat, boolean neptune, boolean isAjax, boolean isZip, String extName, String mergeScript, String rowStyle, boolean isPdf) throws Exception {
        if (records.length() > 10000) {
            DataOutput.outputExcelSXSS(request, response, headers, records, title, reportInfo, dateFormat, timeFormat, neptune, isAjax, isZip, extName, mergeScript, rowStyle, isPdf);
        } else {
            DataOutput.myExcelHandler(request, response, headers, records, title, reportInfo, dateFormat, timeFormat, neptune, isAjax, isZip, extName, mergeScript, rowStyle, isPdf);
        }
    }

    private static void myExcelHandler(HttpServletRequest request, HttpServletResponse response, JSONArray headers, JSONArray records, String title, JSONObject reportInfo, String dateFormat, String timeFormat, boolean neptune, boolean isAjax, boolean isZip, String extName, String mergeScript, String rowStyle, boolean isPdf) throws Exception {
        File excelDir = new File(request.getSession().getServletContext().getRealPath("wb/system/tmp/excel"));
        File respExcelDir = new File(request.getSession().getServletContext().getRealPath("wb/system/tmp/respExcel"));
        if (!excelDir.exists()) {
            excelDir.mkdirs();
        }
        if (!respExcelDir.exists()) {
            respExcelDir.mkdirs();
        }
        if (isPdf) {
            Workbook book = DataOutput.createWorkBook(request, headers, records, title, reportInfo, dateFormat, timeFormat, neptune, isZip, extName, mergeScript, rowStyle);
            DataOutput.exportPdf(request, book, response);
            return;
        }
        String bookData = null;
        JSONArray srcHeaders = new JSONArray(headers.toString());
        int excelFileNum = DataOutput.getExcelFileNum(records.length());
        if (excelFileNum == 1) {
            Workbook book = DataOutput.createWorkBook(request, headers, records, title, reportInfo, dateFormat, timeFormat, neptune, isZip, extName, mergeScript, rowStyle);
            if (isZip || isAjax) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                book.write((OutputStream)os);
                bookData = StringUtil.encodeBase64(os.toByteArray());
            } else {
                book.write((OutputStream)response.getOutputStream());
            }
            if (isAjax) {
                WebUtil.send(response, bookData);
            }
        } else {
            List<JSONArray> splitRecords = DataOutput.splitRecords(records, excelFileNum);
            int i = 0;
            while (i < splitRecords.size()) {
                Workbook book = DataOutput.createWorkBook(request, headers, splitRecords.get(i), title, reportInfo, dateFormat, timeFormat, neptune, isZip, extName, mergeScript, rowStyle);
                DataOutput.saveTempExcelFile(request, String.valueOf(i), book);
                headers = new JSONArray(srcHeaders.toString());
                ++i;
            }
            ZipUtil.doZip(request.getSession().getServletContext().getRealPath("wb/system/tmp/respExcel"), String.valueOf(request.getSession().getServletContext().getRealPath("wb/system/tmp")) + "\\excel.zip");
            DataOutput.myOutputZip(request, response);
            DataOutput.deleteTempFile(request.getSession().getServletContext().getRealPath("wb/system/tmp"));
        }
    }

    private static Workbook createWorkBook(HttpServletRequest request, JSONArray headers, JSONArray records, String title, JSONObject reportInfo, String dateFormat, String timeFormat, boolean neptune, boolean isZip, String extName, String mergeScript, String rowStyle) throws Exception {
        Workbook book = null;
        book = isZip ? ExcelObject.getBook(null) : ExcelObject.getBook(WebUtil.fetch(request, "xRestReportData"));
        redFont = book.createFont();
        redFont.setColor((short)10);
        if (records.length() == 0) {
            Sheet sheet = book.createSheet();
            JSONArray topHtml = reportInfo.optJSONArray("topHtml");
            if (topHtml != null && topHtml.length() != 0) {
                DataOutput.fixTopHtml(topHtml, headers.length());
                DataOutput.createHtml(sheet, topHtml);
            }
            int startRow = topHtml == null ? 0 : topHtml.length();
            Object[] values = DataOutput.createHeaders(sheet, headers, startRow, neptune);
            int headerCols = (Integer)values[0];
            int headerRows = (Integer)values[1];
            if (title != null) {
                DataOutput.createTitle(sheet, title, headerCols);
            }
            return book;
        }
        JSONArray srcHeaders = new JSONArray(headers.toString());
        int perSheetDataNum = DataOutput.getPerSheetDataNum();
        int sheetCount = records.length() % perSheetDataNum == 0 ? records.length() / perSheetDataNum : records.length() / perSheetDataNum + 1;
        List<JSONArray> splitRecords = DataOutput.splitRecords(records, sheetCount);
        int i = 0;
        while (i < splitRecords.size()) {
            Sheet sheet = book.createSheet();
            String sheetName = WebUtil.fetch(request, "xSheetName");
            if (!StringUtil.isEmpty(sheetName)) {
                book.setSheetName(book.getSheetIndex(sheet), sheetName);
            }
            DataOutput.createSheet(sheet, request, headers, splitRecords.get(i), title, reportInfo, dateFormat, timeFormat, neptune, extName, mergeScript, rowStyle);
            headers = new JSONArray(srcHeaders.toString());
            ++i;
        }
        return book;
    }

    private static void createSheet(Sheet sheet, HttpServletRequest request, JSONArray headers, JSONArray records, String title, JSONObject reportInfo, String dateFormat, String timeFormat, boolean neptune, String extName, String mergeScript, String rowStyle) {
        int startRow = 0;
        JSONArray topHtml = reportInfo.optJSONArray("topHtml");
        DataOutput.fixTopHtml(topHtml, headers.length());
        JSONArray bottomHtml = reportInfo.optJSONArray("bottomHtml");
        if (topHtml != null) {
            DataOutput.createHtml(sheet, topHtml);
            startRow = topHtml.length();
            title = null;
        }
        if (title != null) {
            startRow = 1;
        }
        Object[] values = DataOutput.createHeaders(sheet, headers, startRow, neptune);
        int headerCols = (Integer)values[0];
        int headerRows = (Integer)values[1];
        JSONArray fields = (JSONArray)values[2];
        if (title != null) {
            DataOutput.createTitle(sheet, title, headerCols);
        }
        startRow += headerRows;
        if (Var.getBool("sys.service.excel.freezePane")) {
            sheet.createFreezePane(0, startRow);
        }
        DataOutput.createRecords(request, sheet, records, fields, startRow, dateFormat, timeFormat, rowStyle);
        DataOutput.mergeCells(sheet, reportInfo, startRow);
        if (bottomHtml != null) {
            DataOutput.createHtml(sheet, bottomHtml);
        }
        if (!StringUtil.isEmpty(mergeScript)) {
            DataOutput.doMergeScript(sheet, mergeScript);
        }
    }

    private static void fixTopHtml(JSONArray topHtml, int feildSize) {
        if (topHtml == null) {
            return;
        }
        int length = topHtml.length();
        if (length == 1) {
            return;
        }
        int colSpanSize = topHtml.getJSONObject(0).getJSONArray(ITEMSPROP).getJSONObject(0).getInt("colSpan");
        if (feildSize != colSpanSize) {
            topHtml.getJSONObject(0).getJSONArray(ITEMSPROP).getJSONObject(0).put("colSpan", feildSize);
            colSpanSize = topHtml.getJSONObject(0).getJSONArray(ITEMSPROP).getJSONObject(0).getInt("colSpan");
        }
        int i = 1;
        while (i < length) {
            JSONArray array;
            if (colSpanSize == 3) {
                array = topHtml.getJSONObject(i).getJSONArray(ITEMSPROP);
                int j = 0;
                while (j < array.length()) {
                    JSONObject object = array.getJSONObject(j);
                    object.put("colSpan", 1);
                    ++j;
                }
            } else {
                array = topHtml.getJSONObject(i).getJSONArray(ITEMSPROP);
                int leng = 0;
                int j = 0;
                while (j < array.length()) {
                    JSONObject object = array.getJSONObject(j);
                    int size = object.getInt("colSpan");
                    leng += size;
                    ++j;
                }
                if (leng > colSpanSize) {
                    JSONObject object = array.getJSONObject(array.length() - 1);
                    int size = object.getInt("colSpan");
                    object.put("colSpan", size - (leng - colSpanSize));
                }
            }
            ++i;
        }
    }

    public static List<JSONArray> splitRecords(JSONArray records, int count) {
        ArrayList<JSONArray> result = new ArrayList<JSONArray>();
        if (records != null && records.length() > 0) {
            int perCount = records.length() % count == 0 ? records.length() / count : records.length() / count + 1;
            JSONArray temp = null;
            int i = 0;
            while (i < count) {
                temp = i == count - 1 ? DataOutput.fitData2JSONArray(records, i * perCount, records.length()) : DataOutput.fitData2JSONArray(records, i * perCount, (i + 1) * perCount);
                result.add(temp);
                ++i;
            }
        }
        return result;
    }

    public static JSONArray fitData2JSONArray(JSONArray records, int startIndex, int endIndex) {
        JSONArray temp = new JSONArray();
        int i = startIndex;
        while (i < endIndex) {
            temp.put(i - startIndex, records.get(i));
            ++i;
        }
        return temp;
    }

    private static void saveTempExcelFile(HttpServletRequest request, String fileName, Workbook book) {
        FileOutputStream fos = null;
        try {
            try {
                String realPath = request.getSession().getServletContext().getRealPath("wb/system/tmp/respExcel");
                boolean is07Excel = DataOutput.getExcelVersion();
                String excelName = is07Excel ? "data" + fileName + ".xlsx" : "data" + fileName + ".xls";
                fos = new FileOutputStream(new File(realPath, excelName));
                book.write((OutputStream)fos);
            }
            catch (IOException e) {
                log.error((Object)"", (Throwable)e);
                try {
                    if (fos != null) {
                        fos.close();
                    }
                    if (book != null) {
                        book.close();
                    }
                }
                catch (IOException e2) {
                    log.error((Object)"", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
                if (book != null) {
                    book.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"", (Throwable)e);
            }
        }
    }

    public static void outputExcelSXSS(HttpServletRequest request, HttpServletResponse response, JSONArray headers, JSONArray records, String title, JSONObject reportInfo, String dateFormat, String timeFormat, boolean neptune, boolean isAjax, boolean isZip, String extName, String mergeScript, String rowStyle, boolean isPdf) throws Exception {
        int startRow = 0;
        String bookData = null;
        JSONArray topHtml = reportInfo.optJSONArray("topHtml");
        JSONArray bottomHtml = reportInfo.optJSONArray("bottomHtml");
        try (SXSSFWorkbook book = new SXSSFWorkbook(5000);){
            Sheet sheet = book.createSheet();
            String sheetName = WebUtil.fetch(request, "xSheetName");
            if (!StringUtil.isEmpty(sheetName)) {
                book.setSheetName(book.getSheetIndex(sheet), sheetName);
            }
            if (topHtml != null) {
                DataOutput.createHtml(sheet, topHtml);
                startRow = topHtml.length();
                title = null;
            }
            if (title != null) {
                startRow = 1;
            }
            Object[] values = DataOutput.createHeaders(sheet, headers, startRow, neptune);
            int headerCols = (Integer)values[0];
            int headerRows = (Integer)values[1];
            JSONArray fields = (JSONArray)values[2];
            if (title != null) {
                DataOutput.createTitle(sheet, title, headerCols);
            }
            startRow += headerRows;
            if (Var.getBool("sys.service.excel.freezePane")) {
                sheet.createFreezePane(0, startRow);
            }
            DataOutput.createRecords(request, sheet, records, fields, startRow, dateFormat, timeFormat, rowStyle);
            DataOutput.mergeCells(sheet, reportInfo, startRow);
            if (bottomHtml != null) {
                DataOutput.createHtml(sheet, bottomHtml);
            }
            if (!StringUtil.isEmpty(mergeScript)) {
                DataOutput.doMergeScript(sheet, mergeScript);
            }
            if (isZip || isAjax) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                book.write((OutputStream)os);
                bookData = StringUtil.encodeBase64(os.toByteArray());
                if (isZip) {
                    DataOutput.outputZip(response.getOutputStream(), bookData, WebUtil.fetch(request, "xRestReportData"), WebUtil.fetch(request, "xAllFileName"), extName);
                    return;
                }
            } else {
                if (isPdf) {
                    DataOutput.exportPdf(request, (Workbook)book, response);
                    return;
                }
                book.write((OutputStream)response.getOutputStream());
            }
        }
        if (isAjax) {
            WebUtil.send(response, (Object)bookData);
        }
    }

    private static void exportPdf(HttpServletRequest request, Workbook book, HttpServletResponse response) throws IOException {
        block8: {
            String path = String.valueOf(request.getServletContext().getRealPath("/")) + "wb" + File.separatorChar + "template" + File.separatorChar + "tempFile" + File.separatorChar + UUID.randomUUID().toString().replaceAll("-", "");
            File filePath = new File(path);
            if (!filePath.exists()) {
                filePath.mkdirs();
            }
            File saveFile = new File(path, String.valueOf(request.toString()) + "saveExcel2Pdf.xlsx");
            FileOutputStream fos = new FileOutputStream(saveFile);
            book.write((OutputStream)fos);
            FileInputStream fis = new FileInputStream(saveFile);
            boolean addWaterMark = DataOutput.isWatermark();
            FileOutputStream pdfFos = null;
            try {
                try {
                    if (addWaterMark) {
                        File savePdfFile = new File(path, String.valueOf(request.toString()) + "saveExcel2Pdf.pdf");
                        pdfFos = new FileOutputStream(savePdfFile);
                        OfficeUtils.excel2Pdf((InputStream)fis, (OutputStream)pdfFos);
                        Class<?> clz = Class.forName("com.fintech.basic.impl.previewoffice.utils.PreviewOfficeUtil");
                        Method addWaterMarkMethod = clz.getMethod("addWaterMark", String.class, String.class);
                        String watermarkContent = request.getSession().getAttribute("sys.user") + " " + new SimpleDateFormat("yyyyMMdd HH:mm:ss").format(new Date());
                        Object invoke = addWaterMarkMethod.invoke(null, savePdfFile.getAbsolutePath(), watermarkContent);
                        byte[] data = FileUtils.readFileToByteArray((File)new File(invoke.toString()));
                        DataOutput.respFile2Client(data, "data.pdf", request, response);
                        savePdfFile.delete();
                    } else {
                        OfficeUtils.excel2Pdf((HttpServletRequest)request, (HttpServletResponse)response, (InputStream)fis, (String)"data.pdf");
                    }
                }
                catch (Exception e) {
                    log.error((Object)"error", (Throwable)e);
                    DbUtils.close((AutoCloseable[])new AutoCloseable[]{fis, fos, pdfFos});
                    saveFile.delete();
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DbUtils.close((AutoCloseable[])new AutoCloseable[]{fis, fos, pdfFos});
                saveFile.delete();
                throw throwable;
            }
            DbUtils.close((AutoCloseable[])new AutoCloseable[]{fis, fos, pdfFos});
            saveFile.delete();
        }
    }

    private static boolean isWatermark() {
        try {
            return Var.getBool("sys.service.pdf.watermark");
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void respFile2Client(byte[] data, String fileName, HttpServletRequest request, HttpServletResponse response) {
        try {
            String userAgent = request.getHeader("user-agent").toLowerCase();
            fileName = userAgent.contains("msie") || userAgent.contains("like gecko") ? URLEncoder.encode(fileName, "UTF-8") : new String(fileName.getBytes("UTF-8"), "iso-8859-1");
            response.setCharacterEncoding("utf-8");
            response.setContentType("multipart/form-data");
            response.setHeader("Content-Disposition", "attachment;fileName=" + fileName);
            ServletOutputStream fos = response.getOutputStream();
            fos.write(data);
            fos.flush();
            if (fos != null) {
                fos.close();
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public static void outputExcel_bak(HttpServletRequest request, HttpServletResponse response, JSONArray headers, JSONArray records, String title, JSONObject reportInfo, String dateFormat, String timeFormat, boolean neptune, boolean isAjax, boolean isZip, String extName, String mergeScript, String rowStyle) throws Exception {
        int startRow = 0;
        String bookData = null;
        JSONArray topHtml = reportInfo.optJSONArray("topHtml");
        JSONArray bottomHtml = reportInfo.optJSONArray("bottomHtml");
        try (Workbook book = isZip ? ExcelObject.getBook(null) : ExcelObject.getBook(WebUtil.fetch(request, "xRestReportData"));){
            Sheet sheet = book.createSheet();
            String sheetName = WebUtil.fetch(request, "xSheetName");
            if (!StringUtil.isEmpty(sheetName)) {
                book.setSheetName(book.getSheetIndex(sheet), sheetName);
            }
            if (topHtml != null) {
                DataOutput.createHtml(sheet, topHtml);
                startRow = topHtml.length();
                title = null;
            }
            if (title != null) {
                startRow = 1;
            }
            Object[] values = DataOutput.createHeaders(sheet, headers, startRow, neptune);
            int headerCols = (Integer)values[0];
            int headerRows = (Integer)values[1];
            JSONArray fields = (JSONArray)values[2];
            if (title != null) {
                DataOutput.createTitle(sheet, title, headerCols);
            }
            startRow += headerRows;
            if (Var.getBool("sys.service.excel.freezePane")) {
                sheet.createFreezePane(0, startRow);
            }
            DataOutput.createRecords(request, sheet, records, fields, startRow, dateFormat, timeFormat, rowStyle);
            DataOutput.mergeCells(sheet, reportInfo, startRow);
            if (bottomHtml != null) {
                DataOutput.createHtml(sheet, bottomHtml);
            }
            if (!StringUtil.isEmpty(mergeScript)) {
                DataOutput.doMergeScript(sheet, mergeScript);
            }
            if (isZip || isAjax) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                book.write((OutputStream)os);
                bookData = StringUtil.encodeBase64(os.toByteArray());
                if (isZip) {
                    DataOutput.outputZip(response.getOutputStream(), bookData, WebUtil.fetch(request, "xRestReportData"), WebUtil.fetch(request, "xAllFileName"), extName);
                    return;
                }
            } else {
                book.write((OutputStream)response.getOutputStream());
            }
        }
        if (isAjax) {
            WebUtil.send(response, (Object)bookData);
        }
    }

    private static void deleteTempFile(String realPath) {
        File[] srcFolderArr;
        System.gc();
        File[] fileArray = srcFolderArr = new File(realPath).listFiles();
        int n = srcFolderArr.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory() && (file.getName().equals("excel") || file.getName().equals("respExcel"))) {
                File[] listFiles;
                File[] fileArray2 = listFiles = file.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        String name = pathname.getName();
                        return name.endsWith(".xls") || name.endsWith(".xlsx");
                    }
                });
                int n3 = listFiles.length;
                int n4 = 0;
                while (n4 < n3) {
                    File delFile = fileArray2[n4];
                    delFile.delete();
                    ++n4;
                }
            } else {
                file.delete();
            }
            ++n2;
        }
    }

    private static boolean getExcelVersion() {
        return Var.getBool("sys.service.excel.xlsx");
    }

    private static int getPerExcelDataNum() {
        if (Var.getBool("sys.service.excel.xlsx")) {
            return Var.getInt("sys.service.excel.size.2007_sheet_size") * Var.getInt("sys.service.excel.size.sheet_num");
        }
        return Var.getInt("sys.service.excel.size.2003_sheet_size") * Var.getInt("sys.service.excel.size.sheet_num");
    }

    private static int getPerSheetDataNum() {
        if (Var.getBool("sys.service.excel.xlsx")) {
            return Var.getInt("sys.service.excel.size.2007_sheet_size");
        }
        return Var.getInt("sys.service.excel.size.2003_sheet_size");
    }

    private static int getExcelFileNum(int totalRecords) {
        int sheetNum;
        int _2003SheetSize = Var.getInt("sys.service.excel.size.2003_sheet_size");
        int _2007SheetSize = Var.getInt("sys.service.excel.size.2007_sheet_size");
        int actualSheetNum = 1;
        actualSheetNum = Var.getBool("sys.service.excel.xlsx") ? (totalRecords % _2007SheetSize == 0 ? totalRecords / _2007SheetSize : totalRecords / _2007SheetSize + 1) : (totalRecords % _2003SheetSize == 0 ? totalRecords / _2003SheetSize : totalRecords / _2003SheetSize + 1);
        if (actualSheetNum > (sheetNum = Var.getInt("sys.service.excel.size.sheet_num"))) {
            return actualSheetNum % sheetNum == 0 ? actualSheetNum / sheetNum : actualSheetNum / sheetNum + 1;
        }
        return 1;
    }

    private static void myOutputZip(HttpServletRequest request, HttpServletResponse response) {
        OutputStream os = null;
        InputStream inputStreamzip = null;
        try {
            try {
                int length;
                response.setCharacterEncoding("utf-8");
                response.setContentType("multipart/form-data");
                response.setHeader("Content-disposition", "attachment;filename=excel.zip");
                inputStreamzip = new FileInputStream(new File(String.valueOf(request.getSession().getServletContext().getRealPath("wb/system/tmp")) + "\\excel.zip"));
                os = response.getOutputStream();
                byte[] b = new byte[2048];
                while ((length = inputStreamzip.read(b)) > 0) {
                    os.write(b, 0, length);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (inputStreamzip != null || os != null) {
                try {
                    inputStreamzip.close();
                    os.close();
                }
                catch (IOException e) {
                    log.error((Object)"", (Throwable)e);
                }
            }
        }
    }

    private static void doMergeScript(Sheet sheet, String mergeScript) {
        if (StringUtil.isEmpty(mergeScript)) {
            return;
        }
        JSONArray items = new JSONArray(mergeScript);
        int j = items.length();
        int i = 0;
        while (i < j) {
            JSONObject item = items.optJSONObject(i);
            String cmd = item.optString("cmd");
            if ("del".equals(cmd)) {
                sheet.getRow(item.optInt("row")).getCell(item.optInt("col")).setCellValue("");
            } else {
                sheet.addMergedRegion(new CellRangeAddress(item.optInt("firstRow"), item.optInt("lastRow"), item.optInt("firstCol"), item.optInt("lastCol")));
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void outputZip(ServletOutputStream outputStream, String bookData, String fetch, String xAllFileName, String extName) throws Exception {
        datas = new JSONArray(fetch);
        fileNames = new JSONArray(xAllFileName);
        j = fileNames.length();
        files = new File[j + 1];
        try {
            datas.put((Object)bookData);
            i = 0;
            while (i < j) {
                files[i] = new File(Base.path, "wb/system/tmp/" + fileNames.getString(i) + extName);
                FileUtils.writeByteArrayToFile((File)files[i], (byte[])StringUtil.decodeBase64(datas.getString(i)));
                ++i;
            }
            ZipUtil.zip(files, (OutputStream)outputStream);
        }
        finally {
            i = 0;
            ** while (i < j)
        }
lbl-1000:
        // 1 sources

        {
            files[i].delete();
            ++i;
            continue;
        }
lbl23:
        // 1 sources

    }

    private static void mergeCells(Sheet sheet, JSONObject reportInfo, int startRow) {
        boolean isLast;
        String value;
        Object object;
        Cell cell;
        Row row;
        String prevValue;
        int rowIndex;
        int span;
        Iterator rows;
        int i;
        JSONArray mergeInfo = reportInfo.optJSONArray("mergeInfo");
        int j = mergeInfo.length();
        int lastRowNum = sheet.getLastRowNum();
        int lastColNum = j - 1;
        if (reportInfo.optBoolean("mergeRows")) {
            i = 0;
            while (i < j) {
                if (mergeInfo.getJSONArray(i).getBoolean(0)) {
                    rows = sheet.rowIterator();
                    span = 0;
                    rowIndex = 0;
                    prevValue = null;
                    while (rows.hasNext()) {
                        row = (Row)rows.next();
                        if (rowIndex < startRow) {
                            ++rowIndex;
                            continue;
                        }
                        cell = row.getCell(i);
                        object = ExcelObject.getCellValue(cell);
                        value = object == null ? "" : object.toString();
                        boolean bl = isLast = rowIndex == lastRowNum;
                        if (prevValue != null && (!value.equals(prevValue) || isLast)) {
                            if (isLast) {
                                if (value.equals(prevValue)) {
                                    ++span;
                                } else {
                                    isLast = false;
                                }
                            }
                            if (span > 1) {
                                if (isLast) {
                                    sheet.addMergedRegion(new CellRangeAddress(rowIndex - span + 1, rowIndex, i, i));
                                } else {
                                    sheet.addMergedRegion(new CellRangeAddress(rowIndex - span, rowIndex - 1, i, i));
                                }
                            }
                            span = 0;
                        }
                        prevValue = value;
                        ++span;
                        ++rowIndex;
                    }
                }
                ++i;
            }
        }
        rowIndex = 0;
        if (reportInfo.optBoolean("mergeCols")) {
            rows = sheet.rowIterator();
            String[] colGroup = new String[j];
            i = 0;
            while (i < j) {
                colGroup[i] = mergeInfo.getJSONArray(i).optString(1);
                ++i;
            }
            while (rows.hasNext()) {
                row = (Row)rows.next();
                if (rowIndex < startRow) {
                    ++rowIndex;
                    continue;
                }
                Iterator cells = row.cellIterator();
                span = 0;
                int colIndex = 0;
                prevValue = null;
                String prevGroup = null;
                while (cells.hasNext()) {
                    cell = (Cell)cells.next();
                    object = ExcelObject.getCellValue(cell);
                    String group = colGroup[colIndex];
                    value = object == null ? "" : object.toString();
                    boolean bl = isLast = colIndex == lastColNum;
                    if (!(prevValue == null || value.equals(prevValue) && group.equals(prevGroup) && !isLast)) {
                        if (isLast) {
                            if (value.equals(prevValue)) {
                                ++span;
                            } else {
                                isLast = false;
                            }
                        }
                        if (span > 1) {
                            if (isLast && !group.isEmpty()) {
                                sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, colIndex - span + 1, colIndex));
                            } else if (!prevGroup.isEmpty()) {
                                sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, colIndex - span, colIndex - 1));
                            }
                        }
                        span = 0;
                    }
                    prevValue = value;
                    prevGroup = group;
                    ++span;
                    ++colIndex;
                }
                ++rowIndex;
            }
        }
    }

    public static void outputExcel(OutputStream outputStream, JSONArray headers, JSONArray records, String title, JSONObject reportInfo, String dateFormat, String timeFormat, boolean neptune) throws Exception {
        DataOutput.outputExcelForReq(null, outputStream, headers, records, title, reportInfo, dateFormat, timeFormat, neptune);
    }

    public static void outputExcelForReq(HttpServletRequest request, OutputStream outputStream, JSONArray headers, JSONArray records, String title, JSONObject reportInfo, String dateFormat, String timeFormat, boolean neptune) throws Exception {
        int startRow = 0;
        JSONArray topHtml = reportInfo.optJSONArray("topHtml");
        JSONArray bottomHtml = reportInfo.optJSONArray("bottomHtml");
        try (Workbook book = ExcelObject.getBook(null);){
            Sheet sheet = book.createSheet();
            if (topHtml != null) {
                DataOutput.createHtml(sheet, topHtml);
                startRow = topHtml.length();
                title = null;
            }
            if (title != null) {
                startRow = 1;
            }
            Object[] values = DataOutput.createHeaders(sheet, headers, startRow, neptune);
            int headerCols = (Integer)values[0];
            int headerRows = (Integer)values[1];
            JSONArray fields = (JSONArray)values[2];
            if (title != null) {
                DataOutput.createTitle(sheet, title, headerCols);
            }
            startRow += headerRows;
            if (Var.getBool("sys.service.excel.freezePane")) {
                sheet.createFreezePane(0, startRow);
            }
            DataOutput.createRecords(request, sheet, records, fields, startRow, dateFormat, timeFormat, null);
            ExcelObject.mergeCells(sheet, reportInfo, startRow, Integer.MAX_VALUE, 0);
            if (bottomHtml != null) {
                DataOutput.createHtml(sheet, bottomHtml);
            }
            book.write(outputStream);
        }
    }

    private static void createTitle(Sheet sheet, String title, int headerCols) {
        Row row = sheet.createRow(0);
        Object[] styles = DataOutput.createCellStyle(sheet.getWorkbook(), "title");
        row.setHeight(((Short)styles[1]).shortValue());
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, headerCols - 1));
        Cell cell = row.createCell(0);
        cell.setCellStyle((CellStyle)styles[0]);
        cell.setCellValue(title);
    }

    private static void createHtml(Sheet sheet, JSONArray data) {
        Workbook book = sheet.getWorkbook();
        int y = data.length();
        int startIndex = sheet.getLastRowNum();
        if (startIndex > 0) {
            ++startIndex;
        }
        int x = 0;
        while (x < y) {
            JSONObject dataRow = data.optJSONObject(x);
            JSONArray dataCells = dataRow.optJSONArray(ITEMSPROP);
            Row row = sheet.createRow(startIndex + x);
            int j = dataCells.length();
            int cellIndex = 0;
            int brCount = 1;
            int i = 0;
            while (i < j) {
                int fontSize;
                JSONObject dataCell = dataCells.optJSONObject(i);
                int colSpan = dataCell.optInt("colSpan");
                Cell cell = row.createCell(cellIndex);
                String text = dataCell.optString("value");
                int count = 1;
                int index = 0;
                while ((index = text.indexOf("<br>", index)) != -1) {
                    index += "<br>".length();
                    ++count;
                }
                brCount = Math.max(count, brCount);
                cell.setCellValue(StringUtil.replaceAll(text, "<br>", "\n\r"));
                CellStyle style = book.createCellStyle();
                style.setWrapText(true);
                style.setAlignment(ExcelObject.getAlignment(dataCell.optString("align"), (short)1));
                style.setVerticalAlignment((short)1);
                Font font = book.createFont();
                if ("bold".equals(dataCell.optString("weight"))) {
                    font.setBoldweight((short)700);
                }
                if ((fontSize = dataCell.optInt("size")) > 0) {
                    font.setFontHeightInPoints((short)fontSize);
                }
                style.setFont(font);
                cell.setCellStyle(style);
                int k = 1;
                while (k < colSpan) {
                    row.createCell(cellIndex + k);
                    ++k;
                }
                if (colSpan > 1) {
                    sheet.addMergedRegion(new CellRangeAddress(startIndex + x, startIndex + x, cellIndex, cellIndex + colSpan - 1));
                }
                cellIndex += colSpan;
                ++i;
            }
            row.setHeight((short)(dataRow.optInt("height") * 20 * brCount));
            ++x;
        }
    }

    private static Object[] createHeaders(Sheet sheet, JSONArray headers, int startRow, boolean neptune) {
        Workbook book = sheet.getWorkbook();
        JSONArray processedHeaders = new JSONArray();
        Object[] values = DataOutput.prepareHeaders(sheet, headers, processedHeaders, startRow, neptune);
        Cell cell = null;
        Cell[][] cells = (Cell[][])values[0];
        Object[] styles = DataOutput.createCellStyle(book, HEADERPROP);
        CellStyle baseStyle = (CellStyle)styles[0];
        int j = processedHeaders.length();
        int brCount = 1;
        int i = 0;
        while (i < j) {
            JSONObject header = processedHeaders.getJSONObject(i);
            String text = header.optString(TEXTPROP);
            int count = 1;
            int index = 0;
            while ((index = text.indexOf("<br>", index)) != -1) {
                index += "<br>".length();
                ++count;
            }
            brCount = Math.max(count, brCount);
            int x = header.getInt("x");
            int y = header.getInt(CELLY);
            int colspan = Math.max(header.getInt("colspan"), 0);
            int rowspan = Math.max(header.getInt("rowspan"), 0);
            if (colspan > 0 || rowspan > 0) {
                sheet.addMergedRegion(new CellRangeAddress(y + startRow, y + startRow + rowspan, x, x + colspan));
            }
            cell = cells[x][y];
            CellStyle style = book.createCellStyle();
            style.cloneStyleFrom(baseStyle);
            style.setAlignment(ExcelObject.getAlignment(header.optString("titleAlign"), header.has("child") ? (short)2 : 1));
            cell.setCellStyle(style);
            if (text.contains("span")) {
                text = StringUtil.replaceAll(text, "<br>", "\n\r");
                text = StringUtil.replaceAll(text, "<span style=\"color:red\">*</span>", "*");
                XSSFRichTextString richString = null;
                if (sheet instanceof XSSFSheet) {
                    richString = new XSSFRichTextString(text);
                } else if (sheet instanceof HSSFSheet) {
                    richString = new HSSFRichTextString(text);
                }
                richString.applyFont(0, 1, redFont);
                cell.setCellValue((RichTextString)richString);
            } else {
                cell.setCellValue(StringUtil.replaceAll(text, "<br>", "\n\r"));
            }
            ++i;
        }
        cell.getRow().setHeight((short)(cell.getRow().getHeight() * brCount));
        Object[] result = new Object[]{cells.length, cells[0].length, values[1]};
        return result;
    }

    private static Object[] prepareHeaders(Sheet sheet, JSONArray rawHeaders, JSONArray processedHeaders, int startRow, boolean neptune) {
        JSONArray leafs = new JSONArray();
        Object[] result = new Object[2];
        int flexWidth = Var.getInt("sys.service.excel.flexColumnMaxWidth");
        Object[] styles = DataOutput.createCellStyle(sheet.getWorkbook(), HEADERPROP);
        CellStyle style = (CellStyle)styles[0];
        short rowHeight = (Short)styles[1];
        double rate = neptune ? 32.06 : 36.55;
        leafs.put(0);
        DataOutput.markParents(leafs, rawHeaders, null, 0);
        int maxDepth = leafs.getInt(0);
        leafs.remove(0);
        int j = leafs.length();
        int i = 0;
        while (i < j) {
            JSONObject node = leafs.getJSONObject(i);
            int width = node.has("width") ? node.getInt("width") : (node.has("flex") ? flexWidth : 100);
            sheet.setColumnWidth(i, (int)((double)width * rate));
            node.put("rowspan", maxDepth - node.getInt(CELLY));
            do {
                node.put("colspan", node.getInt("colspan") + 1);
                if (node.has("x")) continue;
                node.put("x", i);
                processedHeaders.put((Object)node);
            } while ((node = (JSONObject)node.opt("parent")) != null);
            ++i;
        }
        Cell[][] cells = new Cell[j][++maxDepth];
        int k = 0;
        while (k < maxDepth) {
            Row row = sheet.createRow(k + startRow);
            row.setHeight(rowHeight);
            int l = 0;
            while (l < j) {
                Cell cell = row.createCell(l);
                cell.setCellStyle(style);
                cells[l][k] = cell;
                ++l;
            }
            ++k;
        }
        result[0] = cells;
        result[1] = leafs;
        return result;
    }

    private static void markParents(JSONArray leafs, JSONArray headers, JSONObject parent, int depth) {
        int j = headers.length();
        leafs.put(0, Math.max(leafs.getInt(0), depth));
        int i = 0;
        while (i < j) {
            JSONArray items;
            JSONObject header = headers.getJSONObject(i);
            header.put(CELLY, depth);
            header.put("colspan", -1);
            header.put("rowspan", -1);
            if (parent != null) {
                header.put("parent", (Object)parent);
                parent.put("child", (Object)header);
            }
            if ((items = (JSONArray)header.opt(ITEMSPROP)) != null) {
                DataOutput.markParents(leafs, items, header, depth + 1);
            } else {
                leafs.put((Object)header);
            }
            ++i;
        }
    }

    private static void createRecords(HttpServletRequest request, Sheet sheet, JSONArray records, JSONArray fields, int startRow, String defaultDateFormat, String defaultTimeFormat, String rowStyle) {
        boolean useBoolString;
        int j = records.length();
        int l = fields.length();
        String[] fieldNames = new String[l];
        Workbook book = sheet.getWorkbook();
        Object[] cellStyles = DataOutput.createCellStyle(book, TEXTPROP);
        CellStyle baseStyle = (CellStyle)cellStyles[0];
        CellStyle[] colStyles = new CellStyle[l];
        CellStyle[][] dateTimeStyles = new CellStyle[l][2];
        String boolString = Var.getString("sys.service.excel.boolText");
        String trueText = null;
        String falseText = null;
        int[] dataTypes = new int[l];
        Object[] keyMaps = new Object[l];
        boolean bl = useBoolString = !boolString.isEmpty();
        if (useBoolString) {
            String[] boolStrings = boolString.split(",");
            trueText = boolStrings[0];
            falseText = boolStrings[1];
        }
        int k = 0;
        while (k < l) {
            int dataType;
            String dataTypeStr;
            String keyName;
            JSONObject field = fields.getJSONObject(k);
            fieldNames[k] = field.optString(FIELDPROP);
            CellStyle style = book.createCellStyle();
            style.cloneStyleFrom(baseStyle);
            style.setAlignment(ExcelObject.getAlignment(field.optString("align"), (short)1));
            if (Boolean.TRUE.equals(field.opt("autoWrap"))) {
                style.setWrapText(true);
            }
            if ((keyName = field.optString(KEYNAMEPROP)).isEmpty()) {
                keyMaps[k] = null;
                dataTypeStr = field.optString("type").toLowerCase();
            } else {
                keyMaps[k] = KVBuffer.getLangBuffer(request).get(keyName);
                dataTypeStr = "string";
            }
            String format = field.optString("format");
            if (dataTypeStr.equals("string")) {
                dataType = 1;
            } else if (dataTypeStr.startsWith("int") || dataTypeStr.equals("float") || dataTypeStr.equals("number")) {
                dataType = 2;
                if (!StringUtil.isEmpty(format)) {
                    style.setDataFormat(book.createDataFormat().getFormat(format));
                }
            } else if (dataTypeStr.equals("date")) {
                dataType = 3;
                if (StringUtil.isEmpty(format)) {
                    CellStyle dateStyle = book.createCellStyle();
                    dateStyle.cloneStyleFrom(style);
                    CellStyle dateTimeStyle = book.createCellStyle();
                    dateTimeStyle.cloneStyleFrom(style);
                    format = ExcelObject.toExcelDateFormat(defaultDateFormat, true);
                    dateStyle.setDataFormat(book.createDataFormat().getFormat(format));
                    dateTimeStyles[k][0] = dateStyle;
                    format = ExcelObject.toExcelDateFormat(String.valueOf(defaultDateFormat) + " " + defaultTimeFormat, true);
                    dateTimeStyle.setDataFormat(book.createDataFormat().getFormat(format));
                    dateTimeStyles[k][1] = dateTimeStyle;
                    style = dateStyle;
                } else {
                    dateTimeStyles[0][0] = null;
                    if ((format = ExcelObject.toExcelDateFormat(format, false)) == null) {
                        format = ExcelObject.toExcelDateFormat(defaultDateFormat, true);
                    }
                    style.setDataFormat(book.createDataFormat().getFormat(format));
                }
            } else {
                dataType = dataTypeStr.startsWith("bool") ? 4 : 5;
            }
            dataTypes[k] = dataType;
            colStyles[k] = style;
            ++k;
        }
        int i = 0;
        while (i < j) {
            ScriptObjectMirror styleScript = null;
            Row row = sheet.createRow(startRow + i);
            JSONObject record = (JSONObject)records.opt(i);
            if (StrUtil.isNotBlank((CharSequence)rowStyle)) {
                styleScript = DataOutput.getRowStyleScript(WebUtil.replaceParams2(record, rowStyle));
            }
            int brCount = 1;
            short rowHeight = (Short)cellStyles[1];
            k = 0;
            while (k < l) {
                Cell cell = row.createCell(k);
                CellStyle cs = null;
                if (styleScript != null) {
                    cs = DataOutput.createRowCellStyle(book, colStyles[k], styleScript);
                }
                if (cs != null) {
                    cell.setCellStyle(cs);
                } else {
                    cell.setCellStyle(colStyles[k]);
                }
                Object value = JsonUtil.opt(record, fieldNames[k]);
                if (value != null) {
                    if (keyMaps[k] != null) {
                        value = KVBuffer.getValue((Map)keyMaps[k], value);
                    }
                    if (dataTypes[k] == 5) {
                        dataTypes[k] = value instanceof Number ? 2 : (value instanceof Date ? 3 : (value instanceof Boolean ? 4 : 1));
                    }
                    switch (dataTypes[k]) {
                        case 2: {
                            double number = value instanceof Number ? ((Number)value).doubleValue() : Double.parseDouble(value.toString());
                            cell.setCellValue(number);
                            break;
                        }
                        case 3: {
                            Date date;
                            if (dateTimeStyles[k][0] == null) {
                                date = value instanceof Date ? (Date)value : Timestamp.valueOf(value.toString());
                            } else {
                                boolean hasTime;
                                if (value instanceof Date) {
                                    date = (Date)value;
                                    hasTime = !DateUtil.dateToStr(date).endsWith("00:00:00.0");
                                } else {
                                    String dateTimeStr = value.toString();
                                    date = Timestamp.valueOf(dateTimeStr);
                                    boolean bl2 = hasTime = !dateTimeStr.endsWith("00:00:00.0") && !(dateTimeStr.endsWith("00:00:00") | dateTimeStr.endsWith("00:00:00.000"));
                                }
                                if (hasTime) {
                                    cell.setCellStyle(dateTimeStyles[k][1]);
                                } else {
                                    cell.setCellStyle(dateTimeStyles[k][0]);
                                }
                            }
                            cell.setCellValue(date);
                            break;
                        }
                        case 4: {
                            if (useBoolString) {
                                cell.setCellValue(StringUtil.getBool(value.toString()) ? trueText : falseText);
                                break;
                            }
                            cell.setCellValue(StringUtil.getBool(value.toString()));
                            break;
                        }
                        default: {
                            String text = value.toString();
                            int count = 1;
                            int index = 0;
                            while ((index = text.indexOf("<br>", index)) != -1) {
                                index += "<br>".length();
                                ++count;
                            }
                            brCount = Math.max(count, brCount);
                            rowHeight = (short)(Integer.parseInt(cellStyles[1].toString()) * brCount);
                            cell.setCellValue(StringUtil.replaceAll(text, "<br>", "\n\r"));
                        }
                    }
                }
                ++k;
            }
            row.setHeight(rowHeight);
            ++i;
        }
    }

    private static Object[] createCellStyle(Workbook book, String type) {
        CellStyle style = book.createCellStyle();
        Font font = book.createFont();
        String fontName = Var.getString("sys.service.excel." + type + ".fontName");
        int fontHeight = Var.getInt("sys.service.excel." + type + ".fontHeight");
        double rowHeight = Var.getDouble("sys.service.excel." + type + ".rowHeight");
        Object[] result = new Object[2];
        if (!fontName.isEmpty()) {
            font.setFontName(fontName);
        }
        font.setBoldweight((short)Var.getInt("sys.service.excel." + type + ".fontWeight"));
        font.setFontHeight((short)fontHeight);
        if (rowHeight < 10.0) {
            rowHeight *= (double)fontHeight;
        }
        if (!TEXTPROP.equals(type) && Var.getBool("sys.service.excel." + type + ".wrapText")) {
            style.setWrapText(true);
        }
        if ("title".equals(type)) {
            String align = Var.getString("sys.service.excel." + type + ".align");
            if (!align.isEmpty()) {
                Object[][] alignments = new Object[][]{{"\u5c45\u4e2d", (short)2}, {"\u5de6", (short)1}, {"\u53f3", (short)3}, {"\u5c45\u4e2d\u9009\u62e9", (short)6}, {"\u586b\u5145", (short)4}, {"\u5e38\u89c4", (short)0}, {"\u4e24\u7aef\u5bf9\u9f50", (short)5}};
                style.setAlignment(((Short)SysUtil.getValue(alignments, align)).shortValue());
            }
        } else if (Var.getBool("sys.service.excel.border")) {
            style.setBorderTop((short)1);
            style.setBorderBottom((short)1);
            style.setBorderLeft((short)1);
            style.setBorderRight((short)1);
        }
        if (HEADERPROP.equals(type)) {
            String backColor = Var.getString("sys.service.excel.header.backColor");
            style.setWrapText(true);
            if (!"\u9ed8\u8ba4".equals(backColor)) {
                Object[][] colors = new Object[][]{{"\u9ed8\u8ba4", -1}, {"\u91d1\u8272", HSSFColor.GOLD.index}, {"\u7070\u8272", HSSFColor.GREY_25_PERCENT.index}, {"\u6d45\u9ec4", HSSFColor.LIGHT_YELLOW.index}, {"\u6d45\u68d5", HSSFColor.TAN.index}};
                style.setFillForegroundColor(((Short)SysUtil.getValue(colors, backColor)).shortValue());
                style.setFillPattern((short)1);
            }
        }
        style.setVerticalAlignment((short)1);
        style.setFont(font);
        result[0] = style;
        result[1] = Double.valueOf(rowHeight).shortValue();
        return result;
    }

    private static ScriptObjectMirror getRowStyleScript(String script) {
        ScriptObjectMirror som = null;
        try {
            som = (ScriptObjectMirror)ScriptBuffer.run(script, "rowStyle");
        }
        catch (Exception e) {
            log.error((Object)"createRowCellStyle \u6267\u884cjavascript\u62a5\u9519\uff1a{}", (Throwable)e);
        }
        return som;
    }

    private static CellStyle createRowCellStyle(Workbook book, CellStyle style, ScriptObjectMirror som) {
        Font font = book.createFont();
        CellStyle cellStyle = book.createCellStyle();
        cellStyle.cloneStyleFrom(style);
        if (som != null && !som.isEmpty()) {
            if (som.containsKey((Object)"bold") && StrUtil.isNotBlank((CharSequence)som.get((Object)"bold").toString())) {
                font.setBold(Boolean.parseBoolean(som.get((Object)"bold").toString()));
            }
            if (som.containsKey((Object)"color") && StrUtil.isNotBlank((CharSequence)som.get((Object)"color").toString())) {
                DataOutput.setFontColor(book, font, som.get((Object)"color").toString());
            }
            if (som.containsKey((Object)"fcolor") && StrUtil.isNotBlank((CharSequence)som.get((Object)"fcolor").toString())) {
                DataOutput.setFillColor(book, cellStyle, som.get((Object)"fcolor").toString());
            }
            if (Var.getBool("sys.service.excel.border")) {
                cellStyle.setBorderTop((short)1);
                cellStyle.setBorderBottom((short)1);
                cellStyle.setBorderLeft((short)1);
                cellStyle.setBorderRight((short)1);
            }
            cellStyle.setFont(font);
            return cellStyle;
        }
        return null;
    }

    private static void setFontColor(Workbook book, Font font, String color) {
        if (font instanceof XSSFFont) {
            XSSFFont f = (XSSFFont)font;
            f.setColor(new XSSFColor(Color.decode(color)));
        } else if (font instanceof HSSFFont) {
            HSSFFont f = (HSSFFont)font;
            f.setColor(DataOutput.setStyleColor(book, color));
        }
    }

    private static void setFillColor(Workbook book, CellStyle style, String color) {
        if (style instanceof XSSFCellStyle) {
            XSSFCellStyle x = (XSSFCellStyle)style;
            x.setFillForegroundColor(new XSSFColor(Color.decode(color)));
            x.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        } else if (style instanceof HSSFCellStyle) {
            HSSFCellStyle h = (HSSFCellStyle)style;
            h.setFillForegroundColor(DataOutput.setStyleColor(book, color));
            h.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
    }

    private static short setStyleColor(Workbook book, String color) {
        short colorIndex = -1;
        Object xssfColor = null;
        Object rgb = null;
        if (book instanceof HSSFWorkbook) {
            if (colorShortMap.isEmpty()) {
                Map colorMap = HSSFColor.getTripletHash();
                colorMap.forEach((k, v) -> {
                    String[] ka = k.split(":");
                    String r = DataOutput.getHexStr(ka[0]);
                    String g = DataOutput.getHexStr(ka[1]);
                    String b = DataOutput.getHexStr(ka[2]);
                    colorShortMap.put(StringUtil.concat("#", r, g, b), v.getIndex());
                });
                colorIndex = DataOutput.getHSSFColorIndex((HSSFWorkbook)book, color);
            } else {
                colorIndex = DataOutput.getHSSFColorIndex((HSSFWorkbook)book, color);
            }
        }
        return colorIndex;
    }

    private static short getHSSFColorIndex(HSSFWorkbook book, String color) {
        short colorIndex;
        if (colorShortMap.containsKey(color)) {
            colorIndex = colorShortMap.get(color);
        } else {
            HSSFPalette customPalette = book.getCustomPalette();
            byte[] rgb = ColorKit.hex2Rgb(color);
            customPalette.setColorAtIndex(HSSFColor.BLACK.index, rgb[0], rgb[1], rgb[2]);
            colorIndex = HSSFColor.BLACK.index;
        }
        return colorIndex;
    }

    private static String getHexStr(String s) {
        if (s.length() == 1) {
            return StrUtil.repeat((CharSequence)s, (int)2);
        }
        return s.substring(2);
    }

    public static void outputHtml(OutputStream outputStream, JSONArray headers, JSONArray records, String title, String dateFormat, String timeFormat, boolean neptune, int rowNumberWidth, String rowNumberTitle, String decimalSeparator, String thousandSeparator) throws Exception {
        DataOutput.outputHtmlForReq(null, outputStream, headers, records, title, dateFormat, timeFormat, neptune, rowNumberWidth, rowNumberTitle, decimalSeparator, thousandSeparator);
    }

    public static void outputHtmlForReq(HttpServletRequest request, OutputStream outputStream, JSONArray headers, JSONArray records, String title, String dateFormat, String timeFormat, boolean neptune, int rowNumberWidth, String rowNumberTitle, String decimalSeparator, String thousandSeparator) throws Exception {
        StringBuilder html = new StringBuilder();
        html.append("<!DOCTYPE html><html><head><meta http-equiv=\"content-type\" content=\"text/html;charset=utf-8\">");
        if (!StringUtil.isEmpty(title)) {
            html.append("<title>");
            html.append(title);
            html.append("</title>");
        }
        html.append("<style type=\"text/css\">table{table-layout:fixed;border-collapse:collapse;word-wrap:break-word;");
        String value = Var.getString("sys.service.preview.textFont");
        if (!value.isEmpty()) {
            html.append("font-family:");
            html.append(value);
            html.append(';');
        }
        html.append("line-height:");
        html.append(Var.getString("sys.service.preview.textLineHeight"));
        html.append(";font-size:");
        html.append(Var.getString("sys.service.preview.textFontSize"));
        html.append(";}.header{");
        value = Var.getString("sys.service.preview.headerBackColor");
        if (!value.isEmpty()) {
            html.append("background-color:");
            html.append(value);
            html.append(';');
        }
        html.append("font-weight:");
        html.append(Var.getString("sys.service.preview.headerFontWeight"));
        html.append(";}td{border:1px solid #000000;padding:0 2px 0 2px;}th{border:0;}.wrap{word-wrap:break-word;}</style></head><body>");
        JSONArray fields = DataOutput.createHtmlHeaders(html, headers, title, neptune, rowNumberWidth, rowNumberTitle);
        DataOutput.getTextContent(request, html, records, fields, dateFormat, timeFormat, rowNumberWidth > -1, true, decimalSeparator, thousandSeparator, null, false);
        html.append("</table></body></html>");
        outputStream.write(html.toString().getBytes("utf-8"));
    }

    public static void outputText(OutputStream outputStream, JSONArray headers, JSONArray records, String defaultDateFormat, String defaultTimeFormat, String decimalSeparator, String thousandSeparator, boolean isCSV) throws Exception {
        DataOutput.outputTextForReq(null, outputStream, headers, records, defaultDateFormat, defaultTimeFormat, decimalSeparator, thousandSeparator, isCSV);
    }

    public static void outputTextForReq(HttpServletRequest request, OutputStream outputStream, JSONArray headers, JSONArray records, String defaultDateFormat, String defaultTimeFormat, String decimalSeparator, String thousandSeparator, boolean isCSV) throws Exception {
        StringBuilder text = new StringBuilder();
        JSONArray leafs = new JSONArray();
        String lineSeparator = SysUtil.getLineSeparator();
        leafs.put(0);
        DataOutput.markParents(leafs, headers, null, 0);
        leafs.remove(0);
        int j = leafs.length();
        int i = 0;
        while (i < j) {
            if (i > 0) {
                text.append(isCSV ? (char)',' : '\t');
            }
            text.append(leafs.getJSONObject(i).optString(TEXTPROP));
            ++i;
        }
        text.append(lineSeparator);
        DataOutput.getTextContent(request, text, records, leafs, defaultDateFormat, defaultTimeFormat, false, false, decimalSeparator, thousandSeparator, lineSeparator, isCSV);
        outputStream.write(text.toString().getBytes("utf-8"));
    }

    private static JSONArray createHtmlHeaders(StringBuilder html, JSONArray rawHeaders, String title, boolean neptune, int rowNumberWidth, String rowNumberTitle) {
        JSONArray row;
        JSONObject node;
        JSONArray leafs = new JSONArray();
        JSONArray grid = new JSONArray();
        int flexWidth = Var.getInt("sys.service.excel.flexColumnMaxWidth");
        double rate = neptune ? 0.87719298 : 1.0;
        int tableWidth = rowNumberWidth > -1 ? (rowNumberWidth = (int)Math.round((double)rowNumberWidth * rate)) : 0;
        leafs.put(0);
        DataOutput.markParents(leafs, rawHeaders, null, 0);
        int maxDepth = leafs.getInt(0);
        leafs.remove(0);
        int j = leafs.length();
        int i = 0;
        while (i < j) {
            node = leafs.getJSONObject(i);
            tableWidth += DataOutput.getHtmlCellWidth(node, flexWidth, rate);
            int y = node.getInt(CELLY);
            node.put("rowspan", maxDepth - y);
            do {
                node.put("colspan", node.getInt("colspan") + 1);
                if (node.has("x")) continue;
                node.put("x", i);
                y = node.getInt(CELLY);
                row = grid.optJSONArray(y);
                if (row == null) {
                    row = new JSONArray();
                    grid.put(y, (Object)row);
                }
                row.put(i, (Object)node);
            } while ((node = (JSONObject)node.opt("parent")) != null);
            ++i;
        }
        if (title != null) {
            html.append("<p style=\"text-align:center;width:");
            html.append(tableWidth);
            html.append("px;");
            String value = Var.getString("sys.service.preview.titleFont");
            if (!value.isEmpty()) {
                html.append("font-family:");
                html.append(value);
                html.append(';');
            }
            html.append("font-weight:");
            html.append(Var.getString("sys.service.preview.titleFontWeight"));
            html.append(";line-height:");
            html.append(Var.getString("sys.service.preview.titleLineHeight"));
            html.append(";font-size:");
            html.append(Var.getString("sys.service.preview.titleFontSize"));
            html.append(";\">");
            html.append(StringUtil.toHTML(title, true, true));
            html.append("</p>");
        }
        html.append("<table style=\"width:");
        html.append(tableWidth);
        html.append("px;\">");
        html.append("<tr style=\"height:0\">");
        if (rowNumberWidth > -1) {
            html.append("<th width=\"");
            html.append(rowNumberWidth);
            html.append("px\"></th>");
        }
        j = leafs.length();
        i = 0;
        while (i < j) {
            node = leafs.getJSONObject(i);
            html.append("<th width=\"");
            html.append(DataOutput.getHtmlCellWidth(node, flexWidth, rate));
            html.append("px\"></th>");
            ++i;
        }
        html.append("</tr>");
        j = grid.length();
        i = 0;
        while (i < j) {
            html.append("<tr class=\"header\">");
            if (rowNumberWidth > -1 && i == 0) {
                html.append("<td rowspan=\"");
                html.append(maxDepth + 1);
                html.append("\">");
                html.append(rowNumberTitle);
                html.append("</td>");
            }
            row = grid.getJSONArray(i);
            int l = row.length();
            int k = 0;
            while (k < l) {
                node = row.optJSONObject(k);
                if (node != null) {
                    int rowspan;
                    html.append("<td align=\"");
                    int colspan = node.getInt("colspan");
                    String align = node.optString("titleAlign");
                    if (StringUtil.isEmpty(align) && colspan > 0) {
                        align = "center";
                    }
                    html.append(align);
                    html.append('\"');
                    if (colspan > 0) {
                        html.append(" colspan=\"");
                        html.append(colspan + 1);
                        html.append("\"");
                    }
                    if ((rowspan = node.getInt("rowspan")) > 0) {
                        html.append(" rowspan=\"");
                        html.append(rowspan + 1);
                        html.append("\"");
                    }
                    html.append('>');
                    html.append(node.optString(TEXTPROP));
                    html.append("</td>");
                }
                ++k;
            }
            html.append("</tr>");
            ++i;
        }
        return leafs;
    }

    private static int getHtmlCellWidth(JSONObject node, int flexWidth, double rate) {
        int width = node.has("width") ? node.getInt("width") : (node.has("flex") ? flexWidth : 100);
        return (int)Math.round((double)width * rate);
    }

    private static void getTextContent(HttpServletRequest request, StringBuilder buf, JSONArray records, JSONArray fields, String defaultDateFormat, String defaultTimeFormat, boolean hasRowNumber, boolean isHtml, String decimalSeparator, String thousandSeparator, String lineSeparator, boolean isCSV) {
        boolean useBoolString;
        int j = records.length();
        int l = fields.length();
        String[] fieldNames = new String[l];
        String boolString = Var.getString("sys.service.excel.boolText");
        String trueText = null;
        String falseText = null;
        String[] aligns = new String[l];
        boolean[] wraps = new boolean[l];
        int[] dataTypes = new int[l];
        Format[] formats = new Format[l];
        SimpleDateFormat dateFormat = new SimpleDateFormat(ExcelObject.toJavaDateFormat(defaultDateFormat, true));
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat(ExcelObject.toJavaDateFormat(String.valueOf(defaultDateFormat) + " " + defaultTimeFormat, true));
        Object[] keyMaps = new Object[l];
        boolean bl = useBoolString = !boolString.isEmpty();
        if (useBoolString) {
            String[] boolStrings = boolString.split(",");
            trueText = boolStrings[0];
            falseText = boolStrings[1];
        }
        int k = 0;
        while (k < l) {
            int dataType;
            String dataTypeStr;
            JSONObject field = fields.getJSONObject(k);
            String keyName = field.optString(KEYNAMEPROP);
            if (keyName.isEmpty()) {
                keyMaps[k] = null;
                dataTypeStr = field.optString("type").toLowerCase();
            } else {
                keyMaps[k] = KVBuffer.getLangBuffer(request).get(keyName);
                dataTypeStr = "string";
            }
            String format = field.optString("format");
            formats[k] = null;
            if (dataTypeStr.equals("string")) {
                dataType = 1;
            } else if (dataTypeStr.startsWith("int") || dataTypeStr.equals("float") || dataTypeStr.equals("number")) {
                dataType = 2;
                if (!format.isEmpty()) {
                    DecimalFormat decimalFormat = new DecimalFormat(format);
                    decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
                    DecimalFormatSymbols dfs = new DecimalFormatSymbols();
                    dfs.setDecimalSeparator(decimalSeparator.charAt(0));
                    dfs.setGroupingSeparator(thousandSeparator.charAt(0));
                    decimalFormat.setDecimalFormatSymbols(dfs);
                    formats[k] = decimalFormat;
                }
            } else if (dataTypeStr.equals("date")) {
                dataType = 3;
                if (!StringUtil.isEmpty(format)) {
                    formats[k] = (format = ExcelObject.toJavaDateFormat(format, false)) == null ? dateFormat : new SimpleDateFormat(format);
                }
            } else {
                dataType = dataTypeStr.startsWith("bool") ? 4 : 5;
            }
            dataTypes[k] = dataType;
            fieldNames[k] = field.optString(FIELDPROP);
            aligns[k] = field.optString("align");
            wraps[k] = Boolean.TRUE.equals(field.opt("autoWrap"));
            ++k;
        }
        int i = 0;
        while (i < j) {
            JSONObject record = (JSONObject)records.opt(i);
            if (isHtml) {
                buf.append("<tr>");
                if (hasRowNumber) {
                    buf.append("<td align=\"right\">");
                    buf.append(i + 1);
                    buf.append("</td>");
                }
            } else if (i > 0) {
                buf.append(lineSeparator);
            }
            k = 0;
            while (k < l) {
                Object value = JsonUtil.opt(record, fieldNames[k]);
                if (value == null) {
                    if (isHtml) {
                        buf.append("<td></td>");
                    } else {
                        buf.append(isCSV ? "," : "\t");
                    }
                } else {
                    String valueText;
                    if (isHtml) {
                        buf.append("<td");
                        if (!aligns[k].isEmpty()) {
                            buf.append(" align=\"");
                            buf.append(aligns[k]);
                            buf.append("\"");
                        }
                        if (wraps[k]) {
                            buf.append(" class=\"wrap\"");
                        }
                        buf.append('>');
                    } else if (k > 0) {
                        buf.append(isCSV ? "," : "\t");
                    }
                    if (keyMaps[k] != null) {
                        value = KVBuffer.getValue((Map)keyMaps[k], value);
                    }
                    if (dataTypes[k] == 5) {
                        dataTypes[k] = value instanceof Number ? 2 : (value instanceof Date ? 3 : (value instanceof Boolean ? 4 : 1));
                    }
                    switch (dataTypes[k]) {
                        case 2: {
                            double number;
                            if (value instanceof Number) {
                                if (formats[k] == null) {
                                    valueText = StringUtil.replaceFirst(value.toString(), ".", decimalSeparator);
                                    break;
                                }
                                number = ((Number)value).doubleValue();
                                valueText = formats[k].format(number);
                                break;
                            }
                            if (formats[k] == null) {
                                valueText = StringUtil.replaceFirst(value.toString(), ".", decimalSeparator);
                                break;
                            }
                            number = Double.parseDouble(value.toString());
                            valueText = formats[k].format(number);
                            break;
                        }
                        case 3: {
                            Date date;
                            if (formats[k] == null) {
                                boolean hasTime;
                                if (value instanceof Date) {
                                    date = (Date)value;
                                    hasTime = !DateUtil.dateToStr(date).endsWith("00:00:00.0");
                                } else {
                                    String dateTimeStr = value.toString();
                                    date = Timestamp.valueOf(dateTimeStr);
                                    boolean bl2 = hasTime = !dateTimeStr.endsWith("00:00:00.0") && !(dateTimeStr.endsWith("00:00:00") | dateTimeStr.endsWith("00:00:00.000"));
                                }
                                if (hasTime) {
                                    valueText = dateTimeFormat.format((Object)date);
                                    break;
                                }
                                valueText = dateFormat.format((Object)date);
                                break;
                            }
                            date = value instanceof Date ? (Date)value : Timestamp.valueOf(value.toString());
                            valueText = formats[k].format(date);
                            break;
                        }
                        case 4: {
                            if (useBoolString) {
                                valueText = StringUtil.getBool(value.toString()) ? trueText : falseText;
                                break;
                            }
                            valueText = value.toString();
                            break;
                        }
                        default: {
                            valueText = value.toString();
                        }
                    }
                    if (isHtml) {
                        buf.append(StringUtil.toHTML(valueText, true, true));
                        buf.append("</td>");
                    } else {
                        buf.append(valueText);
                    }
                }
                ++k;
            }
            if (isHtml) {
                buf.append("</tr>");
            }
            ++i;
        }
    }

    public static void importToExcel(JSONObject params, File excelFile, OutputStream outputStream, int sheetIndex) throws Exception {
        DataOutput.importToExcelForReq(null, params, excelFile, outputStream, sheetIndex);
    }

    public static void importToExcelForReq(HttpServletRequest request, JSONObject params, File excelFile, OutputStream outputStream, int sheetIndex) throws Exception {
        try (FileInputStream is = new FileInputStream(excelFile);){
            boolean is07v = excelFile.getName().toLowerCase().endsWith(".xls");
            DataOutput.importToExcelForReq(request, params, is, outputStream, sheetIndex, is07v);
        }
    }

    public static Workbook getWorkBook(String excelName, InputStream inputStream) throws IOException {
        HSSFWorkbook workbook = null;
        workbook = excelName.toLowerCase().endsWith(".xls") ? new HSSFWorkbook(inputStream) : new XSSFWorkbook(inputStream);
        return workbook;
    }

    public static void importToExcel(JSONObject params, InputStream inputStream, OutputStream outputStream, int sheetIndex, boolean is07v) throws Exception {
        DataOutput.importToExcelForReq(null, params, inputStream, outputStream, sheetIndex, is07v);
    }

    public static void importToExcelForReq(HttpServletRequest request, JSONObject params, InputStream inputStream, OutputStream outputStream, int sheetIndex, boolean is07v) throws Exception {
        HSSFWorkbook book = null;
        try {
            book = is07v ? new HSSFWorkbook(inputStream) : new XSSFWorkbook(inputStream);
            int j = book.getNumberOfSheets();
            int i = j - 1;
            while (i >= 0) {
                if (sheetIndex != -1 && i != sheetIndex) {
                    book.removeSheetAt(i);
                } else {
                    Sheet sheet = book.getSheetAt(i);
                    DataOutput.importToSheetForReq(request, (Workbook)book, sheet, params);
                    ExcelObject.executeInstruction(sheet, params);
                }
                --i;
            }
            book.write(outputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(book);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)book);
    }

    public static void importMulSheetToExcel(JSONObject params, File excelFile, OutputStream outputStream) throws Exception {
        DataOutput.importMulSheetToExcelForReq(null, params, excelFile, outputStream);
    }

    public static void importMulSheetToExcelForReq(HttpServletRequest request, JSONObject params, File excelFile, OutputStream outputStream) throws Exception {
        XSSFWorkbook book = null;
        if (excelFile.getName().toLowerCase().endsWith(".xls")) {
            throw new IllegalArgumentException("Excel file version requires 2007+");
        }
        FileInputStream is = new FileInputStream(excelFile);
        try {
            book = new XSSFWorkbook((InputStream)is);
            if (book != null && params != null) {
                for (Map.Entry entry : params.entrySet()) {
                    String sheetName = (String)entry.getKey();
                    JSONObject everySheetData = (JSONObject)entry.getValue();
                    Sheet sheet = book.getSheet(sheetName);
                    if (sheet == null) continue;
                    DataOutput.importToSheetForReq(request, (Workbook)book, sheet, everySheetData);
                    ExcelObject.executeInstruction(sheet, everySheetData);
                }
            }
            book.write(outputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(book);
            if (is != null) {
                is.close();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)book);
        if (is != null) {
            is.close();
        }
    }

    public static void importToSheet(Workbook book, Sheet sheet, JSONObject data) throws Exception {
        DataOutput.importToSheetForReq(null, book, sheet, data);
    }

    public static void importToSheetForReq(HttpServletRequest request, Workbook book, Sheet sheet, JSONObject data) throws Exception {
        long start = System.currentTimeMillis();
        DataOutput.dealMutiData(request, sheet, data);
        DataOutput.dealDynHeader(book, sheet, data);
        log.info((Object)("\u5904\u7406\u52a8\u6001\u8868\u5934\u8017\u65f6:" + (System.currentTimeMillis() - start)));
        Iterator rows = sheet.rowIterator();
        while (rows.hasNext()) {
            Row row = (Row)rows.next();
            Iterator cells = row.cellIterator();
            while (cells.hasNext()) {
                boolean replaced;
                Cell cell = (Cell)cells.next();
                Object value = ExcelObject.getCellValue(cell);
                if (value == null) continue;
                String name = value.toString();
                if (name.indexOf("{#") != -1) {
                    replaced = true;
                    name = WebUtil.replaceParams(data, name);
                    value = name;
                } else {
                    replaced = false;
                }
                if (name.startsWith("{") && name.endsWith("}")) {
                    if (name.indexOf(58) == -1) {
                        String[] express = StringUtil.split(name.substring(1, name.length() - 1), ' ');
                        if ((name = express[0]).length() > 0) {
                            char firstChar = name.charAt(0);
                            if (firstChar == '!' || firstChar == '%' || firstChar == '*') {
                                name = name.substring(1);
                            }
                        } else {
                            name = null;
                        }
                    } else {
                        try {
                            name = new JSONObject(name).optString("itemId");
                        }
                        catch (Throwable e) {
                            name = null;
                        }
                    }
                    if (name == null) {
                        value = null;
                    } else {
                        String showName;
                        if (name.startsWith("_") && !data.has(name)) {
                            name = name.substring(1);
                        }
                        value = data.has(showName = "%" + name) ? JsonUtil.opt(data, showName) : JsonUtil.opt(data, name);
                    }
                } else if (!replaced) continue;
                ExcelObject.setCellValue(cell, value);
            }
        }
    }

    private static void dealMutiData(HttpServletRequest request, Sheet sheet, JSONObject data) throws Exception {
        JSONArray gridModelInfos = DataOutput.getGridModelInfos(sheet, data);
        if (gridModelInfos == null) {
            return;
        }
        List<Map<String, Object>> list = null;
        JSONObject gridModelInfo = null;
        String rowsKey = null;
        JSONArray parseArray = null;
        JSONArray keyFields = data.optJSONArray(KEYFIELDSPROP);
        SqlExecutor sqlExecutor = (SqlExecutor)SpringContextUtil.getBean((String)"sqlExecutor");
        JdbcTemplate jdbcTemplate = (JdbcTemplate)SpringContextUtil.getBean((String)"jdbcTemplate");
        if (gridModelInfos != null) {
            gridModelInfos.length();
        }
        for (Object obj : gridModelInfos) {
            JSONObject rows;
            String exp;
            gridModelInfo = (JSONObject)obj;
            rowsKey = gridModelInfo.optString(NAMEPROP);
            Object perGridRows = data.opt(rowsKey);
            if (perGridRows == null) continue;
            list = perGridRows instanceof JSONObject ? ((exp = (rows = (JSONObject)perGridRows).optString(SQLPROP)).trim().startsWith(SPPREFIX) ? SqlUtil.executeSp(sqlExecutor, exp, new HashMap<String, Object>()) : SqlUtil.executeSql(jdbcTemplate, exp)) : (List<Map<String, Object>>)JSON.parse((String)perGridRows.toString());
            if (keyFields != null) {
                DataOutput.dealKVConvert(request, list, keyFields);
            }
            parseArray = new JSONArray(JSON.toJSONString((Object)list));
            data.put(rowsKey, (Object)parseArray);
        }
    }

    private static List<Map<String, Object>> dealKVConvert(HttpServletRequest request, List<Map<String, Object>> list, JSONArray keyFields) {
        if (list != null && list.size() > 0) {
            for (Map<String, Object> map : list) {
                Set<String> fields = map.keySet();
                Map<String, Map<Object, String>> keyMap = DataOutput.getKeyMap(request, fields, keyFields);
                for (String field : fields) {
                    Object defaultValue = map.get(field);
                    if (!keyMap.containsKey(field)) continue;
                    String value = KVBuffer.getValue(keyMap.get(field), defaultValue);
                    map.put(field, value);
                }
            }
        }
        return list;
    }

    private static Map<String, Map<Object, String>> getKeyMap(HttpServletRequest request, Set<String> fields, JSONArray keyFields) {
        HashMap<String, Map<Object, String>> keyMap = new HashMap<String, Map<Object, String>>();
        JSONObject keyJson = null;
        if (fields != null && fields.size() > 0) {
            for (String field : fields) {
                keyJson = JsonUtil.findObject(keyFields, FIELDPROP, field);
                if (keyJson == null) continue;
                String keyName = keyJson.optString(KEYNAMEPROP);
                if (!KVBuffer.getLangBuffer(request).containsKey(keyName)) continue;
                keyMap.put(field, KVBuffer.getLangBuffer(request).get(keyName));
            }
        }
        return keyMap;
    }

    public static void dealDynHeader(Workbook book, Sheet sheet, JSONObject params) {
        JSONArray gridModelInfos = null;
        JSONArray newGridModelInfos = new JSONArray();
        JSONObject perGridModelInfoObj = null;
        JSONObject newPerGridModelInfoObj = null;
        Object list = null;
        gridModelInfos = DataOutput.getGridModelInfos(sheet, params);
        if (gridModelInfos == null) {
            return;
        }
        int addRow = 0;
        int i = 0;
        while (i < gridModelInfos.length()) {
            perGridModelInfoObj = gridModelInfos.getJSONObject(i);
            int orgY = perGridModelInfoObj.getInt(CELLY);
            perGridModelInfoObj.put(CELLY, orgY + addRow);
            JSONArray headers = DataOutput.getHeaders(params, perGridModelInfoObj);
            if (headers == null || headers.length() == 0) {
                newGridModelInfos.add(i, (Object)perGridModelInfoObj);
            } else {
                int fillRows = DataOutput.getFillRows(book, headers, perGridModelInfoObj.getInt(CELLY), false);
                addRow += fillRows + 1;
                newPerGridModelInfoObj = DataOutput.dealPerDynHeader(book, sheet, params, perGridModelInfoObj, headers);
                newGridModelInfos.add(i, (Object)perGridModelInfoObj);
            }
            ++i;
        }
        Cell cell = sheet.getRow(sheet.getLastRowNum()).getCell(0);
        ExcelObject.setCellValue(cell, INSTRUCTFLAG + newGridModelInfos.toString());
    }

    private static JSONObject dealPerDynHeader(Workbook book, Sheet sheet, JSONObject params, JSONObject perGridModelInfo, JSONArray headers) {
        int startRow = perGridModelInfo.getInt(CELLY);
        int headerRows = DataOutput.getFillRows(book, headers, startRow, false);
        int shiftRows = headerRows + 1;
        sheet.shiftRows(startRow, sheet.getLastRowNum(), shiftRows, true, false);
        DataOutput.createHeaders(sheet, headers, startRow, false);
        List<String> columns = DataOutput.getColumns(params, perGridModelInfo);
        int markRowIndex = startRow + headerRows;
        Row row = DataOutput.getRow(sheet, markRowIndex);
        CellStyle style = DataOutput.setMarkRowCellStyle(book);
        int j = 0;
        while (j < columns.size()) {
            Cell c = DataOutput.getCell(row, j);
            c.setCellStyle(style);
            c.setCellValue(columns.get(j));
            ++j;
        }
        perGridModelInfo.put(CELLY, markRowIndex);
        return perGridModelInfo;
    }

    private static JSONArray getHeaders(JSONObject params, JSONObject gridModelInfoObj) {
        JSONArray headers = null;
        ArrayList<Object> root = new ArrayList<Object>();
        String keyName = gridModelInfoObj.optString(HEADERPROP);
        if (keyName == null) {
            return null;
        }
        Object object = params.opt(keyName);
        if (object instanceof String) {
            headers = new JSONArray(object.toString());
        } else if (object instanceof JSONArray) {
            headers = params.optJSONArray(keyName);
        }
        DataOutput.filter(root, headers);
        JSONArray ret = new JSONArray(JSON.toJSONString(root));
        return ret;
    }

    private static void filter(List<Object> root, JSONArray headers) {
        if (headers != null && headers.length() > 0) {
            for (Object json : headers) {
                JSONObject child = (JSONObject)json;
                if (StringUtils.isEmpty((Object)child.optString(DATAINDEXPROP)) && child.optJSONArray(ITEMSPROP) == null || child.optBoolean(HIDDENPROP)) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (String key : child.keySet()) {
                    if (ITEMSPROP.equals(key) && child.getJSONArray(key).length() > 0) {
                        ArrayList<Object> list = new ArrayList<Object>();
                        DataOutput.filter(list, child.getJSONArray(ITEMSPROP));
                        map.put(ITEMSPROP, list);
                        continue;
                    }
                    if (TEXTPROP.equals(key) && child.getString(TEXTPROP).startsWith(HEADERSTARTFLAG)) {
                        map.put(key, "");
                        continue;
                    }
                    if (DATAINDEXPROP.equals(key)) {
                        if (StringUtils.isEmpty((Object)child.optString(DATAINDEXPROP))) continue;
                        map.put(key, child.get(key));
                        continue;
                    }
                    map.put(key, child.get(key));
                }
                root.add(map);
            }
        }
    }

    private static List<String> getColumns(JSONObject params, JSONObject gridModelInfoObj) {
        LinkedList<String> columns = new LinkedList<String>();
        JSONArray headers = DataOutput.getHeaders(params, gridModelInfoObj);
        DataOutput.iteratorColumns(headers, columns);
        return columns;
    }

    private static List<String> iteratorColumns(JSONArray headers, List<String> columns) {
        if (headers != null && headers.length() != 0) {
            int i = 0;
            while (i < headers.length()) {
                JSONObject obj = headers.optJSONObject(i);
                if (obj != null) {
                    String dataIndex = obj.optString(DATAINDEXPROP);
                    if (!StringUtils.isEmpty((Object)dataIndex)) {
                        columns.add(dataIndex);
                    } else if (obj.optJSONArray(ITEMSPROP) != null) {
                        JSONArray items = obj.optJSONArray(ITEMSPROP);
                        DataOutput.iteratorColumns(items, columns);
                    }
                }
                ++i;
            }
        }
        return columns;
    }

    private static JSONArray getGridModelInfos(Sheet sheet, JSONObject params) {
        JSONArray gridModelInfos = null;
        int lastRowIndex = sheet.getLastRowNum();
        Row lastRow = sheet.getRow(lastRowIndex);
        if (lastRow == null) {
            return null;
        }
        Cell cell = lastRow.getCell(0);
        if (cell == null) {
            return null;
        }
        Object value = ExcelObject.getCellValue(cell);
        if (value == null) {
            return null;
        }
        String instruction = value.toString();
        if (!(instruction = WebUtil.replaceParams(params, instruction)).startsWith(INSTRUCTFLAG)) {
            return null;
        }
        instruction = instruction.substring(2);
        gridModelInfos = instruction.startsWith("{") ? new JSONArray("[" + instruction + "]") : new JSONArray(instruction);
        return gridModelInfos;
    }

    private static int getFillRows(Workbook book, JSONArray headers, int startRow, boolean neptune) {
        JSONArray tmpHeaders = new JSONArray(headers.toString());
        Sheet tempSheet = book.createSheet(TMPSHEETNAME);
        int removeSheetIndex = book.getSheetIndex(TMPSHEETNAME);
        Object[] values = DataOutput.createHeaders(tempSheet, tmpHeaders, startRow, neptune);
        book.removeSheetAt(removeSheetIndex);
        tmpHeaders = null;
        return (Integer)values[1];
    }

    private static Row getRow(Sheet sheet, int rowIndex) {
        Row row = sheet.getRow(rowIndex);
        if (row == null) {
            row = sheet.createRow(rowIndex);
        }
        return row;
    }

    private static Cell getCell(Row row, int cellIndex) {
        Cell cell = row.getCell(cellIndex);
        if (cell == null) {
            cell = row.createCell(cellIndex);
        }
        return cell;
    }

    private static CellStyle setMarkRowCellStyle(Workbook book) {
        CellStyle style = book.createCellStyle();
        style.setBorderTop((short)1);
        style.setBorderBottom((short)1);
        style.setBorderLeft((short)1);
        style.setBorderRight((short)1);
        return style;
    }

    public static void outputDBF(OutputStream outputStream, JSONArray headers, JSONArray records) throws Exception {
        int j = records.length();
        int l = headers.length();
        String[] fieldNames = new String[l];
        int[] dataTypes = new int[l];
        DBFWriter writer = new DBFWriter();
        writer.setCharactersetName("GBK");
        DBFField[] fields = new DBFField[l];
        Object[] rowData = null;
        int k = 0;
        while (k < l) {
            int dataType;
            fields[k] = new DBFField();
            JSONObject field = headers.getJSONObject(k);
            String dataTypeStr = field.optString("type");
            int fieldLength = field.optInt("width", 1);
            if (dataTypeStr.equals("string")) {
                dataType = 1;
                fields[k].setDataType((byte)67);
                fieldLength = fieldLength > 254 ? 254 : fieldLength;
                fields[k].setFieldLength(fieldLength == 1 ? 3 : fieldLength);
            } else if (dataTypeStr.startsWith("int") || dataTypeStr.equals("float") || dataTypeStr.equals("number")) {
                dataType = 2;
                fields[k].setDataType((byte)78);
                fieldLength = fieldLength > 32 ? 32 : fieldLength;
                fields[k].setFieldLength(fieldLength);
                fields[k].setDecimalCount(field.optInt("metaScale"));
            } else if (dataTypeStr.equals("date")) {
                dataType = 3;
                fields[k].setDataType((byte)68);
            } else if (dataTypeStr.startsWith("bool")) {
                dataType = 4;
                fields[k].setDataType((byte)76);
            } else {
                dataType = 5;
                fields[k].setDataType((byte)67);
                fieldLength = fieldLength > 254 ? 254 : fieldLength;
                fields[k].setFieldLength(fieldLength == 1 ? 3 : fieldLength);
            }
            dataTypes[k] = dataType;
            fieldNames[k] = field.optString(FIELDPROP);
            fields[k].setName(DataOutput.getFieldName(fieldNames[k]));
            ++k;
        }
        writer.setFields(fields);
        int i = 0;
        while (i < j) {
            rowData = new Object[l];
            JSONObject record = (JSONObject)records.opt(i);
            k = 0;
            while (k < l) {
                Object value = JsonUtil.opt(record, fieldNames[k]);
                if (dataTypes[k] == 5) {
                    dataTypes[k] = value instanceof Number ? 2 : (value instanceof Date ? 3 : (value instanceof Boolean ? 4 : 1));
                }
                switch (dataTypes[k]) {
                    case 2: {
                        double number;
                        if (value instanceof Number) {
                            number = ((Number)value).doubleValue();
                            value = number;
                            break;
                        }
                        number = Double.parseDouble(ObjectUtils.toString((Object)value, (String)"0"));
                        value = number;
                        break;
                    }
                    case 3: {
                        if (value instanceof Date) {
                            value = (Date)value;
                            break;
                        }
                        value = ObjectUtils.toString((Object)value, null) == null ? null : Timestamp.valueOf(ObjectUtils.toString((Object)value, null));
                        break;
                    }
                    case 4: {
                        value = Boolean.parseBoolean(ObjectUtils.toString((Object)value, (String)"False"));
                        break;
                    }
                    default: {
                        value = ObjectUtils.toString((Object)value);
                    }
                }
                rowData[k] = value;
                ++k;
            }
            writer.addRecord(rowData);
            ++i;
        }
        writer.write(outputStream);
    }

    public static String getFieldName(String fieldName) {
        Pattern pWord = Pattern.compile("[\u4e00-\u9fa5]");
        Pattern dWord = Pattern.compile("[a-zA-Z0-9]");
        if (pWord.matcher(fieldName).find() && fieldName.length() > 5) {
            return fieldName.substring(0, 5);
        }
        if (dWord.matcher(fieldName).find() && fieldName.length() > 10) {
            return fieldName.substring(0, 10);
        }
        return fieldName;
    }

    public static String getExtName() {
        return Var.getBool("sys.service.excel.xlsx") ? ".xlsx" : ".xls";
    }

    public static void main(String[] args) {
        String s = null;
        System.out.println(Timestamp.valueOf(s));
    }
}

