/*
 * Decompiled with CFR 0.152.
 */
package com.wb.ldap;

import com.wb.common.Var;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.directory.InitialDirContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAP {
    private static Logger log = LoggerFactory.getLogger(LDAP.class);
    private static final String STRING_INITIAL_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String STRING_SECURITY_AUTHENTICATION = "simple";
    private String ldapServerPath = "";

    public LDAP(String ldapServerPath) {
        this.ldapServerPath = ldapServerPath;
    }

    private String makeSecurityPrincipal(String host, String employeeCode) {
        return String.valueOf(employeeCode) + "@" + host;
    }

    private Hashtable<String, String> makeRequest(String host, String employeeCode, String password) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (this.ldapServerPath.contains("ldaps") || this.ldapServerPath.contains("636")) {
            String sslPath = null;
            String sslPass = null;
            try {
                sslPath = (String)Var.get("sys.ldap.sslPath");
                sslPass = (String)Var.get("sys.ldap.sslPassword");
                System.setProperty("javax.net.ssl.trustStore", sslPath);
                System.setProperty("javax.net.ssl.keyStorePassword", sslPass);
                env.put("java.naming.security.protocol", "ssl");
            }
            catch (Exception e) {
                log.error("\u8bbe\u7f6eldaps ssl\u8bc1\u4e66\u51fa\u9519", (Throwable)e);
            }
        }
        env.put("java.naming.factory.initial", STRING_INITIAL_CONTEXT_FACTORY);
        env.put("java.naming.security.authentication", STRING_SECURITY_AUTHENTICATION);
        env.put("java.naming.security.principal", this.makeSecurityPrincipal(host, employeeCode));
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.provider.url", this.ldapServerPath);
        return env;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String doLdapLogin(String host, String userName, String password) throws Exception {
        System.out.println("============LDAP\u8ba4\u8bc1\u5f00\u59cb=============");
        String result = "";
        Hashtable<String, String> env = this.makeRequest(host, userName, password);
        try (InitialDirContext dirContext = null;){
            try {
                dirContext = new InitialDirContext(env);
                System.out.println("===========LDAP\u8ba4\u8bc1\u6210\u529f============");
                return result;
            }
            catch (AuthenticationException e) {
                String authErrStr = e.toString();
                System.out.println("LDAP\u8ba4\u8bc1\u5931\u8d25\uff1a" + authErrStr);
                result = this.getResult(authErrStr);
                if (dirContext == null) return result;
                dirContext.close();
                return result;
            }
            catch (Exception ex) {
                System.out.println("LDAP\u8ba4\u8bc1\u9519\u8bef:{}" + ex);
                result = "\u5176\u4ed6\u9519\u8bef";
                if (dirContext == null) return result;
                dirContext.close();
                return result;
            }
        }
    }

    public String getResult(String authErrStr) {
        String result = "";
        if (authErrStr.contains("data 525")) {
            result = "\u7528\u6237\u540d\u4e0d\u5b58\u5728";
        } else if (authErrStr.contains("data 52e")) {
            result = "\u7528\u6237\u540d\u6216\u5bc6\u7801\u65e0\u6548";
        } else if (authErrStr.contains("data 530")) {
            result = "\u6b64\u65f6\u4e0d\u5141\u8bb8\u767b\u5f55";
        } else if (authErrStr.contains("data 531")) {
            result = "\u5728\u6b64\u5de5\u4f5c\u7ad9\u4e0a\u4e0d\u5141\u8bb8\u767b\u5f55";
        } else if (authErrStr.contains("data 532")) {
            result = "\u5bc6\u7801\u8fc7\u671f";
        } else if (authErrStr.contains("data 533")) {
            result = "\u8d26\u6237\u7981\u7528";
        } else if (authErrStr.contains("data 701")) {
            result = "\u8d26\u6237\u8fc7\u671f";
        } else if (authErrStr.contains("data 773")) {
            result = "\u7528\u6237\u5fc5\u987b\u91cd\u7f6e\u5bc6\u7801";
        } else if (authErrStr.contains("data 775")) {
            result = "\u7528\u6237\u8d26\u6237\u9501\u5b9a";
        }
        return result;
    }
}

