/*
 * Decompiled with CFR 0.152.
 */
package com.wb.interact;

import com.ks.fintech.bw.api.FunctionEObj;
import com.wb.interact.ScanXwl;
import com.wb.util.StringUtil;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ks.fintech.bw.api.service.BasicServiceAware;
import ks.fintech.bw.api.service.CacheServiceAware;
import ks.fintech.bw.api.service.FunctionContentCacheAware;
import ks.fintech.framework.core.exception.KException;
import ks.fintech.framework.utils.DateUtils;
import ks.fintech.framework.utils.SpringContextUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SearchUtils {
    public static boolean containXwl(String[] filePatterns) {
        if (filePatterns != null) {
            String[] stringArray = filePatterns;
            int n = filePatterns.length;
            int n2 = 0;
            while (n2 < n) {
                String pattern = stringArray[n2];
                if (pattern.endsWith(".xwl")) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static void dealXwl(HttpServletRequest request, HttpServletResponse response, JSONArray rows, ScanXwl deal, String xwlBasePath) throws KException, JSONException, IOException {
        boolean whole = Boolean.parseBoolean(request.getParameter("whole"));
        String searchText = request.getParameter("search");
        boolean caseSensitive = Boolean.parseBoolean(request.getParameter("caseSensitive"));
        Pattern searchPattern = null;
        boolean regularExp = Boolean.parseBoolean(request.getParameter("regularExp"));
        String replace = request.getParameter("replace");
        searchPattern = regularExp ? Pattern.compile(searchText) : Pattern.compile(StringUtil.concat(caseSensitive ? "" : "(?i)", whole ? "\\b" : "", "\\Q", searchText, "\\E", whole ? "\\b" : ""));
        boolean isReplace = Boolean.parseBoolean(request.getParameter("isReplace"));
        SearchUtils.replaceOrSearch(isReplace, replace, searchPattern, xwlBasePath, (String)request.getSession().getAttribute("sys.username"), deal, rows);
    }

    public static void replaceOrSearch(boolean isReplace, String replace, Pattern searchPattern, String xwlBasePath, String userId, ScanXwl deal, JSONArray rows) throws KException {
        FunctionContentCacheAware contentCache = (FunctionContentCacheAware)SpringContextUtil.getBean((String)"contentCacheServcie");
        CacheServiceAware cacheService = (CacheServiceAware)SpringContextUtil.getBean((String)"sysCacheServcie");
        for (FunctionEObj func : cacheService.getFuncMap().values()) {
            if (isReplace && replace != null) {
                String replacedText;
                Timestamp ldt = DateUtils.getCurrentTimestamp();
                String content = contentCache.getContent(func.getFuncId()).toString();
                if (content.equals(replacedText = searchPattern.matcher(content).replaceAll(Matcher.quoteReplacement(replace)))) continue;
                func.setFuncContent(replacedText);
                func.setLastUpdateTms(ldt);
                func.setLastUpdateUser(userId);
                JSONObject row = new JSONObject();
                row.put("content", (Object)("\u66ff\u6362\uff1a" + replacedText));
                row.put("path", (Object)(String.valueOf(xwlBasePath) + func.getFuncPath()));
                row.put("lastModified", (Object)func.getLastUpdateTms());
                rows.put((Object)row);
                BasicServiceAware basicService = (BasicServiceAware)SpringContextUtil.getBean((String)"bwBasicService");
                basicService.updateFunctionContent(func);
                continue;
            }
            JSONObject root = new JSONObject();
            JSONObject object = new JSONObject(String.valueOf(contentCache.getContent(func.getFuncId())));
            root.put("children", (Object)new JSONArray().put((Object)object));
            deal.scanXwl(root, String.valueOf(xwlBasePath) + "/" + func.getFuncPath(), searchPattern, rows, null);
        }
    }
}

