/*
 * Decompiled with CFR 0.152.
 */
package com.wb.interact;

import cn.hutool.core.util.StrUtil;
import com.wb.common.Base;
import com.wb.common.Resource;
import com.wb.common.Session;
import com.wb.common.Str;
import com.wb.common.Value;
import com.wb.common.XwlBuffer;
import com.wb.interact.IDE;
import com.wb.util.DbUtil;
import com.wb.util.FileUtil;
import com.wb.util.JsonUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WbUtil;
import com.wb.util.WebUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class Portal {
    private static JSONArray getModuleList(HttpServletRequest request, String path, String[] roles, int type) throws Exception {
        File base;
        int displayType;
        String iconCls = null;
        String relPath = null;
        int n = displayType = type == 1 ? 1 : 3;
        if (path == null) {
            base = Base.modulePath;
        } else {
            base = new File(Base.modulePath, path);
            if (!FileUtil.isAncestor(Base.modulePath, base)) {
                SysUtil.accessDenied();
            }
        }
        path = String.valueOf(path) + "/";
        ArrayList<Map.Entry<String, Integer>> fileNames = IDE.getSortedFile(base);
        JSONObject content = null;
        JSONArray fileArray = new JSONArray();
        for (Map.Entry<String, Integer> entry : fileNames) {
            String fileName = entry.getKey();
            File file = new File(base, fileName);
            if (!file.exists() || !XwlBuffer.canDisplay(file, roles, displayType)) continue;
            boolean isFolder = file.isDirectory();
            if (isFolder) {
                if (type != 1 && !Portal.hasLoginModule(file)) continue;
                File configFile = new File(file, "folder.json");
                content = configFile.exists() ? JsonUtil.readObject(configFile) : new JSONObject();
            } else {
                if (type != 1 && !file.getName().endsWith(".xwl")) continue;
                content = file.getParentFile().equals(Base.modulePath) ? XwlBuffer.get(fileName, false) : XwlBuffer.get(String.valueOf(path) + fileName, false);
                if (type != 1 && Boolean.FALSE.equals(content.opt("loginRequired"))) continue;
            }
            JSONObject fileObject = new JSONObject();
            String qtip = content.optString("qtip");
            String title = Str.getText(request, content.optString("title"));
            fileObject.put("text", (Object)StringUtil.select(title, fileName));
            fileObject.put("isFolder", isFolder ? 1 : 0);
            fileObject.put("qtip", (Object)qtip);
            relPath = FileUtil.getModulePath(file);
            fileObject.put("path", (Object)relPath);
            fileObject.put("fileName", (Object)fileName);
            fileObject.put("inframe", Boolean.TRUE.equals(content.opt("inframe")));
            if (isFolder) {
                fileObject.put("children", (Object)Portal.getModuleList(request, relPath, roles, type));
            } else {
                String pageLink = (String)content.opt("pageLink");
                if (!StringUtil.isEmpty(pageLink)) {
                    fileObject.put("pageLink", (Object)pageLink);
                }
                fileObject.put("leaf", true);
            }
            fileObject.put("cls", (Object)"wb_pointer");
            iconCls = content.optString("iconCls");
            if (!StringUtil.isEmpty(iconCls)) {
                fileObject.put("iconCls", (Object)iconCls);
            }
            if (type == 2) {
                fileObject.put("checked", false);
            }
            fileArray.put((Object)fileObject);
        }
        return fileArray;
    }

    private static boolean hasLoginModule(File path) throws IOException {
        File[] files;
        File[] fileArray = files = FileUtil.listFiles(path);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            JSONObject content;
            File file = fileArray[n2];
            if (file.isDirectory() ? Portal.hasLoginModule(file) : file.getName().endsWith(".xwl") && Boolean.TRUE.equals((content = XwlBuffer.get(FileUtil.getModulePath(file), true)).opt("loginRequired"))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void getAppInfo(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String url = FileUtil.getModuleFile(request.getParameter("url"));
        if (!XwlBuffer.canAccess(request, url)) {
            SysUtil.accessDenied();
        }
        WebUtil.send(response, (Object)WbUtil.getAppInfo(url, request));
    }

    public static void initHome(HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean navIconHidden;
        boolean treeHidden;
        boolean treeCollapsed;
        int viewIndex;
        int treeWidth;
        String desktopString = Resource.getString(request, "desktop", null);
        if (desktopString == null) {
            desktopString = Resource.getString("sys.home.desktop", null);
        }
        if (desktopString != null) {
            JSONObject desktop = new JSONObject(desktopString);
            treeWidth = desktop.optInt("treeWidth", 200);
            viewIndex = desktop.optInt("viewIndex", 2);
            treeCollapsed = desktop.optBoolean("treeCollapsed", false);
            treeHidden = desktop.optBoolean("treeHidden", false);
            navIconHidden = desktop.optBoolean("navIconHidden", false);
            JSONArray pages = desktop.optJSONArray("pages");
            if (pages != null) {
                int j = pages.length();
                int activeIndex = desktop.optInt("active", 0);
                JSONArray tabItems = new JSONArray();
                int i = 0;
                while (i < j) {
                    JSONObject page = pages.optJSONObject(i);
                    String rawUrl = page.optString("url");
                    String url = FileUtil.getModuleFile(rawUrl, true);
                    JSONObject module = XwlBuffer.get(url, true);
                    if (module == null) {
                        if (i <= activeIndex) {
                            --activeIndex;
                        }
                    } else {
                        String qtip;
                        String pageLink;
                        JSONObject item = new JSONObject();
                        item.put("url", (Object)rawUrl);
                        String title = (String)module.opt("title");
                        if (title.startsWith("Str.")) {
                            title = Str.format(request, title.substring(4));
                        }
                        item.put("title", (Object)StringUtil.select(title, FileUtil.getFilename(url)));
                        item.put("iconCls", (Object)((String)module.opt("iconCls")));
                        item.put("inframe", Boolean.TRUE.equals(module.opt("inframe")));
                        String params = page.optString("params");
                        if (!StringUtil.isEmpty(params)) {
                            item.put("params", (Object)new JSONObject(params));
                        }
                        if (!StringUtil.isEmpty(pageLink = (String)module.opt("pageLink"))) {
                            JsonUtil.apply(item, new JSONObject(pageLink));
                        }
                        if (StringUtils.isNotBlank((String)(qtip = ObjectUtils.toString((Object)module.opt("qtip"), (String)"")))) {
                            item.put("qtip", (Object)qtip);
                        }
                        tabItems.put((Object)item);
                    }
                    ++i;
                }
                request.setAttribute("activeIndex", (Object)activeIndex);
                request.setAttribute("tabItems", (Object)StringUtil.text(tabItems.toString()));
            }
            JSONArray portlets = desktop.optJSONArray("portlets");
            JSONArray newPortals = new JSONArray();
            if (portlets != null) {
                int j = portlets.length();
                int i = 0;
                while (i < j) {
                    JSONArray cols = portlets.optJSONArray(i);
                    int l = cols.length();
                    JSONArray newCols = new JSONArray();
                    int k = 0;
                    while (k < l) {
                        JSONObject portlet = cols.optJSONObject(k);
                        String url = FileUtil.getModuleFile(portlet.optString("url"), true);
                        if (XwlBuffer.canAccess(request, url)) {
                            JSONObject module = XwlBuffer.get(url, true);
                            if (module == null) {
                                cols.remove(k);
                                --k;
                                --l;
                            } else {
                                String qtip;
                                String title = (String)module.opt("title");
                                if (title.startsWith("Str.")) {
                                    title = Str.format(request, title.substring(4));
                                }
                                portlet.put("title", (Object)StringUtil.select(title, FileUtil.getFilename(url)));
                                portlet.put("iconCls", (Object)((String)module.opt("iconCls")));
                                portlet.put("inframe", Boolean.TRUE.equals(module.opt("inframe")));
                                String pageLink = (String)module.opt("pageLink");
                                if (!StringUtil.isEmpty(pageLink)) {
                                    JsonUtil.apply(portlet, new JSONObject(pageLink));
                                }
                                if (StringUtils.isNotBlank((String)(qtip = ObjectUtils.toString((Object)module.opt("qtip"), (String)"")))) {
                                    portlet.put("qtip", (Object)qtip);
                                }
                                newCols.put((Object)portlet);
                            }
                        }
                        ++k;
                    }
                    newPortals.put((Object)newCols);
                    ++i;
                }
                request.setAttribute("portlets", (Object)StringUtil.text(newPortals.toString()));
            }
        } else {
            treeWidth = 200;
            viewIndex = 2;
            treeCollapsed = false;
            treeHidden = false;
            navIconHidden = false;
        }
        request.setAttribute("treeWidth", (Object)(treeWidth < 200 ? 200 : treeWidth));
        request.setAttribute("viewIndex", (Object)viewIndex);
        request.setAttribute("treeCollapsed", (Object)treeCollapsed);
        request.setAttribute("treeHidden", (Object)treeHidden);
        request.setAttribute("navIconHidden", (Object)navIconHidden);
        request.setAttribute("hideSetDefaultDesktop", (Object)(!XwlBuffer.canAccess(request, "m?xwl=sys/portal/home/save-default-desktop") ? 1 : 0));
        request.setAttribute("hideSetAllDesktop", (Object)(!XwlBuffer.canAccess(request, "m?xwl=sys/portal/home/save-all-desktop") ? 1 : 0));
    }

    public static void saveDesktop(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Portal.doSaveDesktop(request, 1);
    }

    public static void saveAsDefaultDesktop(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Portal.doSaveDesktop(request, 2);
    }

    public static void saveAsAllDesktop(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Portal.doSaveDesktop(request, 3);
    }

    private static void doSaveDesktop(HttpServletRequest request, int type) throws Exception {
        JSONObject desktop = new JSONObject();
        desktop.put("treeWidth", Integer.parseInt(request.getParameter("treeWidth")));
        desktop.put("viewIndex", Integer.parseInt(request.getParameter("viewIndex")));
        desktop.put("treeCollapsed", Boolean.parseBoolean(request.getParameter("treeCollapsed")));
        desktop.put("treeHidden", Boolean.parseBoolean(request.getParameter("treeHidden")));
        desktop.put("navIconHidden", Boolean.parseBoolean(request.getParameter("navIconHidden")));
        desktop.put("pages", (Object)new JSONArray(request.getParameter("pages")));
        desktop.put("portlets", (Object)new JSONArray(request.getParameter("portlets")));
        desktop.put("active", Integer.parseInt(request.getParameter("active")));
        if (type == 1) {
            Resource.set(request, "desktop", desktop.toString());
        } else {
            if (type == 3) {
                DbUtil.run(request, "delete from WB_RESOURCE where RES_ID like '%@desktop'");
            }
            Resource.set("sys.home.desktop", desktop.toString());
        }
    }

    public static String getAppListText(HttpServletRequest request) throws Exception {
        return new JSONObject().put("children", (Object)Portal.getModuleList(request, request.getParameter("path"), Session.getRoles(request), 1)).toString();
    }

    public static void getAppList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebUtil.send(response, (Object)Portal.getAppListText(request));
    }

    public static void getPermList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebUtil.send(response, (Object)new JSONObject().put("children", (Object)Portal.getModuleList(request, request.getParameter("path"), Session.getRoles(request), 2)));
    }

    public static void getUserPermList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String role = request.getParameter("roles");
        String[] roles = null;
        roles = StrUtil.isBlank((CharSequence)role) ? Session.getRoles(request) : role.split(",");
        WebUtil.send(response, (Object)new JSONObject().put("children", (Object)Portal.getModuleList(request, request.getParameter("path"), roles, 3)));
    }

    public static void setTheme(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String theme = request.getParameter("theme");
        Value.set(request, "theme", theme);
        WebUtil.setSessionValue(request, "sys.theme", theme);
    }

    public static void setTouchTheme(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String theme = request.getParameter("theme");
        Value.set(request, "touchTheme", theme);
        WebUtil.setSessionValue(request, "sys.touchTheme", theme);
    }

    public static void initTouchHome(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(false);
        boolean isNotLogin = session == null || session.getAttribute("sys.logined") == null;
        request.setAttribute("isNotLogin", (Object)(isNotLogin ? 1 : 0));
    }

    private static void searchModule(HttpServletRequest request, HttpServletResponse response, boolean isPerm) throws Exception {
        JSONArray array = new JSONArray();
        String query = request.getParameter("query").toLowerCase();
        String[] roles = Session.getRoles(request);
        if (query.isEmpty()) {
            query = ".xwl";
        }
        Portal.doSearchFile(request, Base.modulePath, query.toLowerCase(), "", "", array, isPerm, roles);
        WebUtil.send(response, (Object)new JSONObject().put("rows", (Object)array));
    }

    public static void searchAppModule(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Portal.searchModule(request, response, false);
    }

    public static void searchPermModule(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Portal.searchModule(request, response, true);
    }

    private static boolean doSearchFile(HttpServletRequest request, File folder, String searchName, String parentText, String parentFile, JSONArray array, boolean isPerm, String[] roles) throws Exception {
        File[] files;
        File[] fileArray = files = FileUtil.listFiles(folder);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (XwlBuffer.canDisplay(file, roles, isPerm ? 3 : 1)) {
                if (file.isDirectory()) {
                    String folderTitle;
                    JSONObject jo;
                    File indexFile = new File(file, "folder.json");
                    String folderFile = file.getName();
                    if (indexFile.exists()) {
                        jo = JsonUtil.readObject(indexFile);
                        folderTitle = jo.optString("title");
                        if (folderTitle.isEmpty()) {
                            folderTitle = folderFile;
                        }
                    } else {
                        folderTitle = folderFile;
                    }
                    if (folderTitle.startsWith("Str.")) {
                        folderTitle = Str.format(request, folderTitle.substring(4));
                    }
                    if (!isPerm && folderTitle.toLowerCase().indexOf(searchName) != -1) {
                        jo = new JSONObject();
                        jo.put("path", (Object)parentText);
                        jo.put("title", (Object)folderTitle);
                        jo.put("file", (Object)folderFile);
                        jo.put("parentFile", (Object)parentFile);
                        array.put((Object)jo);
                        if (array.length() > 99) {
                            return true;
                        }
                    }
                    if (Portal.doSearchFile(request, file, searchName, StringUtil.concat(parentText, "/", folderTitle), StringUtil.concat(parentFile, "/", folderFile), array, isPerm, roles)) {
                        return true;
                    }
                } else {
                    String path = FileUtil.getModulePath(file);
                    if (path.endsWith(".xwl")) {
                        JSONObject moduleData = XwlBuffer.get(path);
                        if (!isPerm || !Boolean.FALSE.equals(moduleData.opt("loginRequired"))) {
                            String title = moduleData.optString("title");
                            if (title.isEmpty()) {
                                title = path.substring(path.lastIndexOf(47) + 1);
                            }
                            if (title.startsWith("Str.")) {
                                title = Str.format(request, title.substring(4));
                            }
                            if (title.toLowerCase().indexOf(searchName) != -1) {
                                JSONObject jo = new JSONObject();
                                jo.put("path", (Object)parentText);
                                jo.put("title", (Object)title);
                                jo.put("file", (Object)file.getName());
                                jo.put("parentFile", (Object)parentFile);
                                array.put((Object)jo);
                                if (array.length() > 99) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
            ++n2;
        }
        return false;
    }

    public static void getMobileAppList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ArrayList<JSONObject> appList = new ArrayList<JSONObject>();
        JSONArray outputList = new JSONArray();
        String[] roles = Session.getRoles(request);
        Portal.scanMobileApp(request, appList, new File(Base.modulePath, "apps"), roles);
        for (JSONObject jo : appList) {
            outputList.put((Object)jo);
        }
        WebUtil.send(response, (Object)new JSONObject().put("rows", (Object)outputList));
    }

    private static void scanMobileApp(HttpServletRequest request, ArrayList<JSONObject> appList, File path, String[] roles) throws Exception {
        ArrayList<Map.Entry<String, Integer>> fileNames = IDE.getSortedFile(path);
        for (Map.Entry<String, Integer> entry : fileNames) {
            JSONObject viewport;
            String fileName = entry.getKey();
            File file = new File(path, fileName);
            if (!XwlBuffer.canDisplay(file, roles, 2)) continue;
            if (file.isDirectory()) {
                Portal.scanMobileApp(request, appList, file, roles);
                continue;
            }
            String url = FileUtil.getModulePath(file);
            JSONObject content = XwlBuffer.get(url, true);
            if (content == null || (viewport = Portal.getViewport(content)) == null) continue;
            viewport = viewport.getJSONObject("configs");
            JSONObject item = new JSONObject();
            String title = content.optString("title");
            if (title.startsWith("Str.")) {
                title = Str.format(request, title.substring(4));
            }
            item.put("title", (Object)StringUtil.select(title, file.getName()));
            String image = viewport.optString("appImage");
            if (image.isEmpty()) {
                String glyph = viewport.optString("appGlyph");
                if (glyph.isEmpty()) {
                    item.put("glyph", (Object)"&#xf10a;");
                } else {
                    item.put("glyph", (Object)StringUtil.concat("&#x", glyph, ";"));
                }
            } else {
                item.put("image", (Object)image);
            }
            item.put("url", (Object)url);
            appList.add(item);
        }
    }

    private static JSONObject getViewport(JSONObject rootNode) throws Exception {
        JSONObject module = (JSONObject)((JSONArray)rootNode.opt("children")).opt(0);
        JSONArray items = (JSONArray)module.opt("children");
        if (items == null) {
            return null;
        }
        int j = items.length();
        int i = 0;
        while (i < j) {
            JSONObject jo = (JSONObject)items.opt(i);
            if ("tviewport".equals(jo.opt("type"))) {
                return jo;
            }
            ++i;
        }
        return null;
    }

    public static void getUserRolePermList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String roles = request.getParameter("ROLE_ID_S");
        String[] role = roles.split(",");
        WebUtil.send(response, (Object)new JSONObject().put("children", (Object)Portal.getModuleList(request, request.getParameter("path"), role, 3)));
    }

    public static void getUserToRolePermList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String roles = request.getParameter("ROLE_ID_S");
        String[] role = roles.split(",");
        WebUtil.send(response, (Object)new JSONObject().put("children", (Object)Portal.getModuleList(request, request.getParameter("path"), role, 2)));
    }
}

