/*
 * Decompiled with CFR 0.152.
 */
package com.wb.interact;

import com.wb.common.Base;
import com.wb.common.ScriptBuffer;
import com.wb.common.UrlBuffer;
import com.wb.common.Var;
import com.wb.interact.IDE;
import com.wb.tool.TaskManager;
import com.wb.util.DateUtil;
import com.wb.util.DbUtil;
import com.wb.util.FileUtil;
import com.wb.util.JsonUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class Install {
    static Log log = LogFactory.getLog(Install.class);

    public static void checkInstall(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!Var.getBool("sys.service.allowInstall")) {
            throw new RuntimeException("\u7cfb\u7edf\u5df2\u7ecf\u5b89\u88c5\u5b8c\u6210\uff0c\u5982\u9700\u91cd\u65b0\u5b89\u88c5\u8bf7\u8bbe\u7f6e\u53d8\u91cfsys.service.allowInstall\u4e3atrue\u3002");
        }
    }

    public static void generateJndi(HttpServletRequest request, HttpServletResponse response) throws Exception {
        File rootFolder;
        File libFolder;
        Install.checkInstall(request, response);
        String overwrite = request.getParameter("overwrite");
        if (overwrite == null) {
            throw new NullPointerException("overwrite \u53c2\u6570\u4e3anull");
        }
        char dbType = request.getParameter("dbType").charAt(0);
        String contextFilename = null;
        String libFilename = null;
        switch (dbType) {
            case 's': {
                contextFilename = "s-context.xml";
                libFilename = "sqljdbc4.jar";
                break;
            }
            case 'm': {
                contextFilename = "m-context.xml";
                libFilename = "mysql51.jar";
                break;
            }
            case 'o': {
                contextFilename = "o-context.xml";
                libFilename = "ojdbc6.jar";
            }
        }
        File metaFolder = new File(Base.path, "META-INF");
        File contextFile = new File(metaFolder, "context.xml");
        if (!metaFolder.exists() && !metaFolder.mkdir()) {
            throw new IOException("\u521b\u5efaMETA-INF\u76ee\u5f55\u5931\u8d25\u3002");
        }
        if (!Boolean.parseBoolean(overwrite) && contextFile.exists()) {
            SysUtil.error("\u6587\u4ef6 \"META-INF/context.xml\" \u5df2\u7ecf\u5b58\u5728\uff0c\u786e\u5b9a\u8981\u8986\u76d6\u5417\uff1f", "106");
        }
        if (!new File(libFolder = new File(rootFolder = Base.path.getParentFile().getParentFile(), "lib"), libFilename).exists()) {
            FileUtils.copyFileToDirectory((File)new File(Base.path, "wb/system/database/" + libFilename), (File)libFolder);
        }
        String xml = FileUtil.readString(new File(Base.path, "wb/system/database/" + contextFilename));
        xml = WebUtil.replaceParams(request, xml);
        FileUtil.writeString(contextFile, xml);
        File syncFolder = new File(rootFolder, "conf/Catalina/localhost");
        if (!syncFolder.exists()) {
            syncFolder.mkdirs();
        }
        FileUtil.writeString(new File(syncFolder, String.valueOf(Base.path.getName()) + ".xml"), xml);
    }

    public static synchronized void getPack(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Install.getReleasePath();
        IDE.makeFile(request, Base.path, false);
        Install.exportWBTables("r".equals(request.getParameter("type")));
        Install.createPack(request, response);
    }

    private static void exportWBTables(boolean userRelease) throws Exception {
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        String[] withoutTables = new String[]{"WB_LOG", "WB_ROUTE", "WB_SN", "WB_SYS1", "WB_SYS2", "WB_VALUE"};
        String[] sqls = FileUtil.readString(new File(Base.path, "wb/system/database/sqls.sql")).split(";");
        File tablesPath = new File(Base.path, "wb/system/database/tables");
        File syncPath = FileUtil.getSyncPath(tablesPath);
        try {
            FileUtils.cleanDirectory((File)tablesPath);
            if (syncPath != null) {
                FileUtils.cleanDirectory((File)syncPath);
            }
            conn = DbUtil.getConnection();
            st = conn.createStatement();
            st.executeUpdate("update WB_USER set LOGIN_TIMES=0");
            String[] stringArray = sqls;
            int n = sqls.length;
            int n2 = 0;
            while (n2 < n) {
                String sql = stringArray[n2];
                String upperSQL = sql.toUpperCase();
                int index = upperSQL.indexOf("CREATE TABLE");
                if (index != -1) {
                    String tableName = sql.substring(index + 13, sql.indexOf(40)).trim();
                    if (userRelease || StringUtil.indexOf(withoutTables, tableName) == -1) {
                        BufferedWriter writer = null;
                        rs = null;
                        try {
                            File destTable = new File(tablesPath, String.valueOf(tableName) + ".dat");
                            rs = userRelease ? st.executeQuery("select * from " + tableName) : (tableName.equals("WB_USER") ? st.executeQuery("select * from WB_USER where USER_ID in ('admin','test')") : (tableName.equals("WB_RESOURCE") ? st.executeQuery("select * from WB_RESOURCE where RES_ID in ('desktop@admin','desktop@test')") : st.executeQuery("select * from " + tableName)));
                            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destTable), "utf-8"));
                            DbUtil.exportData(rs, writer);
                            writer.close();
                            writer = null;
                            if (syncPath != null) {
                                FileUtils.copyFileToDirectory((File)destTable, (File)syncPath);
                            }
                        }
                        finally {
                            if (writer != null) {
                                writer.close();
                            }
                            if (rs != null) {
                                rs.close();
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(rs);
            DbUtil.close(st);
            DbUtil.close(conn);
            throw throwable;
        }
        DbUtil.close(rs);
        DbUtil.close(st);
        DbUtil.close(conn);
    }

    public static void testJNDI(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Install.checkInstall(request, response);
        String jndi = request.getParameter("jndi");
        Var.set("sys.jndi.default", jndi);
        Var.jndi = jndi;
        DbUtil.getConnection().close();
    }

    public static void setup(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Install.checkInstall(request, response);
        String jndi = request.getParameter("jndiText");
        String type = request.getParameter("typeText");
        Var.set("sys.jndi.default", jndi);
        Var.jndi = jndi;
        if ("postgresql".equals(type) && !"e".equals(Var.getString("sys.app.versionType"))) {
            throw new RuntimeException("postgresql\u6570\u636e\u5e93\u7c7b\u578b\u53ea\u6709\u4f01\u4e1a\u7248\u672c\u652f\u6301\u3002");
        }
        Connection conn = null;
        Statement st = null;
        File mapJson = new File(Base.path, "wb/system/map.json");
        File tablePath = new File(Base.path, "wb/system/database/tables");
        try {
            JSONArray mapArray = JsonUtil.readArray(mapJson);
            JSONObject jo = new JSONObject();
            jo.put("var.json", (Object)FileUtil.readString(Var.getFile()));
            FileUtil.syncSave(mapJson, mapArray.put((Object)jo).toString());
            String[] sqls = Install.replaceSQLMacro(FileUtil.readString(new File(Base.path, "wb/system/database/sqls.sql")), type).split(";");
            conn = DbUtil.getConnection();
            st = conn.createStatement();
            String[] stringArray = sqls;
            int n = sqls.length;
            int n2 = 0;
            while (n2 < n) {
                String sql = stringArray[n2];
                int index = sql.indexOf("CREATE TABLE");
                if (index == -1) {
                    st.executeUpdate(sql.trim());
                } else {
                    String tableName = sql.substring(index + 13, sql.indexOf(40)).trim();
                    try {
                        st.executeUpdate("DROP TABLE " + tableName);
                    }
                    catch (Throwable e) {
                        log.error((Object)"", e);
                    }
                    st.executeUpdate(sql.trim());
                    File file = new File(tablePath, StringUtil.concat(tableName, ".dat"));
                    if (file.exists()) {
                        DbUtil.importData(conn, tableName, new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8")));
                    }
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(st);
            DbUtil.close(conn);
            throw throwable;
        }
        DbUtil.close(st);
        DbUtil.close(conn);
        Var.set("sys.db.defaultType", type);
        if ("d".equals(Var.getString("sys.app.versionType"))) {
            Var.set("sys.portal", "demo-index");
            UrlBuffer.buffer.put("/", "sys/portal/demo-index.xwl");
        } else {
            Var.set("sys.portal", "index");
            UrlBuffer.put("/", "sys/portal/index.xwl");
        }
        Var.set("sys.service.allowInstall", false);
        SysUtil.reload(3);
        TaskManager.start();
    }

    private static File getReleasePath() {
        String releasePathVar = Var.getString("sys.ide.releasePath");
        if (releasePathVar.isEmpty()) {
            throw new RuntimeException("\u53d1\u5e03\u76ee\u5f55\u53d8\u91cf \"sys.ide.releasePath\" \u672a\u6307\u5b9a\u3002");
        }
        File releasePath = new File(releasePathVar);
        if (!releasePath.exists()) {
            throw new RuntimeException("\u53d1\u5e03\u76ee\u5f55 \"" + releasePath + "\" \u4e0d\u5b58\u5728\u3002");
        }
        return releasePath;
    }

    private static void createPack(HttpServletRequest request, HttpServletResponse response) throws Exception {
        File releasePath = Install.getReleasePath();
        String type = request.getParameter("type");
        boolean userReleaseVersion = "r".equals(type);
        File destPath = FileUtil.getUniqueFile(new File(releasePath, String.valueOf(userReleaseVersion ? Var.getString("sys.app.title") : "wb7" + type) + "(" + DateUtil.format(new Date(), "yyyy-MM-dd") + ")"));
        if (userReleaseVersion) {
            File[] files;
            File[] fileArray = files = FileUtil.listFiles(Base.path);
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                FileUtils.copyDirectoryToDirectory((File)file, (File)destPath);
                ++n2;
            }
            File varFile = new File(destPath, "wb/system/var.json");
            JSONObject varObject = JsonUtil.readObject(varFile);
            ((JSONArray)JsonUtil.getValue(varObject, "sys.db.defaultType", '.')).put(0, (Object)"");
            ((JSONArray)JsonUtil.getValue(varObject, "sys.jndi.default", '.')).put(0, (Object)"");
            ((JSONArray)JsonUtil.getValue(varObject, "sys.ide.releasePath", '.')).put(0, (Object)"");
            ((JSONArray)JsonUtil.getValue(varObject, "sys.ide.syncPath", '.')).put(0, (Object)"");
            ((JSONArray)JsonUtil.getValue(varObject, "sys.portal", '.')).put(0, (Object)"setup");
            ((JSONArray)JsonUtil.getValue(varObject, "sys.service.allowInstall", '.')).put(0, true);
            FileUtil.writeString(varFile, varObject.toString(2));
        } else {
            File destWebInf = new File(destPath, "wb/WEB-INF");
            FileUtils.copyDirectoryToDirectory((File)new File(Base.path, "WEB-INF/lib"), (File)destWebInf);
            FileUtils.copyFileToDirectory((File)new File(Base.path, "WEB-INF/web.xml"), (File)destWebInf);
            FileUtils.copyDirectoryToDirectory((File)new File(Base.path, "wb"), (File)new File(destPath, "wb"));
            FileUtils.copyDirectory((File)new File(Var.getString("sys.ide.sourcePath")), (File)new File(destPath, "source"));
            FileUtils.copyFileToDirectory((File)new File(releasePath, "webbuilder-" + Var.getString("sys.app.version") + ".jar"), (File)new File(destPath, "wb/WEB-INF/lib"));
            FileUtils.copyDirectoryToDirectory((File)new File(releasePath, "misc"), (File)destPath);
            FileUtils.copyDirectoryToDirectory((File)new File(releasePath, "docs/docs"), (File)destPath);
            FileUtils.copyFileToDirectory((File)new File(releasePath, "api.html"), (File)destPath);
            FileUtils.copyFileToDirectory((File)new File(releasePath, "manual.docx"), (File)destPath);
            FileUtils.copyFileToDirectory((File)new File(releasePath, "license.html"), (File)destPath);
            FileUtils.copyFileToDirectory((File)new File(releasePath, "readme.html"), (File)destPath);
            File ssproto = new File(destPath, "wb/wb/system/database/ssproto.sql");
            if (!ssproto.delete()) {
                throw new RuntimeException("\u65e0\u6cd5\u5220\u9664 \"" + ssproto + "\"\u3002");
            }
            String packJSPath = "wb/wb/system/pack.js";
            File packJS = new File(destPath, packJSPath);
            if (!packJS.delete()) {
                throw new RuntimeException("\u65e0\u6cd5\u5220\u9664 \"" + packJS + "\"\u3002");
            }
            packJSPath = "wb/system/pack.js";
            packJS = new File(Base.path, packJSPath);
            request.setAttribute("destPath", (Object)destPath);
            ScriptBuffer.run(packJSPath, FileUtil.readString(packJS), request, response, packJSPath);
        }
        WebUtil.send(response, (Object)destPath);
    }

    private static String replaceSQLMacro(String sql, String dbType) throws Exception {
        JSONObject object = JsonUtil.readObject(new File(Base.path, "wb/system/database/types.json"));
        JSONObject items = object.getJSONObject(dbType);
        Set es = items.entrySet();
        for (Map.Entry entry : es) {
            sql = StringUtil.replaceAll(sql, "{#" + (String)entry.getKey() + "#}", entry.getValue().toString());
        }
        return sql;
    }

    public static void register(HttpServletRequest request, HttpServletResponse response) throws Exception {
    }

    public static void verify(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String msg;
        String sn;
        try {
            sn = request.getParameter("snText");
            msg = WebUtil.submit("http://www.putdb.com/sn-verify", new JSONObject().put("sn", (Object)sn));
        }
        catch (Throwable e) {
            throw new RuntimeException("\u9a8c\u8bc1\u5931\u8d25\uff0c\u7f51\u7edc\u65e0\u6548\u6216\u670d\u52a1\u6682\u65f6\u4e0d\u53ef\u8bbf\u95ee\u3002");
        }
        if (!"ok".equals(msg)) {
            throw new RuntimeException("\u9a8c\u8bc1\u5931\u8d25\uff0c\u5e8f\u5217\u53f7 \u201c" + sn + "\u201d \u65e0\u6548\u3002");
        }
    }
}

