/*
 * Decompiled with CFR 0.152.
 */
package com.wb.interact;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.db.DbUtil;
import com.wb.common.Base;
import com.wb.interact.MenuEntry;
import com.wb.util.FileUtil;
import com.wb.util.JsonUtil;
import com.wb.util.LogUtil;
import com.wb.util.WebUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class IDEModulesPerm {
    private static Log log = LogFactory.getLog(IDEModulesPerm.class);

    public static void addModule(final HttpServletRequest request, final String pkId, final String path, final boolean isDefaultRole) throws Exception {
        ThreadUtil.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                block5: {
                    Connection connection = null;
                    PreparedStatement st = null;
                    String sql = "insert into WB_MODULES_PERM(PK_ID,IS_DEFAULT,PATH,OPERATOR,OPERATE_TIME) values(?,?,?,?,?)";
                    try {
                        try {
                            connection = com.wb.util.DbUtil.getConnection();
                            st = connection.prepareStatement(sql);
                            st.setString(1, pkId);
                            st.setBoolean(2, isDefaultRole);
                            st.setString(3, path);
                            st.setString(4, WebUtil.fetch(request, "sys.username"));
                            st.setTimestamp(5, DbUtil.toSqlTimestamp((Date)new Date()));
                            st.executeUpdate();
                            connection.commit();
                        }
                        catch (Exception e) {
                            log.error((Object)"", (Throwable)e);
                            LogUtil.error("\u6dfb\u52a0\u6587\u4ef6\u4fdd\u5b58\u6570\u636e\u5e93\u65f6\u5f02\u5e38\uff1a" + e.getMessage());
                            com.wb.util.DbUtil.close(st);
                            com.wb.util.DbUtil.close(connection);
                            break block5;
                        }
                    }
                    catch (Throwable throwable) {
                        com.wb.util.DbUtil.close(st);
                        com.wb.util.DbUtil.close(connection);
                        throw throwable;
                    }
                    com.wb.util.DbUtil.close(st);
                    com.wb.util.DbUtil.close(connection);
                }
            }
        });
    }

    public static void setModulesPerm(HttpServletRequest request, final String operationType, final List<Map<String, Object>> list) {
        final String userName = WebUtil.fetch(request, "sys.username");
        ThreadUtil.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                block6: {
                    Connection connection = null;
                    PreparedStatement st = null;
                    PreparedStatement st1 = null;
                    try {
                        try {
                            connection = com.wb.util.DbUtil.getConnection();
                            connection.setAutoCommit(false);
                            String hisSql = "insert into WB_MODULES_PERM_HIS(PK_ID,OPERATION_TYPE,OLD_PATH,OLD_ROLES,OLD_OPERATOR,NEW_PATH,NEW_ROLES,OPERATOR,REMARK,OPERATE_TIME) select PK_ID,?,PATH,ROLES,OPERATOR,PATH,?,?,?,? from WB_MODULES_PERM where PATH=?";
                            String sql = "update WB_MODULES_PERM set ROLES=?,OPERATE_TIME=?,OPERATOR=? where PATH=?";
                            st = connection.prepareStatement(hisSql);
                            st1 = connection.prepareStatement(sql);
                            for (Map map : list) {
                                st.setString(1, operationType);
                                st.setString(2, map.get("ROLES").toString());
                                st.setString(3, userName);
                                st.setString(4, "\u4fee\u6539\u6743\u9650\u4fe1\u606f");
                                st.setTimestamp(5, DbUtil.toSqlTimestamp((Date)new Date()));
                                st.setString(6, map.get("PATH").toString());
                                st.addBatch();
                                st1.setString(1, map.get("ROLES").toString());
                                st1.setTimestamp(2, DbUtil.toSqlTimestamp((Date)new Date()));
                                st1.setString(3, userName);
                                st1.setString(4, map.get("PATH").toString());
                                st1.addBatch();
                            }
                            st.executeBatch();
                            st1.executeBatch();
                            connection.commit();
                        }
                        catch (Exception e) {
                            log.error((Object)"\u4fee\u6539\u6587\u4ef6\u6743\u9650\u5165\u5e93\u64cd\u4f5c\u5f02\u5e38\uff1a", (Throwable)e);
                            com.wb.util.DbUtil.close(st);
                            com.wb.util.DbUtil.close(st1);
                            com.wb.util.DbUtil.close(connection);
                            break block6;
                        }
                    }
                    catch (Throwable throwable) {
                        com.wb.util.DbUtil.close(st);
                        com.wb.util.DbUtil.close(st1);
                        com.wb.util.DbUtil.close(connection);
                        throw throwable;
                    }
                    com.wb.util.DbUtil.close(st);
                    com.wb.util.DbUtil.close(st1);
                    com.wb.util.DbUtil.close(connection);
                }
            }
        });
    }

    public static void setProperty(HttpServletRequest request, final String newRelPath, final String oldRelPath, final boolean isDir, final String pkId, final boolean isDefaultRole) throws Exception {
        final String userName = WebUtil.fetch(request, "sys.username");
        ThreadUtil.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                Connection conn = null;
                PreparedStatement pre = null;
                try {
                    try {
                        conn = com.wb.util.DbUtil.getConnection();
                        conn.setAutoCommit(false);
                        if (!newRelPath.equals(oldRelPath)) {
                            Timestamp time = DbUtil.toSqlTimestamp((Date)new Date());
                            if (isDir) {
                                String hisSql = "insert into WB_MODULES_PERM_HIS(PK_ID,OPERATION_TYPE,OLD_PATH,OLD_ROLES,OLD_OPERATOR,NEW_PATH,NEW_ROLES,OPERATOR,REMARK,OPERATE_TIME) select PK_ID,?,PATH,ROLES,OPERATOR,replace(PATH,?,?),ROLES,?,?,? from WB_MODULES_PERM where PATH like ?";
                                String sql = "update WB_MODULES_PERM set PATH=replace(PATH,?,?),OPERATE_TIME=?,OPERATOR=? where PATH like ?";
                                pre = conn.prepareStatement(hisSql);
                                pre.setString(1, "EDIT");
                                pre.setString(2, oldRelPath);
                                pre.setString(3, newRelPath);
                                pre.setString(4, userName);
                                pre.setString(5, "\u4fee\u6539\u8def\u5f84");
                                pre.setTimestamp(6, time);
                                pre.setString(7, String.valueOf(oldRelPath) + "/%");
                                pre.executeUpdate();
                                pre.close();
                                pre = conn.prepareStatement(sql);
                                pre.setString(1, oldRelPath);
                                pre.setString(2, newRelPath);
                                pre.setTimestamp(3, time);
                                pre.setString(4, userName);
                                pre.setString(5, String.valueOf(oldRelPath) + "/%");
                                pre.executeUpdate();
                            } else {
                                String hisSql = "insert into WB_MODULES_PERM_HIS(PK_ID,OPERATION_TYPE,OLD_PATH,OLD_ROLES,OLD_OPERATOR,NEW_PATH,NEW_ROLES,OPERATOR,REMARK,OPERATE_TIME)select PK_ID,?,PATH,ROLES,OPERATOR,?,ROLES,?,?,? from WB_MODULES_PERM where PK_ID=?";
                                String sql = "update WB_MODULES_PERM set PATH=?,OPERATE_TIME=?,OPERATOR=?,IS_DEFAULT=? where PK_ID=?";
                                pre = conn.prepareStatement(hisSql);
                                pre.setString(1, "EDIT");
                                pre.setString(2, newRelPath);
                                pre.setString(3, userName);
                                pre.setString(4, "\u4fee\u6539\u8def\u5f84");
                                pre.setTimestamp(5, time);
                                pre.setString(6, pkId);
                                pre.executeUpdate();
                                pre.close();
                                pre = conn.prepareStatement(sql);
                                pre.setString(1, newRelPath);
                                pre.setTimestamp(2, time);
                                pre.setString(3, userName);
                                pre.setBoolean(4, isDefaultRole);
                                pre.setString(5, pkId);
                                pre.executeUpdate();
                            }
                        } else if (!isDir) {
                            String sql = "update WB_MODULES_PERM set IS_DEFAULT=? where PK_ID=?";
                            pre = conn.prepareStatement(sql);
                            pre.setBoolean(1, isDefaultRole);
                            pre.setString(2, pkId);
                            pre.executeUpdate();
                        }
                        conn.commit();
                    }
                    catch (Exception se) {
                        log.error((Object)"\u4fee\u6539\u6587\u4ef6\u5c5e\u6027\u9519\u8bef", (Throwable)se);
                        com.wb.util.DbUtil.close(pre);
                        com.wb.util.DbUtil.close(conn);
                    }
                }
                finally {
                    com.wb.util.DbUtil.close(pre);
                    com.wb.util.DbUtil.close(conn);
                }
            }
        });
    }

    public static void moveFiles(HttpServletRequest request, final JSONArray src, final File folder) throws Exception {
        final String username = WebUtil.fetch(request, "sys.username");
        ThreadUtil.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                Connection connection = null;
                PreparedStatement st = null;
                try {
                    try {
                        connection = com.wb.util.DbUtil.getConnection();
                        connection.setAutoCommit(false);
                        int i = 0;
                        while (i < src.length()) {
                            String sql;
                            String hisSql;
                            String newPath;
                            File file = new File(src.getString(i));
                            if (!folder.equals(Base.modulePath)) {
                                String path = FileUtil.getModulePath(folder);
                                newPath = String.valueOf(path) + "/" + file.getName();
                            } else {
                                newPath = file.getName();
                            }
                            String oldPath = FileUtil.getModulePath(file);
                            if (oldPath.endsWith(".xwl")) {
                                hisSql = "insert into WB_MODULES_PERM_HIS(PK_ID,OPERATION_TYPE,OLD_PATH,OLD_ROLES,OLD_OPERATOR,NEW_PATH,NEW_ROLES,OPERATOR,REMARK,OPERATE_TIME) select PK_ID,?,PATH,ROLES,OPERATOR,?,ROLES,?,?,? from WB_MODULES_PERM where PATH=?";
                                st = connection.prepareStatement(hisSql);
                                st.setString(1, "EDIT");
                                st.setString(2, newPath);
                                st.setString(3, username);
                                st.setString(4, "\u4fee\u6539\u6587\u4ef6\u8def\u5f84");
                                st.setTimestamp(5, DbUtil.toSqlTimestamp((Date)new Date()));
                                st.setString(6, oldPath);
                                st.executeUpdate();
                                st.close();
                                sql = "update WB_MODULES_PERM set PATH=?,OPERATE_TIME=?,OPERATOR=? where PATH=?";
                                st = connection.prepareStatement(sql);
                                st.setString(1, newPath);
                                st.setTimestamp(2, DbUtil.toSqlTimestamp((Date)new Date()));
                                st.setString(3, username);
                                st.setString(4, oldPath);
                                st.executeUpdate();
                            } else {
                                hisSql = "insert into WB_MODULES_PERM_HIS(PK_ID,OPERATION_TYPE,OLD_PATH,OLD_ROLES,OLD_OPERATOR,NEW_PATH,NEW_ROLES,OPERATOR,REMARK,OPERATE_TIME)select PK_ID,?,PATH,ROLES,OPERATOR,replace(PATH,?,?),ROLES,?,?,? from WB_MODULES_PERM where PATH like ?";
                                st = connection.prepareStatement(hisSql);
                                st.setString(1, "EDIT");
                                st.setString(2, oldPath);
                                st.setString(3, newPath);
                                st.setString(4, username);
                                st.setString(5, "\u4fee\u6539\u6587\u4ef6\u8def\u5f84");
                                st.setTimestamp(6, DbUtil.toSqlTimestamp((Date)new Date()));
                                st.setString(7, String.valueOf(oldPath) + "/%");
                                st.executeUpdate();
                                st.close();
                                sql = "update WB_MODULES_PERM set PATH=replace(PATH,?,?),OPERATE_TIME=?,OPERATOR=? where PATH like ?";
                                st = connection.prepareStatement(sql);
                                st.setString(1, oldPath);
                                st.setString(2, newPath);
                                st.setTimestamp(3, DbUtil.toSqlTimestamp((Date)new Date()));
                                st.setString(4, username);
                                st.setString(5, String.valueOf(oldPath) + "/%");
                                st.executeUpdate();
                            }
                            connection.commit();
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"\u79fb\u52a8\u6587\u4ef6\u9519\u8bef:", (Throwable)e);
                        com.wb.util.DbUtil.close(st);
                        com.wb.util.DbUtil.close(connection);
                    }
                }
                finally {
                    com.wb.util.DbUtil.close(st);
                    com.wb.util.DbUtil.close(connection);
                }
            }
        });
    }

    public static void deleteFiles(HttpServletRequest request, final List<File> list) {
        final String username = WebUtil.fetch(request, "sys.username");
        ThreadUtil.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                block6: {
                    Connection connection = null;
                    PreparedStatement st = null;
                    PreparedStatement st1 = null;
                    String hisSql = "insert into WB_MODULES_PERM_HIS(PK_ID,OPERATION_TYPE,OLD_PATH,OPERATOR,OPERATE_TIME) select PK_ID,?,PATH,?,? from WB_MODULES_PERM where PATH=?";
                    String sql = "delete from WB_MODULES_PERM where PATH=?";
                    try {
                        try {
                            connection = com.wb.util.DbUtil.getConnection();
                            connection.setAutoCommit(false);
                            st = connection.prepareStatement(hisSql);
                            st1 = connection.prepareStatement(sql);
                            for (File file : list) {
                                if (!file.getName().endsWith(".xwl")) continue;
                                String filePath = FileUtil.getModulePath(file);
                                st.setString(1, "DEL");
                                st.setString(2, username);
                                st.setTimestamp(3, DbUtil.toSqlTimestamp((Date)new Date()));
                                st.setString(4, filePath);
                                st1.setString(1, filePath);
                                st.addBatch();
                                st1.addBatch();
                            }
                            st.executeBatch();
                            st1.executeBatch();
                            connection.commit();
                        }
                        catch (Exception e) {
                            log.error((Object)"\u5220\u9664\u6587\u4ef6\u9519\u8bef:", (Throwable)e);
                            com.wb.util.DbUtil.close(st);
                            com.wb.util.DbUtil.close(st1);
                            com.wb.util.DbUtil.close(connection);
                            break block6;
                        }
                    }
                    catch (Throwable throwable) {
                        com.wb.util.DbUtil.close(st);
                        com.wb.util.DbUtil.close(st1);
                        com.wb.util.DbUtil.close(connection);
                        throw throwable;
                    }
                    com.wb.util.DbUtil.close(st);
                    com.wb.util.DbUtil.close(st1);
                    com.wb.util.DbUtil.close(connection);
                }
            }
        });
    }

    public static void uploadFiles(final HttpServletRequest request, final File destPath) {
        ThreadUtil.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                block5: {
                    Connection connection = null;
                    PreparedStatement st = null;
                    try {
                        try {
                            JSONObject content = JsonUtil.readObject(destPath);
                            String pkId = RandomUtil.simpleUUID();
                            content.put("pkId", (Object)pkId);
                            content.put("isDefaultRole", false);
                            content.put("roles", (Object)new JSONObject());
                            FileUtil.syncSave(destPath, content.toString());
                            connection = com.wb.util.DbUtil.getConnection();
                            String sql = "insert into WB_MODULES_PERM(PK_ID,PATH,OPERATOR,OPERATE_TIME) values(?,?,?,?)";
                            st = connection.prepareStatement(sql);
                            st.setString(1, pkId);
                            st.setString(2, FileUtil.getModulePath(destPath));
                            st.setString(3, WebUtil.fetch(request, "sys.username"));
                            st.setTimestamp(4, DbUtil.toSqlTimestamp((Date)new Date()));
                            st.executeUpdate();
                            connection.commit();
                        }
                        catch (Exception e) {
                            log.error((Object)"uploadFiles\u65b9\u6cd5\u4fdd\u5b58\u5bfc\u5165\u6587\u4ef6\u5230\u6570\u636e\u5e93\u5f02\u5e38:", (Throwable)e);
                            com.wb.util.DbUtil.close(st);
                            com.wb.util.DbUtil.close(connection);
                            break block5;
                        }
                    }
                    catch (Throwable throwable) {
                        com.wb.util.DbUtil.close(st);
                        com.wb.util.DbUtil.close(connection);
                        throw throwable;
                    }
                    com.wb.util.DbUtil.close(st);
                    com.wb.util.DbUtil.close(connection);
                }
            }
        });
    }

    public static void copyFiles(HttpServletRequest request, final JSONArray moveTo) {
        final String username = WebUtil.fetch(request, "sys.username");
        ThreadUtil.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    List<Map<String, Object>> FileList = IDEModulesPerm.saveFileInfo(username, moveTo);
                    MenuEntry.savePerm(FileList);
                }
                catch (Exception e) {
                    log.error((Object)"copyFiles\u65b9\u6cd5\u5f02\u5e38:", (Throwable)e);
                }
            }
        });
    }

    public static ArrayList<File> getfileList(JSONArray moveTo) {
        ArrayList<File> fileList = new ArrayList<File>();
        Object object = null;
        String strPath = null;
        int i = 0;
        while (i < moveTo.length()) {
            object = moveTo.get(i);
            strPath = ((Object[])object)[0].toString();
            fileList.addAll(cn.hutool.core.io.FileUtil.loopFiles((String)strPath));
            ++i;
        }
        return fileList;
    }

    public static List<Map<String, Object>> saveFileInfo(String username, JSONArray moveTo) throws Exception {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        ArrayList<File> fileList = IDEModulesPerm.getfileList(moveTo);
        for (File file : fileList) {
            if (!FileUtil.getFileExt(file.getName()).equals("xwl")) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            JSONObject content = JsonUtil.readObject(file);
            String path = FileUtil.getModulePath(file);
            JSONObject roles = content.optJSONObject("roles");
            Set keys = roles.keySet();
            String pkId = RandomUtil.simpleUUID();
            content.put("pkId", (Object)pkId);
            map.put("PK_ID", pkId);
            map.put("PATH", path);
            map.put("IS_DEFAULT", content.has("isDefaultRole") ? content.getBoolean("isDefaultRole") : false);
            map.put("ROLES", CollUtil.join((Iterable)keys, (CharSequence)","));
            map.put("OPERATOR", username);
            arrayList.add(map);
            FileUtil.syncSave(file, content.toString());
        }
        return arrayList;
    }
}

