/*
 * Decompiled with CFR 0.152.
 */
package com.wb.interact;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import com.ks.fintech.bw.api.FunctionEObj;
import com.ks.fintech.bw.api.MenuEObj;
import com.ks.fintech.bw.support.BwIDE;
import com.ks.fintech.bw.support.FormatUtils;
import com.ks.fintech.bw.support.FunctionUtils;
import com.ks.fintech.bw.support.IdeUtils;
import com.wb.common.Base;
import com.wb.common.UrlBuffer;
import com.wb.common.Value;
import com.wb.common.Var;
import com.wb.common.XwlBuffer;
import com.wb.interact.Controls;
import com.wb.interact.ScanXwl;
import com.wb.interact.SearchUtils;
import com.wb.interact.Service;
import com.wb.tool.Console;
import com.wb.tool.Encrypter;
import com.wb.tool.QueueWriter;
import com.wb.tool.ScriptCompressor;
import com.wb.tool.SvnUtil;
import com.wb.util.DateUtil;
import com.wb.util.DbUtil;
import com.wb.util.FileUtil;
import com.wb.util.JsonUtil;
import com.wb.util.LogUtil;
import com.wb.util.SortUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import ks.fintech.bw.api.service.CacheServiceAware;
import ks.fintech.bw.api.service.FunctionContentCacheAware;
import ks.fintech.bw.api.service.UserRoleServiceAware;
import ks.fintech.bw.api.utils.RoleUtils;
import ks.fintech.framework.core.exception.KException;
import ks.fintech.framework.sql.SqlExecutor;
import ks.fintech.framework.threadpool.DefaultThreadPool;
import ks.fintech.framework.utils.DateUtils;
import ks.fintech.framework.utils.SpringContextUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class IDE {
    private static final String[] imageTypes = new String[]{"gif", "jpg", "png", "bmp"};
    private static Log log = LogFactory.getLog(IDE.class);
    private static ExecutorService fixedThreadPool;

    public static void getList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if ("root".equals(request.getParameter("node"))) {
            IDE.getBaseList(request, response);
        } else if ("module".equals(request.getParameter("type"))) {
            IDE.getModuleList(request, response);
        } else {
            IDE.getFileList(request, response);
        }
    }

    public static void getFileList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        File[] files;
        File base;
        String path = request.getParameter("path");
        String type = request.getParameter("type");
        JSONArray fileArray = new JSONArray();
        String mode = request.getParameter("mode");
        boolean isIde = StringUtil.isEmpty(mode);
        boolean isTouch = "1".equals(mode);
        boolean isTree = "2".equals(mode);
        boolean isGrid = "3".equals(mode);
        if (StringUtil.isEmpty(path)) {
            IDE.limitDemoUser(request, null);
            base = null;
            files = File.listRoots();
        } else {
            base = new File(path);
            IDE.limitDemoUser(request, null);
            files = FileUtil.listFiles(base);
        }
        if (isGrid) {
            String[] sortInfo = WebUtil.getSortInfo(request);
            String[] fields = new String[]{"text", "size", "type", "date"};
            SortUtil.sort(files, StringUtil.indexOf(fields, sortInfo[0]), sortInfo[1].equalsIgnoreCase("desc"));
        } else {
            SortUtil.sort(files);
        }
        File[] fileArray2 = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray2[n2];
            boolean isDir = file.isDirectory();
            if (!isTree || isDir) {
                String fileDir = FileUtil.getPath(file);
                if (!(isIde && "app".equals(type) && file.equals(Base.modulePath) || "file".equals(type) && file.equals(Base.path))) {
                    JSONObject fileObject = new JSONObject();
                    fileObject.put("text", (Object)StringUtil.select(file.getName(), fileDir));
                    if (isDir) {
                        if (isTouch || isGrid) {
                            fileObject.put("icon", (Object)"wb/images/folder.png");
                        }
                        if (isIde && FileUtil.isEmpty(file) || isTree && !FileUtil.hasFolder(file)) {
                            fileObject.put("children", (Object)new JSONArray());
                        }
                    } else {
                        fileObject.put("size", file.length());
                        fileObject.put("leaf", true);
                        if (isGrid) {
                            fileObject.put("icon", (Object)WebUtil.encode(fileDir));
                        } else if (!isTree) {
                            fileObject.put("icon", (Object)("m?xwl=dev/ide/get-file-icon&file=" + WebUtil.encode(fileDir)));
                        }
                    }
                    if (isGrid || isTouch) {
                        fileObject.put("date", (Object)new Date(file.lastModified()));
                        fileObject.put("type", (Object)(isDir ? "\u6587\u4ef6\u5939" : FileUtil.getFileType(file)));
                    }
                    fileArray.put((Object)fileObject);
                }
            }
            ++n2;
        }
        WebUtil.send(response, (Object)new JSONObject().put(isGrid ? "rows" : "children", (Object)fileArray));
    }

    public static void getJSONArray(JSONArray fileArray, Long menuId) throws KException {
        CacheServiceAware roleCache = (CacheServiceAware)SpringContextUtil.getBean((String)"sysCacheServcie");
        Map menuMap = roleCache.getMenuMap();
        if (menuMap != null) {
            for (MenuEObj menuEObj : menuMap.values()) {
                String icon;
                if (menuId == null || !menuId.equals(menuEObj.getParentId())) continue;
                String fileName = menuEObj.getMenuName();
                JSONObject fileObject = new JSONObject();
                fileObject.put("text", (Object)fileName);
                fileObject.put("title", (Object)menuEObj.getMenuTitle());
                fileObject.put("isFunction", false);
                boolean hidden = "0".equals(menuEObj.getMenuStatus());
                fileObject.put("hidden", hidden);
                if (hidden) {
                    fileObject.put("cls", (Object)"x-highlight");
                }
                fileObject.put("inframe", false);
                fileObject.put("pageLink", (Object)"");
                fileObject.put("qtip", (Object)"");
                fileObject.put("pkId", (Object)"");
                fileObject.put("index", (Object)menuEObj.getMenuSeq());
                fileObject.put("menuId", (Object)menuEObj.getMenuId());
                String iconCls = menuEObj.getMenuIcon();
                if (!StringUtil.isEmpty(iconCls)) {
                    fileObject.put("iconCls", (Object)iconCls);
                }
                if (!StringUtil.isEmpty(icon = menuEObj.getMenuIcon())) {
                    fileObject.put("icon", (Object)icon);
                }
                if (!IDE.hasChildren(menuEObj)) {
                    fileObject.put("children", (Object)new JSONArray());
                }
                boolean isDefaultRole = false;
                fileObject.put("isDefaultRole", isDefaultRole);
                fileArray.put((Object)fileObject);
            }
        }
    }

    public static void getModuleList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String path = request.getParameter("path");
        File base = new File(path);
        if (!FileUtil.isAncestor(Base.path, base)) {
            SysUtil.accessDenied();
        }
        JSONArray fileArray = new JSONArray();
        if (path != null && RoleUtils.clean((String)path).equals(RoleUtils.clean((String)String.valueOf(Base.modulePath)))) {
            fileArray = new JSONArray();
            IDE.getJSONArray(fileArray, Long.parseLong("-100"));
        } else if (path != null && !RoleUtils.clean((String)path).equals(RoleUtils.clean((String)String.valueOf(Base.modulePath)))) {
            fileArray = new JSONArray();
            Long menuId = Long.parseLong(request.getParameter("menuId").toString());
            IDE.getJSONArray(fileArray, menuId);
            CacheServiceAware roleCache = (CacheServiceAware)SpringContextUtil.getBean((String)"sysCacheServcie");
            Map funcMap = roleCache.getFuncMap();
            if (funcMap != null) {
                for (FunctionEObj functionEObj : funcMap.values()) {
                    if (menuId == null || !menuId.equals(functionEObj.getMenuId())) continue;
                    String fileName = functionEObj.getFuncName();
                    JSONObject fileObject = new JSONObject();
                    JSONObject content = IDE.get(functionEObj.getFuncId());
                    fileObject.put("text", (Object)functionEObj.getShortPath());
                    fileObject.put("title", (Object)fileName);
                    fileObject.put("isFunction", true);
                    fileObject.put("index", (Object)functionEObj.getFuncSeq());
                    boolean hidden = "0".equals(functionEObj.getFuncStatus());
                    fileObject.put("hidden", hidden);
                    if (hidden) {
                        fileObject.put("cls", (Object)"x-highlight");
                    }
                    boolean inFrame = !"0".equals(functionEObj.getInframe());
                    fileObject.put("inframe", inFrame);
                    fileObject.put("pageLink", (Object)functionEObj.getPageLink());
                    fileObject.put("qtip", (Object)functionEObj.getQtip());
                    fileObject.put("pkId", (Object)functionEObj.getPkId());
                    fileObject.put("menuId", (Object)functionEObj.getMenuId());
                    String iconCls = functionEObj.getFuncIcon();
                    if (!StringUtil.isEmpty(iconCls)) {
                        fileObject.put("iconCls", (Object)iconCls);
                    }
                    fileObject.put("leaf", true);
                    if (content.has("roles")) {
                        JSONObject roles = content.getJSONObject("roles");
                        boolean isDefaultRole = false;
                        if (roles != null && roles.length() > 0 && StringUtils.isNotBlank((String)Var.defaultRole)) {
                            for (String defaultRole : Arrays.asList(Var.defaultRole.split(","))) {
                                if (!roles.has(defaultRole) || roles.getInt(defaultRole) != 1) continue;
                                isDefaultRole = true;
                                break;
                            }
                        }
                        fileObject.put("isDefaultRole", isDefaultRole);
                    }
                    fileArray.put((Object)fileObject);
                }
            }
        }
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        int i = 0;
        while (i < fileArray.length()) {
            list.add((JSONObject)fileArray.get(i));
            ++i;
        }
        Collections.sort(list, new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject o1, JSONObject o2) {
                Long a = (Long)o1.get("index");
                Long b = (Long)o2.get("index");
                if (a > b) {
                    return 1;
                }
                if (a == b) {
                    return 0;
                }
                return -1;
            }
        });
        JSONArray jsonArray = new JSONArray(((Object)list).toString());
        WebUtil.send(response, (Object)new JSONObject().put("children", (Object)jsonArray));
    }

    public static JSONObject get(Long funcId) throws IOException, JSONException, KException {
        FunctionContentCacheAware contentCache = (FunctionContentCacheAware)SpringContextUtil.getBean((String)"contentCacheServcie");
        JSONObject root = new JSONObject(String.valueOf(contentCache.getContent(funcId)));
        JSONObject moduleNode = new JSONObject(String.valueOf(contentCache.getContent(funcId)));
        try {
            root.getJSONObject("roles").put("admin", 1);
        }
        catch (Exception e) {
            JSONObject temp = new JSONObject();
            temp.put("admin", 1);
            root.put("roles", (Object)temp);
        }
        root.put("loginRequired", !"false".equals(moduleNode.opt("loginRequired")));
        boolean[] libTypes = XwlBuffer.optimize(root, true, String.valueOf(SysUtil.getId()) + ".");
        XwlBuffer.autoSetConfig(moduleNode, libTypes);
        if (moduleNode.optString("loadJS").indexOf("touch") != -1) {
            root.put("hasTouch", true);
        }
        return root;
    }

    public static String getFuncPath(String path) {
        String shorPath = path.substring(path.lastIndexOf("/"));
        String tem = path.substring(0, path.lastIndexOf("/"));
        String func_path = String.valueOf(tem.substring(tem.lastIndexOf("/") + 1)) + shorPath;
        return func_path;
    }

    private static void getBaseList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONArray list = new JSONArray();
        JSONObject node = new JSONObject();
        String sysFolderBase = Var.getString("sys.ide.sysFolderBase");
        node.put("text", (Object)"\u6a21\u5757");
        node.put("iconCls", (Object)"module_icon");
        node.put("expanded", true);
        node.put("base", (Object)(String.valueOf(FileUtil.getPath(Base.modulePath)) + '/'));
        node.put("type", (Object)"module");
        list.put((Object)node);
        if (Var.getBool("sys.ide.appFolder", true)) {
            node = new JSONObject();
            node.put("text", (Object)"\u5e94\u7528");
            node.put("iconCls", (Object)"application_icon");
            node.put("base", (Object)(String.valueOf(FileUtil.getPath(Base.path)) + '/'));
            node.put("type", (Object)"app");
            list.put((Object)node);
        }
        if (!sysFolderBase.equals("app")) {
            node = new JSONObject();
            node.put("text", (Object)"\u7cfb\u7edf");
            node.put("iconCls", (Object)"system_icon");
            sysFolderBase = sysFolderBase.equals("server") ? String.valueOf(FileUtil.getPath(Base.path.getParentFile().getParent())) + '/' : "";
            node.put("base", (Object)sysFolderBase);
            node.put("type", (Object)"file");
            list.put((Object)node);
        }
        WebUtil.send(response, (Object)list);
    }

    public static void setProperty(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject result;
        File newFile;
        JSONObject map = WebUtil.fetch(request);
        String pkId = map.getString("pkId");
        File configFile = null;
        File oldFile = new File(map.getString("path"));
        String newRelPath = null;
        String oldRelPath = null;
        String url = map.optString("url");
        String oldName = oldFile.getName();
        String newName = map.getString("text");
        String qtip = map.getString("qtip");
        boolean nameModified = !oldName.equals(newName);
        boolean urlValid = map.optBoolean("urlValid");
        JSONObject indexContent = null;
        boolean isDir = oldFile.isDirectory();
        boolean isModule = map.getBoolean("isModule");
        if (nameModified) {
            Service.containAdmin(oldFile.getAbsolutePath(), null);
            newFile = new File(oldFile.getParent(), newName);
        } else {
            newFile = oldFile;
        }
        if (isModule) {
            BwIDE.updateTask((JSONObject)map, (boolean)nameModified);
            result = new JSONObject();
            result.put("lastModified", (Object)DateUtil.getTimestamp(newFile.lastModified()));
            result.put("path", (Object)FileUtil.getPath(newFile));
            result.put("qtip", (Object)qtip);
            newRelPath = FileUtil.getModulePath(newFile);
            oldRelPath = nameModified ? FileUtil.getModulePath(oldFile) : newRelPath;
            boolean isChange = false;
            if (isDir) {
                if (nameModified) {
                    UrlBuffer.change(oldRelPath, newRelPath, isDir);
                    isChange = true;
                }
            } else if (urlValid) {
                if (url == null || url.equals("")) {
                    UrlBuffer.remove(oldRelPath);
                } else {
                    if (!UrlBuffer.exists(url, oldFile)) {
                        throw new IllegalArgumentException("URL\u6377\u5f84 \"" + url + "\" \u5df2\u7ecf\u5b58\u5728\u3002");
                    }
                    if (nameModified) {
                        UrlBuffer.remove(oldRelPath);
                        UrlBuffer.put(String.valueOf('/') + url, newRelPath);
                    } else {
                        UrlBuffer.put(String.valueOf('/') + url, oldRelPath);
                    }
                }
                isChange = true;
            }
            if (isChange) {
                UrlBuffer.save();
            }
        } else {
            boolean needConfig;
            if (urlValid && !UrlBuffer.exists(url, oldFile)) {
                throw new IllegalArgumentException("URL\u6377\u5f84 \"" + url + "\" \u5df2\u7ecf\u5b58\u5728\u3002");
            }
            if (nameModified) {
                FileUtil.syncRename(oldFile, newFile);
            }
            File indexFile = new File(newFile.getParentFile(), "folder.json");
            boolean indexFileExists = indexFile.exists();
            boolean bl = needConfig = isModule || indexFileExists;
            if (needConfig) {
                JSONArray idxArray;
                int index;
                if (indexFileExists) {
                    indexContent = JsonUtil.readObject(indexFile);
                } else if (isModule) {
                    indexContent = new JSONObject();
                    indexContent.put("index", (Object)new JSONArray());
                }
                if (isModule) {
                    JSONObject content;
                    if (isDir) {
                        configFile = new File(newFile, "folder.json");
                        if (configFile.exists()) {
                            content = JsonUtil.readObject(configFile);
                        } else {
                            content = new JSONObject();
                            content.put("index", (Object)new JSONArray());
                        }
                    } else {
                        content = JsonUtil.readObject(newFile);
                    }
                    content.put("title", (Object)map.getString("title"));
                    content.put("iconCls", (Object)map.getString("iconCls"));
                    content.put("hidden", map.getBoolean("hidden"));
                    content.put("qtip", (Object)qtip);
                    if (isDir) {
                        FileUtil.syncSave(configFile, content.toString());
                    } else {
                        content.put("inframe", map.getBoolean("inframe"));
                        content.put("pageLink", (Object)map.getString("pageLink"));
                        if (map.has("isDefaultRole")) {
                            String[] roles;
                            boolean isDefaultRole = map.getBoolean("isDefaultRole");
                            content.put("isDefaultRole", isDefaultRole);
                            if (isDefaultRole && StringUtils.isNotBlank((String)Var.defaultRole)) {
                                roles = StringUtils.split((String)Var.defaultRole, (String)",");
                                IDE.updateModule(newFile, content, roles, true, WebUtil.fetch(request, "sys.user"));
                            } else if (!isDefaultRole && StringUtils.isNotBlank((String)Var.defaultRole)) {
                                roles = StringUtils.split((String)Var.defaultRole, (String)",");
                                IDE.updateModule(newFile, content, roles, false, WebUtil.fetch(request, "sys.user"));
                            } else {
                                IDE.updateModule(newFile, content, null, false, WebUtil.fetch(request, "sys.user"));
                            }
                        } else {
                            IDE.updateModule(newFile, content, null, false, WebUtil.fetch(request, "sys.user"));
                        }
                    }
                }
                if (nameModified && indexFileExists && (index = (idxArray = indexContent.getJSONArray("index")).indexOf((Object)oldName)) != -1) {
                    idxArray.put(index, (Object)newName);
                    FileUtil.syncSave(indexFile, indexContent.toString());
                }
            }
            if (isModule) {
                newRelPath = FileUtil.getModulePath(newFile);
                oldRelPath = nameModified ? FileUtil.getModulePath(oldFile) : newRelPath;
                boolean changed = false;
                if (isDir) {
                    if (nameModified && UrlBuffer.change(oldRelPath, newRelPath, isDir)) {
                        changed = true;
                    }
                } else {
                    if (UrlBuffer.remove(oldRelPath)) {
                        changed = true;
                    }
                    if (urlValid && !url.isEmpty()) {
                        UrlBuffer.put(String.valueOf('/') + url, newRelPath);
                        changed = true;
                    }
                }
                if (changed) {
                    UrlBuffer.save();
                }
            }
            result = new JSONObject();
            result.put("lastModified", (Object)DateUtil.getTimestamp(newFile.lastModified()));
            result.put("path", (Object)FileUtil.getPath(newFile));
            result.put("qtip", (Object)qtip);
            if (nameModified) {
                JSONObject resp = new JSONObject();
                JSONArray src = new JSONArray();
                JSONArray moveTo = new JSONArray();
                src.put((Object)FileUtil.getPath(oldFile));
                moveTo.put((Object)FileUtil.getPath(newFile));
                Object[] changeInfo = IDE.changePath(src, moveTo);
                resp.put("files", changeInfo[0]);
                resp.put("change", changeInfo[1]);
                resp.put("moveTo", (Object)moveTo);
                result.put("refactorInfo", (Object)resp);
            }
        }
        WebUtil.send(response, (Object)result);
        if (isModule) {
            boolean isDefaultRole = false;
            if (map.has("isDefaultRole")) {
                isDefaultRole = map.getBoolean("isDefaultRole");
            }
        }
    }

    private static void addDefaultRole(JSONObject content, boolean isDefaultRole) {
        if (isDefaultRole && StringUtils.isNotBlank((String)Var.defaultRole)) {
            for (String defaultRole : Arrays.asList(Var.defaultRole.split(","))) {
                if (content.has("roles")) {
                    ((JSONObject)content.get("roles")).put(defaultRole, 1);
                    continue;
                }
                content.put("roles", (Object)new JSONObject().put(defaultRole, 1));
            }
        } else {
            content.put("roles", (Object)new JSONObject());
        }
    }

    private static boolean doSearchFile(File folder, String searchName, JSONArray array) throws Exception {
        File[] files;
        File[] fileArray = files = FileUtil.listFiles(folder);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                if (IDE.doSearchFile(file, searchName, array)) {
                    return true;
                }
            } else {
                String path = FileUtil.getPath(file);
                String name = path.substring(path.lastIndexOf(47) + 1).toLowerCase();
                if (!name.equals("folder.json") && name.indexOf(searchName) != -1) {
                    JSONObject jo = new JSONObject();
                    jo.put("path", (Object)path);
                    array.put((Object)jo);
                    if (array.length() > 99) {
                        return true;
                    }
                }
            }
            ++n2;
        }
        return false;
    }

    public static void total(HttpServletRequest request, HttpServletResponse response) throws Exception {
        File file = new File(request.getParameter("path"));
        JSONObject result = new JSONObject();
        boolean isDir = file.isDirectory();
        String path = RoleUtils.getRelativePath((String)file.getAbsolutePath());
        Timestamp time = null;
        long fileSize = 0L;
        CacheServiceAware cacheService = (CacheServiceAware)SpringContextUtil.getBean((String)"sysCacheServcie");
        int[] info = new int[4];
        if (path.endsWith(".xwl")) {
            FunctionEObj functionEObj = cacheService.getFunctionByPath(path);
            time = DateUtil.getTimestamp(functionEObj.getLastUpdateTms().getTime());
            FunctionContentCacheAware ct = (FunctionContentCacheAware)SpringContextUtil.getBean((String)"contentCacheServcie");
            fileSize = ct.getContent(functionEObj.getFuncId()).length();
        } else if (IDE.getTimeStamp(path) != null) {
            time = DateUtil.getTimestamp(IDE.getTimeStamp(path).getLastUpdateTms().getTime());
            IDE.getChildMenFunction(IDE.getTimeStamp(path).getMenuId(), info);
        } else {
            time = DateUtil.getTimestamp(file.lastModified());
            fileSize = file.length();
            if (isDir && FileUtil.isAncestor(Base.path, file)) {
                IDE.total(file, info);
            }
        }
        result.put("total", (Object)info);
        result.put("lastModified", time != null ? DateUtils.getDateFormat((String)"yyyy-MM-dd HH:mm:ss").format(time) : time);
        result.put("fileSize", fileSize);
        if (!isDir && FileUtil.isAncestor(Base.modulePath, file) && file.getName().endsWith(".xwl")) {
            result.put("url", (Object)UrlBuffer.find(file));
        }
        WebUtil.send(response, (Object)result);
    }

    private static void getChildMenFunction(Long menuId, int[] info) throws KException {
        CacheServiceAware cacheService = (CacheServiceAware)SpringContextUtil.getBean((String)"sysCacheServcie");
        FunctionContentCacheAware ct = (FunctionContentCacheAware)SpringContextUtil.getBean((String)"contentCacheServcie");
        List getMenuChildFunction = cacheService.getMenuChildFunction(menuId);
        for (FunctionEObj functionEObj : getMenuChildFunction) {
            info[3] = info[3] + ct.getContent(functionEObj.getFuncId()).length();
        }
        info[0] = info[0] + getMenuChildFunction.size();
        List getChildMenu = cacheService.getChildMenus(menuId);
        info[2] = info[2] + getChildMenu.size();
        info[1] = info[0] + info[2] + 1;
        for (MenuEObj menuEObj : getChildMenu) {
            IDE.getChildMenFunction(menuEObj.getMenuId(), info);
        }
    }

    private static MenuEObj getTimeStamp(String name) throws KException {
        name = name.substring(name.lastIndexOf("/") + 1);
        CacheServiceAware cacheService = (CacheServiceAware)SpringContextUtil.getBean((String)"sysCacheServcie");
        Map menuMap = cacheService.getMenuMap();
        for (Long menuId : menuMap.keySet()) {
            MenuEObj menuEObj = (MenuEObj)menuMap.get(menuId);
            if (!name.equals(menuEObj.getMenuName())) continue;
            return menuEObj;
        }
        return null;
    }

    private static void total(File folder, int[] info) {
        File[] files;
        File[] fileArray = files = FileUtil.listFiles(folder);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                info[2] = info[2] + 1;
                IDE.total(file, info);
            } else {
                if (file.getName().endsWith(".xwl")) {
                    info[0] = info[0] + 1;
                }
                info[1] = info[1] + 1;
                info[3] = (int)((long)info[3] + file.length());
            }
            ++n2;
        }
    }

    public static void search(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String searchType = request.getParameter("searchType");
        if ("shortcut".equals(searchType)) {
            IDE.searchShortcut(request, response);
            return;
        }
        if ("filelist".equals(searchType)) {
            IDE.searchFile(request, response);
            return;
        }
        if ("duplicate".equals(searchType)) {
            IDE.searchDuplicateFiles(request, response);
            return;
        }
        JSONArray pathList = new JSONArray(request.getParameter("pathList"));
        String searchText = request.getParameter("search");
        String[] filePatterns = StringUtil.split(request.getParameter("filePatterns"), ',', true);
        boolean whole = Boolean.parseBoolean(request.getParameter("whole"));
        boolean isReplace = Boolean.parseBoolean(request.getParameter("isReplace"));
        Pattern searchPattern = null;
        int pathListLen = pathList.length();
        ArrayList<File> searchedFiles = new ArrayList<File>(pathListLen);
        JSONArray rows = new JSONArray();
        searchPattern = Boolean.parseBoolean(request.getParameter("regularExp")) ? Pattern.compile(searchText) : Pattern.compile(StringUtil.concat(Boolean.parseBoolean(request.getParameter("caseSensitive")) ? "" : "(?i)", whole ? "\\b" : "", "\\Q", searchText, "\\E", whole ? "\\b" : ""));
        int i = 0;
        while (i < pathListLen) {
            File file = new File(pathList.getString(i));
            if (!FileUtil.isAncestor(Base.path, file)) {
                throw new IllegalArgumentException("\u7981\u6b62\u68c0\u7d22\u5e94\u7528\u76ee\u5f55\u4e4b\u5916\u7684\u6587\u4ef6\u3002");
            }
            boolean searched = false;
            for (File f : searchedFiles) {
                if (!FileUtil.isAncestor(f, file) || BwIDE.isModuleFile((File)file)) continue;
                searched = true;
                break;
            }
            if (!searched) {
                if (!BwIDE.isModuleFile((File)file)) {
                    IDE.doSearch(request, response, file, rows, searchPattern, filePatterns, isReplace ? request.getParameter("replace") : null);
                    searchedFiles.add(file);
                } else if (SearchUtils.containXwl(filePatterns)) {
                    SearchUtils.dealXwl(request, response, rows, new ScanXwl(){

                        @Override
                        public void scanXwl(JSONObject xwl, String path, Pattern pattern, JSONArray rows, String nodePath) {
                            IDE.searchXwl(xwl.toString(), path, pattern, rows);
                        }
                    }, Base.modulePathText);
                }
            }
            ++i;
        }
        WebUtil.send(response, (Object)new JSONObject().put("rows", (Object)rows));
    }

    private static boolean doSearch(HttpServletRequest request, HttpServletResponse response, File file, JSONArray rows, Pattern pattern, String[] filePatterns, String replaceText) throws Exception {
        if (file.isDirectory()) {
            File[] files;
            File[] fileArray = files = FileUtil.listFiles(file);
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                boolean match;
                File f = fileArray[n2];
                if (filePatterns.length == 0 || f.isDirectory()) {
                    match = true;
                } else {
                    match = false;
                    String[] stringArray = filePatterns;
                    int n3 = filePatterns.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String filePattern = stringArray[n4];
                        if (FilenameUtils.wildcardMatch((String)f.getName(), (String)filePattern, (IOCase)IOCase.SYSTEM)) {
                            match = true;
                            break;
                        }
                        ++n4;
                    }
                }
                if (match && !IDE.doSearch(request, response, f, rows, pattern, filePatterns, replaceText)) {
                    return false;
                }
                ++n2;
            }
        } else {
            if (IDE.debugVersionExists(file)) {
                return true;
            }
            String text = FileUtil.readString(file);
            String path = FileUtil.getPath(file);
            if (replaceText == null) {
                if (path.endsWith(".xwl") ? !IDE.searchXwl(text, path, pattern, rows) : !IDE.searchText(text, path, pattern, rows, null, null)) {
                    return false;
                }
            } else {
                String replacedText;
                if (path.endsWith(".xwl")) {
                    replaceText = StringUtil.text(replaceText);
                }
                if (!(replacedText = pattern.matcher(text).replaceAll(Matcher.quoteReplacement(replaceText))).equals(text)) {
                    FileUtil.syncSave(file, replacedText);
                    JSONObject row = new JSONObject();
                    row.put("content", (Object)("\u66ff\u6362\uff1a" + replaceText));
                    row.put("path", (Object)path);
                    row.put("lastModified", (Object)DateUtil.getTimestamp(file.lastModified()));
                    rows.put((Object)row);
                }
            }
        }
        return true;
    }

    private static boolean searchText(String text, String path, Pattern pattern, JSONArray rows, String nodePath, String itemName) {
        int lastPos = 0;
        int line = 1;
        int textLength = text.length();
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            int minPos;
            int matchTextLength;
            JSONObject row = new JSONObject();
            if (rows.length() == 999) {
                row.put("content", (Object)"\u8d85\u8fc71000\u9879\u88ab\u641c\u7d22\u5230\uff0c\u505c\u6b62\u641c\u7d22\u3002");
                rows.put((Object)row);
                return false;
            }
            int pos = matcher.start();
            int afterTextPos = pos + (matchTextLength = matcher.end() - pos);
            if (afterTextPos > (minPos = Math.min(textLength, pos + 70))) {
                return true;
            }
            row.put("content", (Object)StringUtil.concat(StringUtil.toHTML(text.substring(Math.max(0, pos - 30), pos), false, false), "<strong>", StringUtil.toHTML(text.substring(pos, afterTextPos), false, false), "</strong>", afterTextPos >= textLength ? "" : StringUtil.toHTML(text.substring(afterTextPos, minPos), false, false)));
            int[] lineInfo = StringUtil.stringOccur(text, '\n', lastPos, pos);
            lastPos = pos;
            row.put("path", (Object)path);
            row.put("line", line += lineInfo[0]);
            row.put("ch", pos - lineInfo[1]);
            row.put("nodePath", (Object)nodePath);
            row.put("itemName", (Object)itemName);
            rows.put((Object)row);
            pos += matchTextLength;
        }
        return true;
    }

    public static void searchShortcut(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String shortcut = request.getParameter("shortcut");
        Set<Map.Entry<String, String>> es = UrlBuffer.buffer.entrySet();
        JSONArray ja = new JSONArray();
        for (Map.Entry<String, String> e : es) {
            String key = e.getKey().substring(1);
            if (!FilenameUtils.wildcardMatch((String)key, (String)shortcut, (IOCase)IOCase.INSENSITIVE)) continue;
            JSONObject jo = new JSONObject();
            if (ja.length() == 999) {
                jo.put("content", (Object)"\u8d85\u8fc71000\u9879\u88ab\u641c\u7d22\u5230\uff0c\u505c\u6b62\u641c\u7d22\u3002");
                ja.put((Object)jo);
                break;
            }
            jo.put("content", (Object)key);
            jo.put("path", (Object)FileUtil.getPath(new File(Base.modulePath, e.getValue())));
            jo.put("line", 1);
            jo.put("ch", 1);
            ja.put((Object)jo);
        }
        WebUtil.send(response, (Object)new JSONObject().put("rows", (Object)ja));
    }

    public static void searchFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        long lastModified;
        JSONArray array = new JSONArray();
        String query = request.getParameter("query");
        String onlyXwl = request.getParameter("onlyXwl");
        boolean searchList = Boolean.parseBoolean(request.getParameter("searchList"));
        String lastModifiedStr = searchList ? request.getParameter("lastModified") : "-1";
        long l = lastModified = "-1".equals(lastModifiedStr) ? -1L : DateUtil.strToDate(lastModifiedStr).getTime();
        if (!"onlyXwl".equals(onlyXwl)) {
            String temp = query;
            if (temp.isEmpty()) {
                temp = ".xwl";
            }
            if (!searchList) {
                temp = "*" + temp + "*";
            }
            IDE.doSearchFile(Base.path, temp, lastModified, array);
        }
        if (query != null && !"".equals(query)) {
            IDE.doSearchFile(query, lastModified, array);
        }
        WebUtil.send(response, (Object)new JSONObject().put("rows", (Object)array));
    }

    private static boolean doSearchFile(String searchName, long lastModified, JSONArray array) throws Exception {
        CacheServiceAware roleCache = (CacheServiceAware)SpringContextUtil.getBean((String)"sysCacheServcie");
        Map funcMap = roleCache.getFuncMap();
        for (Long key : funcMap.keySet()) {
            FunctionEObj functionEObj = (FunctionEObj)funcMap.get(key);
            String funcPath = functionEObj.getFuncPath();
            if (funcPath == null || !funcPath.contains(searchName)) continue;
            JSONObject jo = new JSONObject();
            jo.put("path", (Object)("modules/" + funcPath));
            jo.put("content", (Object)searchName);
            jo.put("line", 1);
            jo.put("ch", 1);
            array.put((Object)jo);
            if (array.length() <= 99) continue;
            return true;
        }
        return false;
    }

    private static boolean doSearchFile(File folder, String searchName, long lastModified, JSONArray array) throws Exception {
        File[] files;
        File[] fileArray = files = FileUtil.listFiles(folder);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                if (IDE.doSearchFile(file, searchName, lastModified, array)) {
                    return true;
                }
            } else {
                boolean search;
                String path = FileUtil.getPath(file);
                String name = path.substring(path.lastIndexOf(47) + 1);
                boolean bl = search = !(name.equals("folder.json") || !searchName.isEmpty() && !FilenameUtils.wildcardMatch((String)name, (String)searchName, (IOCase)IOCase.INSENSITIVE) || lastModified != -1L && file.lastModified() < lastModified);
                if (search) {
                    JSONObject jo = new JSONObject();
                    jo.put("path", (Object)path);
                    jo.put("content", (Object)name);
                    jo.put("line", 1);
                    jo.put("ch", 1);
                    array.put((Object)jo);
                    if (array.length() > 99) {
                        return true;
                    }
                }
            }
            ++n2;
        }
        return false;
    }

    private static boolean debugVersionExists(File file) {
        if (Var.getBool("sys.ide.searchIgnoreRelease")) {
            String filename = file.getName();
            File debugFile = new File(file.getParentFile(), String.valueOf(FileUtil.removeExtension(filename)) + "-debug." + FileUtil.getFileExt(filename));
            return debugFile.exists();
        }
        return false;
    }

    private static boolean searchXwl(String text, String path, Pattern pattern, JSONArray rows) {
        JSONObject xwl = new JSONObject(text);
        return IDE.scanXwl(xwl, path, pattern, rows, "");
    }

    private static boolean scanXwl(JSONObject xwl, String path, Pattern pattern, JSONArray rows, String nodePath) {
        JSONArray children = xwl.optJSONArray("children");
        if (children != null) {
            int j = children.length();
            int i = 0;
            while (i < j) {
                String currentPath;
                JSONObject jo = children.getJSONObject(i);
                JSONObject configs = jo.getJSONObject("configs");
                if (!IDE.scanItems(configs, path, pattern, rows, currentPath = String.valueOf(nodePath) + "/" + configs.getString("itemId"), "Configs")) {
                    return false;
                }
                if (jo.has("events") && !IDE.scanItems(jo.getJSONObject("events"), path, pattern, rows, currentPath, "Events")) {
                    return false;
                }
                if (!IDE.scanXwl(jo, path, pattern, rows, currentPath)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private static boolean scanItems(JSONObject jo, String path, Pattern pattern, JSONArray rows, String nodePath, String type) {
        Set items = jo.entrySet();
        for (Map.Entry item : items) {
            String key = (String)item.getKey();
            if (!IDE.searchText(key, path, pattern, rows, nodePath, String.valueOf(type) + "=" + key)) {
                return false;
            }
            if (IDE.searchText(item.getValue().toString(), path, pattern, rows, nodePath, String.valueOf(type) + "=" + key)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasChildren(MenuEObj parentMenu) throws KException {
        Map funcMap;
        CacheServiceAware roleCache = (CacheServiceAware)SpringContextUtil.getBean((String)"sysCacheServcie");
        Map menuMap = roleCache.getMenuMap();
        if (menuMap != null) {
            for (MenuEObj menuEObj : menuMap.values()) {
                if (!parentMenu.getMenuId().equals(menuEObj.getParentId())) continue;
                return true;
            }
        }
        if ((funcMap = roleCache.getFuncMap()) != null) {
            for (FunctionEObj functionEObj : funcMap.values()) {
                if (!parentMenu.getMenuId().equals(functionEObj.getMenuId())) continue;
                return true;
            }
        }
        return false;
    }

    public static void addModule(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject moduleConfigs;
        String name = request.getParameter("name");
        String title = request.getParameter("title");
        String iconCls = request.getParameter("iconCls");
        String qtip = request.getParameter("qtip");
        String url = null;
        String pkId = null;
        boolean isDefaultRole = false;
        boolean hidden = Boolean.parseBoolean(request.getParameter("hidden"));
        boolean isDir = Boolean.parseBoolean(request.getParameter("isDir"));
        JSONObject content = new JSONObject();
        JSONObject moduleMeta = moduleConfigs = Controls.get("module").optJSONObject("configs");
        content.put("title", (Object)title);
        content.put("iconCls", (Object)iconCls);
        content.put("hidden", hidden);
        content.put("qtip", (Object)qtip);
        if (!isDir) {
            pkId = RandomUtil.simpleUUID();
            content.put("pkId", (Object)pkId);
            isDefaultRole = Boolean.parseBoolean(request.getParameter("isDefaultRole"));
            content.put("isDefaultRole", isDefaultRole);
            IDE.addDefaultRole(content, isDefaultRole);
            content.put("inframe", Boolean.parseBoolean(request.getParameter("inframe")));
            content.put("pageLink", (Object)request.getParameter("pageLink"));
            url = request.getParameter("url");
            if (!UrlBuffer.exists(url, null)) {
                throw new IllegalArgumentException("URL\u6377\u5f84 \"" + url + "\" \u5df2\u7ecf\u5b58\u5728\u3002");
            }
            if (!name.endsWith(".xwl")) {
                name = name.toLowerCase().endsWith(".xwl") ? String.valueOf(name.substring(0, name.length() - 3)) + "xwl" : String.valueOf(name) + ".xwl";
            }
            JSONObject module = new JSONObject();
            moduleConfigs = new JSONObject();
            moduleConfigs.put("itemId", (Object)"module");
            Set moduleConfigEntries = moduleMeta.entrySet();
            for (Map.Entry entry : moduleConfigEntries) {
                Object value = ((JSONObject)entry.getValue()).opt("value");
                if (value == null) continue;
                moduleConfigs.put((String)entry.getKey(), (Object)value.toString());
            }
            module.put("children", (Object)new JSONArray());
            module.put("configs", (Object)moduleConfigs);
            module.put("type", (Object)"module");
            content.put("children", (Object)new JSONArray().put((Object)module));
        }
        File base = new File(request.getParameter("path"));
        File file = IDE.addModule(request.getParameter("path"), name, isDir, content);
        if (isDir) {
            JSONObject fileInfo = new JSONObject();
            fileInfo.put("file", (Object)name);
            fileInfo.put("title", (Object)title);
            fileInfo.put("iconCls", (Object)iconCls);
            fileInfo.put("hidden", hidden);
            fileInfo.put("qtip", (Object)qtip);
            WebUtil.send(response, (Object)fileInfo);
        } else {
            if (StrUtil.isNotBlank(url)) {
                UrlBuffer.put(String.valueOf('/') + url, FileUtil.getModulePath(file));
                UrlBuffer.save();
            }
            IDE.doOpen(new JSONArray().put((Object)FileUtil.getPath(file)), null, null, request, response);
        }
    }

    private static void createFunction(HttpServletRequest request) throws Exception {
        String text = request.getParameter("text");
        if (StringUtils.isNotBlank((String)text)) {
            text = StringUtils.substringBefore((String)text, (String)".");
        }
        Connection conn = null;
        CallableStatement cst = null;
        try {
            try {
                conn = DbUtil.getConnection();
                cst = conn.prepareCall("{call P_FUNCTION_DESC(?,?,?,?,?,?,?)}");
                cst.setString(1, text);
                cst.setString(2, "");
                cst.setString(3, "");
                cst.setString(4, WebUtil.fetch(request, "title"));
                cst.setString(5, WebUtil.fetch(request, "sys.username"));
                cst.registerOutParameter(6, 12);
                cst.registerOutParameter(7, 4);
                cst.execute();
            }
            catch (Throwable e) {
                log.error((Object)"", e);
                LogUtil.error(e.getMessage());
                throw e;
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(cst);
            DbUtil.close(conn);
            throw throwable;
        }
        DbUtil.close(cst);
        DbUtil.close(conn);
    }

    private static void setFileIndex(File folder, String indexFileName, JSONArray insertFileNames, String type) throws Exception {
        int index;
        int i;
        JSONArray indexArray;
        JSONObject content;
        File file = new File(folder, "folder.json");
        int j = insertFileNames.length();
        if (file.exists()) {
            content = JsonUtil.readObject(file);
            indexArray = content.getJSONArray("index");
            i = 0;
            while (i < j) {
                index = indexArray.indexOf((Object)insertFileNames.getString(i));
                if (index != -1) {
                    indexArray.remove(index);
                }
                ++i;
            }
            int k = indexArray.length();
            i = k - 1;
            while (i >= 0) {
                File checkFile = new File(folder, indexArray.getString(i));
                if (!checkFile.exists()) {
                    indexArray.remove(i);
                }
                --i;
            }
            if (StringUtil.isEmpty(indexFileName) || "append".equals(type)) {
                index = -1;
            } else {
                index = indexArray.indexOf((Object)indexFileName);
                if (index != -1 && "after".equals(type)) {
                    ++index;
                }
            }
        } else {
            content = new JSONObject();
            indexArray = new JSONArray();
            content.put("index", (Object)indexArray);
            index = -1;
        }
        if (index == -1) {
            i = j - 1;
            while (i >= 0) {
                indexArray.put((Object)insertFileNames.getString(i));
                --i;
            }
        } else {
            i = 0;
            while (i < j) {
                indexArray.add(index, (Object)insertFileNames.getString(i));
                ++i;
            }
        }
        FileUtil.syncSave(file, content.toString());
    }

    private static File addModule(String base, String name, boolean isDir, JSONObject content) throws Exception {
        File file = new File(base, name);
        BwIDE.addModule((String)base, (String)name, (boolean)isDir, (JSONObject)content);
        return file;
    }

    public static void getThreadList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        Thread[] threadArray = threadSet.toArray(new Thread[threadSet.size()]);
        StringBuilder buf = new StringBuilder();
        final Collator collator = Collator.getInstance();
        int daemonThreads = 0;
        Arrays.sort(threadArray, new Comparator<Thread>(){

            @Override
            public int compare(Thread t1, Thread t2) {
                CollationKey k1 = collator.getCollationKey(StringUtil.opt(t1.getName()).toLowerCase());
                CollationKey k2 = collator.getCollationKey(StringUtil.opt(t2.getName()).toLowerCase());
                return k1.compareTo(k2);
            }
        });
        Thread[] threadArray2 = threadArray;
        int n = threadArray.length;
        int n2 = 0;
        while (n2 < n) {
            Thread thread = threadArray2[n2];
            buf.append("<p");
            if (thread.isDaemon()) {
                ++daemonThreads;
                buf.append(" style=\"color:blue\">");
            } else {
                buf.append(">");
            }
            buf.append(thread.getName());
            buf.append(" (");
            buf.append(thread.getPriority());
            buf.append(")</p>");
            ++n2;
        }
        buf.append("<p>\u5408\u8ba1\u7ebf\u7a0b\uff1a");
        buf.append(threadArray.length);
        buf.append("\uff0c\u5b88\u62a4\u7ebf\u7a0b\uff1a");
        buf.append(daemonThreads);
        buf.append("\uff0c\u666e\u901a\u7ebf\u7a0b\uff1a");
        buf.append(threadArray.length - daemonThreads);
        buf.append("</p>");
        WebUtil.send(response, (Object)buf);
    }

    public static void addFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String name = request.getParameter("name");
        String path = request.getParameter("path");
        if (path.isEmpty()) {
            throw new IllegalArgumentException("\u7236\u76ee\u5f55\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\u3002");
        }
        boolean isDir = Boolean.parseBoolean(request.getParameter("isDir"));
        JSONObject fileInfo = new JSONObject();
        File file = IDE.addFile(new File(path), name, isDir);
        if (isDir) {
            fileInfo.put("children", (Object)new JSONArray());
        } else {
            fileInfo.put("leaf", true);
            fileInfo.put("icon", (Object)("m?xwl=dev/ide/get-file-icon&file=" + WebUtil.encode(FileUtil.getPath(file))));
        }
        fileInfo.put("text", (Object)name);
        WebUtil.send(response, (Object)fileInfo);
    }

    public static void reload(HttpServletRequest request, HttpServletResponse response) {
        SysUtil.reload(1);
    }

    private static File addFile(File base, String name, boolean isDir) throws Exception {
        File file = new File(base, name);
        if (isDir) {
            FileUtil.syncCreate(file, true);
        } else {
            FileUtil.syncCreate(file, false);
        }
        return file;
    }

    public static ArrayList<Map.Entry<String, Integer>> getSortedFile(File dir) throws Exception {
        HashMap<String, Integer> jsonMap = new HashMap<String, Integer>();
        String[] fileNames = dir.list();
        SortUtil.sort(fileNames);
        int j = fileNames.length;
        int i = 0;
        while (i < j) {
            jsonMap.put(fileNames[j - i - 1], Integer.MAX_VALUE - i);
            ++i;
        }
        File configFile = new File(dir, "folder.json");
        if (configFile.exists()) {
            JSONArray indexArray = JsonUtil.readObject(configFile).getJSONArray("index");
            j = indexArray.length();
            i = 0;
            while (i < j) {
                jsonMap.put(indexArray.getString(i), i);
                ++i;
            }
        }
        return SortUtil.sortValue(jsonMap, true);
    }

    public static void saveFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String fileExt;
        File file;
        JSONObject content;
        boolean confirm = !Boolean.parseBoolean(request.getParameter("noConfirm"));
        JSONArray files = new JSONArray(StringUtil.getString((InputStream)request.getInputStream()));
        JSONArray lastModifiedData = new JSONArray();
        String filename = null;
        int j = files.length();
        int modifiedCount = 0;
        int i = 0;
        while (i < j) {
            content = files.getJSONObject(i);
            file = new File(content.getString("file"));
            Service.containAdmin(file.getAbsolutePath(), null);
            if (filename == null) {
                filename = content.getString("file");
            }
            long lastUpdateTms = 0L;
            fileExt = FileUtil.getFileExt(filename).toLowerCase();
            if ("xwl".equals(fileExt)) {
                String path = RoleUtils.getRelativePath((String)content.getString("file"));
                CacheServiceAware cacheService = (CacheServiceAware)SpringContextUtil.getBean((String)"sysCacheServcie");
                FunctionEObj functionEObj = cacheService.getFunctionByPath(path);
                lastUpdateTms = functionEObj.getLastUpdateTms().getTime();
            } else {
                lastUpdateTms = file.lastModified();
            }
            if (confirm && lastUpdateTms != content.getTimestamp("lastModified").getTime()) {
                ++modifiedCount;
            }
            ++i;
        }
        if (modifiedCount > 0) {
            SysUtil.error("\u6587\u4ef6 \"" + FileUtil.getFilename(filename) + "\"" + (modifiedCount > 1 ? " \u7b49 " + modifiedCount + " \u9879" : " ") + "\u5df2\u7ecf\u88ab\u522b\u4eba\u4fee\u6539\uff0c\u786e\u5b9a\u8981\u4fdd\u5b58\u5417\uff1f", "101");
        }
        i = 0;
        while (i < j) {
            content = files.getJSONObject(i);
            filename = content.getString("file");
            String saveContent = content.getString("content");
            file = new File(filename);
            fileExt = FileUtil.getFileExt(filename).toLowerCase();
            if (StringUtil.indexOf(imageTypes, fileExt) == -1) {
                if ("xwl".equals(fileExt)) {
                    IDE.updateModule(file, new JSONObject(saveContent), null, false, WebUtil.fetch(request, "sys.user"));
                } else {
                    FileUtil.syncSave(file, saveContent, content.optString("charset"));
                }
            } else {
                FileUtil.syncSave(file, StringUtil.decodeBase64(saveContent));
            }
            if ("xwl".equals(fileExt)) {
                String path = RoleUtils.getRelativePath((String)filename);
                CacheServiceAware cacheService = (CacheServiceAware)SpringContextUtil.getBean((String)"sysCacheServcie");
                FunctionEObj functionEObj = cacheService.getFunctionByPath(path);
                lastModifiedData.put((Object)DateUtil.getTimestamp(functionEObj.getLastUpdateTms().getTime()));
            } else {
                lastModifiedData.put((Object)DateUtil.getTimestamp(file.lastModified()));
            }
            ++i;
        }
        WebUtil.send(response, (Object)lastModifiedData);
    }

    public static void updateModule(File file, JSONObject moduleData, String[] roles, boolean addRoles, final String user) throws Exception {
        if (moduleData == null && roles == null) {
            return;
        }
        final JSONObject module = (JSONObject)((JSONArray)moduleData.opt("children")).opt(0);
        boolean loginRequired = RoleUtils.isLoginRequired((JSONObject)moduleData);
        final FunctionEObj functionEObj = FunctionUtils.updateFunctionContent((String)file.getAbsolutePath(), (String)module.toString(), (String)user, (boolean)loginRequired);
        String absolutePath = StringUtil.replaceAll(file.getAbsolutePath(), "\\", "/");
        String newPath = absolutePath.replace("modules", "xwl");
        final String tempPath = newPath.substring(0, newPath.lastIndexOf("/"));
        final String fileName = file.getName();
        ThreadPoolTaskExecutor exec = DefaultThreadPool.getThreadPoolTaskExecutor();
        exec.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    IDE.saveXwl(String.valueOf(tempPath) + "/" + DateUtils.formatCompactDatetime((Timestamp)functionEObj.getLastUpdateTms()) + "_" + user + "_" + fileName, module.toString(), "utf-8", tempPath);
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        });
    }

    public static void saveXwl(String file, String content, String charSet, String tempPath) throws Exception {
        File fileFold;
        boolean autoSubmitSVN = Var.getBool("sys.app.autoSubmitSVN");
        File fileXwl = new File(file);
        if (autoSubmitSVN) {
            SvnUtil.submitSvn(fileXwl.getName(), file, 1);
        }
        if (!(fileFold = new File(tempPath)).exists()) {
            fileFold.mkdirs();
        }
        if (!fileXwl.exists()) {
            fileXwl.createNewFile();
        }
        FileUtil.syncSave(fileXwl, content, charSet);
        if (autoSubmitSVN) {
            SvnUtil.submitSvn(fileXwl.getName(), file, 2);
        }
    }

    public static void openFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        IDE.doOpen(new JSONArray(request.getParameter("fileNames")), request.getParameter("charset"), request.getParameter("type"), request, response);
    }

    private static void doOpen(JSONArray fileNames, String charset, String type, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONArray result = new JSONArray();
        JSONObject content = new JSONObject();
        boolean fromEditor = "1".equals(type);
        int j = fileNames.length();
        int i = 0;
        while (i < j) {
            String filename = fileNames.getString(i);
            String shortFilename = FileUtil.getFilename(filename);
            String fileExt = FileUtil.getFileExt(filename).toLowerCase();
            IDE.limitDemoUser(request, null);
            if (!fromEditor && fileExt.equals("xwl")) {
                content = IdeUtils.getFileCacheXwl((String)filename);
                IDE.fillProperties(content);
                result.put((Object)content);
            } else {
                String fileText;
                File file = new File(filename);
                content = new JSONObject();
                content.put("file", (Object)shortFilename);
                content.put("icon", (Object)("m?xwl=dev/ide/get-file-icon&file=" + WebUtil.encode(filename)));
                if (StringUtil.indexOf(imageTypes, fileExt) == -1) {
                    if (StringUtil.isEmpty(charset)) {
                        charset = FileUtil.isAncestor(Base.path, file) ? "utf-8" : Var.getString("sys.locale.charset");
                    } else if ("[\u7cfb\u7edf\u9ed8\u8ba4]".equals(charset)) {
                        charset = null;
                    }
                    if (StringUtil.isEmpty(charset)) {
                        fileText = FileUtils.readFileToString((File)file);
                        content.put("charset", (Object)"[\u7cfb\u7edf\u9ed8\u8ba4]");
                    } else {
                        fileText = FileUtils.readFileToString((File)file, (String)charset);
                        content.put("charset", (Object)charset);
                    }
                } else {
                    fileText = StringUtil.encodeBase64(new FileInputStream(file));
                }
                content.put("content", (Object)fileText);
                content.put("lastModified", (Object)DateUtil.getTimestamp(file.lastModified()));
                content.put("path", (Object)filename);
                result.put((Object)content);
            }
            ++i;
        }
        WebUtil.send(response, (Object)result);
    }

    public static void getOutputs(HttpServletRequest request, HttpServletResponse response) throws Exception {
        QueueWriter out = IDE.getSysOut(request);
        String string = out.toString();
        out.clear();
        WebUtil.send(response, (Object)string);
    }

    private static void fillProperties(JSONObject json) throws IOException {
        JSONArray controls = json.getJSONArray("children");
        int j = controls.length();
        int i = 0;
        while (i < j) {
            JSONObject control = controls.getJSONObject(i);
            String type = control.getString("type");
            JSONObject fillControl = Controls.get(type);
            if (fillControl == null) {
                throw new NullPointerException("\u63a7\u4ef6 \"" + type + "\" \u6ca1\u6709\u627e\u5230\u3002");
            }
            JSONObject configs = control.optJSONObject("configs");
            if (configs != null) {
                control.put("text", (Object)configs.optString("itemId"));
            }
            JSONObject fillGeneral = fillControl.getJSONObject("general");
            control.put("iconCls", (Object)fillGeneral.getString("iconCls"));
            if (control.has("children") && control.length() > 0) {
                IDE.fillProperties(control);
            }
            ++i;
        }
    }

    public static void getFileIcon(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String fileName = WebUtil.decode(request.getParameter("file"));
        String fileExt = FileUtil.getFileExt(fileName).toLowerCase();
        String[] zipTypes = new String[]{"zip", "rar", "gzip", "gz", "tar", "cab"};
        File file = null;
        if (StringUtil.indexOf(imageTypes, fileExt) != -1) {
            file = new File(fileName);
            IDE.limitDemoUser(request, file);
            long fileLen = file.length();
            if (fileLen > 10240L || fileLen == 0L) {
                file = null;
            }
        }
        if (file == null) {
            fileName = fileExt.equals("doc") || fileExt.equals("docx") ? "file_doc" : (fileExt.equals("xls") || fileExt.equals("xlsx") ? "file_xls" : (fileExt.equals("ppt") || fileExt.equals("pptx") ? "file_ppt" : (fileExt.equals("htm") || fileExt.equals("html") ? "web" : (fileExt.equals("jar") || fileExt.equals("war") ? "file_jar" : (StringUtil.indexOf(zipTypes, fileExt) != -1 ? "file_zip" : (fileExt.equals("txt") ? "file_txt" : (fileExt.equals("js") ? "file_js" : (fileExt.equals("css") ? "file_css" : (fileExt.equals("java") ? "file_java" : (fileExt.equals("jsp") ? "file_jsp" : (fileExt.equals("XWL") ? "file_xwl" : (fileExt.equals("xwl") ? "file_xwl" : "file_default"))))))))))));
            file = new File(Base.path, StringUtil.concat("wb/images/", String.valueOf(fileName) + ".png"));
            response.setContentType("image/png");
        } else {
            response.setContentType("image/" + fileExt);
        }
        try (FileInputStream is = new FileInputStream(file);){
            IOUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
        }
        response.flushBuffer();
    }

    public static void deleteFiles(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONArray files = new JSONArray(request.getParameter("files"));
        for (Object fileString : files) {
            Service.containAdmin(fileString.toString(), null);
            if (!BwIDE.isModeuleFile((String)fileString.toString())) {
                FileUtil.syncDelete(new File(fileString.toString()), true);
                continue;
            }
            BwIDE.delete(fileString, (String)"admin");
        }
        UrlBuffer.deleteFileUrl(request.getParameter("files"));
        UrlBuffer.save();
    }

    public static void setData(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String name = request.getParameter("name");
        String value = request.getParameter("value");
        String sessionName = request.getParameter("sessionName");
        Value.set(request, name, value);
        if (sessionName != null) {
            WebUtil.setSessionValue(request, sessionName, value);
        }
    }

    public static void moveFiles(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String isCopyStr = request.getParameter("isCopy");
        boolean fromPaste = !StringUtil.isEmpty(isCopyStr);
        boolean isCopy = "true".equals(isCopyStr);
        boolean confirm = !Boolean.parseBoolean(request.getParameter("noConfirm"));
        JSONArray src = new JSONArray(request.getParameter("src"));
        JSONArray moveTo = null;
        File dstFile = new File(request.getParameter("dst"));
        File folder = null;
        String dropPosition = request.getParameter("dropPosition");
        String overwriteFilename = null;
        int j = src.length();
        int overwriteCount = 0;
        folder = dropPosition.equals("append") ? dstFile : dstFile.getParentFile();
        if (folder == null) {
            throw new Exception("\u65e0\u6cd5\u590d\u5236\u5230\u6b64\u76ee\u5f55\u3002");
        }
        int i = 0;
        while (i < j) {
            if (src.getString(i).isEmpty()) {
                throw new IllegalArgumentException("\u590d\u5236\u6e90\u542b\u65e0\u6548\u76ee\u5f55\u3002");
            }
            File srcFile = new File(src.getString(i));
            Service.containAdmin(src.getString(i), null);
            String filename = srcFile.getName();
            File newDstFile = new File(folder, filename);
            if (BwIDE.getContainModulesCounts((File)dstFile) == 1 && folder.getAbsolutePath().endsWith("wb" + File.separator + "modules") && filename.endsWith(".xwl")) {
                throw new IllegalArgumentException("\u6839\u76ee\u5f55\u4e0d\u5141\u8bb8\u5b58\u653e\u4efb\u4f55xwl\u6587\u4ef6\uff1a" + filename);
            }
            if (FileUtil.isAncestor(srcFile, newDstFile, false)) {
                throw new IllegalArgumentException("\u4e0a\u7ea7\u76ee\u5f55 \"" + filename + "\" \u4e0d\u80fd\u590d\u5236\u5230\u4e0b\u7ea7\u76ee\u5f55\u3002");
            }
            if (BwIDE.getContainModulesCounts((File)folder) >= 1) {
                if (isCopy && BwIDE.isExistInBuffer((File)folder, (File)srcFile)) {
                    throw new IllegalArgumentException("\"" + filename + "\" \u5df2\u7ecf\u5b58\u5728\u3002");
                }
                if (!isCopy && !srcFile.getParentFile().getAbsolutePath().equals(folder.getAbsolutePath()) && BwIDE.isExistInBuffer((File)folder, (File)srcFile)) {
                    throw new IllegalArgumentException("\"" + filename + "\" \u5df2\u7ecf\u5b58\u5728\u3002");
                }
            } else {
                File tempFile = new File(String.valueOf(folder.getAbsolutePath()) + File.separator + filename);
                if (!srcFile.getParentFile().getAbsolutePath().equals(folder.getAbsolutePath()) && tempFile.exists()) {
                    throw new IllegalArgumentException("\"" + filename + "\" \u5df2\u7ecf\u5b58\u5728\u3002");
                }
            }
            ++i;
        }
        if (overwriteCount > 0) {
            SysUtil.error("\"" + overwriteFilename + "\"" + (overwriteCount > 1 ? " \u7b49 " + overwriteCount + " \u9879" : " ") + "\u5df2\u7ecf\u5b58\u5728\uff0c\u786e\u5b9a\u8981\u8986\u76d6\u5417\uff1f", "101");
        }
        JSONArray srcNames = new JSONArray();
        JSONObject resp = new JSONObject();
        if (fromPaste && isCopy) {
            moveTo = BwIDE.getContainModulesCounts((File)folder) >= 1 ? BwIDE.doCopyFiles((JSONArray)src, (File)folder, (String)"admin") : IDE.copyFiles(src, folder, !isCopy);
            j = moveTo.length();
            i = j - 1;
            while (i >= 0) {
                Object[] moveInfo = (Object[])moveTo.get(i);
                if (!((Boolean)moveInfo[1]).booleanValue()) {
                    srcNames.put((Object)FileUtil.getFilename((String)moveInfo[0]));
                }
                --i;
            }
        } else {
            i = j - 1;
            while (i >= 0) {
                srcNames.put((Object)FileUtil.getFilename(src.getString(i)));
                if (folder.equals(new File(src.getString(i)).getParentFile())) {
                    src.remove(i);
                }
                --i;
            }
            if (BwIDE.getContainModulesCounts((File)folder) >= 1) {
                moveTo = BwIDE.doMoveFiles((JSONArray)src, (File)folder, (String)"admin");
            } else {
                moveTo = IDE.doMoveFiles(src, folder);
                Object[] result = IDE.changePath(src, moveTo);
                resp.put("files", result[0]);
                resp.put("change", result[1]);
            }
        }
        String srcPath = request.getParameter("src");
        UrlBuffer.moveFileUrl(srcPath, folder.getAbsolutePath());
        UrlBuffer.save();
        resp.put("moveTo", (Object)moveTo);
        WebUtil.send(response, (Object)resp);
        if ("module".equals(request.getParameter("type"))) {
            BwIDE.setFileIndex((File)folder, (String)dstFile.getName(), (JSONArray)srcNames, (String)dropPosition, (String)"admin");
        }
    }

    private static Object[] changePath(JSONArray source, JSONArray dest) throws Exception {
        JSONArray rows = new JSONArray();
        ArrayList<Object[]> changes = new ArrayList<Object[]>();
        boolean changed = false;
        int j = source.length();
        int i = 0;
        while (i < j) {
            File srcFile = new File(source.getString(i));
            Object value = dest.opt(i);
            File dstFile = value instanceof String ? new File((String)value) : new File((String)((Object[])value)[0]);
            boolean isDir = dstFile.isDirectory();
            if (FileUtil.isAncestor(Base.modulePath, srcFile) && FileUtil.isAncestor(Base.modulePath, dstFile) && (isDir || srcFile.getName().endsWith(".xwl") && dstFile.getName().endsWith(".xwl"))) {
                String dstPath;
                String srcPath = FileUtil.getModulePath(srcFile);
                if (UrlBuffer.change(srcPath, dstPath = FileUtil.getModulePath(dstFile), isDir)) {
                    changed = true;
                }
                if (!isDir) {
                    srcPath = srcPath.substring(0, srcPath.length() - 4);
                    dstPath = dstPath.substring(0, dstPath.length() - 4);
                }
                Object[] change = new Object[2];
                if (isDir) {
                    change[0] = Pattern.compile("\\bxwl=" + srcPath + "\\b/");
                    change[1] = "xwl=" + dstPath + "/";
                } else {
                    change[0] = Pattern.compile("(\\bxwl=" + srcPath + "\\b)(?![/\\-\\.])");
                    change[1] = "xwl=" + dstPath;
                }
                changes.add(change);
            }
            ++i;
        }
        if (changed) {
            UrlBuffer.save();
        }
        IDE.doChangePath(Base.modulePath, changes, rows);
        IDE.doChangePath(new File(Base.path, "wb/script"), changes, rows);
        Object[] result = new Object[]{rows, changes};
        return result;
    }

    private static void doChangePath(File folder, ArrayList<Object[]> changes, JSONArray rows) throws Exception {
        File[] files;
        File[] fileArray = files = FileUtil.listFiles(folder);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                IDE.doChangePath(file, changes, rows);
            } else {
                String fileExt = FileUtil.getFileExt(file.getName()).toLowerCase();
                if (fileExt.equals("xwl") || fileExt.equals("js")) {
                    String text;
                    String replacedText = text = FileUtil.readString(file);
                    for (Object[] change : changes) {
                        replacedText = ((Pattern)change[0]).matcher(replacedText).replaceAll(Matcher.quoteReplacement((String)change[1]));
                    }
                    if (!replacedText.equals(text)) {
                        FileUtil.syncSave(file, replacedText);
                        JSONObject row = new JSONObject();
                        row.put("path", (Object)FileUtil.getPath(file));
                        row.put("lastModified", (Object)DateUtil.getTimestamp(file.lastModified()));
                        rows.put((Object)row);
                    }
                }
            }
            ++n2;
        }
    }

    private static JSONArray copyFiles(JSONArray src, File dstFolder, boolean deleteOld) throws Exception {
        int j = src.length();
        JSONArray newNames = new JSONArray();
        int i = 0;
        while (i < j) {
            File file = new File(src.getString(i));
            Object[] object = FileUtil.syncCopy(file, dstFolder);
            if (deleteOld) {
                FileUtil.syncDelete(file, false);
            }
            newNames.put((Object)object);
            ++i;
        }
        return newNames;
    }

    private static JSONArray doMoveFiles(JSONArray src, File dstFile) throws Exception {
        int j = src.length();
        JSONArray result = new JSONArray();
        int i = 0;
        while (i < j) {
            File file = new File(src.getString(i));
            FileUtil.syncMove(file, dstFile);
            Object[] object = new Object[]{FileUtil.getPath(new File(dstFile, file.getName())), false};
            result.put((Object)object);
            ++i;
        }
        return result;
    }

    public static void initIDE(HttpServletRequest request, HttpServletResponse response) {
        JSONObject config = new JSONObject();
        config.put("fileTitle", Var.get("sys.ide.fileTitle"));
        request.setAttribute("initParams", (Object)StringUtil.text(config.toString()));
    }

    private static QueueWriter getSysOut(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        QueueWriter out = (QueueWriter)session.getAttribute("sysx.out");
        if (out == null) {
            out = new QueueWriter(Var.getInt("sys.ide.consoleBufferSize"));
            session.setAttribute("sysx.out", (Object)out);
        }
        return out;
    }

    public static ArrayList<String> getIconList() {
        File iconPath = new File(Base.path, "wb/images");
        File[] files = FileUtil.listFiles(iconPath);
        ArrayList<String> list = new ArrayList<String>();
        SortUtil.sort(files);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.isDirectory()) {
                list.add(String.valueOf(FileUtil.removeExtension(file.getName())) + "_icon");
            }
            ++n2;
        }
        return list;
    }

    public static void compressScriptFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean compressAll = Boolean.parseBoolean(request.getParameter("compressAll"));
        IDE.makeFile(request, Base.path, compressAll);
    }

    private static void limitDemoUser(HttpServletRequest request, File path) throws IOException {
        File base;
        if (WebUtil.hasRole(request, "admin") || !WebUtil.hasRole(request, "demo")) {
            return;
        }
        String sysFolderBase = Var.getString("sys.ide.sysFolderBase");
        if (path == null && !"root".equals(sysFolderBase)) {
            SysUtil.accessDenied(request);
        }
        if ("server".equals(sysFolderBase)) {
            base = Base.path.getParentFile().getParentFile();
        } else if ("app".equals(sysFolderBase)) {
            FileUtil.checkProctected(request, path, false);
            base = Base.path;
        } else {
            base = null;
        }
        if (base != null && !FileUtil.isAncestor(base, path)) {
            SysUtil.accessDenied(request);
        }
    }

    public static void searchDuplicateFiles(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        String lastValue = null;
        JSONArray rows = new JSONArray();
        JSONObject lastRow = null;
        JSONObject lastAddRow = null;
        IDE.getFileMd5(Base.modulePath, map);
        ArrayList<Map.Entry<String, String>> sortedList = SortUtil.sortValue(map);
        for (Map.Entry<String, String> entry : sortedList) {
            String key = entry.getKey();
            String value = entry.getValue();
            JSONObject row = new JSONObject();
            row.put("content", (Object)FileUtil.getFilename(key));
            row.put("path", (Object)key);
            row.put("line", 1);
            row.put("ch", 1);
            row.put("nodePath", (Object)"/module");
            row.put("itemName", (Object)"Configs=itemId");
            if (value.equals(lastValue)) {
                if (lastAddRow != lastRow) {
                    rows.put((Object)lastRow);
                }
                rows.put((Object)row);
                lastAddRow = row;
            }
            lastValue = value;
            lastRow = row;
        }
        WebUtil.send(response, (Object)new JSONObject().put("rows", (Object)rows));
    }

    public static void getFileMd5(File folder, HashMap<String, String> map) throws Exception {
        CacheServiceAware roleCache = (CacheServiceAware)SpringContextUtil.getBean((String)"sysCacheServcie");
        FunctionContentCacheAware contentService = (FunctionContentCacheAware)SpringContextUtil.getBean((String)"contentCacheServcie");
        Map functions = roleCache.getFuncMap();
        Set funcIdSet = functions.keySet();
        for (Long funcId : funcIdSet) {
            FunctionEObj function = (FunctionEObj)functions.get(funcId);
            map.put(function.getFuncPath(), Encrypter.getMD5(contentService.getContent(funcId).toString().getBytes("UTF-8")));
        }
    }

    public static void checkFilePerm(File path) throws IOException {
        File base;
        String sysFolderBase = Var.getString("sys.ide.sysFolderBase");
        if ("server".equals(sysFolderBase)) {
            base = Base.path.getParentFile().getParentFile();
        } else if ("app".equals(sysFolderBase)) {
            if (FileUtil.isAncestor(new File(Base.path, "wb/system"), path) || FileUtil.isAncestor(new File(Base.path, "META-INF"), path) || FileUtil.isAncestor(new File(Base.path, "WEB-INF"), path)) {
                SysUtil.accessDenied();
            }
            base = Base.path;
        } else {
            base = null;
        }
        if (!(base == null || path != null && FileUtil.isAncestor(base, path))) {
            SysUtil.accessDenied();
        }
    }

    public static void makeFile(HttpServletRequest request, File folder, boolean compressAll) throws IOException {
        File[] files;
        File[] fileArray = files = FileUtil.listFiles(folder);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                IDE.makeFile(request, file, compressAll);
            } else {
                String name = file.getName();
                String ext = FileUtil.getFileExt(name).toLowerCase();
                if ((ext.equals("js") || ext.equals("css")) && (name = FileUtil.removeExtension(name)).endsWith("-debug")) {
                    File newFile = new File(file.getParent(), String.valueOf(name.substring(0, name.length() - 6)) + "." + ext);
                    if (compressAll || file.lastModified() != newFile.lastModified()) {
                        Console.log(request, "Compressing " + file.toString());
                        if (ext.equals("js")) {
                            ScriptCompressor.compressJs(file, newFile, false);
                        } else {
                            ScriptCompressor.compressCss(file, newFile);
                        }
                        newFile.setLastModified(file.lastModified());
                        File syncFile = FileUtil.getSyncPath(newFile);
                        if (syncFile != null) {
                            FileUtils.copyFile((File)newFile, (File)syncFile);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    public static JSONObject getMenuChildMenuOrFunction(String path, String sub) throws Exception {
        CacheServiceAware service = (CacheServiceAware)SpringContextUtil.getBean((String)"sysCacheServcie");
        JSONObject object = new JSONObject();
        JSONArray array = new JSONArray();
        if (sub == null) {
            MenuEObj menu = service.getMenu(path);
            if (menu == null) {
                return object;
            }
            List menus = service.getChildMenus(menu.getMenuId());
            int i = 0;
            while (i < menus.size()) {
                JSONObject json = new JSONObject();
                MenuEObj tempMenu = (MenuEObj)menus.get(i);
                json.put("name", (Object)tempMenu.getMenuName());
                json.put("title", (Object)(tempMenu.getMenuTitle() == null ? tempMenu.getMenuName() : tempMenu.getMenuTitle()));
                array.add(i, (Object)json);
                ++i;
            }
        } else {
            List<FunctionEObj> funcLs = null;
            if (sub.indexOf("m?xwl=") != -1) {
                String[] urlArray;
                funcLs = new ArrayList();
                String[] stringArray = urlArray = StringUtil.split(sub, ";");
                int tempMenu = urlArray.length;
                int json = 0;
                while (json < tempMenu) {
                    FunctionEObj function;
                    String url = stringArray[json];
                    if (url.length() > 6 && (function = service.getFunctionByPath(String.valueOf(url.substring(6)) + ".xwl")) != null) {
                        funcLs.add(function);
                    }
                    ++json;
                }
            } else {
                String menuPath = "".equals(sub) ? path : String.valueOf(path) + "/" + sub;
                MenuEObj menu = service.getMenu(menuPath);
                if (menu == null) {
                    return object;
                }
                funcLs = service.getMenuChildFunction(menu.getMenuId());
            }
            int i = 0;
            while (i < funcLs.size()) {
                FunctionEObj function = (FunctionEObj)funcLs.get(i);
                JSONObject json = new JSONObject();
                JSONObject configs = new JSONObject();
                String name = FileUtil.removeExtension(function.getShortPath());
                String funcPath = function.getNoCacheFuncPath().substring(0, function.getNoCacheFuncPath().indexOf(".xwl"));
                String tempPath = "".equals(sub) ? funcPath : (sub.indexOf("m?xwl=") != -1 ? "m?xwl=" + funcPath : "m?xwl=" + sub + "/" + name);
                configs.put("text", (Object)(function.getFuncName() == null ? name : function.getFuncName()));
                configs.put("itemId", (Object)(String.valueOf(name) + "_item"));
                configs.put("iconCls", (Object)(function.getFuncIcon() == null ? "item_icon" : function.getFuncIcon()));
                configs.put("tagConfigs", (Object)("{bindFile:" + StringUtil.quote(tempPath) + "}"));
                json.put("children", (Object)new JSONArray());
                json.put("configs", (Object)configs);
                json.put("expanded", false);
                json.put("type", (Object)"item");
                array.add(i, (Object)json);
                ++i;
            }
        }
        object.put("children", (Object)array);
        return object;
    }

    public static String queryHelpMenuFunctionTree(HttpServletRequest request, String func_path, String menuId) throws KException {
        FunctionEObj func;
        MenuEObj menu;
        CacheServiceAware roleCache = (CacheServiceAware)SpringContextUtil.getBean((String)"sysCacheServcie");
        UserRoleServiceAware userRoleService = (UserRoleServiceAware)SpringContextUtil.getBean((String)"userRoleService");
        String userId = (String)request.getSession().getAttribute("sys.user");
        String lan = (String)request.getSession().getAttribute("sys.lang");
        List roles = userRoleService.getRolesByUserId(userId);
        HashMap rootMenuWapper = new HashMap();
        HashSet set = new HashSet();
        for (String role : roles) {
            List funcs = roleCache.getRoleFunctions(role);
            if (funcs == null || funcs.size() <= 0) continue;
            set.addAll(funcs);
        }
        if (menuId != null || func_path == null && menuId == null) {
            List<Map<String, Object>> helpsList = IDE.queryHelpFileAll();
            for (Map<String, Object> map : helpsList) {
                for (FunctionEObj func2 : set) {
                    if (func2 == null) continue;
                    if (map.get("FUNC_PATH").equals(func2.getFuncPath())) {
                        func2.setFuncDesc((String)map.get("FILE_NAME"));
                        func2.setLastUpdateUser((String)map.get("LAST_UPDATE_USER"));
                    } else {
                        func2.setFuncDesc("");
                        func2.setLastUpdateUser("");
                    }
                    MenuEObj menu2 = null;
                    menu2 = menuId != null ? roleCache.getMenuById(Long.valueOf(menuId)) : roleCache.getMenuById(func2.getMenuId());
                    if (menu2 == null || !"1".equals(menu2.getMenuStatus())) continue;
                    roleCache.buildMenuFunction(menu2, rootMenuWapper, func2);
                }
            }
        } else if (func_path != null && (menu = roleCache.getMenuById((func = roleCache.getFunctionByPath(func_path)).getMenuId())) != null && "1".equals(menu.getMenuStatus())) {
            roleCache.buildMenuFunction(menu, rootMenuWapper, func);
        }
        return FormatUtils.newFormate(rootMenuWapper.values().iterator(), (String)lan);
    }

    public static void uploadHelpFile(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String update_sql = "UPDATE T_HELP_FILE_CONTENT SET CONTENT=?,FILE_NAME=?,FILE_SIZE=?,FILE_TYPE=?,LAST_UPDATE_USER=?,LAST_UPDATE_TMS=? WHERE FUNC_PATH=?";
        String insert_sql = "INSERT INTO T_HELP_FILE_CONTENT(CONTENT,FILE_NAME,FILE_SIZE,FILE_TYPE,LAST_UPDATE_USER,LAST_UPDATE_TMS,FUNC_PATH) VALUES(?,?,?,?,?,?,?)";
        String func_path = (String)request.getAttribute("func_path");
        Map<String, Object> map = IDE.queryHelpFileByFuncPath(func_path);
        if (map != null && map.size() > 0) {
            IDE.insertOrUpdateHelpFile(func_path, request, update_sql);
        } else {
            IDE.insertOrUpdateHelpFile(func_path, request, insert_sql);
        }
    }

    public static void insertOrUpdateHelpFile(String func_path, HttpServletRequest request, String sql) throws IOException {
        String flag = "xwl";
        String userId = (String)request.getSession().getAttribute("sys.user");
        SqlExecutor sqlExecutor = (SqlExecutor)SpringContextUtil.getBean((String)"sqlExecutor");
        String file_name = (String)request.getAttribute("file_name");
        String file_type = (String)request.getAttribute("file_type");
        InputStream inStream = null;
        byte[] file_content = null;
        Long file_size = null;
        if (!flag.equals(file_type)) {
            inStream = (InputStream)request.getAttribute("file1");
            file_content = IDE.input2byte(inStream);
            file_size = Long.valueOf((String)request.getAttribute("file_size"));
        }
        Timestamp update_time = new Timestamp(System.currentTimeMillis());
        Object[] obj = new Object[]{file_content, file_name, file_size, file_type, userId, update_time, func_path};
        sqlExecutor.update(sql, obj);
    }

    public static Map<String, Object> queryHelpFileByFuncPath(String func_path) {
        String query_sql = "SELECT FUNC_PATH,CONTENT,FILE_NAME,FILE_TYPE,LAST_UPDATE_USER FROM T_HELP_FILE_CONTENT WHERE FUNC_PATH=?";
        Object[] obj = new Object[]{func_path};
        SqlExecutor sqlExecutor = (SqlExecutor)SpringContextUtil.getBean((String)"sqlExecutor");
        Map queryMap = sqlExecutor.queryMap(query_sql, obj);
        return queryMap;
    }

    public static List<Map<String, Object>> queryHelpFileAll() {
        String query_sql = "SELECT FUNC_PATH,CONTENT,FILE_NAME,FILE_TYPE,LAST_UPDATE_USER FROM T_HELP_FILE_CONTENT";
        SqlExecutor sqlExecutor = (SqlExecutor)SpringContextUtil.getBean((String)"sqlExecutor");
        List queryListMap = sqlExecutor.queryMapList(query_sql, null);
        return queryListMap;
    }

    public static final byte[] input2byte(InputStream inStream) throws IOException {
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buff = new byte[100];
        int rc = 0;
        while ((rc = inStream.read(buff, 0, 100)) > 0) {
            swapStream.write(buff, 0, rc);
        }
        byte[] in2b = swapStream.toByteArray();
        return in2b;
    }
}

