/*
 * Decompiled with CFR 0.152.
 */
package com.wb.interact;

import com.wb.fit.CustomResponse;
import com.wb.interact.CustomCsvExport;
import com.wb.interact.CustomGridExport;
import com.wb.tool.DataOutput;
import com.wb.tool.ExcelObject;
import com.wb.util.FileUtil;
import com.wb.util.StringUtil;
import com.wb.util.WebUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class FilePush {
    public static void getFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String filename = WebUtil.fetch(request, "filename");
        String data = WebUtil.fetch(request, "data");
        boolean gzip = Boolean.parseBoolean(WebUtil.fetch(request, "gzip"));
        if (filename == null) {
            filename = gzip ? "data.gz" : "data";
        }
        response.setHeader("content-type", "application/force-download");
        response.setHeader("content-disposition", "attachment;" + WebUtil.encodeFilename(request, filename));
        if (gzip) {
            try (GZIPOutputStream gos = new GZIPOutputStream((OutputStream)response.getOutputStream());){
                gos.write(data.getBytes("utf-8"));
            }
            response.flushBuffer();
        } else {
            WebUtil.send(response, (Object)data);
        }
    }

    public static void getText(HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebUtil.send(response, (Object)request.getParameter("text"));
    }

    public static void getExcel(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String ext = ExcelObject.getExtName();
        String filename = WebUtil.fetch(request, "filename");
        String title = WebUtil.fetch(request, "title");
        filename = StringUtil.isEmpty(filename) ? "data" + ext : String.valueOf(filename) + ext;
        response.setHeader("content-type", "application/force-download");
        response.setHeader("content-disposition", "attachment;" + WebUtil.encodeFilename(request, filename));
        DataOutput.outputExcelForReq(request, (OutputStream)response.getOutputStream(), new JSONArray(WebUtil.fetch(request, "headers")), new JSONArray(WebUtil.fetch(request, "rows")), StringUtil.isEmpty(title) ? null : title, new JSONObject("{mergeInfo:[]}"), StringUtil.select(WebUtil.fetch(request, "dateFormat"), "Y-m-d"), StringUtil.select(WebUtil.fetch(request, "timeFormat"), "H:i:s"), false);
        response.flushBuffer();
    }

    public static void writeFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String filename = WebUtil.fetch(request, "filename");
        String data = WebUtil.fetch(request, "data");
        boolean gzip = Boolean.parseBoolean(WebUtil.fetch(request, "gzip"));
        File file = new File(filename);
        if (file.exists()) {
            throw new Exception("\u6587\u4ef6 \u201c" + filename + "\u201d \u5df2\u7ecf\u5b58\u5728\u3002");
        }
        if (gzip) {
            FileOutputStream fos = null;
            GZIPOutputStream gos = null;
            try {
                fos = new FileOutputStream(file);
                gos = new GZIPOutputStream(fos);
                gos.write(data.getBytes("utf-8"));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(gos);
                fos.close();
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)gos);
            fos.close();
        } else {
            FileUtil.writeString(file, data);
        }
    }

    public static void transfer(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONArray records;
        String fileExtName;
        JSONObject metaParams = new JSONObject(request.getParameter("__metaParams"));
        boolean isHtml = false;
        boolean isZip = "true".equals(WebUtil.fetch(request, "isZip"));
        String type = metaParams.optString("type");
        if ("excel".equals(type)) {
            fileExtName = ExcelObject.getExtName();
        } else if ("text".equals(type)) {
            fileExtName = ".txt";
        } else if ("dbf".equals(type)) {
            fileExtName = ".dbf";
        } else if ("html".equals(type)) {
            fileExtName = ".html";
            isHtml = true;
        } else if ("pdf".equals(type)) {
            fileExtName = ".pdf";
        } else if ("csv".equals(type)) {
            fileExtName = ".csv";
        } else {
            throw new IllegalArgumentException("Invalid request file type.");
        }
        String data = metaParams.optString("data", null);
        if (data == null) {
            if ("excel".equals(type)) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("reportInfo", metaParams.optJSONObject("reportInfo"));
                map.put("title", metaParams.optString("title", null));
                map.put("headers", metaParams.optJSONArray("headers"));
                map.put("neptune", metaParams.optBoolean("neptune"));
                map.put("response", response);
                CustomGridExport.varMap.put(request.toString(), map);
                request.setAttribute("isExportGrid", (Object)"true");
                CustomResponse resp = new CustomResponse(response);
                request.setAttribute("sys.rowOnly", (Object)1);
                request.setAttribute("sys.fromExport", (Object)1);
                WebUtil.include(request, (HttpServletResponse)resp, metaParams.optString("url"));
                return;
            }
            if ("csv".equals(type)) {
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                map.put("response", response);
                map.put("headers", metaParams.optJSONArray("headers"));
                map.put("dateFormat", metaParams.optString("dateFormat"));
                map.put("timeFormat", metaParams.optString("timeFormat"));
                map.put("decimalSeparator", metaParams.optString("decimalSeparator"));
                map.put("thousandSeparator", metaParams.optString("thousandSeparator"));
                CustomCsvExport.varMap.put(request.toString(), map);
                request.setAttribute("isExportAllCsv", (Object)"true");
                CustomResponse resp = new CustomResponse(response);
                request.setAttribute("sys.rowOnly", (Object)1);
                request.setAttribute("sys.fromExport", (Object)1);
                WebUtil.include(request, (HttpServletResponse)resp, metaParams.optString("url"));
                return;
            }
            CustomResponse resp = new CustomResponse(response);
            request.setAttribute("sys.rowOnly", (Object)1);
            request.setAttribute("sys.fromExport", (Object)1);
            WebUtil.include(request, (HttpServletResponse)resp, metaParams.optString("url"));
            String respText = FilePush.getResponseString(resp);
            if (respText.startsWith("<textarea>")) {
                data = respText.substring(10, respText.length() - 11);
                JSONObject responseObject = new JSONObject(data);
                data = (String)responseObject.opt("value");
                if (!responseObject.optBoolean("success")) {
                    WebUtil.send(response, data, false);
                    return;
                }
            } else {
                if (!(respText = respText.trim()).startsWith("{") || !respText.endsWith("}")) {
                    WebUtil.send(response, respText, false);
                    return;
                }
                data = respText;
            }
            records = new JSONObject(data).getJSONArray("rows");
        } else {
            records = new JSONArray(data);
        }
        JSONArray headers = metaParams.optJSONArray("headers");
        JSONArray fields = metaParams.optJSONArray("fields");
        String title = metaParams.optString("title", null);
        JSONObject reportInfo = metaParams.optJSONObject("reportInfo");
        String dateFormat = metaParams.optString("dateFormat");
        String timeFormat = metaParams.optString("timeFormat");
        boolean neptune = metaParams.optBoolean("neptune");
        String decimalSeparator = metaParams.optString("decimalSeparator");
        String thousandSeparator = metaParams.optString("thousandSeparator");
        String filename = metaParams.optString("filename");
        String rowStyle = metaParams.optString("rowStyle");
        if (StringUtil.isEmpty(filename)) {
            filename = "data";
        }
        filename = isZip ? String.valueOf(filename) + ".zip" : String.valueOf(filename) + fileExtName;
        if (!isHtml) {
            response.setHeader("content-type", "application/force-download");
            response.setHeader("content-disposition", "attachment;" + WebUtil.encodeFilename(request, filename));
        }
        if ("excel".equals(type)) {
            DataOutput.outputExcel(request, response, headers, records, title, reportInfo, dateFormat, timeFormat, neptune, "true".equals(WebUtil.fetch(request, "isAjax")), isZip, fileExtName, WebUtil.fetch(request, "mergeScript"), rowStyle, false);
        } else if ("text".equals(type)) {
            DataOutput.outputTextForReq(request, (OutputStream)response.getOutputStream(), headers, records, dateFormat, timeFormat, decimalSeparator, thousandSeparator, false);
        } else if ("csv".equals(type)) {
            byte[] uft8bom = new byte[]{-17, -69, -65};
            response.getOutputStream().write(uft8bom);
            DataOutput.outputTextForReq(request, (OutputStream)response.getOutputStream(), headers, records, dateFormat, timeFormat, decimalSeparator, thousandSeparator, true);
        } else if ("dbf".equals(type)) {
            DataOutput.outputDBF((OutputStream)response.getOutputStream(), fields, records);
        } else if ("pdf".equals(type)) {
            DataOutput.outputExcel(request, response, headers, records, title, reportInfo, dateFormat, timeFormat, neptune, "true".equals(WebUtil.fetch(request, "isAjax")), isZip, fileExtName, WebUtil.fetch(request, "mergeScript"), rowStyle, true);
        } else {
            DataOutput.outputHtmlForReq(request, (OutputStream)response.getOutputStream(), headers, records, title, dateFormat, timeFormat, neptune, metaParams.getInt("rowNumberWidth"), metaParams.optString("rowNumberTitle"), decimalSeparator, thousandSeparator);
        }
        response.flushBuffer();
    }

    private static String getResponseString(CustomResponse response) throws Exception {
        String result;
        byte[] data = response.getBytes();
        if (data.length > 2 && data[0] == 31 && data[1] == -117) {
            try (GZIPInputStream is = new GZIPInputStream(new ByteArrayInputStream(data));){
                result = StringUtil.getString(is);
            }
        } else {
            result = new String(data, "utf-8");
        }
        return result;
    }
}

