/*
 * Decompiled with CFR 0.152.
 */
package com.wb.common;

import com.wb.common.Var;
import com.wb.tool.HttpSessionConfig;
import com.wb.util.SysUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ServerEndpoint(value="/webSocketEcharts", configurator=HttpSessionConfig.class)
public class WebSocketEcharts {
    private static HashMap<String, HttpSession> httpSessionMap = new HashMap();
    private static HashMap<String, List<Session>> webSocketSessionMap = new HashMap();
    static Log log = LogFactory.getLog(WebSocketEcharts.class);

    @OnOpen
    public void onOpen(Session session, EndpointConfig conf) {
        block6: {
            try {
                HttpSession httpSession = (HttpSession)conf.getUserProperties().get("WbHttpSession");
                String httpSessionId = httpSession.getId();
                httpSessionMap.put(httpSessionId, httpSession);
                if (webSocketSessionMap.containsKey(httpSessionId)) {
                    webSocketSessionMap.get(httpSessionId).add(session);
                    log.debug((Object)"httpSessionId");
                } else {
                    ArrayList<Session> webSocketListTemp = new ArrayList<Session>();
                    webSocketListTemp.add(session);
                    webSocketSessionMap.put(httpSessionId, webSocketListTemp);
                }
            }
            catch (Throwable e) {
                try {
                    session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CANNOT_ACCEPT, SysUtil.getRootError(e)));
                }
                catch (Throwable ex) {
                    log.error((Object)"", ex);
                }
                if (!Var.showSocketError) break block6;
                this.showException(session, e);
            }
        }
    }

    @OnMessage
    public static void onMessage(String message, Session session) throws Throwable {
        for (Map.Entry<String, List<Session>> entry : webSocketSessionMap.entrySet()) {
            for (Session wsSession : entry.getValue()) {
                wsSession.getBasicRemote().sendText(message);
                log.info((Object)("message:" + message));
            }
        }
    }

    @OnClose
    public void onClose(Session session, CloseReason reason) {
        String webSocketSessionId = session.getId();
        for (Map.Entry<String, List<Session>> entry : webSocketSessionMap.entrySet()) {
            if (!entry.getValue().contains(session)) continue;
            String httpSessionId = entry.getKey();
            List<Session> tempList = webSocketSessionMap.get(httpSessionId);
            int i = 0;
            while (i < tempList.size()) {
                if (webSocketSessionId.equals(tempList.get(i).getId())) {
                    webSocketSessionMap.get(httpSessionId).remove(i);
                }
                ++i;
            }
            if (webSocketSessionMap.get(httpSessionId) != null) continue;
            httpSessionMap.remove(httpSessionId);
            webSocketSessionMap.remove(httpSessionId);
        }
    }

    @OnError
    public void onError(Session session, Throwable error) {
        if (Var.showSocketError) {
            this.showException(session, error);
        }
    }

    private void showException(Session session, Throwable exception) {
        StringWriter writer = new StringWriter();
        PrintWriter pwriter = new PrintWriter((Writer)writer, true);
        exception.printStackTrace(pwriter);
        pwriter.close();
        String errorMessage = writer.toString();
        try {
            session.getBasicRemote().sendText(errorMessage);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }
}

