/*
 * Decompiled with CFR 0.152.
 */
package com.wb.common;

import cn.hutool.core.util.StrUtil;
import com.wb.common.ProductTagOperator;
import com.wb.common.SysConfigOperator;
import com.wb.util.JsonUtil;
import com.wb.util.StringUtil;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class Var {
    public static boolean uncheckModified;
    public static boolean sendStreamGzip;
    public static int sendGzipMinSize;
    public static boolean printError;
    public static boolean log;
    public static boolean taskLog;
    public static int limitRecords;
    public static int limitExportRecords;
    public static int gzipMinSize;
    public static boolean cacheEnabled;
    public static int cacheMaxAge;
    public static boolean debug;
    public static boolean showSocketError;
    public static boolean serverConsolePrint;
    public static boolean sqlDebug;
    public static boolean saveState;
    public static boolean homeShowApp;
    public static boolean consolePrint;
    public static boolean batchUpdate;
    public static int sessionTimeout;
    public static boolean uniqueLogin;
    public static boolean useDouble;
    public static int ajaxTimeout;
    public static int maskTimeout;
    public static boolean useLocalTime;
    public static boolean recordSession;
    public static int stringAsText;
    public static String syncPath;
    public static String jndi;
    public static String language;
    public static String defaultLanguage;
    public static String urlEncoding;
    public static String sessionVars;
    public static boolean forceUpperCase;
    public static String emptyString;
    public static int fetchSize;
    public static File file;
    public static ConcurrentHashMap<String, Object> buffer;
    public static String defaultRole;
    public static String priority;
    public static boolean preTradeDate;
    public static String allowType;
    public static String notAllowType;
    public static boolean limitPassword;
    public static int limitCount;
    public static boolean validateUserNameRule;
    public static boolean keyPassword;
    public static boolean limitIP;
    public static boolean limitMAC;
    public static boolean ldapLogin;
    public static String ldapServerPath;
    public static String ldapHost;
    public static boolean setFirstLogin;
    public static boolean passwordExpired;
    public static int setReviseDate;
    public static String sessionShareName;
    public static String defaultTheme;
    public static String home;
    public static String[] homes;
    public static boolean styleTheme;
    public static boolean filterDataPermission;
    public static String wolfDataConn;
    private static String CONFIG_TYPE;
    public static Set<String> jndiNames;

    static {
        file = Var.getFile();
        homes = new String[0];
        CONFIG_TYPE = "var";
    }

    public static File getFile() {
        return null;
    }

    public static Object get(String name) {
        if (StringUtil.isEmpty(name)) {
            throw new NullPointerException("Var name \"" + name + "\" can not be blank");
        }
        if ("sys.app.productTag".equals(name)) {
            return ProductTagOperator.readProductTag();
        }
        Object val = buffer.get(name);
        if (val == null) {
            throw new NullPointerException("Var \"" + name + "\" does not exist");
        }
        return val;
    }

    public static String getString(String name) {
        return Var.get(name).toString();
    }

    public static int getInt(String name) {
        Object val = Var.get(name);
        if (val instanceof Integer) {
            return (Integer)val;
        }
        throw new RuntimeException("Var \"" + name + "\" is not an integer value");
    }

    public static double getDouble(String name) {
        Object val = Var.get(name);
        if (val instanceof Double) {
            return (Double)val;
        }
        throw new RuntimeException("Var \"" + name + "\" is not a double value");
    }

    public static boolean getBool(String name) {
        Object val = Var.get(name);
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        throw new RuntimeException("Var \"" + name + "\" is not a boolean value");
    }

    public static Object get(String name, Object defValue) {
        if (StringUtil.isEmpty(name)) {
            throw new NullPointerException("Var name \"" + name + "\" can not be blank");
        }
        if (buffer.containsKey(name)) {
            return buffer.get(name);
        }
        return defValue;
    }

    public static String getString(String name, String defValue) {
        return Var.get(name, defValue).toString();
    }

    public static int getInt(String name, int defValue) {
        Object val = Var.get(name, defValue);
        if (val instanceof Integer) {
            return (Integer)val;
        }
        throw new RuntimeException("Var \"" + name + "\" is not an integer value");
    }

    public static double getDouble(String name, double defValue) {
        Object val = Var.get(name, defValue);
        if (val instanceof Double) {
            return (Double)val;
        }
        throw new RuntimeException("Var \"" + name + "\" is not a double value");
    }

    public static boolean getBool(String name, boolean defValue) {
        Object val = Var.get(name, defValue);
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        throw new RuntimeException("Var \"" + name + "\" is not a boolean value");
    }

    public static synchronized void add(String name, String key, Object value) {
        if (name == null) {
            throw new NullPointerException("Null variable name");
        }
        if (value == null) {
            throw new NullPointerException("Null variable value");
        }
        try {
            JSONObject object = Var.readVarConfig();
            Object valObject = JsonUtil.getValue(object, name, '.');
            if (valObject instanceof JSONObject) {
                JSONObject valJson = (JSONObject)valObject;
                valJson.put(key, value);
            } else if (valObject instanceof JSONArray) {
                JSONArray valArr = (JSONArray)valObject;
                valArr.put(value);
            } else {
                throw new RuntimeException("\"" + name + "\" is not a variable.");
            }
            Var.writeVarConfig(object.toString());
            Var.load();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized boolean nameIsExist(String name) {
        if (name == null) {
            throw new NullPointerException("Null variable name");
        }
        if (buffer == null) {
            return false;
        }
        return buffer.containsKey(name);
    }

    public static synchronized void set(String name, Object value) {
        if (name == null) {
            throw new NullPointerException("Null variable name");
        }
        if (value == null) {
            throw new NullPointerException("Null variable value");
        }
        try {
            JSONObject object = Var.readVarConfig();
            Object valObject = JsonUtil.getValue(object, name, '.');
            if (!(valObject instanceof JSONArray)) {
                throw new RuntimeException("\"" + name + "\" is not a variable.");
            }
            JSONArray valArray = (JSONArray)valObject;
            valArray.put(0, value);
            Var.writeVarConfig(object.toString());
            buffer.put(name, value);
            Var.loadBasicVars();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized void load() {
        try {
            Var.checkTableExist();
            JSONObject object = Var.readVarConfig();
            ConcurrentHashMap<String, Object> tempBuffer = new ConcurrentHashMap<String, Object>();
            Var.getValues(tempBuffer, object, "");
            buffer = tempBuffer;
            Var.loadBasicVars();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized void load(File file) {
        try {
            if (buffer == null) {
                Var.checkTableExist();
                JSONObject object = Var.readVarConfig();
                ConcurrentHashMap<String, Object> tempBuffer = new ConcurrentHashMap<String, Object>();
                Var.getValues(tempBuffer, object, "");
                buffer = tempBuffer;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static void getValues(ConcurrentHashMap<String, Object> tempBuffer, JSONObject object, String parentName) {
        Set items = object.entrySet();
        for (Map.Entry item : items) {
            Object value = item.getValue();
            String name = String.valueOf(parentName) + (String)item.getKey();
            if (value instanceof JSONObject) {
                Var.getValues(tempBuffer, (JSONObject)value, String.valueOf(name) + '.');
                continue;
            }
            JSONArray jsonArray = (JSONArray)value;
            if ("double".equals(jsonArray.getJSONObject(2).opt("type"))) {
                tempBuffer.put(name, ((Number)jsonArray.opt(0)).doubleValue());
                continue;
            }
            tempBuffer.put(name, jsonArray.opt(0));
        }
    }

    private static Set<String> getJndiNames() {
        JSONObject var = Var.readVarConfig();
        JSONObject jndiList = (JSONObject)JsonUtil.getValue(var, "sys.jndi", '.');
        return jndiList.keySet();
    }

    private static void checkTableExist() {
        SysConfigOperator.checkTableExist();
    }

    public static JSONObject readVarConfig() {
        return SysConfigOperator.readConfig(CONFIG_TYPE);
    }

    public static void writeVarConfig(String varContent) {
        SysConfigOperator.writeConfig(CONFIG_TYPE, varContent);
    }

    public static void refreshCache() {
        JSONObject object = Var.readVarConfig();
        ConcurrentHashMap<String, Object> tempBuffer = new ConcurrentHashMap<String, Object>();
        Var.getValues(tempBuffer, object, "");
        buffer = tempBuffer;
        Var.loadBasicVars();
    }

    public static void loadBasicVars() {
        uncheckModified = !Var.getBool("sys.cache.checkModified");
        sendStreamGzip = Var.getBool("sys.sendStreamGzip");
        sendGzipMinSize = Var.getInt("sys.sendGzipMinSize");
        printError = Var.getBool("sys.printError");
        showSocketError = Var.getBool("sys.network.showSocketError");
        log = Var.getBool("sys.log");
        taskLog = Var.getBool("sys.task.log");
        limitRecords = Var.getInt("sys.controls.limitRecords");
        limitExportRecords = Var.getInt("sys.controls.limitExportRecords");
        gzipMinSize = Var.getInt("sys.cache.gzipMinSize");
        cacheEnabled = Var.getBool("sys.cache.enabled");
        cacheMaxAge = Var.getInt("sys.cache.maxAge");
        debug = Var.getBool("sys.debug");
        homeShowApp = Var.getBool("sys.app.homeShowApp");
        consolePrint = Var.getBool("sys.ide.consolePrint");
        batchUpdate = Var.getBool("sys.db.batchUpdate");
        sessionTimeout = Var.getInt("sys.session.sessionTimeout");
        uniqueLogin = Var.getBool("sys.session.uniqueLogin");
        useDouble = Var.getBool("sys.db.useDouble");
        ajaxTimeout = Var.getInt("sys.session.ajaxTimeout");
        maskTimeout = Var.getInt("sys.session.maskTimeout");
        useLocalTime = Var.getBool("sys.locale.useLocalTime");
        recordSession = Var.getBool("sys.session.recordSession");
        stringAsText = Var.getInt("sys.db.stringAsText");
        syncPath = Var.getString("sys.ide.syncPath");
        saveState = Var.getBool("sys.controls.saveState");
        jndi = Var.getString("sys.jndi.default");
        language = Var.getString("sys.locale.language");
        defaultLanguage = Var.getString("sys.locale.defaultLanguage");
        urlEncoding = Var.getString("sys.locale.urlEncoding");
        sessionVars = Var.getString("sys.session.sessionVars");
        forceUpperCase = Var.getBool("sys.db.forceUpperCase");
        emptyString = Var.getString("sys.db.emptyString");
        fetchSize = Var.getInt("sys.db.fetchSize");
        defaultRole = Var.getString("sys.session.defaultRole");
        priority = Var.getString("sys.mail.priority");
        preTradeDate = Var.getBool("sys.db.preTradeDate");
        allowType = Var.getString("sys.service.upload.allowType");
        notAllowType = Var.getString("sys.service.upload.notAllowType");
        sqlDebug = Var.getBool("sys.sqlDebug");
        serverConsolePrint = Var.getBool("sys.serverConsolePrint");
        limitPassword = Var.getBool("sys.session.limitPassword");
        limitCount = Var.getInt("sys.session.limitCount");
        validateUserNameRule = Var.getBool("sys.session.validateUserNameRule");
        keyPassword = Var.getBool("sys.session.keyPassword");
        limitIP = Var.getBool("sys.network.limitIP");
        limitMAC = Var.getBool("sys.network.limitMAC");
        ldapLogin = Var.getBool("sys.ldap.login");
        ldapServerPath = Var.getString("sys.ldap.serverPath");
        ldapHost = Var.getString("sys.ldap.host");
        setFirstLogin = Var.getBool("sys.session.setFirstLogin");
        setReviseDate = Var.getInt("sys.session.setReviseDate");
        passwordExpired = Var.getBool("sys.session.passwordExpired");
        sessionShareName = Var.getString("sys.session.shareName");
        defaultTheme = Var.getString("sys.app.theme");
        home = Var.getString("sys.home");
        homes = StrUtil.split((CharSequence)Var.getString("sys.homes"), (CharSequence)",");
        styleTheme = Var.getBool("sys.controls.styleTheme");
        filterDataPermission = Var.getBool("sys.controls.filterDataPermission");
        wolfDataConn = Var.getString("sys.jndiName.wolfDataConn");
        jndiNames = Var.getJndiNames();
    }
}

