/*
 * Decompiled with CFR 0.152.
 */
package com.wb.common;

import com.wb.common.SysConfigDbOperator;
import com.wb.common.SysConfigOperator;
import com.wb.common.UrlBuffer;
import com.wb.common.Var;
import com.wb.interact.Controls;
import java.sql.Timestamp;
import ks.fintech.framework.core.exception.KRuntimeException;
import ks.fintech.framework.threadpool.DefaultThreadPool;

public class SysConfigDbSyn {
    private static long SYN_TIME = 2000L;

    public static void startSyn() {
        int type = SysConfigOperator.getDataSource();
        SysConfigDbSyn.waitVarLoad(type);
        if (type == 1) {
            SysConfigDbOperator.initSynData();
            RefreshTask task = new RefreshTask();
            DefaultThreadPool.getThreadPoolTaskExecutor().execute((Runnable)task);
        }
    }

    private static void waitVarLoad(int type) {
        while (type == 0) {
            try {
                Thread.sleep(SYN_TIME);
            }
            catch (InterruptedException e) {
                throw new KRuntimeException((Throwable)e);
            }
        }
    }

    private static class RefreshTask
    extends Thread {
        public RefreshTask() {
            super("RefreshCacheTask");
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(SYN_TIME);
                }
                catch (InterruptedException e) {
                    throw new KRuntimeException((Throwable)e);
                }
                this.refresh();
            }
        }

        private void refresh() {
            Timestamp lastChange = SysConfigDbOperator.getLastChangeTime();
            Timestamp cacheChange = SysConfigDbOperator.cacheUpdateTime;
            if (lastChange.getTime() > cacheChange.getTime()) {
                Var.refreshCache();
                UrlBuffer.refreshCache();
                Controls.refreshCache();
                SysConfigDbOperator.cacheUpdateTime = lastChange;
            }
        }
    }
}

