/*
 * Decompiled with CFR 0.152.
 */
package com.wb.common;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.wb.common.LDAPConfigure;
import com.wb.common.LoginMode;
import com.wb.common.ResourceUtils;
import com.wb.common.SSOLoginError;
import com.wb.common.SimpleListener;
import com.wb.common.Str;
import com.wb.common.UserCheckUtil;
import com.wb.common.UserList;
import com.wb.common.Var;
import com.wb.splogic.util.RunSqlLogic;
import com.wb.tool.CheckV7Md5psw;
import com.wb.tool.Encrypter;
import com.wb.tool.GlobeStorage;
import com.wb.tool.UserReg;
import com.wb.util.DbUtil;
import com.wb.util.LogUtil;
import com.wb.util.RSAUtils;
import com.wb.util.StringUtil;
import com.wb.util.SystemKit;
import com.wb.util.WebUtil;
import java.security.interfaces.RSAPrivateKey;
import java.sql.Date;
import java.sql.ResultSet;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import ks.fintech.framework.utils.DateUtils;
import ks.fintech.framework.utils.SpringContextUtil;
import ks.fintech.user.api.DeptService;
import ks.fintech.user.api.LoginCallBack;
import ks.fintech.user.api.UserService;
import ks.fintech.user.eobj.DeptEObj;
import ks.fintech.user.eobj.UserEObj;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;

public class Session {
    private static Log log = LogFactory.getLog(Session.class);
    private static boolean loginCallBackFlag = false;

    public static void verifySSO(HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("sso", (Object)"1");
        Session.createSession(request, response);
    }

    public static void verify(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String referer = StringUtil.opt(request.getHeader("Referer"));
        String redirect = request.getParameter("redirect");
        HttpSession session = request.getSession(false);
        request.setAttribute("sso", (Object)"0");
        if (Var.getBool("sys.session.verifyImage.enabled")) {
            if (session == null) {
                throw new Exception(Str.format(request, "vcExpired"));
            }
            String verifyCode = (String)session.getAttribute("sys.verifyCode");
            session.removeAttribute("sys.verifyCode");
            if (StringUtil.isEmpty(verifyCode) || !StringUtil.isSame(verifyCode, request.getParameter("verifyCode"))) {
                throw new Exception(Str.format(request, "vcInvalid"));
            }
        }
        if (session != null) {
            try {
                session.invalidate();
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        Session.createSession(request, response);
        if (referer.endsWith("/login") || referer.endsWith("m?xwl=sys/session/login")) {
            referer = Var.getString("sys.home");
        }
        if (referer.endsWith("/tlogin") || referer.endsWith("m?xwl=sys/session/tlogin")) {
            referer = Var.getString("sys.homeMobile");
        }
        if (StringUtil.isEmpty(redirect)) {
            if (referer.endsWith("index")) {
                int index = referer.lastIndexOf("index");
                referer = referer.substring(0, index);
            }
            WebUtil.send(response, (Object)referer);
        } else {
            response.sendRedirect(redirect);
        }
    }

    public static void logout(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
            session.getServletContext().removeAttribute("ck_session");
        }
    }

    public static String[] getRoles(HttpServletRequest request) throws Exception {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        return (String[])session.getAttribute("sys.roles");
    }

    private static void createSession(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String ret;
        Object[] obj;
        String sql;
        String deptCode = "";
        String branchNo = "";
        String password = "";
        boolean sso = WebUtil.exists(request, "sso");
        String username = sso ? (String)request.getAttribute("username") : request.getParameter("username");
        if (Var.validateUserNameRule && !UserReg.validateUserName(username)) {
            LogUtil.error("\u5c1d\u8bd5\u767b\u5f55\u7684\u7528\u6237\u540d\uff1a" + username + "\u975e\u6cd5");
            throw new IllegalArgumentException("\u5c1d\u8bd5\u767b\u5f55\u7684\u7528\u6237\u540d\uff1a" + username + "\u975e\u6cd5");
        }
        String userIP = SystemKit.getClientIP(request);
        String ssoStr = (String)request.getAttribute("sso");
        if ("0".equals(ssoStr) && Var.keyPassword) {
            HashMap<String, Object> keyMap = GlobeStorage.globeStorage.get(userIP);
            if (keyMap == null) {
                keyMap = RSAUtils.getKeys();
            }
            RSAPrivateKey privateKey = (RSAPrivateKey)keyMap.get("private");
            password = RSAUtils.decryptByPrivateKey(request.getParameter("password"), privateKey);
        } else {
            password = request.getParameter("password");
        }
        UserService userService = (UserService)SpringContextUtil.getBean((String)"userService");
        UserEObj user = userService.findUser(username);
        if (user == null) {
            LogUtil.log(username, userIP, 3, Str.format(request, "userNotExist", username));
            log.error((Object)("\u7528\u6237\u4e0d\u5b58\u5728: " + username));
            if (!sso) {
                throw new IllegalArgumentException(Str.format(request, "loginError", username));
            }
            SSOLoginError.getError(request, response, username);
            return;
        }
        boolean ldapFlag = false;
        if (!"admin".equals(username) && Var.ldapLogin) {
            if (Var.getBool("sys.ldap.separateLogin")) {
                if ("1".equals(user.getUserType())) {
                    ldapFlag = LDAPConfigure.doLdapLogin(username, password);
                }
            } else {
                ldapFlag = LDAPConfigure.doLdapLogin(username, password);
            }
        }
        int errorTimes = user.getErrorTimes();
        int limitCount = Var.limitCount;
        if (Var.limitPassword) {
            java.util.Date lastVisitDate = user.getLastVisitDate();
            long currentDate = System.currentTimeMillis();
            long lastDate = lastVisitDate == null ? currentDate : lastVisitDate.getTime();
            long diff = (currentDate - lastDate) / 3600000L;
            if (user.getStatus() == 3 && errorTimes >= limitCount && diff <= 24L) {
                throw new IllegalArgumentException(Str.format(request, "\u60a8\u7684\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a," + (24L - diff) + "\u5c0f\u65f6\u540e\u518d\u5c1d\u8bd5\u767b\u5f55"));
            }
        }
        if (Var.limitIP && !Session.accessIP(user.getAccessIp(), userIP)) {
            LogUtil.log(username, userIP, 3, Str.format(request, "accessIP"));
            throw new IllegalArgumentException(Str.format(request, "accessIP"));
        }
        String userMAC = null;
        if (Var.limitMAC) {
            userMAC = SystemKit.getMacAddress(userIP);
            if (!Session.accessMAC(user.getAccessMac(), userMAC)) {
                throw new IllegalArgumentException(Str.format(request, "accessMAC"));
            }
        }
        if (!ldapFlag && !sso) {
            String inputMd5Psw = Encrypter.getMD5(user.getUserId(), password);
            boolean pwdError = !user.getPassword().equals(inputMd5Psw);
            if (pwdError = CheckV7Md5psw.convertMd5(pwdError, request, userIP, user, password)) {
                log.error((Object)("input psw:" + inputMd5Psw + " userName" + user.getUserName()));
                if (Var.limitPassword) {
                    if (errorTimes >= limitCount) {
                        String sql2 = "update WB_USER set ERROR_TIMES=1,LAST_VISIT_DATE=?,STATUS=1 where USER_NAME=? and STATUS=3";
                        Object[] obj2 = new Object[]{DateUtils.getNowTimestamp(), username};
                        RunSqlLogic.update(sql2, obj2);
                        LogUtil.log(username, userIP, 3, "\u5bc6\u7801\u9519\u8bef,\u60a8\u8fd8\u6709" + (limitCount - 1) + "\u6b21\u767b\u9646\u673a\u4f1a");
                        throw new IllegalArgumentException(String.valueOf(Str.format(request, "loginError", username)) + ",\u60a8\u8fd8\u6709" + (limitCount - 1) + "\u6b21\u767b\u9646\u673a\u4f1a");
                    }
                    if (++errorTimes == limitCount) {
                        String sql3 = "update WB_USER set ERROR_TIMES=?,LAST_VISIT_DATE=?,STATUS=3 where USER_NAME=? and STATUS=1";
                        Object[] obj3 = new Object[]{errorTimes, DateUtils.getNowTimestamp(), username};
                        RunSqlLogic.update(sql3, obj3);
                        LogUtil.log(username, userIP, 3, "\u60a8\u5df2\u8fde\u7eed\u8f93\u9519\u5bc6\u78015\u6b21\uff0c24\u5c0f\u65f6\u5185\u7981\u6b62\u767b\u9646");
                        throw new IllegalArgumentException("\u60a8\u5df2\u8fde\u7eed\u8f93\u9519\u5bc6\u7801" + limitCount + "\u6b21\uff0c24\u5c0f\u65f6\u5185\u7981\u6b62\u767b\u9646");
                    }
                    String sql4 = "update WB_USER set ERROR_TIMES=?,LAST_VISIT_DATE=? where USER_NAME=? and STATUS=1";
                    Object[] obj4 = new Object[]{errorTimes, DateUtils.getNowTimestamp(), username};
                    RunSqlLogic.update(sql4, obj4);
                    LogUtil.log(username, userIP, 3, "\u5bc6\u7801\u9519\u8bef,\u60a8\u8fd8\u6709" + (limitCount - errorTimes) + "\u6b21\u767b\u9646\u673a\u4f1a");
                    throw new IllegalArgumentException(String.valueOf(Str.format(request, "loginError", username)) + ",\u60a8\u8fd8\u6709" + (limitCount - errorTimes) + "\u6b21\u767b\u9646\u673a\u4f1a");
                }
                LogUtil.log(username, userIP, 3, "\u767b\u5f55\u5bc6\u7801\u9519\u8bef");
                throw new IllegalArgumentException(Str.format(request, "loginError"));
            }
        }
        if (StrUtil.isNotBlank((CharSequence)user.getDeptId())) {
            DeptService deptService = (DeptService)SpringContextUtil.getBean((String)"deptService");
            DeptEObj dept = deptService.findDept(user.getDeptId());
            if (dept == null) {
                LogUtil.log(username, userIP, 3, "\u7528\u6237\u6240\u5728\u90e8\u95e8\u4e0d\u5b58\u5728");
            } else {
                deptCode = dept.getDeptCode();
                branchNo = dept.getBranchNo();
            }
        }
        HttpSession session = request.getSession(true);
        session.setAttribute("sys.logined", (Object)true);
        session.setAttribute("sys.theme", (Object)Var.defaultTheme);
        int timeout = Var.sessionTimeout;
        if (timeout == -1) {
            timeout = Integer.MAX_VALUE;
        }
        if (timeout > 0) {
            session.setMaxInactiveInterval(timeout);
        }
        String userId = user.getUserId();
        session.setAttribute("sys.user", (Object)userId);
        session.setAttribute("sys.username", (Object)user.getUserName());
        session.setAttribute("sys.dispname", (Object)user.getDisplayName());
        session.setAttribute("sys.orgNum", (Object)user.getDeptId());
        session.setAttribute("sys.deptCode", (Object)deptCode);
        session.setAttribute("sys.branchNo", (Object)branchNo);
        session.setAttribute("sys.isFirstLogin", (Object)user.getLoginTimes());
        session.setAttribute("sys.dbDate", (Object)new Date(System.currentTimeMillis()));
        session.setAttribute("sysx.userAgent", (Object)StringUtil.substring(request.getHeader("user-agent"), 0, 500));
        session.setAttribute("sys.ip", (Object)userIP);
        session.setAttribute("sys.mac", (Object)userMAC);
        session.setAttribute("sys.lang", (Object)StringUtil.select(user.getUseLang(), "auto"));
        if (Var.limitPassword) {
            sql = "update WB_USER set ERROR_TIMES=0,LAST_VISIT_DATE=?,LOGIN_TIMES=LOGIN_TIMES+1 where USER_ID=?";
            obj = new Object[]{DateUtils.getNowTimestamp(), session.getAttribute("sys.user")};
            RunSqlLogic.update(sql, obj);
        } else {
            sql = "update WB_USER set LAST_VISIT_DATE=?,LOGIN_TIMES=LOGIN_TIMES+1 where USER_ID=?";
            obj = new Object[]{DateUtils.getNowTimestamp(), session.getAttribute("sys.user")};
            RunSqlLogic.update(sql, obj);
        }
        Session.storeUserValues(request, session, userId);
        SimpleListener simpleListener = new SimpleListener();
        if (Var.uniqueLogin) {
            String[] userIds = new String[]{userId};
            UserList.invalidate(userIds);
        }
        LoginMode.setLoginMode(session, sso, ldapFlag);
        ResourceUtils.setResourcePers(session, user.getUserId(), user.getUserName());
        session.setAttribute("sysx.simpleListener", (Object)simpleListener);
        String createDate = DateUtils.format((java.util.Date)user.getCreateDate(), (String)"yyyy-MM-dd HH:mm:ss");
        String updateDate = user.getUpdateDate() != null ? DateUtils.format((java.util.Date)user.getUpdateDate(), (String)"yyyy-MM-dd HH:mm:ss") : null;
        Session.storePwdState(session, createDate, updateDate, ldapFlag, sso);
        if (!ldapFlag && !sso && (ret = UserCheckUtil.checkPswRule(password)) != null) {
            session.setAttribute("sys.pwdState", (Object)-1);
            session.setAttribute("sys.pwdUpdReson", (Object)ret);
        }
        Session.LoginSuccessCallBack(username, password);
    }

    private static void LoginSuccessCallBack(String username, String password) {
        try {
            loginCallBackFlag = Var.getBool("sys.session.loginCallBackFlag");
        }
        catch (Exception e) {
            log.error((Object)"\u83b7\u53d6sys.session.loginCallBackFlag\u53d8\u91cf\u5f02\u5e38", (Throwable)e);
        }
        if (loginCallBackFlag) {
            try {
                LoginCallBack loginCallBack = Session.getLoginCallBack();
                if (loginCallBack != null) {
                    loginCallBack.loginSucc(username, password);
                }
            }
            catch (Exception e) {
                log.error((Object)"\u767b\u5f55\u6210\u529f\u540e\u56de\u8c03\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private static LoginCallBack getLoginCallBack() {
        try {
            return (LoginCallBack)SpringContextUtil.getBean((String)"loginCallBack");
        }
        catch (BeansException e) {
            log.error((Object)"loginCallBack is null", (Throwable)e);
            return null;
        }
    }

    private static boolean accessIPandMAC(String accessIP, String accessMAC, String ip, String mac) {
        boolean macflag = false;
        boolean ipflag = false;
        if (StringUtils.isNotBlank((CharSequence)accessIP) && StringUtils.isNotBlank((CharSequence)accessMAC) && StringUtils.isNotBlank((CharSequence)ip) && StringUtils.isNotBlank((CharSequence)mac)) {
            String[] ipArr = accessIP.split(";");
            Object[] macArr = accessMAC.split(";");
            if (Arrays.binarySearch(macArr, mac) != -1) {
                macflag = true;
            }
            String[] stringArray = ipArr;
            int n = ipArr.length;
            int n2 = 0;
            while (n2 < n) {
                String one = stringArray[n2];
                if (one.equals(ip)) {
                    ipflag = true;
                    break;
                }
                if (Session.checkIP(one, ip)) {
                    ipflag = true;
                    break;
                }
                ++n2;
            }
        }
        return macflag && ipflag;
    }

    private static boolean accessIP(String accessIP, String ip) {
        boolean ipflag = false;
        if (StringUtils.isNotBlank((CharSequence)accessIP) && StringUtils.isNotBlank((CharSequence)ip)) {
            String[] ipArr;
            String[] stringArray = ipArr = accessIP.split(";");
            int n = ipArr.length;
            int n2 = 0;
            while (n2 < n) {
                String one = stringArray[n2];
                if (one.equals(ip)) {
                    ipflag = true;
                    break;
                }
                if (Session.checkIP(one, ip)) {
                    ipflag = true;
                    break;
                }
                ++n2;
            }
        } else if (StringUtils.isBlank((CharSequence)accessIP)) {
            ipflag = true;
        }
        return ipflag;
    }

    private static boolean accessMAC(String accessMAC, String mac) {
        boolean macflag = false;
        if (StringUtils.isNotBlank((CharSequence)accessMAC) && StringUtils.isNotBlank((CharSequence)mac)) {
            Object[] macArr = accessMAC.split(";");
            if (Arrays.binarySearch(macArr, mac) != -1) {
                macflag = true;
            }
        } else if (StringUtils.isBlank((CharSequence)accessMAC)) {
            macflag = true;
        }
        return macflag;
    }

    private static boolean checkIP(String one, String ip) {
        if (StringUtils.contains((CharSequence)one, (CharSequence)"*")) {
            String[] oneArr = StringUtils.split((String)one, (String)".");
            String[] ipArr = StringUtils.split((String)ip, (String)".");
            int i = 0;
            while (i < oneArr.length) {
                if (!oneArr[i].equals("*") && !oneArr[i].equals(ipArr[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private static void storePwdState(HttpSession session, String createDate, String updateDate, boolean ldapFlag, boolean sso) {
        if (!ldapFlag & !sso & Var.setFirstLogin) {
            if (StringUtils.isBlank((CharSequence)updateDate)) {
                session.setAttribute("sys.pwdState", (Object)Session.getFirstLoginInfo(Var.setFirstLogin));
            }
        } else if (!ldapFlag & !sso & Var.passwordExpired) {
            if (Var.setReviseDate > 0) {
                if (StringUtils.isBlank((CharSequence)updateDate)) {
                    session.setAttribute("sys.pwdState", (Object)Session.getPwdDate(createDate, Var.setReviseDate));
                } else {
                    session.setAttribute("sys.pwdState", (Object)Session.getPwdDate(updateDate, Var.setReviseDate));
                }
            }
        } else {
            session.setAttribute("sys.pwdState", (Object)0);
        }
        ServletContext context = session.getServletContext();
        context.setAttribute(Var.sessionShareName, (Object)session);
    }

    private static Integer getFirstLoginInfo(boolean setFirstLogin) {
        if (setFirstLogin) {
            return -1;
        }
        return 0;
    }

    private static Integer getPwdDate(String dataTime, int day) {
        LocalDateTime today = LocalDateTime.now();
        DateTimeFormatter f = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime date = LocalDateTime.parse(dataTime, f);
        long c = today.getLong(ChronoField.EPOCH_DAY) - date.getLong(ChronoField.EPOCH_DAY);
        if (c > (long)day) {
            return -1;
        }
        return 0;
    }

    private static void storeUserValues(HttpServletRequest request, HttpSession session, String userId) throws Exception {
        Object[] dRoleObj;
        String dRoleSql;
        List<Map<String, Object>> dRolesList;
        String[] names = Var.sessionVars.split(",");
        String[] valueIds = new String[names.length];
        ArrayList<String> roles = new ArrayList<String>();
        ArrayList<String> dRoles = new ArrayList<String>();
        HashSet<String> homeUrl = new HashSet<String>();
        int i = 0;
        String sql = "select r.ROLE_ID,k.HOME_URL,r.user_id, k.role_start_date, k.role_end_date\n     from ks_role k, ks_user_role r\n    where k.role_id = r.role_id\n      and r.ROLE_ID <> 'default'\n      and k.status = 1\n      and r.STATUS = '1'\n      and k.role_start_date<=?\n      and k.role_end_date>=?\n      and r.user_id = ?";
        Object[] obj = new Object[3];
        obj[2] = session.getAttribute("sys.user");
        obj[1] = new Date(System.currentTimeMillis());
        obj[0] = new Date(System.currentTimeMillis());
        List<Map<String, Object>> list = RunSqlLogic.getResultSet(sql, obj);
        if (StringUtils.isNotBlank((CharSequence)Var.defaultRole)) {
            roles.addAll(Arrays.asList(Var.defaultRole.split(",")));
        }
        if (list != null) {
            for (Map<String, Object> map : list) {
                roles.add(map.get("ROLE_ID").toString());
                if (map.get("HOME_URL") == null || !StrUtil.isNotBlank((CharSequence)map.get("HOME_URL").toString())) continue;
                homeUrl.add(map.get("HOME_URL").toString());
            }
        }
        if ((dRolesList = RunSqlLogic.getResultSet(dRoleSql = "select drole_id as DROLE_ID from wolf.ks_user_drole where user_id = ?", dRoleObj = new Object[]{session.getAttribute("sys.user")})) != null) {
            for (Map<String, Object> map : dRolesList) {
                if (map.get("DROLE_ID") == null || !StrUtil.isNotBlank((CharSequence)map.get("DROLE_ID").toString())) continue;
                dRoles.add(map.get("DROLE_ID").toString());
            }
        }
        session.setAttribute("sys.dRoles", dRoles);
        session.setAttribute("sys.roles", (Object)roles.toArray(new String[roles.size()]));
        session.setAttribute("sys.myHome", homeUrl.size() == 0 ? Var.home : CollectionUtil.getFirst(homeUrl));
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            valueIds[i++] = StringUtil.concat("'", name, "@", userId, "'");
            ++n2;
        }
        ResultSet rs = (ResultSet)DbUtil.run(request, "select VAL_ID,VAL_CONTENT from WB_VALUE where VAL_ID in (" + StringUtil.join(valueIds, ',') + ")");
        while (rs.next()) {
            String fieldName = rs.getString("VAL_ID");
            fieldName = StringUtil.substring(fieldName, 0, fieldName.indexOf(64));
            String fieldValue = rs.getString("VAL_CONTENT");
            session.setAttribute("sys." + fieldName, (Object)fieldValue);
        }
    }
}

