/*
 * Decompiled with CFR 0.152.
 */
package com.wb.common;

import com.wb.common.Base;
import com.wb.tool.Route;
import com.wb.util.FileUtil;
import com.wb.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;
import org.quartz.JobExecutionContext;

public class ScriptBuffer {
    private static ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private static ReentrantReadWriteLock.WriteLock writeLock = readWriteLock.writeLock();
    private static ReentrantReadWriteLock.ReadLock readLock = readWriteLock.readLock();
    public static ArrayList<String> globalMembers;
    private static ScriptEngineManager manager;
    private static ScriptEngine engine;
    private static Compilable compilable;
    private static ConcurrentHashMap<String, CompiledScript> buffer;

    public static void run(String id, String scriptText, HttpServletRequest request, HttpServletResponse response, String sourceURL) throws Exception {
        Bindings bindings;
        CompiledScript script;
        try {
            readLock.lock();
            script = buffer.get(id);
            if (script == null) {
                script = compilable.compile(ScriptBuffer.encScript(scriptText, sourceURL, true));
                buffer.put(id, script);
            }
            bindings = engine.createBindings();
            bindings.put("request", (Object)request);
            bindings.put("response", (Object)response);
        }
        finally {
            readLock.unlock();
        }
        script.eval(bindings);
    }

    private static String encScript(String scriptText, String sourceURL, boolean addApp) {
        StringBuilder buf = new StringBuilder(scriptText.length() + 100);
        buf.append("(function main(){");
        if (addApp) {
            buf.append("var app=Wb.getApp(request,response);");
        }
        buf.append(scriptText);
        buf.append("\n})();");
        if (!StringUtil.isEmpty(sourceURL)) {
            buf.append("\n//# sourceURL=");
            buf.append(sourceURL);
        }
        return buf.toString();
    }

    public static void run(String scriptText, HttpServletRequest request, HttpServletResponse response, JSONObject params) throws Exception {
        Bindings bindings;
        CompiledScript script;
        try {
            readLock.lock();
            script = compilable.compile(ScriptBuffer.encScript(scriptText, null, true));
            bindings = engine.createBindings();
            Set es = params.entrySet();
            for (Map.Entry e : es) {
                request.setAttribute((String)e.getKey(), e.getValue());
            }
            bindings.put("request", (Object)request);
            bindings.put("response", (Object)response);
        }
        finally {
            readLock.unlock();
        }
        script.eval(bindings);
    }

    public static Object run(String scriptText, JSONObject params) throws Exception {
        CompiledScript script;
        Bindings bindings = null;
        try {
            readLock.lock();
            script = compilable.compile(ScriptBuffer.encScript(scriptText, null, false));
            if (params != null) {
                bindings = engine.createBindings();
                Set es = params.entrySet();
                for (Map.Entry e : es) {
                    bindings.put((String)e.getKey(), e.getValue());
                }
            }
        }
        finally {
            readLock.unlock();
        }
        if (params == null) {
            return script.eval();
        }
        return script.eval(bindings);
    }

    public static Object run(HttpServletRequest request, HttpServletResponse response, String scriptText, boolean addApp) throws Exception {
        Bindings bindings;
        CompiledScript script;
        try {
            readLock.lock();
            script = compilable.compile(ScriptBuffer.encScript(scriptText, null, addApp));
            bindings = engine.createBindings();
            bindings.put("request", (Object)request);
            bindings.put("response", (Object)response);
        }
        finally {
            readLock.unlock();
        }
        return script.eval(bindings);
    }

    public static boolean evalCondition(String condition, JSONObject params) throws Exception {
        Object value = ScriptBuffer.run(condition, params);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        String str = value.toString();
        return !str.isEmpty();
    }

    public static Object run(String scriptText, String sourceURL) throws Exception {
        CompiledScript script;
        try {
            readLock.lock();
            script = compilable.compile(ScriptBuffer.encScript(scriptText, sourceURL, false));
        }
        finally {
            readLock.unlock();
        }
        return script.eval();
    }

    public static Object run(HttpServletRequest request, String scriptText) throws Exception {
        Bindings bindings;
        CompiledScript script;
        try {
            readLock.lock();
            script = compilable.compile(ScriptBuffer.encScript(scriptText, null, false));
            bindings = engine.createBindings();
            bindings.put("request", (Object)request);
        }
        finally {
            readLock.unlock();
        }
        return script.eval(bindings);
    }

    public static void run(String taskId, String scriptText, JobExecutionContext jobContext) throws Exception {
        Bindings bindings;
        CompiledScript script;
        try {
            readLock.lock();
            script = buffer.get(taskId);
            if (script == null) {
                script = compilable.compile(ScriptBuffer.encScript(scriptText, taskId, false));
                buffer.put(taskId, script);
            }
            bindings = engine.createBindings();
            bindings.put("jobContext", (Object)jobContext);
        }
        finally {
            readLock.unlock();
        }
        script.eval(bindings);
    }

    public static Object run(String scriptId, String scriptText, Route route) throws Exception {
        Bindings bindings;
        CompiledScript script;
        try {
            readLock.lock();
            script = buffer.get(scriptId);
            if (script == null) {
                script = compilable.compile(ScriptBuffer.encScript(scriptText, scriptId, false));
                buffer.put(scriptId, script);
            }
            bindings = engine.createBindings();
            bindings.put("route", (Object)route);
        }
        finally {
            readLock.unlock();
        }
        return script.eval(bindings);
    }

    public static void load() {
        try {
            try {
                writeLock.lock();
                manager = new ScriptEngineManager();
                engine = manager.getEngineByName("javascript");
                compilable = (Compilable)((Object)engine);
                buffer = new ConcurrentHashMap();
                globalMembers = new ArrayList();
                ScriptBuffer.loadUtils();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public static void remove(String id) {
        try {
            readLock.lock();
            Set<Map.Entry<String, CompiledScript>> es = buffer.entrySet();
            for (Map.Entry<String, CompiledScript> e : es) {
                String k = e.getKey();
                if (!k.startsWith(id)) continue;
                buffer.remove(k);
            }
        }
        finally {
            readLock.unlock();
        }
    }

    private static void loadUtils() throws Exception {
        String text = FileUtil.readString(new File(Base.path, "wb/system/server.js"));
        text = String.valueOf(text) + "\n//# sourceURL=server.js";
        CompiledScript script = compilable.compile(text);
        Bindings bindings = engine.createBindings();
        script.eval(bindings);
        Set es = bindings.entrySet();
        for (Map.Entry e : es) {
            String key = (String)e.getKey();
            manager.put((String)e.getKey(), e.getValue());
            globalMembers.add(key);
        }
    }
}

