/*
 * Decompiled with CFR 0.152.
 */
package com.wb.common;

import com.wb.util.DbUtil;
import com.wb.util.WebUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.servlet.http.HttpServletRequest;
import ks.fintech.bw.api.utils.VarUtils;
import org.apache.commons.io.IOUtils;

public class Resource {
    public static String getString(HttpServletRequest request, String id, String defaultValue) {
        return Resource.getString(WebUtil.getIdWithUser(request, id), defaultValue);
    }

    public static String getString(String id, String defaultValue) {
        try {
            byte[] bytes = Resource.getBytes(id, null);
            if (bytes == null) {
                return defaultValue;
            }
            return new String(bytes, "utf-8");
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static String getString(String id) {
        return Resource.getString(id, null);
    }

    public static byte[] getBytes(HttpServletRequest request, String id, byte[] defaultValue) {
        return Resource.getBytes(WebUtil.getIdWithUser(request, id), defaultValue);
    }

    public static byte[] getBytes(String id, byte[] defaultValue) {
        ResultSet rs;
        PreparedStatement st;
        Connection conn;
        block7: {
            byte[] byArray;
            conn = null;
            st = null;
            rs = null;
            long prouctTag = VarUtils.getInstance().getTag();
            try {
                conn = DbUtil.getConnection();
                st = conn.prepareStatement("select RES_CONTENT from WB_RESOURCE where RES_ID=? and PRODUCT_TAG=?");
                st.setString(1, id);
                st.setLong(2, prouctTag);
                rs = st.executeQuery();
                if (!rs.next()) break block7;
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                InputStream is = rs.getBinaryStream(1);
                if (is == null) break block7;
                try {
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                finally {
                    is.close();
                }
                byArray = os.toByteArray();
            }
            catch (Throwable e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(st);
                    DbUtil.close(conn);
                    throw throwable;
                }
            }
            DbUtil.close(rs);
            DbUtil.close(st);
            DbUtil.close(conn);
            return byArray;
        }
        DbUtil.close(rs);
        DbUtil.close(st);
        DbUtil.close(conn);
        return defaultValue;
    }

    public static void set(HttpServletRequest request, String id, String data) {
        Resource.set(WebUtil.getIdWithUser(request, id), data);
    }

    public static void set(String id, String data) {
        try {
            byte[] bytes = data == null ? null : data.getBytes("utf-8");
            Resource.set(id, bytes);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void remove(String id) {
        Resource.set(id, null);
    }

    public static void remove(HttpServletRequest request, String id) {
        Resource.set(request, id, null);
    }

    public static void set(String id, byte[] data) {
        Connection conn = null;
        PreparedStatement st = null;
        boolean hasData = data != null;
        long prouctTag = VarUtils.getInstance().getTag();
        try {
            try {
                conn = DbUtil.getConnection();
                if (hasData) {
                    conn.setAutoCommit(false);
                }
                st = conn.prepareStatement("delete from WB_RESOURCE where RES_ID=? and PRODUCT_TAG=?");
                st.setString(1, id);
                st.setLong(2, prouctTag);
                st.executeUpdate();
                DbUtil.close(st);
                st = null;
                if (hasData) {
                    st = conn.prepareStatement("insert into WB_RESOURCE values(?,?,?)");
                    st.setString(1, id);
                    st.setBinaryStream(2, (InputStream)new ByteArrayInputStream(data), data.length);
                    st.setLong(3, prouctTag);
                    st.executeUpdate();
                    conn.commit();
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(st);
            DbUtil.close(conn);
            throw throwable;
        }
        DbUtil.close(st);
        DbUtil.close(conn);
    }

    public static void set(HttpServletRequest request, String id, byte[] data) {
        Resource.set(WebUtil.getIdWithUser(request, id), data);
    }
}

