/*
 * Decompiled with CFR 0.152.
 */
package com.wb.common;

import com.alibaba.druid.util.StringUtils;
import com.ks.fintech.bw.support.BwIDE;
import com.ks.fintech.bw.support.FunctionUtils;
import com.wb.common.Resource;
import com.wb.common.ScriptBuffer;
import com.wb.common.Session;
import com.wb.common.Str;
import com.wb.common.Var;
import com.wb.common.XwlBuffer;
import com.wb.controls.Control;
import com.wb.controls.ExtControl;
import com.wb.controls.ScriptControl;
import com.wb.interact.Controls;
import com.wb.util.DateUtil;
import com.wb.util.DbUtil;
import com.wb.util.FileUtil;
import com.wb.util.ImportModuleUtil;
import com.wb.util.LogUtil;
import com.wb.util.PropKit;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class Parser {
    private static Log log = LogFactory.getLog(Parser.class);
    private StringBuilder headerHtml = new StringBuilder();
    private ArrayList<String> footerHtml = new ArrayList(15);
    private int htmlPointer;
    private StringBuilder headerScript = new StringBuilder();
    private ArrayList<String> footerScript = new ArrayList(15);
    private int scriptPointer;
    private HttpServletRequest request;
    private HttpServletResponse response;
    public static final int RUN_NORMAL = 0;
    public static final int RUN_MODULE = 1;
    public static final int RUN_CONTROL = 2;
    public static final int RUN_INVOKE = 3;
    public static final int RUN_INNER = 4;
    public static final int RUN_INNER_INVOKE = 5;
    private String funcId = "";
    public static final List dealHolder = Arrays.asList("ks.fintech.bw.impl.filter.PresistanceVisitorTraceFilter", "com.rw.filter.OldPresistanceVisitorTraceFilter");

    public Parser(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public void parse(String moduleFile) throws ServletException {
        this.parse(moduleFile, false, this.request.getParameter("xwlt") != null);
    }

    public void parse(String moduleFile, boolean innerMode, boolean isInvoke) throws ServletException {
        boolean hasExcept = false;
        List<FileItem> fileItemList = null;
        ConcurrentHashMap<String, Object> varMap = null;
        try {
            try {
                varMap = new ConcurrentHashMap<String, Object>();
                this.funcId = StringUtil.toString(FunctionUtils.getFuncByPath((String)moduleFile).getFuncId());
                this.request.setAttribute("sysx.varMap", varMap);
                if (SysUtil.isNotCustomRequest(this.request) && ServletFileUpload.isMultipartContent((HttpServletRequest)this.request)) {
                    fileItemList = WebUtil.setUploadFile(this.request);
                }
                int runMode = innerMode ? (isInvoke ? 5 : 4) : (isInvoke ? 3 : 0);
                this.execute(moduleFile, runMode, null, this.funcId);
            }
            catch (Throwable e) {
                hasExcept = true;
                String username = (String)this.request.getSession().getAttribute("sys.username");
                log.error((Object)("\u7528\u6237\u3010" + username + "\u3011\u5728" + DateUtil.dateToStr(new Date()) + "\u8bf7\u6c42\u6a21\u5757:[" + moduleFile + "]\u53d1\u751f\u9519\u8bef:" + SysUtil.getRootExcept(e)));
                log.error((Object)"", e);
                WebUtil.showException(e, this.request, this.response);
                this.dealException(e);
                Parser.closeObjects(varMap, hasExcept);
                if (fileItemList != null) {
                    WebUtil.clearUploadFile(this.request, fileItemList);
                }
            }
        }
        finally {
            Parser.closeObjects(varMap, hasExcept);
            if (fileItemList != null) {
                WebUtil.clearUploadFile(this.request, fileItemList);
            }
        }
    }

    public void dealException(Throwable e) {
        StackTraceElement[] sts = e.getStackTrace();
        if (sts != null) {
            StackTraceElement[] stackTraceElementArray = sts;
            int n = sts.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement st = stackTraceElementArray[n2];
                String className = st.getClassName();
                if (dealHolder.contains(className)) {
                    throw new RuntimeException(e);
                }
                ++n2;
            }
        }
    }

    public void execute(String moduleFile, int runMode, String xwlId, String parentPath) throws Exception {
        boolean createFrame;
        String tokens;
        boolean runInvoke;
        JSONObject fullModule = XwlBuffer.get(moduleFile, false);
        JSONObject module = (JSONObject)((JSONArray)fullModule.opt("children")).opt(0);
        JSONObject configs = (JSONObject)module.opt("configs");
        boolean runNormal = runMode == 0;
        boolean bl = runInvoke = runMode == 3;
        if ((runNormal || runInvoke) && ((tokens = this.getString(configs, "tokens")).isEmpty() || !this.checkToken(tokens))) {
            String method = this.getString(configs, "method");
            if (!method.isEmpty() && !method.equalsIgnoreCase(this.request.getMethod())) {
                throw new IllegalArgumentException("Method not allowed");
            }
            if (Boolean.TRUE.equals(fullModule.opt("internalCall"))) {
                throw new IllegalArgumentException(Str.format(this.request, "internalCall", StringUtil.select(Str.getText(this.request, fullModule.optString("title")), FileUtil.getFilename(moduleFile)), moduleFile));
            }
            if (BwIDE.isLoginRequired((String)moduleFile) && !WebUtil.checkLogin(this.request, this.response)) {
                return;
            }
            if (!XwlBuffer.canAccess(fullModule, Session.getRoles(this.request), moduleFile)) {
                String expM = " roles:" + Arrays.toString(Session.getRoles(this.request)) + " userId:" + WebUtil.fetch(this.request, "sys.user");
                throw new Exception(String.valueOf(Str.format(this.request, "forbidden", StringUtil.select(fullModule.optString("title"), FileUtil.getFilename(moduleFile)), moduleFile)) + expM);
            }
        }
        JSONObject events = (JSONObject)module.opt("events");
        JSONObject emptyJson = new JSONObject();
        JSONObject moduleGeneral = (JSONObject)Controls.get("module").opt("general");
        String theme = null;
        String touchTheme = null;
        boolean[] libTypes = null;
        boolean exportDBF = Var.getBool("sys.controls.exportDBF");
        boolean hasChildren = module.has("children");
        boolean hasEvents = events != null;
        HttpSession session = null;
        if (runMode == 4) {
            runNormal = true;
        } else if (runMode == 5) {
            runInvoke = true;
        }
        String content = this.getString(configs, "logMessage");
        if (!content.isEmpty()) {
            LogUtil.info(this.request, content);
        }
        if (!(content = this.getString(configs, "initScript")).isEmpty()) {
            ScriptBuffer.run(StringUtil.concat((String)configs.opt("id"), ".is"), content, this.request, this.response, moduleFile);
        }
        if (!(content = this.getString(configs, "serverMethod")).isEmpty()) {
            long startTms = System.currentTimeMillis();
            SysUtil.executeMethod(content, this.request, this.response);
            log.debug((Object)("method:" + content + "cost:" + (System.currentTimeMillis() - startTms)));
        }
        if ((createFrame = this.getBool(configs, "createFrame", true)) && runNormal) {
            this.headerHtml.append("<!DOCTYPE html>\n<html>\n<head>\n<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge,chrome=1\" />\n<meta name=\"renderer\" content=\"webkit\" />\n<meta http-equiv=\"content-type\" content=\"text/html;charset=utf-8\"/>\n<meta name=\"description\" content=\"ckofs\"/>\n<title>");
            String title = this.getString(configs, "title");
            if (title.isEmpty()) {
                title = fullModule.optString("title");
                if (title.startsWith("Str.")) {
                    title = Str.format(this.request, title.substring(4));
                }
            } else if (title.equals("-")) {
                title = null;
            }
            if (!StringUtil.isEmpty(title)) {
                this.headerHtml.append(title);
            }
            this.headerHtml.append("</title>");
            this.appendScript(this.headerHtml, this.getString(configs, "head"));
            session = this.request.getSession(false);
            String string = theme = session == null ? null : (String)session.getAttribute("sys.theme");
            if (theme == null) {
                theme = Var.defaultTheme;
            }
            String string2 = touchTheme = session == null ? null : (String)session.getAttribute("sys.touchTheme");
            if (touchTheme == null) {
                touchTheme = Var.getString("sys.app.touchTheme");
            }
            libTypes = this.setLinks(configs, theme, touchTheme);
            String tagConfigs = this.getString(configs, "tagConfigs");
            this.appendScript(this.headerHtml, this.getString(configs, "headLast"));
            if (tagConfigs.isEmpty()) {
                if ("0".equals(PropKit.getProperty("body.forbid"))) {
                    this.headerHtml.append("\n</head>\n<body>");
                } else {
                    this.headerHtml.append("\n</head>\n<body oncontextmenu='return false' oncopy='document.selection.empty()' onbeforecopy='return false'>");
                }
            } else {
                this.headerHtml.append("\n</head>\n<body ");
                this.headerHtml.append(tagConfigs);
                this.headerHtml.append('>');
            }
            this.headerScript.append("<script language=\"javascript\" type=\"text/javascript\">");
        }
        if (createFrame && runInvoke) {
            this.addLinksScript(configs);
        }
        this.appendScript(this.headerHtml, this.getString(configs, "initHtml"));
        if (createFrame) {
            String namespace;
            if (this.headerScript.length() > 0) {
                this.headerScript.append('\n');
            }
            if (runNormal && libTypes[1] != false) {
                this.headerScript.append("Ext.onReady(function(contextOptions,contextOwner){");
                if (Var.saveState) {
                    this.headerScript.append("\nWb.stateProviderData=");
                    this.headerScript.append(Resource.getString(this.request, "clientState", null));
                    this.headerScript.append(";\nExt.state.Manager.setProvider(Ext.create('Ext.state.WbProvider'));");
                }
            } else if (runNormal && libTypes[2] != false) {
                this.headerScript.append("Ext.setup({");
                if (hasChildren) {
                    this.headerScript.append(this.getTouchViewport((JSONArray)module.opt("children"), moduleGeneral, runNormal));
                }
                this.headerScript.append("onReady:function(contextOptions,contextOwner){");
            } else {
                this.headerScript.append("(function(contextOptions,contextOwner){");
            }
            if ((namespace = (String)configs.opt("itemId")).equals("module")) {
                this.headerScript.append("\nvar app={isXNS:true};");
            } else {
                this.headerScript.append("\nWb.ns(\"");
                this.headerScript.append(namespace);
                this.headerScript.append("\");\nvar app=");
                this.headerScript.append(namespace);
                this.headerScript.append(";\napp.isXNS=true;");
            }
            if (runNormal && libTypes[2] != false) {
                this.headerScript.append("\nthis.appScope=app;\napp[this.itemId]=this;");
            }
            this.headerScript.append("\napp.contextOwner=contextOwner;");
            if (runNormal) {
                this.headerScript.append("\nwindow.app=app;\nWb.init({zo:");
                if (Var.useLocalTime) {
                    Calendar cal = Calendar.getInstance();
                    this.headerScript.append((cal.get(15) + cal.get(16)) / 60000);
                } else {
                    this.headerScript.append("-1");
                }
                this.headerScript.append(",lang:\"");
                this.headerScript.append(Str.getLanguage(this.request));
                this.headerScript.append('\"');
                if (Var.maskTimeout != 1500) {
                    this.headerScript.append(",mask:");
                    this.headerScript.append(Var.maskTimeout);
                }
                if (Var.ajaxTimeout != 0) {
                    this.headerScript.append(",timeout:");
                    this.headerScript.append(Var.ajaxTimeout);
                }
                if (!"gray".equals(theme)) {
                    this.headerScript.append(",theme:\"");
                    this.headerScript.append(theme);
                    this.headerScript.append('\"');
                }
                if (!"classic".equals(touchTheme)) {
                    this.headerScript.append(",touchTheme:\"");
                    this.headerScript.append(touchTheme);
                    this.headerScript.append('\"');
                }
                String string = theme = session == null ? null : (String)session.getAttribute("sys.editTheme");
                if (theme == null) {
                    theme = Var.getString("sys.ide.editTheme");
                }
                if (!"default".equals(theme)) {
                    this.headerScript.append(",editTheme:\"");
                    this.headerScript.append(theme);
                    this.headerScript.append('\"');
                }
                this.headerScript.append(",exportDBF:");
                this.headerScript.append(exportDBF);
                this.headerScript.append("});");
            } else if ((runMode == 2 || runMode == 1) && xwlId != null) {
                this.headerScript.append("\ncontextOwner[");
                this.headerScript.append(StringUtil.quote(xwlId));
                this.headerScript.append("]=app;");
            }
        }
        if (!(content = this.getString(configs, "importModules")).isEmpty()) {
            this.importModules(content, parentPath);
        }
        if (!(content = this.getString(configs, "serverScript")).isEmpty()) {
            ImportModuleUtil.importModule(this.request, this.response);
            ScriptBuffer.run(StringUtil.concat((String)configs.opt("id"), ".ss"), content, this.request, this.response, moduleFile);
        }
        if (hasEvents) {
            String beforeunload = this.getString(events, "beforeunload");
            if (!beforeunload.isEmpty()) {
                this.appendScript(this.headerScript, StringUtil.concat("Wb.onUnload(function(){\n", beforeunload, "\n},contextOwner);"));
            }
            this.appendScript(this.headerScript, this.getString(events, "initialize"));
        }
        if (hasChildren) {
            this.scan(module, moduleGeneral, emptyJson, runNormal, parentPath);
        }
        if (this.response.isCommitted()) {
            return;
        }
        this.appendScript(this.headerHtml, this.getString(configs, "finalHtml"));
        if (hasEvents) {
            this.appendScript(this.headerScript, this.getString(events, "finalize"));
        }
        if (createFrame) {
            if (runNormal) {
                if (libTypes[1] != false) {
                    this.headerScript.append("\n});");
                } else if (libTypes[2] != false) {
                    this.headerScript.append("\n}});");
                } else {
                    this.headerScript.append("\n})();");
                }
            } else if (runMode == 2) {
                this.headerScript.append("\nreturn Wb.optMain(app);\n})(null,app)");
            } else if (runMode == 1) {
                this.headerScript.append("\n})(null,app);");
            } else {
                this.headerScript.append("\nreturn app;\n})();");
            }
        }
        if (runNormal) {
            if (createFrame) {
                this.headerScript.append("\n</script>\n</body>\n</html>");
            }
            this.output();
        } else if (runInvoke) {
            this.output();
        }
    }

    private boolean checkToken(String tokens) {
        String[] ls;
        String token = this.request.getParameter("_token");
        if (StringUtil.isEmpty(token)) {
            return false;
        }
        String[] stringArray = ls = StringUtil.split(tokens, ",");
        int n = ls.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (token.equals(s.trim())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void output() throws IOException {
        if (this.headerHtml.length() > 0 && this.headerScript.length() > 0) {
            this.headerHtml.append('\n');
        }
        this.headerHtml.append((CharSequence)this.headerScript);
        if (this.headerHtml.length() > 0) {
            if (WebUtil.jsonResponse(this.request)) {
                WebUtil.send(this.response, this.headerHtml.toString(), true);
            } else {
                WebUtil.send(this.response, (Object)this.headerHtml);
            }
        }
    }

    private void scan(JSONObject parentNode, JSONObject parentGeneral, JSONObject emptyJson, boolean normalType, String parentItemPath) throws Exception {
        JSONArray ja = (JSONArray)parentNode.opt("children");
        int j = ja.length();
        int k = j - 1;
        int i = 0;
        while (i < j) {
            boolean isScriptControl;
            Control control;
            JSONObject jo = (JSONObject)ja.opt(i);
            String type = (String)jo.opt("type");
            JSONObject meta = Controls.get(type);
            JSONObject general = (JSONObject)meta.opt("general");
            String className = (String)general.opt("class");
            if (className == null) {
                control = new ExtControl();
                isScriptControl = true;
            } else if (className.equals("null")) {
                control = null;
                isScriptControl = false;
                if (type.equals("xwl")) {
                    boolean rootParent = Boolean.TRUE.equals(parentGeneral.opt("root"));
                    this.addModule(jo, rootParent, parentItemPath);
                    if (!rootParent && i < j - 1) {
                        this.headerScript.append(',');
                    }
                }
            } else {
                if (className.indexOf(46) == -1) {
                    className = "com.wb.controls." + className;
                }
                control = (Control)Class.forName(className).newInstance();
                isScriptControl = control instanceof ScriptControl;
            }
            String itemPath = parentItemPath;
            if (control != null) {
                control.init(this.request, this.response, jo, meta, parentGeneral, i == k, normalType);
                itemPath = StringUtils.isEmpty((String)itemPath) && control.configs != null ? control.configs.optString("itemId") : String.valueOf(itemPath) + "->" + control.configs.optString("itemId");
                control.setFuncId(this.funcId);
                control.setItemPath(itemPath);
                control.create();
            }
            if (isScriptControl) {
                ScriptControl sc = (ScriptControl)control;
                this.appendScript(this.headerHtml, sc.getHeaderHtml());
                this.pushHtml(sc.getFooterHtml());
                this.appendScript(this.headerScript, sc.getHeaderScript());
                this.pushScript(sc.getFooterScript());
            }
            if (jo.has("children")) {
                this.scan(jo, general, emptyJson, normalType, itemPath);
            }
            if (isScriptControl) {
                JSONObject configItems;
                this.appendScript(this.headerHtml, this.popHtml());
                String lastScript = this.popScript();
                int quoteIndex = lastScript.lastIndexOf(125);
                if (quoteIndex != -1 && (configItems = (JSONObject)jo.opt("__configs")) != null) {
                    this.appendScript(this.headerScript, lastScript.substring(0, quoteIndex));
                    this.headerScript.append(',');
                    this.scan(configItems, emptyJson, emptyJson, normalType, itemPath);
                    this.appendScript(this.headerScript, lastScript.substring(quoteIndex));
                } else {
                    this.appendScript(this.headerScript, lastScript);
                }
            }
            ++i;
        }
    }

    private void addModule(JSONObject jo, boolean rootParent, String parentPath) throws Exception {
        JSONObject configs = (JSONObject)jo.opt("configs");
        String file = this.getString(configs, "file");
        String itemId = this.getString(configs, "itemId");
        if (file != null && !"".equals(file)) {
            String moduleFile = FileUtil.getModuleFile(file);
            String funcId = StringUtil.toString(FunctionUtils.getFuncByPath((String)moduleFile).getFuncId());
            parentPath = String.valueOf(parentPath) + "->" + itemId + "(" + funcId + ")";
            this.execute(moduleFile, rootParent ? 1 : 2, (String)configs.opt("itemId"), parentPath);
        }
    }

    private void pushHtml(String script) {
        ++this.htmlPointer;
        if (this.footerHtml.size() < this.htmlPointer) {
            this.footerHtml.add(script);
        } else {
            this.footerHtml.set(this.htmlPointer - 1, script);
        }
    }

    private String popHtml() {
        --this.htmlPointer;
        return this.footerHtml.get(this.htmlPointer);
    }

    private void pushScript(String script) {
        ++this.scriptPointer;
        if (this.footerScript.size() < this.scriptPointer) {
            this.footerScript.add(script);
        } else {
            this.footerScript.set(this.scriptPointer - 1, script);
        }
    }

    private String popScript() {
        --this.scriptPointer;
        return this.footerScript.get(this.scriptPointer);
    }

    private void appendScript(StringBuilder buf, String script) {
        if (!StringUtil.isEmpty(script)) {
            if (buf.length() > 0) {
                buf.append('\n');
            }
            buf.append(script);
        }
    }

    private void importModules(String modules, String parentItemPath) throws Exception {
        JSONArray moduleArray = new JSONArray(modules);
        int j = moduleArray.length();
        int i = 0;
        while (i < j) {
            String moduleFile = FileUtil.getModuleFile((String)moduleArray.opt(i));
            String funcId = StringUtil.toString(FunctionUtils.getFuncByPath((String)moduleFile).getFuncId());
            parentItemPath = String.valueOf(parentItemPath) + "(" + funcId + ")";
            this.execute(moduleFile, 1, "importXwl" + (i + 1), parentItemPath);
            ++i;
        }
    }

    private boolean[] setLinks(JSONObject configs, String theme, String touchTheme) {
        int index;
        String value;
        int i;
        int j;
        ArrayList<String> cssArray = new ArrayList<String>();
        ArrayList<String> jsArray = new ArrayList<String>();
        JSONArray cssLinks = null;
        JSONArray jsLinks = null;
        String loadJS = this.getString(configs, "loadJS");
        String lang = Str.getClientLanguage(this.request);
        boolean[] libTypes = new boolean[4];
        String debugSuffix = Var.debug ? "-debug" : "";
        this.request.setAttribute("debugSuffix", (Object)debugSuffix);
        String cssLinksText = this.getString(configs, "cssLinks");
        String jsLinksText = this.getString(configs, "jsLinks");
        if (!cssLinksText.isEmpty()) {
            cssLinks = new JSONArray(cssLinksText);
        }
        if (!jsLinksText.isEmpty()) {
            jsLinks = new JSONArray(jsLinksText);
        }
        if (loadJS.isEmpty()) {
            loadJS = "ext";
        }
        jsArray.add("wb/libs/jquery/jquery.js");
        jsArray.add(StringUtil.concat("wb/script/locale/wb-lang-", Str.optLanguage(lang), debugSuffix, ".js"));
        if (loadJS.indexOf("ext") != -1) {
            libTypes[1] = true;
            cssArray.add(StringUtil.concat("wb/libs/ext/resources/ext-theme-", theme, "/ext-theme-", theme, "-all", debugSuffix, ".css"));
            jsArray.add(StringUtil.concat("wb/libs/ext/ext-all", debugSuffix, ".js"));
            jsArray.add(StringUtil.concat("wb/libs/ext/locale/ext-lang-", Str.optExtLanguage(lang), debugSuffix, ".js"));
            jsArray.add("wb/libs/echarts/echarts.min.js");
        }
        if (loadJS.indexOf("touch") != -1) {
            libTypes[2] = true;
            cssArray.add(StringUtil.concat("wb/libs/touch/resources/css/", touchTheme, debugSuffix, ".css"));
            jsArray.add(StringUtil.concat("wb/libs/touch/locale/t-lang-", Str.optTouchLanguage(lang), debugSuffix, ".js"));
            jsArray.add(StringUtil.concat("wb/libs/touch/sencha-touch-all", debugSuffix, ".js"));
        }
        if (loadJS.indexOf("bootstrap") != -1) {
            libTypes[3] = true;
            cssArray.add(StringUtil.concat("wb/libs/bs/css/bootstrap", debugSuffix, ".css"));
            jsArray.add(StringUtil.concat("wb/libs/jquery/jquery", debugSuffix, ".js"));
            jsArray.add(StringUtil.concat("wb/libs/bs/js/bootstrap", debugSuffix, ".js"));
        }
        this.headerHtml.append("\n<link rel=\"stylesheet\" type=\"text/css\" href=\"wb/libs/ext/resources/common/common.css\">");
        if (Var.styleTheme) {
            cssArray.add(StringUtil.concat("wb/css/style-" + theme, debugSuffix, ".css"));
        } else {
            cssArray.add(StringUtil.concat("wb/css/style", debugSuffix, ".css"));
        }
        jsArray.add(StringUtil.concat("wb/script/wb", debugSuffix, ".js"));
        jsArray.add(StringUtil.concat("wb/script/flow", debugSuffix, ".js"));
        jsArray.add(StringUtil.concat("wb/script/new-flow", debugSuffix, ".js"));
        if (cssLinks != null) {
            j = cssLinks.length();
            i = 0;
            while (i < j) {
                value = cssLinks.getString(i);
                index = cssArray.indexOf(value);
                if (index != -1) {
                    cssArray.remove(index);
                }
                cssArray.add(value);
                ++i;
            }
        }
        if (jsLinks != null) {
            j = jsLinks.length();
            i = 0;
            while (i < j) {
                value = jsLinks.getString(i);
                index = jsArray.indexOf(value);
                if (index != -1) {
                    jsArray.remove(index);
                }
                jsArray.add(value);
                ++i;
            }
        }
        for (String css : cssArray) {
            this.headerHtml.append("\n<link type=\"text/css\" rel=\"stylesheet\" href=\"");
            this.headerHtml.append(css);
            this.headerHtml.append("\">");
        }
        for (String js : jsArray) {
            this.headerHtml.append("\n<script type=\"text/javascript\" src=\"");
            this.headerHtml.append(js);
            this.headerHtml.append("\"></script>");
        }
        return libTypes;
    }

    private void addLinksScript(JSONObject configs) {
        this.request.setAttribute("debugSuffix", (Object)(Var.debug ? "-debug" : ""));
        String cssLinks = this.getString(configs, "cssLinks");
        String jsLinks = this.getString(configs, "jsLinks");
        boolean emptyCss = cssLinks.isEmpty();
        boolean emptyJs = jsLinks.isEmpty();
        if (!emptyCss || !emptyJs) {
            this.headerScript.append("$$@blink{");
            if (!emptyCss) {
                this.headerScript.append("\"css\":");
                this.headerScript.append(cssLinks);
            }
            if (!emptyJs) {
                if (!emptyCss) {
                    this.headerScript.append(',');
                }
                this.headerScript.append("\"js\":");
                this.headerScript.append(jsLinks);
            }
            if (this.getBool(configs, "recursiveLoad", false)) {
                this.headerScript.append(",\"recursive\":true");
            }
            this.headerScript.append("}$$@elink");
        }
    }

    private String getString(JSONObject object, String name) {
        String value = (String)object.opt(name);
        if (value == null) {
            return "";
        }
        return WebUtil.replaceParams(this.request, value);
    }

    private boolean getBool(JSONObject object, String name, boolean defaultValue) {
        String value = this.getString(object, name);
        if (value.isEmpty()) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public static void closeObjects(ConcurrentHashMap<String, Object> map, boolean isExcept) {
        Set<Map.Entry<String, Object>> es = map.entrySet();
        ArrayList<Connection> connList = new ArrayList<Connection>();
        ArrayList<Statement> stList = new ArrayList<Statement>();
        for (Map.Entry<String, Object> e : es) {
            Object object = e.getValue();
            if (object == null) continue;
            if (object instanceof ResultSet) {
                DbUtil.close((ResultSet)object);
                continue;
            }
            if (object instanceof Statement) {
                stList.add((Statement)object);
                continue;
            }
            if (object instanceof Connection) {
                connList.add((Connection)object);
                continue;
            }
            if (object instanceof InputStream) {
                IOUtils.closeQuietly((InputStream)((InputStream)object));
                continue;
            }
            if (!(object instanceof OutputStream)) continue;
            IOUtils.closeQuietly((OutputStream)((OutputStream)object));
        }
        for (Statement st : stList) {
            DbUtil.close(st);
        }
        for (Connection conn : connList) {
            if (isExcept) {
                DbUtil.close(conn);
                continue;
            }
            DbUtil.closeCommit(conn);
        }
    }

    private String getTouchViewport(JSONArray items, JSONObject parentGeneral, boolean normalType) throws Exception {
        if (items == null) {
            return "";
        }
        JSONObject meta = Controls.get("tviewport");
        StringBuilder script = new StringBuilder();
        int j = items.length();
        int k = j - 1;
        int i = 0;
        while (i < j) {
            JSONObject jo = (JSONObject)items.opt(i);
            if ("tviewport".equals(jo.opt("type"))) {
                ExtControl control = new ExtControl();
                control.normalMode = false;
                control.init(this.request, this.response, jo, meta, parentGeneral, i == k, normalType);
                control.create();
                script.append("\nviewport:");
                script.append(control.getHeaderScript());
                script.append(control.getFooterScript());
                script.append(',');
                return script.toString();
            }
            ++i;
        }
        return "";
    }
}

