package baffledbanana87.endervillages.entity.client;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10042;
import net.minecraft.class_10079;
import net.minecraft.class_1047;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_3850;
import net.minecraft.class_3852;
import net.minecraft.class_3883;
import net.minecraft.class_3884;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5321;
import net.minecraft.class_583;
import net.minecraft.class_6880;
import net.minecraft.class_3888.class_3889;

@Environment(EnvType.CLIENT)
public class ModVillagerProfessionLayer extends class_3887 {

   private static final Int2ObjectMap LEVEL_TO_ID;
   private final Object2ObjectMap villagerTypeToHat = new Object2ObjectOpenHashMap();
   private final Object2ObjectMap professionToHat = new Object2ObjectOpenHashMap();
   private final class_3300 resourceManager;
   private final String entityType;


   public ModVillagerProfessionLayer(class_3883 context, class_3300 resourceManager, String entityType) {
      super(context);
      this.resourceManager = resourceManager;
      this.entityType = entityType;
   }

   public void render(class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, class_10042 livingEntityRenderState, float f, float g) {
      if(!livingEntityRenderState.field_53333) {
         class_3850 villagerData = ((class_10079)livingEntityRenderState).method_62617();
         if(villagerData != null) {
            class_6880 registryEntry = villagerData.comp_3520();
            class_6880 registryEntry2 = villagerData.comp_3521();
            class_3889 hatType = this.getHatType(this.villagerTypeToHat, "type", registryEntry);
            class_3889 hatType2 = this.getHatType(this.professionToHat, "profession", registryEntry2);
            class_583 entityModel = this.method_17165();
            ((class_3884)entityModel).method_17150(hatType2 == class_3889.field_17160 || hatType2 == class_3889.field_17161 && hatType != class_3889.field_17162);
            class_2960 identifier = class_2960.method_60655("endervillages", "textures/entity/type/ender_plains.png");
            method_23199(entityModel, identifier, matrixStack, vertexConsumerProvider, i, livingEntityRenderState, -1);
            ((class_3884)entityModel).method_17150(true);
            if(!registryEntry2.method_40225(class_3852.field_17051) && !livingEntityRenderState.field_53457) {
               class_2960 identifier2 = this.getTexture("profession", (class_6880)registryEntry2);
               method_23199(entityModel, identifier2, matrixStack, vertexConsumerProvider, i, livingEntityRenderState, -1);
               if(!registryEntry2.method_40225(class_3852.field_17062)) {
                  class_2960 identifier3 = this.getTexture("profession_level", (class_2960)((class_2960)LEVEL_TO_ID.get(class_3532.method_15340(villagerData.comp_3522(), 1, LEVEL_TO_ID.size()))));
                  method_23199(entityModel, identifier3, matrixStack, vertexConsumerProvider, i, livingEntityRenderState, -1);
               }
            }
         }
      }

   }

   private class_2960 getTexture(String keyType, class_2960 keyId) {
      return this.method_45134(keyType);
   }

   private class_2960 getTexture(String keyType, class_6880 entry) {
      entry.method_40230();
      return (class_2960)this.map(keyType).orElse(class_1047.method_4539());
   }

   public class_3889 getHatType(Object2ObjectMap metadataMap, String keyType, class_6880 entry) {
      class_5321 registryKey = (class_5321)entry.method_40230().orElse((Object)null);
      if(registryKey == null) {
         class_3889 var10000 = class_3889.field_17160;
      }

      return (class_3889)this.computeIfAbsent(keyType, registryKey);
   }

   // $FF: synthetic method
   private class_3889 lambda$getHatType$4(String param1, class_5321 param2, Object param3) {
      // $FF: Couldn't be decompiled
   }

   // $FF: synthetic method
   private static Optional lambda$getHatType$3(class_3298 param0) {
      // $FF: Couldn't be decompiled
   }

   // $FF: synthetic method
   private class_2960 lambda$getTexture$2(String keyType, class_5321 key) {
      return this.getTexture(keyType, (class_2960)key.method_29177());
   }

   // $FF: synthetic method
   private String lambda$getTexture$1(String keyType, String path) {
      String var10000 = this.entityType;
      return path;
   }

   // $FF: synthetic method
   private static void lambda$static$0(Int2ObjectOpenHashMap levelToId) {
      levelToId.put(1, class_2960.method_60656("stone"));
      levelToId.put(2, class_2960.method_60656("iron"));
      levelToId.put(3, class_2960.method_60656("gold"));
      levelToId.put(4, class_2960.method_60656("emerald"));
      levelToId.put(5, class_2960.method_60656("diamond"));
   }

   static {
      // $FF: Couldn't be decompiled
   }
}
