/*
 * Decompiled with CFR 0.152.
 */
package ungp.scripts.utils;

import com.fs.starfarer.api.Global;
import java.net.Socket;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.log4j.Logger;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;
import ungp.scripts.utils.Constants;

public class UNGP_Feedback {
    private static final Logger LOGGER = Global.getLogger(UNGP_Feedback.class);
    private static final String FEEDBACK_SENT_KEY = "UNGP_feedbackSent";
    private static final String FEEDBACK_LIST_KEY = "UNGP_feedbackList";

    public static boolean isFeedbackSent() {
        return Global.getSector().getPersistentData().containsKey(FEEDBACK_SENT_KEY);
    }

    public static void resetFeedbackSent() {
        Global.getSector().getPersistentData().remove(FEEDBACK_SENT_KEY);
    }

    public static void setFeedBackSent() {
        Global.getSector().getPersistentData().put(FEEDBACK_SENT_KEY, true);
    }

    public static void setFeedBackList(List<UNGP_RulesManager.URule> rules) {
        StringBuilder sb = new StringBuilder();
        for (UNGP_RulesManager.URule rule : rules) {
            sb.append(rule.getId());
            sb.append("|");
        }
        sb.deleteCharAt(sb.length() - 1);
        Global.getSector().getPersistentData().put(FEEDBACK_LIST_KEY, sb.toString());
    }

    public static void sendPlayerRulesToServer(List<UNGP_RulesManager.URule> rules) {
        String apiUrl = Constants.rules_i18n.get("button_feedback_url");
        StringBuilder sb = new StringBuilder(apiUrl);
        String ruleString = (String)Global.getSector().getPersistentData().get(FEEDBACK_LIST_KEY);
        if (ruleString != null) {
            sb.append(ruleString);
        } else {
            if (rules.isEmpty()) {
                return;
            }
            for (UNGP_RulesManager.URule rule : rules) {
                sb.append(rule.getId());
                sb.append("|");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        String url = sb.toString();
        LOGGER.info((Object)("Sending to " + url));
        Thread thread = new Thread(() -> {
            try {
                URL connURL = new URL(url);
                HttpsURLConnection conn = (HttpsURLConnection)connURL.openConnection();
                UNGP_Feedback.setHttpProtocol(conn);
                conn.getInputStream().close();
                LOGGER.info((Object)("Successfully send " + url));
            }
            catch (Exception e) {
                LOGGER.info((Object)("Error connecting to " + apiUrl));
                LOGGER.info((Object)e);
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public static void setHttpProtocol(HttpsURLConnection conn) {
        SSLContext ctx = UNGP_Feedback.MyX509TrustManagerUtils();
        conn.setSSLSocketFactory(ctx.getSocketFactory());
        conn.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        });
    }

    private static SSLContext MyX509TrustManagerUtils() {
        TrustManager[] tm = new TrustManager[]{new MyX509TrustManager()};
        SSLContext ctx = null;
        try {
            ctx = SSLContext.getInstance("TLSv1.2");
            ctx.init(null, tm, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ctx;
    }

    private static class MyX509TrustManager
    extends X509ExtendedTrustManager {
        private MyX509TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

