/*
 * Decompiled with CFR 0.152.
 */
package ungp.scripts.ui;

import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.lazywizard.lazylib.ui.FontException;
import org.lazywizard.lazylib.ui.LazyFont;

public class UNGPFont {
    public static LazyFont.DrawableString ORBITRON;
    public static LazyFont.DrawableString ORBITRON_BOLD;
    private static LazyFont orbitronMod;
    private static LazyFont orbitronCore;
    private static final Map<String, LazyFont.DrawableString> DYNAMIC_DRAWABLE_MAP;
    private static final Pattern ENG_CHECKER;

    public static boolean notOnlyEN(String s) {
        return ENG_CHECKER.matcher(s).matches();
    }

    public static void init() {
        try {
            orbitronMod = LazyFont.loadFont((String)"graphics/ungp/fonts/ungp_orbitron.fnt");
            orbitronCore = LazyFont.loadFont((String)"graphics/fonts/orbitron20aabold.fnt");
            ORBITRON = orbitronMod.createText();
            ORBITRON_BOLD = orbitronCore.createText();
        }
        catch (FontException ex) {
            throw new RuntimeException("Error font loading...");
        }
    }

    public static LazyFont.DrawableString getDynamicDrawable(String content, Color color) {
        String key = content + color.toString();
        LazyFont.DrawableString drawableString = DYNAMIC_DRAWABLE_MAP.get(key);
        if (drawableString == null) {
            drawableString = orbitronMod.createText(content, color, 20.0f, 32.0f, 32.0f);
            DYNAMIC_DRAWABLE_MAP.put(key, drawableString);
        }
        return drawableString;
    }

    public static void clearDynamicDrawable() {
        Collection<LazyFont.DrawableString> drawableStrings = DYNAMIC_DRAWABLE_MAP.values();
        for (LazyFont.DrawableString drawableString : drawableStrings) {
            drawableString.dispose();
        }
        DYNAMIC_DRAWABLE_MAP.clear();
    }

    public static LazyFont getOrbitronMod() {
        return orbitronMod;
    }

    public static void drawShadow(LazyFont.DrawableString drawableString, float cx, float cy, float offset) {
        drawableString.draw(cx - offset, cy);
        drawableString.draw(cx + offset, cy);
        drawableString.draw(cx, cy - offset);
        drawableString.draw(cx, cy + offset);
    }

    static {
        DYNAMIC_DRAWABLE_MAP = new HashMap<String, LazyFont.DrawableString>();
        ENG_CHECKER = Pattern.compile("^[\\sa-zA-Z]*");
    }
}

