/*
 * Decompiled with CFR 0.152.
 */
package ungp.scripts.ui;

import com.fs.starfarer.api.campaign.CustomUIPanelPlugin;
import com.fs.starfarer.api.ui.CustomPanelAPI;
import com.fs.starfarer.api.ui.PositionAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.UIComponentAPI;
import java.awt.Color;
import ungp.scripts.ui.UIPanelManager;

public class UIRect {
    private float x;
    private float y;
    private float width;
    private float height;
    private CustomPanelAPI rootPanel;
    private TooltipMakerAPI latestTooltip;
    private UIPanelManager latestSubPanelManager;

    public UIRect(float x, float y, float width, float height) {
        this.x = (int)x;
        this.y = (int)y;
        this.width = (int)width;
        this.height = (int)height;
    }

    public UIRect shrink(float marginTop, float marginBottom, float marginLeft, float marginRight) {
        float newWidth = this.width - marginLeft - marginRight;
        float newHeight = this.height - marginTop - marginBottom;
        float newX = this.x + marginLeft;
        float newY = this.y + marginTop;
        return new UIRect(newX, newY, newWidth, newHeight);
    }

    public UIRect shrink(float margin) {
        return this.shrink(margin, margin, margin, margin);
    }

    public UIRect shrink(float xMargin, float yMargin) {
        return this.shrink(yMargin, yMargin, xMargin, xMargin);
    }

    public UIRect[] splitHorizontally(float ... weights) {
        if (weights == null || weights.length == 0) {
            return new UIRect[]{this};
        }
        float total = 0.0f;
        for (float weight : weights) {
            total += weight;
        }
        float addOnX = 0.0f;
        UIRect[] newRects = new UIRect[weights.length];
        for (int i = 0; i < weights.length; ++i) {
            float curWidth = this.width * (weights[i] / total);
            newRects[i] = new UIRect(this.x + addOnX, this.y, curWidth, this.height);
            addOnX += curWidth;
        }
        return newRects;
    }

    public UIRect[] splitHorizontally(float splitWidth) {
        if (splitWidth >= this.width) {
            return new UIRect[]{this};
        }
        UIRect[] newRects = new UIRect[]{new UIRect(this.x, this.y, splitWidth, this.height), new UIRect(this.x + splitWidth, this.y, this.width - splitWidth, this.height)};
        return newRects;
    }

    public UIRect[] splitHorizontallyReverse(float splitWidth) {
        if (splitWidth >= this.width) {
            return new UIRect[]{this};
        }
        UIRect[] newRects = new UIRect[]{new UIRect(this.x, this.y, this.width - splitWidth, this.height), new UIRect(this.x + (this.width - splitWidth), this.y, splitWidth, this.height)};
        return newRects;
    }

    public UIRect[] splitVertically(float ... weights) {
        if (weights == null || weights.length == 0) {
            return new UIRect[]{this};
        }
        float total = 0.0f;
        for (float weight : weights) {
            total += weight;
        }
        float addOnY = 0.0f;
        UIRect[] newRects = new UIRect[weights.length];
        for (int i = 0; i < weights.length; ++i) {
            float curHeight = this.height * (weights[i] / total);
            newRects[i] = new UIRect(this.x, this.y + addOnY, this.width, curHeight);
            addOnY += curHeight;
        }
        return newRects;
    }

    public UIRect[] splitVertically(float splitHeight) {
        if (splitHeight >= this.height) {
            return new UIRect[]{this};
        }
        UIRect[] newRects = new UIRect[]{new UIRect(this.x, this.y, this.width, splitHeight), new UIRect(this.x, this.y + splitHeight, this.width, this.height - splitHeight)};
        return newRects;
    }

    public UIRect[] splitVerticallyReverse(float splitHeight) {
        if (splitHeight >= this.height) {
            return new UIRect[]{this};
        }
        UIRect[] newRects = new UIRect[]{new UIRect(this.x, this.y, this.width, this.height - splitHeight), new UIRect(this.x, this.y + (this.height - splitHeight), this.width, splitHeight)};
        return newRects;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setRootPanel(CustomPanelAPI rootPanel) {
        this.rootPanel = rootPanel;
    }

    public TooltipMakerAPI beginTooltip(CustomPanelAPI rootPanel, boolean withSpoiler) {
        this.latestTooltip = rootPanel.createUIElement(this.width, this.height, withSpoiler);
        this.setRootPanel(rootPanel);
        return this.latestTooltip;
    }

    public void addTooltip() {
        if (this.rootPanel != null) {
            this.rootPanel.addUIElement(this.latestTooltip).inTL(this.x, this.y);
        }
    }

    public void removeLatestSubPanel() {
        if (this.rootPanel != null && this.latestSubPanelManager != null) {
            this.latestSubPanelManager.clearAllComponents();
            this.rootPanel.removeComponent((UIComponentAPI)this.latestSubPanelManager.getPanel());
            this.latestSubPanelManager = null;
        }
    }

    public void addBoarder(CustomPanelAPI rootPanel, Color color, float thickness) {
        TooltipMakerAPI tooltipMaker = rootPanel.createUIElement(this.width, this.height, false);
        UIComponentAPI boarder = tooltipMaker.createRect(color, thickness);
        tooltipMaker.addCustomDoNotSetPosition(boarder).getPosition().inTL(0.0f, 0.0f).setSize(this.width, this.height);
        rootPanel.addUIElement(tooltipMaker).inTL(this.x, this.y);
    }

    public PositionAPI syncPositionSize(PositionAPI position) {
        return position.setSize(this.width, this.height);
    }

    public UIPanelManager createSubPanel(CustomPanelAPI rootPanel, CustomUIPanelPlugin uiPlugin) {
        if (this.rootPanel == null) {
            this.setRootPanel(rootPanel);
        }
        this.latestSubPanelManager = new UIPanelManager(rootPanel.createCustomPanel(this.width, this.height, uiPlugin), uiPlugin);
        rootPanel.addComponent((UIComponentAPI)this.latestSubPanelManager.getPanel()).inTL(this.x, this.y);
        return this.latestSubPanelManager;
    }
}

