/*
 * Decompiled with CFR 0.152.
 */
package ungp.scripts.ui;

import com.fs.starfarer.api.ui.ButtonAPI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CheckBoxGroup {
    private Map<ButtonAPI, Object> checkBoxMap = new HashMap<ButtonAPI, Object>();
    private ButtonAPI lastCheckedButton;

    public void addCheckBox(ButtonAPI checkBox, Object data) {
        this.checkBoxMap.put(checkBox, data);
    }

    public void clear() {
        this.checkBoxMap.clear();
    }

    public ButtonAPI getCheckedButton() {
        return this.lastCheckedButton;
    }

    public Object getCheckedValue() {
        return this.checkBoxMap.get(this.lastCheckedButton);
    }

    public void tryCheckValue(Object value) {
        for (Map.Entry<ButtonAPI, Object> entry : this.checkBoxMap.entrySet()) {
            Object entryValue = entry.getValue();
            if (entryValue == null) {
                if (value != null) continue;
                entry.getKey().setChecked(true);
                break;
            }
            if (!entryValue.equals(value)) continue;
            entry.getKey().setChecked(true);
            break;
        }
    }

    public void updateCheck() {
        Set<ButtonAPI> checkBoxes = this.checkBoxMap.keySet();
        if (this.lastCheckedButton == null) {
            boolean foundBox = false;
            for (ButtonAPI checkBox : checkBoxes) {
                if (!foundBox && checkBox.isChecked()) {
                    this.lastCheckedButton = checkBox;
                    foundBox = true;
                    continue;
                }
                checkBox.setChecked(false);
            }
        }
        int count = 0;
        for (ButtonAPI checkBox : checkBoxes) {
            if (!checkBox.isChecked()) continue;
            ++count;
        }
        if (count >= 2) {
            ButtonAPI targetButton = null;
            for (ButtonAPI checkBox : checkBoxes) {
                if (!checkBox.isChecked()) continue;
                if (checkBox != this.lastCheckedButton) {
                    targetButton = checkBox;
                }
                checkBox.setChecked(false);
            }
            if (targetButton != null) {
                this.lastCheckedButton = targetButton;
            }
        }
        if (this.lastCheckedButton != null) {
            this.lastCheckedButton.setChecked(true);
        }
    }
}

