/*
 * Decompiled with CFR 0.152.
 */
package ungp.scripts.plugins;

import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.List;
import ungp.api.rules.UNGP_RuleEffectAPI;
import ungp.api.rules.tags.UNGP_CombatInitTag;
import ungp.api.rules.tags.UNGP_CombatTag;
import ungp.api.rules.tags.UNGP_TweakBeforeApplyCombatTag;
import ungp.scripts.campaign.UNGP_InGameData;
import ungp.scripts.campaign.UNGP_Settings;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;
import ungp.scripts.utils.Constants;
import ungp.scripts.utils.UNGPUtils;

public class UNGP_SpecialistCombatPlugin
extends BaseEveryFrameCombatPlugin {
    private CombatEngineAPI engine;
    private boolean init = false;
    private boolean isSpecialistMode = false;
    private List<UNGP_CombatTag> tags = new ArrayList<UNGP_CombatTag>();
    private List<Object[]> bonusMessages = new ArrayList<Object[]>();
    private List<Object[]> notBonusMessages = new ArrayList<Object[]>();

    public void init(CombatEngineAPI engine) {
        UNGP_InGameData inGameData;
        this.engine = engine;
        if ((engine.isInCampaign() || engine.isInCampaignSim()) && (inGameData = UNGP_InGameData.getDataInSave()) != null && inGameData.isHardMode()) {
            if (engine.isInCampaignSim() && !UNGP_SpecialistSettings.isRulesEnabledInSimulation()) {
                return;
            }
            this.isSpecialistMode = true;
            UNGP_SpecialistSettings.Difficulty difficulty = inGameData.getDifficulty();
            ArrayList<UNGP_RulesManager.URule> originalRules = new ArrayList<UNGP_RulesManager.URule>(UNGP_RulesManager.COMBAT_RULES_IN_THIS_GAME);
            ArrayList<UNGP_RulesManager.URule> activatedRules = new ArrayList<UNGP_RulesManager.URule>(originalRules);
            for (UNGP_RulesManager.URule rule : originalRules) {
                if (!(rule.getRuleEffect() instanceof UNGP_TweakBeforeApplyCombatTag)) continue;
                ((UNGP_TweakBeforeApplyCombatTag)((Object)rule.getRuleEffect())).tweakBeforeApply(activatedRules, originalRules);
            }
            for (UNGP_RulesManager.URule rule : activatedRules) {
                UNGP_RuleEffectAPI ruleEffect = rule.getRuleEffect();
                boolean addMessage = false;
                if (ruleEffect instanceof UNGP_CombatTag) {
                    this.tags.add((UNGP_CombatTag)((Object)ruleEffect));
                    addMessage = true;
                }
                if (ruleEffect instanceof UNGP_CombatInitTag) {
                    ((UNGP_CombatInitTag)((Object)ruleEffect)).init(engine);
                    addMessage = true;
                }
                if (!addMessage) continue;
                if (rule.isPositive()) {
                    this.bonusMessages.add(rule.generateCombatTips(difficulty));
                    continue;
                }
                this.notBonusMessages.add(rule.generateCombatTips(difficulty));
            }
        }
    }

    public void advance(float amount, List<InputEventAPI> events) {
        if (!this.init) {
            this.init = true;
            if (this.isSpecialistMode) {
                if (!UNGP_Settings.isNoRuleMessageWhileBattleStart()) {
                    for (Object[] messageArray : this.bonusMessages) {
                        this.engine.getCombatUI().addMessage(0, messageArray);
                    }
                    for (Object[] messageArray : this.notBonusMessages) {
                        this.engine.getCombatUI().addMessage(0, messageArray);
                    }
                    this.engine.getCombatUI().addMessage(0, new Object[]{Misc.getHighlightColor(), Constants.root_i18n.get("specialist_mode_combat_loading")});
                }
                this.bonusMessages.clear();
                this.notBonusMessages.clear();
            }
        }
        if (!this.isSpecialistMode) {
            return;
        }
        if (this.engine.isPaused()) {
            amount = 0.0f;
        }
        for (UNGP_CombatTag tag : this.tags) {
            tag.advanceInCombat(this.engine, amount);
        }
        List ships = this.engine.getShips();
        for (ShipAPI ship : ships) {
            if (!ship.isAlive()) continue;
            if (UNGPUtils.isPlayerShip(ship)) {
                for (UNGP_CombatTag tag : this.tags) {
                    tag.applyPlayerShipInCombat(amount, this.engine, ship);
                }
                continue;
            }
            for (UNGP_CombatTag tag : this.tags) {
                tag.applyEnemyShipInCombat(amount, ship);
            }
        }
    }
}

