/*
 * Decompiled with CFR 0.152.
 */
package ungp.scripts.codex;

import com.fs.starfarer.api.campaign.CustomUIPanelPlugin;
import com.fs.starfarer.api.impl.codex.CodexDialogAPI;
import com.fs.starfarer.api.impl.codex.CodexEntryPlugin;
import com.fs.starfarer.api.impl.codex.CodexEntryV2;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.ui.CustomPanelAPI;
import com.fs.starfarer.api.ui.PositionAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.UIComponentAPI;
import com.fs.starfarer.api.ui.UIPanelAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Set;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;

public class UNGP_RuleCodexEntryPlugin
extends CodexEntryV2
implements CustomUIPanelPlugin {
    public static final String ID_PREFIX = "UNGP_codex_rule_";
    protected CustomPanelAPI panel;
    protected UIPanelAPI relatedEntries;
    protected UIPanelAPI box;
    protected CodexDialogAPI codex;

    public UNGP_RuleCodexEntryPlugin(UNGP_RulesManager.URule uRule) {
        super(ID_PREFIX + uRule.getId(), uRule.getName(), uRule.getSpritePath(), (Object)uRule.getId());
    }

    public UNGP_RuleCodexEntryPlugin(String id, String title, String icon) {
        super(id, title, icon);
    }

    public UNGP_RulesManager.URule getURule() {
        String realId = this.id.substring(ID_PREFIX.length());
        return UNGP_RulesManager.URule.getByID(realId);
    }

    public void createTitleForList(TooltipMakerAPI info, float width, CodexEntryPlugin.ListMode mode) {
        UNGP_RulesManager.URule uRule = this.getURule();
        info.addPara(this.getTitle(), uRule.getTooltipTitleColor(), 0.0f);
        info.addPara(uRule.getRuleTypeName() + "(" + uRule.getCostString() + ")", Misc.getGrayColor(), 0.0f);
    }

    public boolean hasCustomDetailPanel() {
        return true;
    }

    public CustomUIPanelPlugin getCustomPanelPlugin() {
        return this;
    }

    public void destroyCustomDetail() {
        this.panel = null;
        this.relatedEntries = null;
        this.box = null;
        this.codex = null;
    }

    public void createCustomDetail(CustomPanelAPI panel, UIPanelAPI relatedEntries, CodexDialogAPI codex) {
        this.panel = panel;
        this.relatedEntries = relatedEntries;
        this.codex = codex;
        float opad = 10.0f;
        float width = panel.getPosition().getWidth();
        float horzBoxPad = 30.0f;
        float tw = width - 290.0f - opad - horzBoxPad + 10.0f;
        TooltipMakerAPI text = panel.createUIElement(tw, 0.0f, false);
        UNGP_RulesManager.URule uRule = this.getURule();
        uRule.addDetailsToTooltip(text, true, true);
        panel.updateUIElementSizeAndMakeItProcessInput(text);
        this.box = panel.wrapTooltipWithBox(text);
        panel.addComponent((UIComponentAPI)this.box).inTL(0.0f, 0.0f);
        if (relatedEntries != null) {
            panel.addComponent((UIComponentAPI)relatedEntries).inTR(0.0f, 0.0f);
        }
        float height = this.box.getPosition().getHeight();
        if (relatedEntries != null) {
            height = Math.max(height, relatedEntries.getPosition().getHeight());
        }
        panel.getPosition().setSize(width, height);
    }

    public boolean matchesTags(Set<String> tags) {
        UNGP_RulesManager.URule uRule = this.getURule();
        if (tags.contains("positive") && uRule.isPositive()) {
            return true;
        }
        if (tags.contains("negative") && !uRule.isPositive()) {
            return true;
        }
        if (tags.contains("golden") && uRule.isGolden()) {
            return true;
        }
        if (tags.contains("milestone") && uRule.isMilestone()) {
            return true;
        }
        return tags.isEmpty();
    }

    public void positionChanged(PositionAPI position) {
    }

    public void renderBelow(float alphaMult) {
    }

    public void render(float alphaMult) {
    }

    public void advance(float amount) {
    }

    public void processInput(List<InputEventAPI> events) {
    }

    public void buttonPressed(Object buttonId) {
    }

    public boolean isVignetteIcon() {
        return true;
    }
}

