/*
 * Decompiled with CFR 0.152.
 */
package ungp.scripts.codex;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.impl.codex.CodexDataV2;
import com.fs.starfarer.api.impl.codex.CodexEntryPlugin;
import com.fs.starfarer.api.impl.codex.CodexEntryV2;
import com.fs.starfarer.api.ui.TagDisplayAPI;
import java.util.List;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeInfo;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeManager;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;
import ungp.scripts.codex.UNGP_RuleCodexEntryPlugin;
import ungp.scripts.utils.Constants;

public class UNGP_CodexManager {
    public static final String CODEX_ROOT = "UNGP_codex_root";
    public static final String SPECIALIST_ENTRY = "UNGP_specialist_entry";
    public static final String RULE_ENTRY = "UNGP_rule_entry";

    public static void init() {
        CodexEntryV2 rootEntry = new CodexEntryV2(CODEX_ROOT, Constants.codex_i18n.get("root_title"), Global.getSettings().getSpriteName("icons", "UNGP_intel_icon"));
        CodexEntryV2 specialistEntry = new CodexEntryV2(SPECIALIST_ENTRY, Constants.codex_i18n.get("specialist_title"), Global.getSettings().getSpriteName("icons", "UNGP_specialist_mode_logo"));
        rootEntry.addChild((CodexEntryPlugin)specialistEntry);
        final List<UNGP_RulesManager.URule> allRulesCopy = UNGP_RulesManager.getAllRulesCopy();
        allRulesCopy.sort(new UNGP_RulesManager.UNGP_RuleSorter());
        CodexEntryV2 allRulesEntry = new CodexEntryV2(RULE_ENTRY, Constants.codex_i18n.get("rule_title"), Global.getSettings().getSpriteName("codex", "game_mechanics")){

            public boolean hasTagDisplay() {
                return true;
            }

            public void configureTagDisplay(TagDisplayAPI tags) {
                int total = 0;
                int positive = 0;
                int negative = 0;
                int golden = 0;
                int milestone = 0;
                for (UNGP_RulesManager.URule uRule : allRulesCopy) {
                    ++total;
                    if (uRule.isPositive()) {
                        ++positive;
                    } else {
                        ++negative;
                    }
                    if (uRule.isGolden()) {
                        ++golden;
                    }
                    if (!uRule.isMilestone()) continue;
                    ++milestone;
                }
                tags.beginGroup(false, Constants.codex_i18n.get("all_tag"));
                tags.addTag("positive", UNGP_RulesManager.getRuleTypeName(false, false, true), positive);
                tags.addTag("negative", UNGP_RulesManager.getRuleTypeName(false, false, false), negative);
                tags.addTag("golden", UNGP_RulesManager.getRuleTypeName(false, true, false), golden);
                tags.addTag("milestone", UNGP_RulesManager.getRuleTypeName(true, false, false), milestone);
                tags.setTotalOverrideForCurrentGroup(total);
                tags.addGroup(0.0f);
                tags.setGroupChecked(0, true);
            }
        };
        for (UNGP_RulesManager.URule uRule : allRulesCopy) {
            UNGP_RuleCodexEntryPlugin ruleEntry = new UNGP_RuleCodexEntryPlugin(uRule);
            ruleEntry.setRetainOrderOfRelatedEntries(true);
            allRulesEntry.addChild((CodexEntryPlugin)ruleEntry);
        }
        specialistEntry.addChild((CodexEntryPlugin)allRulesEntry);
        allRulesEntry.setRetainOrderOfChildren(true);
        CodexDataV2.ROOT.addChild((CodexEntryPlugin)rootEntry);
    }

    public static void setRelatedEntries() {
        List<UNGP_ChallengeInfo> challengeInfosCopy = UNGP_ChallengeManager.getChallengeInfosCopy();
        for (UNGP_ChallengeInfo challengeInfo : challengeInfosCopy) {
            challengeInfo.getRulesRequired().forEach(rule -> {
                UNGP_RulesManager.URule milestoneToUnlock = challengeInfo.getMilestoneToUnlock();
                CodexDataV2.makeRelated((String[])new String[]{rule.getCodexEntryId(), milestoneToUnlock.getCodexEntryId()});
            });
            challengeInfo.getRulesRequired().forEach(rule -> challengeInfo.getRulesRequired().forEach(anotherRule -> {
                if (rule != anotherRule) {
                    CodexDataV2.makeRelated((String[])new String[]{rule.getCodexEntryId(), anotherRule.getCodexEntryId()});
                }
            }));
        }
    }
}

