/*
 * Decompiled with CFR 0.152.
 */
package ungp.scripts.campaign.ui;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.BaseCustomUIPanelPlugin;
import com.fs.starfarer.api.campaign.CustomUIPanelPlugin;
import com.fs.starfarer.api.campaign.CustomVisualDialogDelegate;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.CustomPanelAPI;
import com.fs.starfarer.api.ui.CutStyle;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.PositionAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.UIComponentAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.lwjgl.opengl.GL11;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeInfo;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeManager;
import ungp.scripts.campaign.specialist.intel.UNGP_SpecialistBackgroundUI;
import ungp.scripts.campaign.specialist.rules.UNGP_RulePickHelper;
import ungp.scripts.campaign.specialist.rules.UNGP_RulePickPresetManager;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;
import ungp.scripts.campaign.ui.UNGP_RulePickItemPanelPlugin;
import ungp.scripts.ui.CheckBoxGroup;
import ungp.scripts.ui.UIRect;
import ungp.scripts.utils.Constants;

public class UNGP_RulePickPanelPlugin
extends BaseCustomUIPanelPlugin {
    private static final Logger LOGGER = Global.getLogger(UNGP_RulePickPanelPlugin.class);
    protected CustomPanelAPI panel;
    protected InteractionDialogAPI dialog;
    protected CustomVisualDialogDelegate.DialogCallbacks callbacks;
    private PositionAPI pos;
    private List<ButtonAPI> allRuleButtons = new ArrayList<ButtonAPI>();
    private CheckBoxGroup presetCheckboxGroup = new CheckBoxGroup();
    private ButtonAPI presetSaveBtn;
    private ButtonAPI presetLoadBtn;
    private ButtonAPI confirmBtn;
    private ButtonAPI cancelBtn;
    private UNGP_SpecialistSettings.Difficulty difficulty;
    private List<UNGP_RulesManager.URule> pickedRules;
    private List<String> completedChallenges;
    private LabelAPI positiveRuleCount;
    private LabelAPI negativeRuleCount;
    private LabelAPI l_curCost;
    private LabelAPI l_curRuleCount;
    private UIRect positiveRuleSummaryContentSect;
    private UIRect negativeRuleSummaryContentSect;
    private UIRect challengeContentSect;
    private UIRect reasonUnmetSect;
    private Script onConfirm;
    private Script onCancel;
    private boolean isRuleInit = false;

    public UNGP_RulePickPanelPlugin(UNGP_SpecialistSettings.Difficulty difficulty, List<UNGP_RulesManager.URule> pickedRules, List<String> completedChallenges, Script onConfirm, Script onCancel) {
        this.difficulty = difficulty;
        this.pickedRules = pickedRules;
        this.completedChallenges = completedChallenges;
        this.onConfirm = onConfirm;
        this.onCancel = onCancel;
    }

    public static UNGP_RulePickPanelPlugin createPlugin(UNGP_SpecialistSettings.Difficulty difficulty, List<UNGP_RulesManager.URule> previousSelectedRules, List<String> completedChallenges, Script onConfirm, Script onCancel) {
        return new UNGP_RulePickPanelPlugin(difficulty, previousSelectedRules, completedChallenges, onConfirm, onCancel);
    }

    public void init(CustomPanelAPI panel, CustomVisualDialogDelegate.DialogCallbacks callbacks, InteractionDialogAPI dialog) {
        this.panel = panel;
        this.callbacks = callbacks;
        this.dialog = dialog;
        UNGP_ChallengeManager.setTemporaryCompletedChallenges(this.completedChallenges);
        this.createContent();
        CustomPanelAPI customPanel = panel.createCustomPanel(this.pos.getWidth(), this.pos.getHeight(), (CustomUIPanelPlugin)new UNGP_SpecialistBackgroundUI(0.8f));
        UNGP_SpecialistBackgroundUI.stopTicking();
        panel.addComponent((UIComponentAPI)customPanel);
        Global.getSoundPlayer().playCustomMusic(1, 1, "UNGP_rulepicker_bgm", true);
    }

    protected void createContent() {
        float panelWidth = this.pos.getWidth();
        float panelHeight = this.pos.getHeight();
        Color boarderColor = Misc.getDarkPlayerColor();
        float sectionHeadingHeight = 25.0f;
        List<UNGP_RulesManager.URule> allRulesCopy = UNGP_RulesManager.getAvailableRules(this.completedChallenges);
        ArrayList<UNGP_RulesManager.URule> positiveRules = new ArrayList<UNGP_RulesManager.URule>();
        ArrayList<UNGP_RulesManager.URule> negativeRules = new ArrayList<UNGP_RulesManager.URule>();
        for (UNGP_RulesManager.URule rule : allRulesCopy) {
            if (rule.isPositive()) {
                positiveRules.add(rule);
                continue;
            }
            negativeRules.add(rule);
        }
        positiveRules.sort(new UNGP_RulesManager.UNGP_RuleSorter());
        negativeRules.sort(new UNGP_RulesManager.UNGP_RuleSorter());
        UIRect parentPanelRect = new UIRect(0.0f, 0.0f, panelWidth, panelHeight);
        UIRect shrinkPanelRect = parentPanelRect.shrink(20.0f);
        UIRect[] temp = shrinkPanelRect.splitHorizontallyReverse(512.0f);
        UIRect ruleRect = temp[0];
        UIRect readMeAndDetailsRect = temp[1];
        temp = ruleRect.splitVertically(0.46f, 0.46f, 0.08f);
        UIRect positiveRuleRect = temp[0].shrink(5.0f);
        UIRect negativeRuleRect = temp[1].shrink(5.0f);
        UIRect presetRect = temp[2].shrink(5.0f);
        this.createRuleRect(ruleRect, positiveRuleRect, positiveRules, negativeRuleRect, negativeRules);
        presetRect.addBoarder(this.panel, boarderColor, 2.0f);
        temp = presetRect.shrink(10.0f).splitHorizontally(1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        for (int i = 0; i < 4; ++i) {
            UIRect presetItemRect = temp[i];
            TooltipMakerAPI presetItemTooltip = presetItemRect.beginTooltip(this.panel, false);
            String presetId = "preset_" + i;
            ButtonAPI presetItemCheckbox = presetItemTooltip.addCheckbox(presetItemRect.getWidth(), presetItemRect.getHeight(), Constants.rules_i18n.get("rule_preset_prefix") + " " + (i + 1), (Object)presetId, ButtonAPI.UICheckboxSize.SMALL, 0.0f);
            if (i == 0) {
                presetItemCheckbox.setChecked(true);
            }
            this.presetCheckboxGroup.addCheckBox(presetItemCheckbox, presetId);
            presetItemRect.addTooltip();
        }
        UIRect presetSaveRect = temp[4].shrink(10.0f);
        TooltipMakerAPI presetSaveTooltip = presetSaveRect.beginTooltip(this.panel, false);
        this.presetSaveBtn = presetSaveTooltip.addButton(Constants.rules_i18n.get("rule_preset_button_save"), (Object)"preset_save", presetSaveRect.getWidth(), presetSaveRect.getHeight(), 0.0f);
        presetSaveRect.addTooltip();
        UIRect presetLoadRect = temp[5].shrink(10.0f);
        TooltipMakerAPI presetLoadTooltip = presetLoadRect.beginTooltip(this.panel, false);
        this.presetLoadBtn = presetLoadTooltip.addButton(Constants.rules_i18n.get("rule_preset_button_load"), (Object)"preset_load", presetLoadRect.getWidth(), presetLoadRect.getHeight(), 0.0f);
        presetLoadRect.addTooltip();
        temp = readMeAndDetailsRect.splitVertically(0.35f, 0.5f, 0.15f);
        UIRect readMeSect = temp[0].shrink(10.0f);
        UIRect detailSect = temp[1];
        UIRect confirmSect = temp[2];
        readMeSect.addBoarder(this.panel, boarderColor, 2.0f);
        readMeSect = readMeSect.shrink(10.0f);
        TooltipMakerAPI readMeTooltip = readMeSect.beginTooltip(this.panel, true);
        TooltipMakerAPI imageTooltip = readMeTooltip.beginImageWithText(this.difficulty.spritePath, 64.0f);
        imageTooltip.setParaOrbitronLarge();
        if (this.difficulty == UNGP_SpecialistSettings.Difficulty.OMEGA) {
            imageTooltip.addPara(Constants.root_i18n.get("rulepick_level"), 0.0f, Misc.getNegativeHighlightColor(), this.difficulty.color, new String[]{this.difficulty.name});
        } else {
            imageTooltip.addPara(Constants.root_i18n.get("rulepick_level"), 0.0f, this.difficulty.color, new String[]{this.difficulty.name});
        }
        imageTooltip.setParaFontDefault();
        imageTooltip.setBulletedListMode("  - ");
        imageTooltip.addPara(Constants.rules_i18n.get("pick_rule_min_rule_count") + ": %s", 10.0f, Misc.getBasePlayerColor(), Misc.getHighlightColor(), new String[]{"" + this.difficulty.minRules});
        imageTooltip.addPara(Constants.rules_i18n.get("pick_rule_max_rule_count") + ": %s", 0.0f, Misc.getBasePlayerColor(), Misc.getHighlightColor(), new String[]{"" + this.difficulty.maxRules});
        imageTooltip.setBulletedListMode(null);
        readMeTooltip.addImageWithText(0.0f);
        readMeTooltip.setParaOrbitronVeryLarge();
        readMeTooltip.addPara(Constants.rules_i18n.get("pick_rule_basic"), Misc.getBasePlayerColor(), 10.0f);
        readMeTooltip.setParaOrbitronLarge();
        readMeTooltip.setBulletedListMode("  - ");
        readMeTooltip.addPara(Constants.rules_i18n.get("pick_rule_basic1"), 10.0f, UNGP_RulesManager.getPNColor(true), new String[]{UNGP_RulesManager.getPNRuleString(true)});
        readMeTooltip.addPara(Constants.rules_i18n.get("pick_rule_basic2"), 0.0f, UNGP_RulesManager.getPNColor(false), new String[]{UNGP_RulesManager.getPNRuleString(false)});
        readMeTooltip.addPara(Constants.rules_i18n.get("pick_rule_basic3"), 0.0f, UNGP_RulesManager.getGoldenColor(), new String[]{UNGP_RulesManager.getGoldenRuleString()});
        readMeTooltip.addPara(Constants.rules_i18n.get("pick_rule_basic4"), 0.0f, UNGP_RulesManager.getMilestoneColor(), new String[]{UNGP_RulesManager.getRuleTypeName(true, false, true), Constants.rules_i18n.get("challenge_name")});
        readMeTooltip.addPara(Constants.rules_i18n.get("pick_rule_basic5"), 0.0f, Misc.getHighlightColor(), new String[]{"0"});
        readMeTooltip.setBulletedListMode(null);
        readMeTooltip.setParaOrbitronVeryLarge();
        readMeTooltip.addPara(Constants.rules_i18n.get("pick_rule_challenge"), Misc.getBasePlayerColor(), 10.0f);
        readMeTooltip.setParaOrbitronLarge();
        readMeTooltip.setBulletedListMode("  - ");
        readMeTooltip.addPara(Constants.rules_i18n.get("pick_rule_challenge1"), 10.0f);
        readMeTooltip.addPara(Constants.rules_i18n.get("pick_rule_challenge2"), 0.0f, UNGP_SpecialistSettings.Difficulty.ALPHA.color, new String[]{UNGP_SpecialistSettings.Difficulty.ALPHA.name});
        readMeTooltip.setBulletedListMode(null);
        readMeSect.addTooltip();
        temp = detailSect.splitVerticallyReverse(100.0f);
        UIRect ruleSummaryRect = temp[0].shrink(10.0f);
        UIRect ruleConditionSect = temp[1].shrink(0.0f, 0.0f, 10.0f, 10.0f);
        ruleSummaryRect.addBoarder(this.panel, boarderColor, 2.0f);
        temp = ruleSummaryRect.splitVertically(0.6f, 0.4f);
        UIRect pnRulesSect = temp[0];
        UIRect challengeSect = temp[1];
        temp = pnRulesSect.splitHorizontally(0.5f, 0.5f);
        UIRect positiveRuleSummarySect = temp[0];
        UIRect negativeRuleSummarySect = temp[1];
        temp = positiveRuleSummarySect.splitVertically(sectionHeadingHeight);
        UIRect positiveRuleSummaryHeadingSect = temp[0];
        this.positiveRuleSummaryContentSect = temp[1].shrink(2.0f, 0.0f);
        TooltipMakerAPI positiveRuleSummaryHeadingTooltip = positiveRuleSummaryHeadingSect.beginTooltip(this.panel, false);
        positiveRuleSummaryHeadingSect.syncPositionSize(positiveRuleSummaryHeadingTooltip.addSectionHeading(UNGP_RulesManager.getPNRuleString(true), UNGP_RulesManager.getPNColor(true), boarderColor, Alignment.MID, 0.0f).getPosition());
        positiveRuleSummaryHeadingSect.addTooltip();
        temp = negativeRuleSummarySect.splitVertically(sectionHeadingHeight);
        UIRect negativeRuleSummaryHeadingSect = temp[0];
        this.negativeRuleSummaryContentSect = temp[1].shrink(2.0f, 0.0f);
        TooltipMakerAPI negativeRuleSummaryHeadingTooltip = negativeRuleSummaryHeadingSect.beginTooltip(this.panel, false);
        negativeRuleSummaryHeadingSect.syncPositionSize(negativeRuleSummaryHeadingTooltip.addSectionHeading(UNGP_RulesManager.getPNRuleString(false), UNGP_RulesManager.getPNColor(false), boarderColor, Alignment.MID, 0.0f).getPosition());
        negativeRuleSummaryHeadingSect.addTooltip();
        temp = challengeSect.splitVertically(sectionHeadingHeight);
        UIRect challengeHeadingSect = temp[0];
        this.challengeContentSect = temp[1].shrink(2.0f, 0.0f);
        TooltipMakerAPI challengeHeadingTooltip = challengeHeadingSect.beginTooltip(this.panel, false);
        challengeHeadingSect.syncPositionSize(challengeHeadingTooltip.addSectionHeading(Constants.rules_i18n.get("challenge_name"), UNGP_RulesManager.getMilestoneColor(), boarderColor, Alignment.MID, 0.0f).getPosition());
        challengeHeadingSect.addTooltip();
        ruleConditionSect.addBoarder(this.panel, boarderColor, 2.0f);
        temp = ruleConditionSect.splitVertically(sectionHeadingHeight);
        UIRect ruleConditionHeadingSect = temp[0];
        TooltipMakerAPI ruleConditionHeadingTooltip = ruleConditionHeadingSect.beginTooltip(this.panel, false);
        ruleConditionHeadingSect.syncPositionSize(ruleConditionHeadingTooltip.addSectionHeading(Constants.rules_i18n.get("pick_rule_condition_heading"), Alignment.MID, 0.0f).getPosition());
        ruleConditionHeadingSect.addTooltip();
        UIRect ruleConditionContentSect = temp[1].shrink(10.0f);
        TooltipMakerAPI ruleConditionTooltip = ruleConditionContentSect.beginTooltip(this.panel, false);
        ruleConditionTooltip.setParaOrbitronLarge();
        this.l_curCost = ruleConditionTooltip.addPara("", Misc.getBasePlayerColor(), 5.0f);
        this.l_curRuleCount = ruleConditionTooltip.addPara("", Misc.getBasePlayerColor(), 5.0f);
        ruleConditionTooltip.setParaFontDefault();
        ruleConditionContentSect.addTooltip();
        temp = confirmSect.splitHorizontally(0.6f, 0.4f);
        UIRect reasonSect = temp[0].shrink(10.0f);
        UIRect okOrNotSect = temp[1].shrink(10.0f);
        reasonSect.addBoarder(this.panel, boarderColor, 2.0f);
        temp = reasonSect.splitVertically(sectionHeadingHeight);
        UIRect reasonUnmetHeading = temp[0];
        TooltipMakerAPI reasonUnmetHeadingTooltip = reasonUnmetHeading.beginTooltip(this.panel, false);
        reasonUnmetHeading.syncPositionSize(reasonUnmetHeadingTooltip.addSectionHeading(Constants.rules_i18n.get("unmet_heading"), Alignment.MID, 0.0f).getPosition());
        reasonUnmetHeading.addTooltip();
        this.reasonUnmetSect = temp[1].shrink(10.0f);
        temp = okOrNotSect.splitVertically(0.5f, 0.5f);
        UIRect confirmBtnSect = temp[0].shrink(0.0f, 5.0f);
        TooltipMakerAPI confirmBtnTooltip = confirmBtnSect.beginTooltip(this.panel, false);
        confirmBtnTooltip.setButtonFontOrbitron20Bold();
        this.confirmBtn = confirmBtnTooltip.addButton(Constants.rules_i18n.get("pick_rule_confirm"), (Object)"confirm", confirmBtnSect.getWidth(), confirmBtnSect.getHeight(), 0.0f);
        confirmBtnSect.addTooltip();
        UIRect cancelBtnSect = temp[1].shrink(0.0f, 5.0f);
        TooltipMakerAPI cancelBtnTooltip = cancelBtnSect.beginTooltip(this.panel, false);
        cancelBtnTooltip.setButtonFontOrbitron20Bold();
        this.cancelBtn = cancelBtnTooltip.addButton(Constants.rules_i18n.get("pick_rule_cancel"), (Object)"cancel", cancelBtnSect.getWidth(), cancelBtnSect.getHeight(), 0.0f);
        this.cancelBtn.setShortcut(1, true);
        cancelBtnSect.addTooltip();
        if (!this.isRuleInit) {
            this.isRuleInit = true;
            for (ButtonAPI ruleButton : this.allRuleButtons) {
                UNGP_RulesManager.URule rule = (UNGP_RulesManager.URule)ruleButton.getCustomData();
                if (!this.pickedRules.contains(rule)) continue;
                ruleButton.setChecked(true);
            }
        }
        this.triggerPresetEvents(null);
        this.updateRuleThings();
    }

    private void createRuleRect(UIRect ruleRect, UIRect positiveRuleRect, List<UNGP_RulesManager.URule> positiveRules, UIRect negativeRuleRect, List<UNGP_RulesManager.URule> negativeRules) {
        float rulePadding = 10.0f;
        float ruleYPadding = rulePadding * 2.5f;
        int itemPerRow = (int)(ruleRect.getWidth() / (112.0f + rulePadding));
        UIRect[] temp = positiveRuleRect.splitVertically(32.0f);
        UIRect positiveRuleTitleRect = temp[0];
        UIRect positiveRuleContentRect = temp[1];
        TooltipMakerAPI positiveRuleTitleTooltip = positiveRuleTitleRect.beginTooltip(this.panel, false);
        TooltipMakerAPI positiveRuleTitleImageTooltip = positiveRuleTitleTooltip.beginImageWithText(UNGP_RulesManager.getRuleIconSpriteName(false, false, true), 16.0f);
        positiveRuleTitleImageTooltip.setParaOrbitronLarge();
        positiveRuleTitleImageTooltip.addPara(UNGP_RulesManager.getPNRuleString(true), UNGP_RulesManager.getPNColor(true), 0.0f);
        positiveRuleTitleTooltip.addImageWithText(0.0f);
        this.positiveRuleCount = positiveRuleTitleTooltip.createLabel("", Color.white);
        this.positiveRuleCount.setAlignment(Alignment.RMID);
        PositionAPI positiveRuleCountPos = positiveRuleTitleTooltip.addCustomDoNotSetPosition((UIComponentAPI)this.positiveRuleCount).getPosition();
        positiveRuleCountPos.setSize(positiveRuleTitleRect.getWidth() - 110.0f, positiveRuleTitleRect.getHeight());
        positiveRuleCountPos.inTL(0.0f, 0.0f);
        positiveRuleTitleTooltip.addButton(Constants.rules_i18n.get("pick_rule_clear"), (Object)"clear_positive_rules", Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Alignment.MID, CutStyle.BL_TR, 100.0f, positiveRuleTitleRect.getHeight() * 0.8f, 0.0f).getPosition().inTL(positiveRuleTitleRect.getWidth() - 100.0f, 0.0f);
        positiveRuleTitleRect.addTooltip();
        TooltipMakerAPI positiveRuleContentTooltip = positiveRuleContentRect.beginTooltip(this.panel, true);
        for (int i = 0; i < positiveRules.size(); ++i) {
            UNGP_RulesManager.URule curRule = positiveRules.get(i);
            UNGP_RulePickItemPanelPlugin plugin = new UNGP_RulePickItemPanelPlugin(curRule, new UNGP_RulePickItemPanelPlugin.ButtonPressListener(){

                @Override
                public void notifyPressed(ButtonAPI button) {
                    LOGGER.info((Object)("Pressed:" + button.getCustomData()));
                    UNGP_RulePickPanelPlugin.this.buttonPressed(button);
                }
            });
            CustomPanelAPI custom = Global.getSettings().createCustom(112.0f, 112.0f, (CustomUIPanelPlugin)plugin);
            plugin.init(custom);
            int x_index = i % itemPerRow;
            int y_index = i / itemPerRow;
            float itemX = (float)x_index * 112.0f + (float)x_index * rulePadding;
            float itemY = (float)y_index * 112.0f + (float)y_index * ruleYPadding;
            positiveRuleContentTooltip.addCustomDoNotSetPosition((UIComponentAPI)custom).getPosition().inTL(itemX, itemY);
            positiveRuleContentTooltip.addSpacer(1.0f / (float)itemPerRow * (112.0f + ruleYPadding));
            this.allRuleButtons.add(plugin.getLinkedButton());
        }
        positiveRuleContentTooltip.addSpacer(112.0f);
        positiveRuleContentRect.addTooltip();
        temp = negativeRuleRect.splitVertically(32.0f);
        UIRect negativeRuleTitleRect = temp[0];
        UIRect negativeRuleContentRect = temp[1];
        TooltipMakerAPI negativeRuleTitleTooltip = negativeRuleTitleRect.beginTooltip(this.panel, false);
        TooltipMakerAPI negativeRuleTitleImageTooltip = negativeRuleTitleTooltip.beginImageWithText(UNGP_RulesManager.getRuleIconSpriteName(false, false, false), 16.0f);
        negativeRuleTitleImageTooltip.setParaOrbitronLarge();
        negativeRuleTitleImageTooltip.addPara(UNGP_RulesManager.getPNRuleString(false), UNGP_RulesManager.getPNColor(false), 0.0f);
        negativeRuleTitleTooltip.addImageWithText(0.0f);
        this.negativeRuleCount = negativeRuleTitleTooltip.createLabel("", Color.white);
        this.negativeRuleCount.setAlignment(Alignment.RMID);
        PositionAPI negativeRuleCountPos = negativeRuleTitleTooltip.addCustomDoNotSetPosition((UIComponentAPI)this.negativeRuleCount).getPosition();
        negativeRuleCountPos.setSize(negativeRuleTitleRect.getWidth() - 110.0f, negativeRuleTitleRect.getHeight());
        negativeRuleCountPos.inTL(0.0f, 0.0f);
        negativeRuleTitleTooltip.addButton(Constants.rules_i18n.get("pick_rule_clear"), (Object)"clear_negative_rules", Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Alignment.MID, CutStyle.BL_TR, 100.0f, negativeRuleTitleRect.getHeight() * 0.8f, 0.0f).getPosition().inTL(negativeRuleTitleRect.getWidth() - 100.0f, 0.0f);
        negativeRuleTitleRect.addTooltip();
        TooltipMakerAPI negativeRuleContentTooltip = negativeRuleContentRect.beginTooltip(this.panel, true);
        for (int i = 0; i < negativeRules.size(); ++i) {
            UNGP_RulesManager.URule curRule = negativeRules.get(i);
            UNGP_RulePickItemPanelPlugin plugin = new UNGP_RulePickItemPanelPlugin(curRule, new UNGP_RulePickItemPanelPlugin.ButtonPressListener(){

                @Override
                public void notifyPressed(ButtonAPI button) {
                    UNGP_RulePickPanelPlugin.this.buttonPressed(button);
                }
            });
            CustomPanelAPI custom = Global.getSettings().createCustom(112.0f, 112.0f, (CustomUIPanelPlugin)plugin);
            plugin.init(custom);
            int x_index = i % itemPerRow;
            int y_index = i / itemPerRow;
            float itemX = (float)x_index * 112.0f + (float)x_index * rulePadding;
            float itemY = (float)y_index * 112.0f + (float)y_index * ruleYPadding;
            negativeRuleContentTooltip.addCustomDoNotSetPosition((UIComponentAPI)custom).getPosition().inTL(itemX, itemY);
            negativeRuleContentTooltip.addSpacer(1.0f / (float)itemPerRow * (112.0f + ruleYPadding));
            this.allRuleButtons.add(plugin.getLinkedButton());
        }
        negativeRuleContentTooltip.addSpacer(112.0f);
        negativeRuleContentRect.addTooltip();
    }

    public void positionChanged(PositionAPI position) {
        this.pos = position;
    }

    public void renderBelow(float alphaMult) {
        if (this.pos != null && this.difficulty != null) {
            GL11.glPushMatrix();
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            Color darkerColor = Misc.scaleColor((Color)this.difficulty.color, (float)0.1f);
            GL11.glBegin((int)7);
            GL11.glColor3ub((byte)((byte)darkerColor.getRed()), (byte)((byte)darkerColor.getGreen()), (byte)((byte)darkerColor.getBlue()));
            GL11.glVertex2f((float)this.pos.getX(), (float)(this.pos.getY() + this.pos.getHeight()));
            GL11.glVertex2f((float)(this.pos.getX() + this.pos.getWidth()), (float)(this.pos.getY() + this.pos.getHeight()));
            GL11.glColor3ub((byte)0, (byte)0, (byte)0);
            GL11.glVertex2f((float)(this.pos.getX() + this.pos.getWidth()), (float)this.pos.getY());
            GL11.glVertex2f((float)this.pos.getX(), (float)this.pos.getY());
            GL11.glEnd();
            GL11.glPopMatrix();
        }
    }

    public void buttonPressed(Object buttonId) {
        String btnId;
        LOGGER.info((Object)("Pressed:" + buttonId));
        this.triggerPresetEvents(buttonId);
        switch (btnId = buttonId.toString()) {
            case "clear_positive_rules": {
                this.resetSpecificRuleButtons(true);
                break;
            }
            case "clear_negative_rules": {
                this.resetSpecificRuleButtons(false);
                break;
            }
        }
        this.triggerRuleEvents(null);
        switch (btnId) {
            case "confirm": {
                this.pickedRules.clear();
                for (ButtonAPI ruleButton : this.allRuleButtons) {
                    UNGP_RulesManager.URule rule;
                    if (!ruleButton.isChecked() || (rule = (UNGP_RulesManager.URule)ruleButton.getCustomData()) == null) continue;
                    this.pickedRules.add(rule);
                }
                this.onConfirm.run();
                this.exit();
                break;
            }
            case "cancel": {
                this.exit();
                break;
            }
        }
    }

    public void buttonPressed(ButtonAPI ruleButton) {
        this.triggerRuleEvents(ruleButton);
    }

    private void resetAllRuleButtons() {
        for (ButtonAPI ruleButton : this.allRuleButtons) {
            ruleButton.setChecked(false);
            ruleButton.setEnabled(true);
        }
    }

    private void resetSpecificRuleButtons(boolean isPositive) {
        for (ButtonAPI ruleButton : this.allRuleButtons) {
            UNGP_RulesManager.URule rule = (UNGP_RulesManager.URule)ruleButton.getCustomData();
            if (rule == null || rule.isPositive() != isPositive) continue;
            ruleButton.setChecked(false);
            ruleButton.setEnabled(true);
        }
    }

    private void triggerPresetEvents(Object buttonId) {
        this.presetCheckboxGroup.updateCheck();
        String presetSlot = (String)this.presetCheckboxGroup.getCheckedValue();
        if (presetSlot != null) {
            List<UNGP_RulesManager.URule> rules;
            this.presetLoadBtn.setEnabled(UNGP_RulePickPresetManager.isPresetExists(presetSlot));
            if ("preset_save".equals(buttonId)) {
                ArrayList<UNGP_RulesManager.URule> pickedRules = new ArrayList<UNGP_RulesManager.URule>();
                for (ButtonAPI ruleButton : this.allRuleButtons) {
                    UNGP_RulesManager.URule rule;
                    if (!ruleButton.isChecked() || (rule = (UNGP_RulesManager.URule)ruleButton.getCustomData()) == null) continue;
                    pickedRules.add(rule);
                }
                UNGP_RulePickPresetManager.save(presetSlot, pickedRules);
            } else if ("preset_load".equals(buttonId) && !(rules = UNGP_RulePickPresetManager.load(presetSlot)).isEmpty()) {
                this.resetAllRuleButtons();
                for (ButtonAPI ruleButton : this.allRuleButtons) {
                    UNGP_RulesManager.URule rule = (UNGP_RulesManager.URule)ruleButton.getCustomData();
                    if (rule == null) continue;
                    ruleButton.setChecked(rules.contains(rule));
                }
                this.triggerRuleEvents(null);
                this.triggerPresetEvents(null);
            }
        }
    }

    private void triggerRuleEvents(ButtonAPI pressedRuleButton) {
        if (pressedRuleButton != null) {
            this.updateGoldenRuleButtonStatus(pressedRuleButton);
        } else {
            ButtonAPI checkedGoldenBtn = null;
            for (ButtonAPI ruleButton : this.allRuleButtons) {
                UNGP_RulesManager.URule rule = (UNGP_RulesManager.URule)ruleButton.getCustomData();
                if (!ruleButton.isChecked() || rule == null || !rule.isGolden()) continue;
                checkedGoldenBtn = ruleButton;
                break;
            }
            if (checkedGoldenBtn != null) {
                this.updateGoldenRuleButtonStatus(checkedGoldenBtn);
            }
        }
        this.updateRuleThings();
    }

    private void updateRuleThings() {
        int positiveCount = 0;
        int negativeCount = 0;
        int totalCount = 0;
        int cost = 0;
        ArrayList<UNGP_RulesManager.URule> curPickedRules = new ArrayList<UNGP_RulesManager.URule>();
        this.positiveRuleSummaryContentSect.removeLatestSubPanel();
        this.negativeRuleSummaryContentSect.removeLatestSubPanel();
        this.reasonUnmetSect.removeLatestSubPanel();
        CustomPanelAPI positivePanel = this.positiveRuleSummaryContentSect.createSubPanel(this.panel, null).getPanel();
        CustomPanelAPI negativePanel = this.negativeRuleSummaryContentSect.createSubPanel(this.panel, null).getPanel();
        CustomPanelAPI reasonUnmetPanel = this.reasonUnmetSect.createSubPanel(this.panel, null).getPanel();
        TooltipMakerAPI positiveTooltip = positivePanel.createUIElement(this.positiveRuleSummaryContentSect.getWidth(), this.positiveRuleSummaryContentSect.getHeight(), true);
        TooltipMakerAPI negativeTooltip = negativePanel.createUIElement(this.negativeRuleSummaryContentSect.getWidth(), this.negativeRuleSummaryContentSect.getHeight(), true);
        TooltipMakerAPI reasonUnmetTooltip = reasonUnmetPanel.createUIElement(this.reasonUnmetSect.getWidth(), this.reasonUnmetSect.getHeight(), true);
        positiveTooltip.addSpacer(5.0f);
        negativeTooltip.addSpacer(5.0f);
        for (ButtonAPI ruleButton : this.allRuleButtons) {
            UNGP_RulesManager.URule rule;
            if (!ruleButton.isChecked() || (rule = (UNGP_RulesManager.URule)ruleButton.getCustomData()) == null) continue;
            if (rule.isPositive()) {
                ++positiveCount;
                imageMaker = positiveTooltip.beginImageWithText(rule.getSpritePath(), 32.0f);
                imageMaker.addPara(rule.getName(), rule.getCorrectColor(), 0.0f);
                rule.addShortDesc((TooltipMakerAPI)imageMaker, 0.0f);
                positiveTooltip.addImageWithText(2.0f);
            } else {
                ++negativeCount;
                imageMaker = negativeTooltip.beginImageWithText(rule.getSpritePath(), 32.0f);
                imageMaker.addPara(rule.getName(), rule.getCorrectColor(), 0.0f);
                rule.addShortDesc((TooltipMakerAPI)imageMaker, 0.0f);
                negativeTooltip.addImageWithText(2.0f);
            }
            cost += rule.getCost();
            curPickedRules.add(rule);
        }
        positivePanel.addUIElement(positiveTooltip);
        negativePanel.addUIElement(negativeTooltip);
        totalCount = positiveCount + negativeCount;
        List<UNGP_ChallengeInfo> runnableChallenges = UNGP_ChallengeManager.getRunnableChallenges(this.difficulty, curPickedRules, this.completedChallenges);
        this.challengeContentSect.removeLatestSubPanel();
        if (!runnableChallenges.isEmpty()) {
            challengeCP = this.challengeContentSect.createSubPanel(this.panel, null).getPanel();
            challengeTooltip = challengeCP.createUIElement(this.challengeContentSect.getWidth(), this.challengeContentSect.getHeight(), true);
            challengeTooltip.addSpacer(5.0f);
            for (UNGP_ChallengeInfo runnableChallenge : runnableChallenges) {
                runnableChallenge.createTooltip(challengeTooltip, 0.0f, null);
            }
            challengeCP.addUIElement(challengeTooltip);
        } else if (!UNGP_ChallengeManager.isDifficultyEnough(this.difficulty)) {
            challengeCP = this.challengeContentSect.createSubPanel(this.panel, null).getPanel();
            challengeTooltip = challengeCP.createUIElement(this.challengeContentSect.getWidth(), this.challengeContentSect.getHeight(), true);
            challengeTooltip.setParaOrbitronLarge();
            challengeTooltip.addPara(Constants.rules_i18n.format("challenge_tip_difficultyNotMeet", UNGP_SpecialistSettings.Difficulty.ALPHA.name, UNGP_SpecialistSettings.Difficulty.OMEGA.name), Misc.getNegativeHighlightColor(), 10.0f).setAlignment(Alignment.MID);
            challengeCP.addUIElement(challengeTooltip);
        }
        this.positiveRuleCount.setText(Constants.rules_i18n.format("pick_rule_count", "" + positiveCount, UNGP_RulesManager.getPNRuleString(true)));
        this.positiveRuleCount.setHighlight(new String[]{"" + positiveCount, UNGP_RulesManager.getPNRuleString(true)});
        this.positiveRuleCount.setHighlightColors(new Color[]{Misc.getHighlightColor(), UNGP_RulesManager.getPNColor(true)});
        this.negativeRuleCount.setText(Constants.rules_i18n.format("pick_rule_count", "" + negativeCount, UNGP_RulesManager.getPNRuleString(false)));
        this.negativeRuleCount.setHighlight(new String[]{"" + negativeCount, UNGP_RulesManager.getPNRuleString(false)});
        this.negativeRuleCount.setHighlightColors(new Color[]{Misc.getHighlightColor(), UNGP_RulesManager.getPNColor(false)});
        this.l_curCost.setText(String.format(Constants.rules_i18n.get("pick_rule_cur_cost") + ": %s", "" + cost));
        this.l_curCost.setHighlight(new String[]{"" + cost});
        this.l_curCost.setHighlightColor(cost >= 0 ? Misc.getPositiveHighlightColor() : Misc.getNegativeHighlightColor());
        Object extraString = "";
        if (totalCount < this.difficulty.minRules) {
            extraString = " ( < " + this.difficulty.minRules + " )";
        }
        if (totalCount > this.difficulty.maxRules) {
            extraString = " ( >" + this.difficulty.maxRules + " )";
        }
        String resultString = totalCount + (String)extraString;
        this.l_curRuleCount.setText(String.format(Constants.rules_i18n.get("pick_rule_cur_rule_count") + ": %s", resultString));
        this.l_curRuleCount.setHighlight(new String[]{resultString});
        this.l_curRuleCount.setHighlightColor(((String)extraString).isEmpty() ? Misc.getPositiveHighlightColor() : Misc.getNegativeHighlightColor());
        boolean isConfirmBtnEnabled = true;
        reasonUnmetTooltip.setParaOrbitronLarge();
        for (UNGP_RulePickHelper.UnmetReason unmetReason : UNGP_RulePickHelper.generateUnmetReasons(curPickedRules, this.difficulty)) {
            isConfirmBtnEnabled = false;
            reasonUnmetTooltip.addPara(Constants.rules_i18n.get(unmetReason.getType().getI18nKey()), Misc.getNegativeHighlightColor(), 5.0f);
        }
        if (isConfirmBtnEnabled) {
            reasonUnmetTooltip.addPara(Constants.rules_i18n.get("unmet_none"), Misc.getPositiveHighlightColor(), 5.0f);
        }
        reasonUnmetPanel.addUIElement(reasonUnmetTooltip);
        this.confirmBtn.setEnabled(isConfirmBtnEnabled);
    }

    private void updateGoldenRuleButtonStatus(ButtonAPI pressedRuleButton) {
        block4: {
            UNGP_RulesManager.URule pressedRule = (UNGP_RulesManager.URule)pressedRuleButton.getCustomData();
            if (!pressedRule.isGolden()) break block4;
            if (pressedRuleButton.isChecked()) {
                for (ButtonAPI button : this.allRuleButtons) {
                    UNGP_RulesManager.URule rule = (UNGP_RulesManager.URule)button.getCustomData();
                    if (rule == null || pressedRule == rule || !rule.isGolden()) continue;
                    button.setChecked(false);
                    button.setEnabled(false);
                }
            } else {
                for (ButtonAPI button : this.allRuleButtons) {
                    UNGP_RulesManager.URule rule = (UNGP_RulesManager.URule)button.getCustomData();
                    if (rule == null || pressedRule == rule || !rule.isGolden()) continue;
                    button.setChecked(false);
                    button.setEnabled(true);
                }
            }
        }
    }

    public void processInput(List<InputEventAPI> events) {
        if (this.pos == null) {
            return;
        }
    }

    public void exit() {
        this.callbacks.dismissDialog();
        UNGP_ChallengeManager.getTemporaryCompletedChallenges().clear();
        Global.getSoundPlayer().playCustomMusic(1, 1, null);
        if (this.onCancel != null) {
            this.onCancel.run();
        }
    }
}

