/*
 * Decompiled with CFR 0.152.
 */
package ungp.scripts.campaign.ui;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCustomUIPanelPlugin;
import com.fs.starfarer.api.campaign.CustomUIPanelPlugin;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.CustomPanelAPI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.PositionAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.opengl.GL11;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;

public class UNGP_RulePickItemPanelPlugin
extends BaseCustomUIPanelPlugin {
    public static final float ITEM_SIZE = 112.0f;
    public static final float RULE_ICON_SIZE = 64.0f;
    private PositionAPI p;
    private UNGP_RulesManager.URule rule;
    private CustomPanelAPI panel;
    private ButtonAPI linkedButton;
    private ButtonPressListener pressListener;
    private SpriteAPI ruleSprite;
    protected FaderUtil highlightBlinker = new FaderUtil(0.0f, 0.25f, 0.25f, true, true);

    public UNGP_RulePickItemPanelPlugin(UNGP_RulesManager.URule rule, ButtonPressListener pressListener) {
        this.rule = rule;
        this.ruleSprite = Global.getSettings().getSprite(rule.getSpritePath());
        this.pressListener = pressListener;
    }

    public void init(CustomPanelAPI panel) {
        this.panel = panel;
        TooltipMakerAPI element = panel.createUIElement(this.p.getWidth(), this.p.getHeight(), false);
        Color borderAndDarkColor = Misc.scaleColorOnly((Color)this.rule.getCorrectColor(), (float)0.2f);
        this.linkedButton = element.addAreaCheckbox("", (Object)this.rule.getId(), this.rule.getCorrectColor(), borderAndDarkColor, Misc.getBrightPlayerColor(), this.p.getWidth(), this.p.getHeight(), 0.0f);
        this.linkedButton.getPosition().setXAlignOffset(-0.5f);
        this.linkedButton.setCustomData((Object)this.rule);
        this.linkedButton.setButtonPressedSound(null);
        if (this.rule.isPositive()) {
            element.addTooltipToPrevious(UNGP_RulesManager.createRuleItemTooltip(this.rule), TooltipMakerAPI.TooltipLocation.BELOW);
        } else {
            element.addTooltipToPrevious(UNGP_RulesManager.createRuleItemTooltip(this.rule), TooltipMakerAPI.TooltipLocation.ABOVE);
        }
        panel.addUIElement(element);
        TooltipMakerAPI labelElement = panel.createUIElement(this.p.getWidth(), this.p.getHeight(), false);
        labelElement.addSpacer(this.p.getHeight() * 0.08f);
        LabelAPI labelAPI = labelElement.addPara(this.rule.getName(), this.rule.getCorrectColor(), 0.0f);
        labelAPI.setAlignment(Alignment.MID);
        panel.addUIElement(labelElement);
        TooltipMakerAPI costElement = panel.createUIElement(this.p.getWidth(), 22.0f, false);
        costElement.setParaOrbitronLarge();
        costElement.addPara(this.rule.getCostString(), this.rule.getCostColor(), 0.0f).setAlignment(Alignment.MID);
        panel.addUIElement(costElement);
        this.highlightBlinker.fadeIn();
    }

    public static CustomPanelAPI createCustom(UNGP_RulesManager.URule rule, ButtonPressListener pressListener) {
        UNGP_RulePickItemPanelPlugin plugin = new UNGP_RulePickItemPanelPlugin(rule, pressListener);
        CustomPanelAPI panel = Global.getSettings().createCustom(112.0f, 112.0f, (CustomUIPanelPlugin)plugin);
        plugin.init(panel);
        return panel;
    }

    public void positionChanged(PositionAPI position) {
        this.p = position;
    }

    public void advance(float amount) {
        this.highlightBlinker.advance(amount * 0.2f);
    }

    public void render(float alphaMult) {
        boolean isGoldenOrMilestone;
        if (this.p == null) {
            return;
        }
        boolean isEnabled = this.linkedButton.isEnabled();
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        if (!isEnabled) {
            this.ruleSprite.setColor(Color.gray);
        } else {
            this.ruleSprite.setColor(Color.white);
        }
        this.ruleSprite.setAlphaMult(alphaMult);
        this.ruleSprite.setSize(64.0f, 64.0f);
        float cx = this.p.getX() + this.p.getWidth() * 0.5f;
        float cy = this.p.getY() + this.p.getHeight() * 0.5f;
        this.ruleSprite.renderAtCenter(cx, cy);
        boolean bl = isGoldenOrMilestone = this.rule.isGolden() || this.rule.isMilestone();
        if (isGoldenOrMilestone && isEnabled && this.highlightBlinker.isFadingIn()) {
            float factor = this.highlightBlinker.getBrightness();
            this.ruleSprite.setColor(UNGP_RulesManager.getGoldenColor());
            this.ruleSprite.setAdditiveBlend();
            float tmp_h = 0.1f;
            float tmp_y = 1.0f + tmp_h - (1.0f + 2.0f * tmp_h) * factor;
            float th = tmp_h;
            float ty = MathUtils.clamp((float)tmp_y, (float)0.0f, (float)1.0f);
            if (tmp_y > 1.0f - tmp_h) {
                float f = th = tmp_y > 1.0f ? 0.0f : 1.0f - tmp_y;
            }
            if (tmp_y < 0.0f) {
                th = tmp_h + tmp_y;
            }
            this.ruleSprite.renderRegionAtCenter(cx, cy, 0.0f, ty, 1.0f, th);
        }
        GL11.glPopMatrix();
    }

    public void renderBelow(float alphaMult) {
        if (this.p == null) {
            return;
        }
    }

    public ButtonAPI getLinkedButton() {
        return this.linkedButton;
    }

    public void buttonPressed(Object buttonId) {
        String soundId = this.rule.isMilestone() ? (this.linkedButton.isChecked() ? "ui_milestone_pickup" : "ui_milestone_drop") : (this.rule.isGolden() ? (this.linkedButton.isChecked() ? "ui_golden_pickup" : "ui_golden_drop") : (this.rule.isPositive() ? (this.linkedButton.isChecked() ? "ui_positive_pickup" : "ui_positive_drop") : (this.linkedButton.isChecked() ? "ui_negative_pickup" : "ui_negative_drop")));
        Global.getSoundPlayer().playUISound(soundId, 1.0f, 1.0f);
        this.pressListener.notifyPressed(this.linkedButton);
    }

    public static interface ButtonPressListener {
        public void notifyPressed(ButtonAPI var1);
    }
}

