/*
 * Decompiled with CFR 0.152.
 */
package ungp.scripts.campaign.ui;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCustomUIPanelPlugin;
import com.fs.starfarer.api.campaign.CustomUIPanelPlugin;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.ui.CustomPanelAPI;
import com.fs.starfarer.api.ui.PositionAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.UIComponentAPI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.lazywizard.lazylib.FastTrig;
import org.lwjgl.opengl.GL11;

public class UNGP_InteractionPanelPlugin
extends BaseCustomUIPanelPlugin {
    private CustomPanelAPI customPanel;
    private PositionAPI pos;
    private float elapsed = 0.0f;
    private float lastYOffset = 0.0f;
    private SpriteAPI sprite = Global.getSettings().getSprite("illustrations", "UNGP_logo");
    private List<UIComponentAPI> currentComponents = new ArrayList<UIComponentAPI>();

    public void update(VisualPanelAPI visualPanel) {
        this.clearUIComponents();
        this.lastYOffset = 0.0f;
        this.customPanel = visualPanel.showCustomPanel(400.0f, 300.0f, (CustomUIPanelPlugin)this);
    }

    public TooltipMakerAPI beginTooltip(float height, boolean withScroller) {
        TooltipMakerAPI tooltip = this.customPanel.createUIElement(this.pos.getWidth(), height, withScroller);
        this.currentComponents.add((UIComponentAPI)tooltip);
        return tooltip;
    }

    public void addTooltip(float height, TooltipMakerAPI tooltip) {
        this.customPanel.addUIElement(tooltip).inTL(0.0f, this.lastYOffset);
        this.lastYOffset += height;
    }

    public void clearUIComponents() {
        for (UIComponentAPI component : this.currentComponents) {
            this.customPanel.removeComponent(component);
        }
        this.currentComponents.clear();
    }

    public void positionChanged(PositionAPI position) {
        this.pos = position;
    }

    public void renderBelow(float alphaMult) {
    }

    private void drawBorder(float alphaMult) {
        float x = this.pos.getX();
        float y = this.pos.getY();
        float w = this.pos.getWidth();
        float h = this.pos.getHeight();
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Color color = Color.cyan;
        GL11.glColor4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)((double)alphaMult * (0.75 + FastTrig.cos((double)(-this.elapsed)) * 0.25))));
        GL11.glBegin((int)2);
        GL11.glVertex2f((float)x, (float)y);
        GL11.glVertex2f((float)(x + w), (float)y);
        GL11.glVertex2f((float)(x + w), (float)(y + h));
        GL11.glVertex2f((float)x, (float)(y + h));
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public void render(float alphaMult) {
        if (!this.currentComponents.isEmpty()) {
            return;
        }
        this.sprite.setAlphaMult(alphaMult);
        float centerX = this.pos.getCenterX();
        float centerY = this.pos.getCenterY();
        this.sprite.renderAtCenter(centerX, centerY);
    }

    public void advance(float amount) {
        this.elapsed += amount;
    }

    public void processInput(List<InputEventAPI> events) {
    }
}

