/*
 * Decompiled with CFR 0.152.
 */
package ungp.scripts.campaign.ui;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.BaseCustomDialogDelegate;
import com.fs.starfarer.api.campaign.BaseStoryPointActionDelegate;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CoreUITabId;
import com.fs.starfarer.api.campaign.CustomDialogDelegate;
import com.fs.starfarer.api.campaign.CustomUIPanelPlugin;
import com.fs.starfarer.api.campaign.CustomVisualDialogDelegate;
import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.StoryPointActionDelegate;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.CustomPanelAPI;
import com.fs.starfarer.api.ui.PositionAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ungp.api.backgrounds.UNGP_BackgroundPluginAPI;
import ungp.api.saves.UNGP_DataSaverAPI;
import ungp.api.saves.UNGP_DataSaverSettingEntryAPI;
import ungp.impl.saves.UNGP_BlueprintsDataSaver;
import ungp.impl.saves.UNGP_CreditsDataSaver;
import ungp.scripts.campaign.UNGP_InGameData;
import ungp.scripts.campaign.UNGP_Settings;
import ungp.scripts.campaign.background.UNGP_Background;
import ungp.scripts.campaign.background.UNGP_BackgroundManager;
import ungp.scripts.campaign.inherit.UNGP_InheritData;
import ungp.scripts.campaign.inherit.UNGP_InheritManager;
import ungp.scripts.campaign.intel.UNGP_BackgroundIntel;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeInfo;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeManager;
import ungp.scripts.campaign.specialist.intel.UNGP_ChallengeIntel;
import ungp.scripts.campaign.specialist.intel.UNGP_SpecialistIntel;
import ungp.scripts.campaign.specialist.rules.UNGP_RulePickHelper;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;
import ungp.scripts.campaign.ui.UNGP_InteractionPanelPlugin;
import ungp.scripts.campaign.ui.UNGP_RulePickPanelDelegate;
import ungp.scripts.campaign.ui.UNGP_RulePickPanelPlugin;
import ungp.scripts.ui.CheckBoxGroup;
import ungp.scripts.ui.HorizontalButtonGroup;
import ungp.scripts.ui.SettingEntry;
import ungp.scripts.utils.Constants;
import ungp.scripts.utils.UNGP_Feedback;

public class UNGP_InteractionDialog
implements InteractionDialogPlugin {
    private InteractionDialogAPI dialog;
    private TextPanelAPI textPanel;
    private OptionPanelAPI options;
    private VisualPanelAPI visual;
    private UNGP_InteractionPanelPlugin uiPanelPlugin;
    private UNGP_InGameData inGameData;
    private boolean onlyDefaultSlot;
    private UNGP_InheritData pickedInheritData;
    private OptionID choseInheritSlotOptionID = null;
    private UNGP_InheritData pregenInheritData;
    private boolean isSpecialistMode = false;
    private InheritSettingEntry<UNGP_SpecialistSettings.Difficulty> settingEntry_difficulty = new InheritSettingEntry<UNGP_SpecialistSettings.Difficulty>(null, UNGP_SpecialistSettings.Difficulty.values().length + 1){

        @Override
        public void initParams(int optionSize) {
            this.entryTitle = Constants.root_i18n.get("hardmodeLevel");
            this.entryTitleColor = Misc.getNegativeHighlightColor();
            for (int i = 0; i < optionSize; ++i) {
                UNGP_SpecialistSettings.Difficulty difficulty;
                if (i == 0) {
                    difficulty = null;
                    this.optionNames[i] = "/";
                    this.optionBaseColor[i] = Misc.getBasePlayerColor();
                    this.optionDarkColor[i] = Misc.getDarkPlayerColor();
                    this.optionBrightColor[i] = Misc.getBrightPlayerColor();
                } else {
                    difficulty = UNGP_SpecialistSettings.Difficulty.values()[i - 1];
                    this.optionNames[i] = difficulty.name;
                    this.optionBaseColor[i] = difficulty.color;
                    this.optionDarkColor[i] = difficulty.color.darker();
                    this.optionBrightColor[i] = difficulty.color.brighter();
                }
                this.optionValues[i] = difficulty;
            }
        }

        @Override
        protected void addTipToOption(TooltipMakerAPI tooltip, Object option) {
            UNGP_SpecialistSettings.Difficulty difficulty = (UNGP_SpecialistSettings.Difficulty)((Object)option);
            tooltip.addTooltipToPrevious((TooltipMakerAPI.TooltipCreator)new DifficultyTooltipCreator(difficulty), TooltipMakerAPI.TooltipLocation.BELOW);
        }
    };
    private List<UNGP_RulesManager.URule> pickedRules = new ArrayList<UNGP_RulesManager.URule>();
    private UNGP_Background pickedBackground;
    private CheckBoxGroup backgroundCheckBoxGroup;

    public UNGP_InteractionDialog(UNGP_InGameData inGameData) {
        this.inGameData = inGameData;
    }

    public void init(InteractionDialogAPI dialog) {
        this.dialog = dialog;
        dialog.setPromptText("");
        dialog.setBackgroundDimAmount(0.4f);
        this.textPanel = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.visual = dialog.getVisualPanel();
        this.pregenInheritData = UNGP_InheritData.createInheritData(this.inGameData);
        this.onlyDefaultSlot = UNGP_InheritManager.loadAllSlots();
        this.uiPanelPlugin = new UNGP_InteractionPanelPlugin();
        this.uiPanelPlugin.update(this.visual);
        this.initMenu();
        dialog.setOptionOnEscape(null, (Object)OptionID.LEAVE);
    }

    private void initMenu() {
        this.textPanel.addPara(Constants.root_i18n.get("menu"));
        this.options.addOption(Constants.root_i18n.get("checkInherit"), (Object)OptionID.CHECK_INHERIT_SLOTS);
        this.options.addOption(Constants.root_i18n.get("checkRecord"), (Object)OptionID.CHECK_RECORD_SLOTS);
        if (!this.inGameData.isInherited() && this.inGameData.isPassedInheritTime()) {
            this.textPanel.addPara(Constants.root_i18n.get("hasPassedTime"), Misc.getNegativeHighlightColor());
        }
        if (!this.inGameData.couldStartRecord()) {
            this.options.setEnabled((Object)OptionID.CHECK_RECORD_SLOTS, false);
            if (this.inGameData.isRecorded()) {
                this.textPanel.addPara(Constants.root_i18n.get("hasRecorded"), Misc.getNegativeHighlightColor());
            }
            if (!UNGP_Settings.reachMaxLevel()) {
                this.textPanel.addPara(Constants.root_i18n.get("notMaxLevel"), Misc.getNegativeHighlightColor());
            }
        }
        TooltipMakerAPI toRecordInfo = this.textPanel.beginTooltip();
        UNGP_SpecialistSettings.Difficulty difficulty = null;
        if (this.inGameData.isHardMode()) {
            difficulty = this.inGameData.getDifficulty();
        }
        this.pregenInheritData.addRecordTooltip(toRecordInfo, difficulty);
        this.textPanel.addTooltip();
        this.options.addOption(Constants.root_i18n.get("help"), (Object)OptionID.HELP);
        this.addLeaveButton();
    }

    private void optionSelectedChooseInherit(OptionID option) {
        this.pickedInheritData = UNGP_InheritManager.getDataFromSlot(this.getSlotIdByOption(option));
        Color nC = Misc.getNegativeHighlightColor();
        if (this.pickedInheritData != null) {
            this.choseInheritSlotOptionID = option;
            TooltipMakerAPI inheritDataInfo = this.textPanel.beginTooltip();
            this.pickedInheritData.addInheritTooltip(inheritDataInfo);
            this.textPanel.addTooltip();
            if (!this.inGameData.isPassedInheritTime() && !this.inGameData.isInherited()) {
                String settingOptionStr = Constants.root_i18n.get("startSetting");
                this.options.addOption(settingOptionStr, (Object)OptionID.INHERIT_SETTINGS);
                this.options.setShortcut((Object)OptionID.INHERIT_SETTINGS, 31, false, false, false, true);
                if (this.isSpecialistMode) {
                    this.options.addOption(Constants.root_i18n.get("rulepick_button") + (UNGP_ChallengeManager.isDifficultyEnough(this.settingEntry_difficulty.getValue()) ? Constants.root_i18n.get("rulepick_couldChallenge") : ""), (Object)OptionID.PICK_RULES_NEW);
                    this.options.setShortcut((Object)OptionID.PICK_RULES_NEW, 19, false, false, false, true);
                    this.pickedRules.clear();
                }
                this.options.addOption(Constants.root_i18n.get("startInherit"), (Object)OptionID.INHERIT);
                this.options.setShortcut((Object)OptionID.INHERIT, 57, false, false, false, true);
                this.updateOptionsFromSettings();
            } else if (this.inGameData.isInherited()) {
                this.textPanel.addPara(Constants.root_i18n.get("hasInherited"), nC);
            } else {
                this.textPanel.addPara(Constants.root_i18n.get("hasPassedTime"), nC);
            }
        } else {
            this.textPanel.addPara(Constants.root_i18n.get("noInherit"), nC);
        }
    }

    private void saveRecordByChosenOption(UNGP_InheritData dataToRecord, OptionID option) {
        UNGP_InheritManager.saveDataToSlot(dataToRecord, this.getSlotIdByOption(option));
    }

    public int getSlotIdByOption(OptionID option) {
        int slotID = 0;
        switch (option) {
            case CHOOSE_RECORD_SLOT_0: 
            case CHOOSE_INHERIT_SLOT_0: {
                break;
            }
            case CHOOSE_RECORD_SLOT_1: 
            case CHOOSE_INHERIT_SLOT_1: {
                slotID = 1;
                break;
            }
            case CHOOSE_RECORD_SLOT_2: 
            case CHOOSE_INHERIT_SLOT_2: {
                slotID = 2;
            }
        }
        return slotID;
    }

    public void optionSelected(String optionText, Object optionData) {
        OptionID selectedOption = (OptionID)((Object)optionData);
        if (selectedOption != OptionID.PICK_RULES_NEW) {
            this.options.clearOptions();
            this.textPanel.clear();
            this.uiPanelPlugin.update(this.visual);
        }
        switch (selectedOption) {
            case CHECK_INHERIT_SLOTS: {
                this.resetSettings();
                if (!this.onlyDefaultSlot) {
                    int curCycle;
                    this.textPanel.addPara(Constants.root_i18n.get("checkInherit"));
                    this.textPanel.addPara(Constants.root_i18n.get("checkInheritSlot"));
                    UNGP_InheritData curSlot = UNGP_InheritManager.InheritData_slot0;
                    if (curSlot == null) {
                        this.options.addOption(Constants.root_i18n.get("emptySlot"), (Object)OptionID.CHOOSE_INHERIT_SLOT_0);
                        this.options.setEnabled((Object)OptionID.CHOOSE_INHERIT_SLOT_0, false);
                    } else {
                        curCycle = Math.max(0, curSlot.cycle);
                        this.options.addOption(curSlot.getPrefixByCycle() + Constants.root_i18n.format("slotDes", "" + curCycle, curSlot.lastPlayerName), (Object)OptionID.CHOOSE_INHERIT_SLOT_0, curSlot.getColorByCycle(), null);
                    }
                    curSlot = UNGP_InheritManager.InheritData_slot1;
                    if (curSlot == null) {
                        this.options.addOption(Constants.root_i18n.get("emptySlot"), (Object)OptionID.CHOOSE_INHERIT_SLOT_1);
                        this.options.setEnabled((Object)OptionID.CHOOSE_INHERIT_SLOT_1, false);
                    } else {
                        curCycle = Math.max(0, curSlot.cycle);
                        this.options.addOption(curSlot.getPrefixByCycle() + Constants.root_i18n.format("slotDes", "" + curCycle, curSlot.lastPlayerName), (Object)OptionID.CHOOSE_INHERIT_SLOT_1, curSlot.getColorByCycle(), null);
                    }
                    curSlot = UNGP_InheritManager.InheritData_slot2;
                    if (curSlot == null) {
                        this.options.addOption(Constants.root_i18n.get("emptySlot"), (Object)OptionID.CHOOSE_INHERIT_SLOT_2);
                        this.options.setEnabled((Object)OptionID.CHOOSE_INHERIT_SLOT_2, false);
                    } else {
                        curCycle = Math.max(0, curSlot.cycle);
                        this.options.addOption(curSlot.getPrefixByCycle() + Constants.root_i18n.format("slotDes", "" + curCycle, curSlot.lastPlayerName), (Object)OptionID.CHOOSE_INHERIT_SLOT_2, curSlot.getColorByCycle(), null);
                    }
                } else {
                    this.optionSelectedChooseInherit(OptionID.CHOOSE_INHERIT_SLOT_0);
                }
                this.addBackButton(OptionID.BACK_TO_MENU);
                break;
            }
            case CHOOSE_INHERIT_SLOT_0: 
            case CHOOSE_INHERIT_SLOT_1: 
            case CHOOSE_INHERIT_SLOT_2: {
                this.optionSelectedChooseInherit(selectedOption);
                this.addBackButton(OptionID.CHECK_INHERIT_SLOTS);
                break;
            }
            case CHECK_RECORD_SLOTS: {
                int curCycle;
                TooltipMakerAPI recordInfo = this.textPanel.beginTooltip();
                this.textPanel.addPara(Constants.root_i18n.get("recordInfo"));
                this.pregenInheritData.addRecordTooltip(recordInfo, this.inGameData.getDifficulty());
                this.textPanel.addTooltip();
                this.textPanel.addPara(Constants.root_i18n.get("checkRecordSlot"));
                UNGP_InheritData curSlot = UNGP_InheritManager.InheritData_slot0;
                if (curSlot == null) {
                    this.options.addOption(Constants.root_i18n.get("emptySlot"), (Object)OptionID.CHOOSE_RECORD_SLOT_0);
                } else {
                    curCycle = Math.max(0, curSlot.cycle);
                    this.options.addOption(curSlot.getPrefixByCycle() + Constants.root_i18n.format("slotDes", "" + curCycle, curSlot.lastPlayerName), (Object)OptionID.CHOOSE_RECORD_SLOT_0, curSlot.getColorByCycle(), null);
                }
                curSlot = UNGP_InheritManager.InheritData_slot1;
                if (curSlot == null) {
                    this.options.addOption(Constants.root_i18n.get("emptySlot"), (Object)OptionID.CHOOSE_RECORD_SLOT_1);
                } else {
                    curCycle = Math.max(0, curSlot.cycle);
                    this.options.addOption(curSlot.getPrefixByCycle() + Constants.root_i18n.format("slotDes", "" + curCycle, curSlot.lastPlayerName), (Object)OptionID.CHOOSE_RECORD_SLOT_1, curSlot.getColorByCycle(), null);
                }
                curSlot = UNGP_InheritManager.InheritData_slot2;
                if (curSlot == null) {
                    this.options.addOption(Constants.root_i18n.get("emptySlot"), (Object)OptionID.CHOOSE_RECORD_SLOT_2);
                } else {
                    curCycle = Math.max(0, curSlot.cycle);
                    this.options.addOption(curSlot.getPrefixByCycle() + Constants.root_i18n.format("slotDes", "" + curCycle, curSlot.lastPlayerName), (Object)OptionID.CHOOSE_RECORD_SLOT_2, curSlot.getColorByCycle(), null);
                }
                this.addBackButton(OptionID.BACK_TO_MENU);
                break;
            }
            case HELP: {
                this.textPanel.addPara(Constants.root_i18n.get("helpInfo"));
                this.addBackButton(OptionID.BACK_TO_MENU);
                break;
            }
            case PICK_RULES_NEW: {
                float width = Global.getSettings().getScreenWidth();
                float height = Global.getSettings().getScreenHeight();
                final UNGP_SpecialistSettings.Difficulty difficulty = this.settingEntry_difficulty.getValue();
                UNGP_RulesManager.setStaticDifficulty(difficulty);
                Script pickTrigger = new Script(){

                    public void run() {
                        UNGP_InteractionDialog.this.setSpecialistModeToolTip();
                        UNGP_InteractionDialog.this.uiPanelPlugin.update(UNGP_InteractionDialog.this.visual);
                        TooltipMakerAPI tooltip = UNGP_InteractionDialog.this.uiPanelPlugin.beginTooltip(0.0f, false);
                        tooltip.addPara(Constants.root_i18n.get("hardmodeDes"), Misc.getHighlightColor(), 0.0f);
                        UNGP_InteractionDialog.this.uiPanelPlugin.addTooltip(20.0f, tooltip);
                        tooltip = UNGP_InteractionDialog.this.uiPanelPlugin.beginTooltip(300.0f, true);
                        for (UNGP_RulesManager.URule rule : UNGP_InteractionDialog.this.pickedRules) {
                            TooltipMakerAPI imageMaker = tooltip.beginImageWithText(rule.getSpritePath(), 32.0f);
                            imageMaker.addPara(rule.getName(), rule.getCorrectColor(), 0.0f);
                            rule.addDesc(imageMaker, 0.0f);
                            tooltip.addImageWithText(3.0f);
                        }
                        UNGP_InteractionDialog.this.uiPanelPlugin.addTooltip(300.0f, tooltip);
                        tooltip = UNGP_InteractionDialog.this.uiPanelPlugin.beginTooltip(10.0f, false);
                        if (UNGP_RulePickHelper.hasUnmetReasons(UNGP_InteractionDialog.this.pickedRules, difficulty)) {
                            tooltip.setParaOrbitronLarge();
                            tooltip.addPara(Constants.root_i18n.get("rulepick_notMeet"), Misc.getNegativeHighlightColor(), 5.0f);
                            tooltip.setParaFontDefault();
                            UNGP_InteractionDialog.this.uiPanelPlugin.addTooltip(10.0f, tooltip);
                        } else {
                            List<UNGP_ChallengeInfo> runnableChallenges = UNGP_ChallengeManager.getRunnableChallenges(difficulty, UNGP_InteractionDialog.this.pickedRules, UNGP_InteractionDialog.this.pickedInheritData.completedChallenges);
                            if (!runnableChallenges.isEmpty()) {
                                tooltip.addPara(Constants.root_i18n.get("rulepick_runnableChallenges"), Misc.getHighlightColor(), 10.0f);
                                UNGP_InteractionDialog.this.uiPanelPlugin.addTooltip(20.0f, tooltip);
                                tooltip = UNGP_InteractionDialog.this.uiPanelPlugin.beginTooltip(300.0f, true);
                                for (UNGP_ChallengeInfo challenge : runnableChallenges) {
                                    challenge.createTooltip(tooltip, 5.0f, null);
                                }
                                UNGP_InteractionDialog.this.uiPanelPlugin.addTooltip(300.0f, tooltip);
                            }
                        }
                    }
                };
                UNGP_RulePickPanelPlugin plugin = UNGP_RulePickPanelPlugin.createPlugin(difficulty, this.pickedRules, this.pickedInheritData.completedChallenges, pickTrigger, pickTrigger);
                this.dialog.showCustomVisualDialog(width, height, (CustomVisualDialogDelegate)new UNGP_RulePickPanelDelegate(plugin, this.dialog, this.getMemoryMap()));
                break;
            }
            case INHERIT: {
                this.inherit();
                this.addLeaveButton();
                break;
            }
            case CHOOSE_RECORD_SLOT_0: 
            case CHOOSE_RECORD_SLOT_1: 
            case CHOOSE_RECORD_SLOT_2: {
                this.dialog.showCustomDialog(720.0f, 200.0f, (CustomDialogDelegate)new RecordDialogDelegate(selectedOption));
                this.addLeaveButton();
                break;
            }
            case BACK_TO_MENU: {
                this.initMenu();
                break;
            }
            case LEAVE: {
                UNGP_InheritManager.clearSlots();
                this.dialog.dismiss();
                break;
            }
            case INHERIT_SETTINGS: {
                float width = Global.getSettings().getScreenWidth();
                float height = Global.getSettings().getScreenHeight();
                width = width < 800.0f ? width : 800.0f;
                height = height < 600.0f ? height : 600.0f;
                this.dialog.showCustomDialog(width, height, (CustomDialogDelegate)new InheritOptionsDelegate());
                break;
            }
        }
    }

    private void inherit() {
        TooltipMakerAPI backgroundTip = this.textPanel.beginTooltip();
        this.pickedBackground.addShortDescTooltipWithIcon(backgroundTip, 0.0f);
        this.textPanel.addTooltip();
        UNGP_BackgroundPluginAPI plugin = this.pickedBackground.getPlugin();
        float inherit_creditsFactor = plugin.getInheritCreditsFactor();
        float inherit_bpsFactor = plugin.getInheritBlueprintsFactor();
        HashMap<String, Object> dataSaverParams = new HashMap<String, Object>();
        dataSaverParams.put("inheritCreditsFactor", Float.valueOf(inherit_creditsFactor));
        dataSaverParams.put("inheritBPFactor", Float.valueOf(inherit_bpsFactor));
        dataSaverParams.put("background", this.pickedBackground);
        for (UNGP_DataSaverAPI dataSaver : this.pickedInheritData.dataSavers) {
            TooltipMakerAPI tooltip = this.textPanel.beginTooltip();
            dataSaver.startInheritDataFromSaver(tooltip, dataSaverParams);
            this.textPanel.addTooltip();
        }
        TooltipMakerAPI tooltip = this.textPanel.beginTooltip();
        UNGP_BackgroundManager.setPlayerBackground(this.pickedBackground);
        plugin.afterConfirm(this.pickedInheritData);
        plugin.addAfterConfirmTooltip(tooltip, this.pickedInheritData);
        UNGP_BackgroundIntel backgroundIntel = new UNGP_BackgroundIntel(Global.getSector().getPlayerFleet().getStarSystem());
        Global.getSector().getIntelManager().addIntel((IntelInfoPlugin)backgroundIntel);
        this.textPanel.addTooltip();
        this.textPanel.setFontInsignia();
        if (this.isSpecialistMode) {
            this.textPanel.addPara(Constants.root_i18n.get("hardModeYes"), Misc.getNegativeHighlightColor());
        }
        this.inGameData.setCurCycle(this.pickedInheritData.cycle);
        this.inGameData.setInherited(true);
        this.inGameData.setHardMode(this.isSpecialistMode);
        this.inGameData.setCompletedChallenges(this.pickedInheritData.completedChallenges);
        if (this.isSpecialistMode) {
            this.inGameData.setDifficulty(this.settingEntry_difficulty.getValue());
            this.inGameData.saveActivatedRules(this.pickedRules);
            UNGP_Feedback.setFeedBackList(this.pickedRules);
            final UNGP_SpecialistIntel intel = new UNGP_SpecialistIntel();
            Global.getSector().getIntelManager().addIntel((IntelInfoPlugin)intel, false, this.textPanel);
            UNGP_ChallengeIntel challengeIntel = UNGP_ChallengeManager.confirmChallenges(this.inGameData);
            if (challengeIntel != null) {
                Global.getSector().getIntelManager().addIntelToTextPanel((IntelInfoPlugin)challengeIntel, this.textPanel);
            }
            UNGP_RulesManager.updateRulesCache();
            Global.getSector().addTransientScript(new EveryFrameScript(){
                private float elapsed = 0.0f;
                private boolean isDone = false;

                public boolean isDone() {
                    return this.isDone;
                }

                public boolean runWhilePaused() {
                    return false;
                }

                public void advance(float amount) {
                    if (this.isDone()) {
                        return;
                    }
                    this.elapsed += amount;
                    if (this.elapsed > 0.1f) {
                        this.isDone = true;
                        Global.getSector().getCampaignUI().showCoreUITab(CoreUITabId.INTEL, (Object)intel);
                        Global.getSector().removeTransientScript((EveryFrameScript)this);
                    }
                }
            });
        }
    }

    private void record(OptionID option) {
        this.inGameData.setRecorded(true);
        this.saveRecordByChosenOption(this.pregenInheritData, option);
        Global.getSoundPlayer().playUISound("ui_rep_raise", 1.0f, 1.0f);
        this.textPanel.addPara(Constants.root_i18n.get("recordSuccess"));
    }

    public void optionMousedOver(String optionText, Object optionData) {
    }

    private void setSpecialistModeToolTip() {
        if (this.options.hasOption((Object)OptionID.INHERIT) && !this.pickedRules.isEmpty()) {
            String[] ruleNames = new String[this.pickedRules.size()];
            Color[] ruleColors = new Color[this.pickedRules.size()];
            StringBuilder result = new StringBuilder(Constants.root_i18n.get("hardmodeDes"));
            for (int i = 0; i < this.pickedRules.size(); ++i) {
                UNGP_RulesManager.URule rule = this.pickedRules.get(i);
                result.append("\n  ");
                result.append(rule.getName());
                ruleNames[i] = rule.getName();
                ruleColors[i] = rule.getCorrectColor();
            }
            this.options.setTooltip((Object)OptionID.INHERIT, result.toString());
            this.options.setTooltipHighlights((Object)OptionID.INHERIT, ruleNames);
            this.options.setTooltipHighlightColors((Object)OptionID.INHERIT, ruleColors);
        }
    }

    public void advance(float amount) {
        if (this.isSpecialistMode && this.options.hasOption((Object)OptionID.INHERIT)) {
            this.options.setEnabled((Object)OptionID.INHERIT, UNGP_SpecialistSettings.rulesMeetCondition(this.pickedRules, this.settingEntry_difficulty.getValue()));
        }
    }

    private void updateOptionsFromSettings() {
        if (this.options.hasOption((Object)OptionID.INHERIT)) {
            float inherit_creditsFactor = 0.0f;
            float inherit_bpsFactor = 0.0f;
            if (this.pickedBackground != null && this.pickedBackground.getPlugin() != null) {
                inherit_creditsFactor = this.pickedBackground.getPlugin().getInheritCreditsFactor();
                inherit_bpsFactor = this.pickedBackground.getPlugin().getInheritBlueprintsFactor();
            }
            int bpInheritGeneratedByDataSaver = 0;
            int creditsInheritGeneratedByDataSaver = 0;
            for (UNGP_DataSaverAPI dataSaver : this.pickedInheritData.dataSavers) {
                if (dataSaver instanceof UNGP_BlueprintsDataSaver) {
                    UNGP_BlueprintsDataSaver blueprintsDataSaver = (UNGP_BlueprintsDataSaver)dataSaver;
                    bpInheritGeneratedByDataSaver = (int)((float)blueprintsDataSaver.bpAmount * inherit_bpsFactor);
                }
                if (!(dataSaver instanceof UNGP_CreditsDataSaver)) continue;
                UNGP_CreditsDataSaver creditsDataSaver = (UNGP_CreditsDataSaver)dataSaver;
                creditsInheritGeneratedByDataSaver = (int)((float)creditsDataSaver.getCredits() * inherit_creditsFactor);
            }
            final int bpInherited = bpInheritGeneratedByDataSaver;
            final int creditsInherited = creditsInheritGeneratedByDataSaver;
            final boolean isSpecialistMode = this.isSpecialistMode;
            final UNGP_SpecialistSettings.Difficulty difficulty = this.settingEntry_difficulty.getValue();
            TooltipMakerAPI tooltip = this.textPanel.beginTooltip();
            TooltipMakerAPI section = tooltip.beginImageWithText("graphics/icons/reports/storage24.png", 24.0f);
            section.addPara(Constants.root_i18n.get("inheritOptions"), Misc.getBasePlayerColor(), 0.0f);
            tooltip.addImageWithText(5.0f);
            tooltip.setBulletedListMode("       ");
            if (this.pickedBackground != null) {
                tooltip.addSpacer(10.0f);
                tooltip.setBulletedListMode(null);
                this.pickedBackground.addDescriptionTooltip(tooltip, this.pickedInheritData, false);
            }
            tooltip.setBulletedListMode("       ");
            if (difficulty != null) {
                TooltipMakerAPI hardSection = tooltip.beginImageWithText(difficulty.spritePath, 64.0f);
                hardSection.addPara(Constants.root_i18n.get("hardmodeLevel") + ": %s", 0.0f, difficulty.color, new String[]{difficulty.name});
                tooltip.addImageWithText(5.0f);
            }
            tooltip.setBulletedListMode(null);
            this.textPanel.addTooltip();
            this.options.addOptionConfirmation((Object)OptionID.INHERIT, (StoryPointActionDelegate)new CustomStoryDialogDelegate(){

                public String getTitle() {
                    return Constants.root_i18n.get("startInherit");
                }

                public void createDescription(TooltipMakerAPI info) {
                    float pad = 10.0f;
                    String credits = Misc.getDGSCredits((float)creditsInherited);
                    Color hl = Misc.getHighlightColor();
                    Color negative = Misc.getNegativeHighlightColor();
                    UNGP_InteractionDialog.this.pickedBackground.addDescriptionTooltip(info, UNGP_InteractionDialog.this.pickedInheritData, false);
                    info.addSectionHeading("  " + Constants.root_i18n.get("inheritConfirmHeading"), Alignment.LMID, 5.0f);
                    info.addPara(Constants.root_i18n.get("inheritConfirmInfo0"), 5.0f, hl, new String[]{credits, "" + bpInherited});
                    if (difficulty != null && isSpecialistMode) {
                        info.addSpacer(pad);
                        info.addSectionHeading(Constants.root_i18n.format("rulepick_level", difficulty.name), hl, Misc.scaleAlpha((Color)negative, (float)0.2f), Alignment.MID, pad * 0.5f);
                        float width = info.getPrev().getPosition().getWidth();
                        info.addPara(Constants.root_i18n.get("inheritConfirmInfo1"), negative, 5.0f).setAlignment(Alignment.MID);
                        info.addSpacer(pad);
                        int ruleSize = UNGP_InteractionDialog.this.pickedRules.size();
                        int itemsPerRow = (int)(width / 64.0f);
                        int page = Math.max(0, ruleSize - 1) / itemsPerRow;
                        for (int i = 0; i <= page; ++i) {
                            ArrayList<String> ruleSprites = new ArrayList<String>();
                            for (int j = i * itemsPerRow; j < (i + 1) * itemsPerRow; ++j) {
                                if (j >= ruleSize) continue;
                                ruleSprites.add(UNGP_InteractionDialog.this.pickedRules.get(j).getSpritePath());
                            }
                            if (ruleSprites.isEmpty()) continue;
                            String[] array = ruleSprites.toArray(new String[0]);
                            info.addImages(width, 64.0f, 0.0f, 4.0f, array);
                        }
                    }
                }
            });
        }
    }

    public void backFromEngagement(EngagementResultAPI battleResult) {
    }

    private void addLeaveButton() {
        this.options.addOption(Constants.root_i18n.get("leave"), (Object)OptionID.LEAVE);
    }

    private void addBackButton(OptionID warpOption) {
        this.options.addOption(Constants.root_i18n.get("back"), (Object)warpOption);
    }

    public Object getContext() {
        return null;
    }

    public Map<String, MemoryAPI> getMemoryMap() {
        return null;
    }

    public void resetSettings() {
        this.settingEntry_difficulty.reset();
        this.pickedBackground = UNGP_BackgroundManager.getDefaultBackground();
        this.backgroundCheckBoxGroup = null;
        this.isSpecialistMode = false;
        this.pickedRules.clear();
    }

    private static enum OptionID {
        CHECK_INHERIT_SLOTS,
        CHECK_RECORD_SLOTS,
        HELP,
        CHOOSE_INHERIT_SLOT_0,
        CHOOSE_INHERIT_SLOT_1,
        CHOOSE_INHERIT_SLOT_2,
        PICK_RULES_NEW,
        INHERIT,
        INHERIT_SETTINGS,
        CHOOSE_RECORD_SLOT_0,
        CHOOSE_RECORD_SLOT_1,
        CHOOSE_RECORD_SLOT_2,
        BACK_TO_MENU,
        LEAVE;

    }

    private static abstract class InheritSettingEntry<T>
    implements UNGP_DataSaverSettingEntryAPI<T> {
        private SettingEntry<T> valueEntry;
        protected String entryTitle;
        protected Color entryTitleColor;
        protected Object[] optionValues;
        protected String[] optionNames;
        protected Color[] optionBaseColor;
        protected Color[] optionDarkColor;
        protected Color[] optionBrightColor;
        protected CheckBoxGroup checkBoxGroup;
        protected HorizontalButtonGroup optionGroup;

        public InheritSettingEntry(T defaultValue, int optionSize) {
            this.valueEntry = new SettingEntry<T>(defaultValue);
            this.optionValues = new Object[optionSize];
            this.optionNames = new String[optionSize];
            this.optionBaseColor = new Color[optionSize];
            this.optionDarkColor = new Color[optionSize];
            this.optionBrightColor = new Color[optionSize];
            this.initParams(optionSize);
        }

        public abstract void initParams(int var1);

        public void addEntry(TooltipMakerAPI tooltip, float width) {
            this.checkBoxGroup = new CheckBoxGroup();
            this.optionGroup = new HorizontalButtonGroup();
            tooltip.addPara(this.entryTitle, this.entryTitleColor, 0.0f);
            tooltip.addSpacer(5.0f);
            int optionSize = this.optionValues.length;
            float buttonWidth = width / (float)optionSize - 10.0f;
            for (int i = 0; i < optionSize; ++i) {
                Object value = this.optionValues[i];
                ButtonAPI checkBox = tooltip.addAreaCheckbox(this.optionNames[i], null, this.optionBaseColor[i], this.optionDarkColor[i], this.optionBrightColor[i], buttonWidth, 30.0f, 0.0f);
                this.addTipToOption(tooltip, value);
                this.optionGroup.addButton(checkBox);
                this.checkBoxGroup.addCheckBox(checkBox, value);
            }
            this.optionGroup.updateTooltip(tooltip, 5.0f);
            this.checkBoxGroup.tryCheckValue(this.valueEntry.get());
        }

        protected void addTipToOption(TooltipMakerAPI tooltip, Object option) {
        }

        @Override
        public void reset() {
            this.cancelConfirm();
            this.valueEntry.reset();
        }

        @Override
        public void advance(float amount) {
            if (this.checkBoxGroup != null) {
                this.checkBoxGroup.updateCheck();
            }
        }

        @Override
        public T confirmValue() {
            Object value = this.checkBoxGroup.getCheckedValue();
            this.valueEntry.set(value);
            return (T)value;
        }

        @Override
        public void cancelConfirm() {
            this.checkBoxGroup = null;
            this.optionGroup = null;
        }

        @Override
        public T getValue() {
            return this.valueEntry.get();
        }
    }

    private class RecordDialogDelegate
    extends BaseCustomDialogDelegate {
        private ButtonAPI btn_recordCargo;
        private ButtonAPI btn_recordShip;
        private ButtonAPI btn_recordColony;
        private ButtonAPI btn_recordSlotBPs;
        private OptionID selectedOption;

        public RecordDialogDelegate(OptionID selectedOption) {
            this.selectedOption = selectedOption;
        }

        public void createCustomDialog(CustomPanelAPI panel, CustomDialogDelegate.CustomDialogCallback callback) {
            float width = panel.getPosition().getWidth();
            float height = panel.getPosition().getHeight();
            float pad = 5.0f;
            TooltipMakerAPI info = panel.createUIElement(width, height, true);
            panel.addUIElement(info);
            info.setParaOrbitronLarge();
            info.addPara(Constants.root_i18n.get("recordConfirmInfo"), Misc.getNegativeHighlightColor(), 0.0f);
            info.addSpacer(30.0f);
            info.setAreaCheckboxFont("graphics/fonts/orbitron24aa.fnt");
            info.addPara(Constants.root_i18n.get("recordExtraCreditsTitle"), Misc.getHighlightColor(), 0.0f);
            info.addSpacer(pad);
            float buttonWidth = width / 3.0f - 10.0f;
            float buttonHeight = 30.0f;
            HorizontalButtonGroup extraCreditsGroup = new HorizontalButtonGroup();
            this.btn_recordCargo = info.addAreaCheckbox(Constants.root_i18n.get("recordExtraCredits_cargo"), null, Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Misc.getBrightPlayerColor(), buttonWidth, buttonHeight, 0.0f);
            this.btn_recordShip = info.addAreaCheckbox(Constants.root_i18n.get("recordExtraCredits_ship"), null, Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Misc.getBrightPlayerColor(), buttonWidth, buttonHeight, 0.0f);
            this.btn_recordColony = info.addAreaCheckbox(Constants.root_i18n.get("recordExtraCredits_colony"), null, Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Misc.getBrightPlayerColor(), buttonWidth, buttonHeight, 0.0f);
            extraCreditsGroup.addButton(this.btn_recordCargo);
            extraCreditsGroup.addButton(this.btn_recordShip);
            extraCreditsGroup.addButton(this.btn_recordColony);
            extraCreditsGroup.updateTooltip(info, 10.0f);
            info.addSpacer(pad);
            info.addPara(Constants.root_i18n.get("recordExtraBPsTitle"), Misc.getHighlightColor(), 0.0f);
            info.addSpacer(pad);
            this.btn_recordSlotBPs = info.addAreaCheckbox(Constants.root_i18n.get("recordExtraBPs_selectedSlot"), null, Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Misc.getBrightPlayerColor(), buttonWidth, buttonHeight, 0.0f);
        }

        public boolean hasCancelButton() {
            return true;
        }

        public String getConfirmText() {
            return null;
        }

        public String getCancelText() {
            return null;
        }

        public void customDialogConfirm() {
            float extraCredits = 0.0f;
            boolean recordCargo = this.btn_recordCargo.isChecked();
            boolean recordShip = this.btn_recordShip.isChecked();
            boolean recordIndustry = this.btn_recordColony.isChecked();
            boolean recordSelectedSlotBPs = this.btn_recordSlotBPs.isChecked();
            CargoAPI convertCargo = Global.getFactory().createCargo(true);
            for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
                CargoAPI storageCargo;
                if (Misc.playerHasStorageAccess((MarketAPI)market) && (storageCargo = Misc.getStorageCargo((MarketAPI)market)) != null) {
                    FleetDataAPI mothballedShips;
                    if (recordCargo) {
                        convertCargo.addAll(storageCargo);
                    }
                    if (recordShip && (mothballedShips = storageCargo.getMothballedShips()) != null) {
                        for (FleetMemberAPI member : mothballedShips.getMembersListCopy()) {
                            extraCredits += member.getBaseValue();
                        }
                    }
                }
                if (!recordIndustry || !market.isPlayerOwned()) continue;
                for (Industry industry : market.getIndustries()) {
                    extraCredits += industry.getBuildCost();
                }
            }
            CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
            CargoAPI playerCargo = playerFleet.getCargo();
            if (recordCargo) {
                convertCargo.addAll(playerCargo);
                for (CargoStackAPI stack : convertCargo.getStacksCopy()) {
                    extraCredits += (float)stack.getBaseValuePerUnit() * stack.getSize();
                }
            }
            if (recordShip && playerFleet.getFleetData() != null) {
                for (FleetMemberAPI member : playerFleet.getFleetData().getMembersListCopy()) {
                    extraCredits += member.getBaseValue();
                }
            }
            UNGP_InteractionDialog.this.textPanel.addPara(Constants.root_i18n.get("recordExtraCredits_success") + " %s ", Misc.getHighlightColor(), new String[]{Misc.getDGSCredits((float)extraCredits)});
            for (UNGP_DataSaverAPI dataSaver : UNGP_InteractionDialog.this.pregenInheritData.dataSavers) {
                UNGP_BlueprintsDataSaver bpSaverFromSlot;
                UNGP_InheritData dataFromSlot;
                if (dataSaver instanceof UNGP_CreditsDataSaver) {
                    ((UNGP_CreditsDataSaver)dataSaver).addCredits((int)extraCredits);
                }
                if (!recordSelectedSlotBPs || !(dataSaver instanceof UNGP_BlueprintsDataSaver) || (dataFromSlot = UNGP_InheritManager.getDataFromSlot(UNGP_InteractionDialog.this.getSlotIdByOption(this.selectedOption))) == null || (bpSaverFromSlot = dataFromSlot.getFirstSaverOfClass(UNGP_BlueprintsDataSaver.class)) == null) continue;
                int extraBPAmount = ((UNGP_BlueprintsDataSaver)dataSaver).add(bpSaverFromSlot);
                UNGP_InteractionDialog.this.textPanel.addPara(Constants.root_i18n.get("recordExtraBPs_success"), Misc.getHighlightColor(), new String[]{"" + extraBPAmount});
            }
            UNGP_InteractionDialog.this.record(this.selectedOption);
        }

        public void customDialogCancel() {
            UNGP_InteractionDialog.this.optionSelected(null, (Object)OptionID.CHECK_RECORD_SLOTS);
        }

        public CustomUIPanelPlugin getCustomPanelPlugin() {
            return null;
        }
    }

    private class InheritOptionsDelegate
    extends BaseCustomDialogDelegate {
        private InheritOptionsDelegate() {
        }

        public void createCustomDialog(CustomPanelAPI panel, CustomDialogDelegate.CustomDialogCallback callback) {
            float width = panel.getPosition().getWidth();
            float height = panel.getPosition().getHeight();
            float backgroundHeight = height * 0.8f;
            float extraOptionsHeight = height - backgroundHeight;
            float backgroundTitleHeight = 30.0f;
            UNGP_Background previousBackground = null;
            if (UNGP_InteractionDialog.this.pickedBackground != null) {
                previousBackground = UNGP_InteractionDialog.this.pickedBackground;
            }
            UNGP_InteractionDialog.this.backgroundCheckBoxGroup = new CheckBoxGroup();
            TooltipMakerAPI backgroundTitleTip = panel.createUIElement(width, backgroundTitleHeight, false);
            backgroundTitleTip.setParaOrbitronLarge();
            backgroundTitleTip.addPara(Constants.root_i18n.get("inherit_choose_background"), Misc.getBasePlayerColor(), 0.0f);
            panel.addUIElement(backgroundTitleTip).inTL(0.0f, 0.0f);
            TooltipMakerAPI backgroundTip = panel.createUIElement(width, backgroundHeight - backgroundTitleHeight, true);
            backgroundTip.setParaOrbitronLarge();
            float backgroundBoxWidth = width - 10.0f;
            float spacerHeight = 5.0f;
            List<UNGP_Background> allBackgrounds = UNGP_BackgroundManager.getSortedBackgroundsCopy();
            for (UNGP_Background background : allBackgrounds) {
                ButtonAPI checkbox = backgroundTip.addAreaCheckbox("", null, Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Misc.getBrightPlayerColor(), 0.0f, 0.0f, 0.0f, true);
                backgroundTip.addTooltipToPrevious((TooltipMakerAPI.TooltipCreator)new UNGP_Background.BackgroundTooltipCreator(background, UNGP_InteractionDialog.this.pickedInheritData, backgroundBoxWidth - 20.0f), TooltipMakerAPI.TooltipLocation.BELOW);
                background.addShortDescTooltipWithIcon(backgroundTip, spacerHeight);
                PositionAPI imageWithTextPosition = backgroundTip.getPrev().getPosition();
                float imageWithTextHeight = imageWithTextPosition.getHeight();
                float imageWithTextWidth = imageWithTextPosition.getWidth();
                float imageWithTextXOffset = 7.0f;
                backgroundTip.addSpacer(spacerHeight);
                imageWithTextPosition.setXAlignOffset(imageWithTextXOffset);
                imageWithTextPosition.setSize(imageWithTextWidth - 15.0f, imageWithTextHeight);
                checkbox.getPosition().setSize(backgroundBoxWidth, imageWithTextHeight + spacerHeight * 2.0f);
                imageWithTextPosition.setYAlignOffset(imageWithTextHeight + spacerHeight);
                backgroundTip.addSpacer(0.0f).getPosition().setXAlignOffset(-imageWithTextXOffset);
                UNGP_InteractionDialog.this.backgroundCheckBoxGroup.addCheckBox(checkbox, background);
            }
            backgroundTip.addSpacer(0.0f);
            panel.addUIElement(backgroundTip).inTL(0.0f, backgroundTitleHeight);
            TooltipMakerAPI tooltip = panel.createUIElement(width, extraOptionsHeight, false);
            tooltip.setParaOrbitronLarge();
            tooltip.setAreaCheckboxFont("graphics/fonts/orbitron24aa.fnt");
            tooltip.addSpacer(10.0f);
            if (previousBackground != null) {
                UNGP_InteractionDialog.this.backgroundCheckBoxGroup.tryCheckValue(previousBackground);
            } else {
                UNGP_InteractionDialog.this.backgroundCheckBoxGroup.tryCheckValue(UNGP_BackgroundManager.getDefaultBackground());
            }
            UNGP_InteractionDialog.this.settingEntry_difficulty.addEntry(tooltip, width);
            panel.addUIElement(tooltip).inTL(0.0f, backgroundHeight);
        }

        public boolean hasCancelButton() {
            return true;
        }

        public void customDialogConfirm() {
            UNGP_SpecialistSettings.Difficulty difficulty;
            if (UNGP_InteractionDialog.this.backgroundCheckBoxGroup != null) {
                UNGP_InteractionDialog.this.pickedBackground = (UNGP_Background)UNGP_InteractionDialog.this.backgroundCheckBoxGroup.getCheckedValue();
            }
            UNGP_InteractionDialog.this.isSpecialistMode = (difficulty = UNGP_InteractionDialog.this.settingEntry_difficulty.confirmValue()) != null;
            UNGP_InteractionDialog.this.optionSelected(null, (Object)UNGP_InteractionDialog.this.choseInheritSlotOptionID);
        }

        public void customDialogCancel() {
            UNGP_InteractionDialog.this.settingEntry_difficulty.cancelConfirm();
            UNGP_InteractionDialog.this.optionSelected(null, (Object)UNGP_InteractionDialog.this.choseInheritSlotOptionID);
        }

        public CustomUIPanelPlugin getCustomPanelPlugin() {
            return new CustomUIPanelPlugin(){

                public void positionChanged(PositionAPI position) {
                }

                public void renderBelow(float alphaMult) {
                }

                public void render(float alphaMult) {
                }

                public void advance(float amount) {
                    if (UNGP_InteractionDialog.this.backgroundCheckBoxGroup != null) {
                        UNGP_InteractionDialog.this.backgroundCheckBoxGroup.updateCheck();
                    }
                    UNGP_InteractionDialog.this.settingEntry_difficulty.advance(amount);
                }

                public void processInput(List<InputEventAPI> events) {
                }

                public void buttonPressed(Object buttonId) {
                }
            };
        }
    }

    private class CustomStoryDialogDelegate
    extends BaseStoryPointActionDelegate {
        private CustomStoryDialogDelegate() {
        }

        public boolean withDescription() {
            return true;
        }

        public boolean withSPInfo() {
            return false;
        }

        public String getLogText() {
            return null;
        }

        public float getBonusXPFraction() {
            return 0.0f;
        }

        public TextPanelAPI getTextPanel() {
            if (UNGP_InteractionDialog.this.dialog == null) {
                return null;
            }
            return UNGP_InteractionDialog.this.textPanel;
        }

        public String getConfirmSoundId() {
            return "ui_acquired_blueprint";
        }

        public int getRequiredStoryPoints() {
            return 0;
        }
    }

    private static class DifficultyTooltipCreator
    implements TooltipMakerAPI.TooltipCreator {
        private UNGP_SpecialistSettings.Difficulty difficulty;

        public DifficultyTooltipCreator(UNGP_SpecialistSettings.Difficulty difficulty) {
            this.difficulty = difficulty;
        }

        public boolean isTooltipExpandable(Object tooltipParam) {
            return false;
        }

        public float getTooltipWidth(Object tooltipParam) {
            return 200.0f;
        }

        public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
            if (this.difficulty == null) {
                tooltip.addPara(Constants.root_i18n.get("difficulty_desc_null"), 0.0f);
            } else {
                Color hl = Misc.getHighlightColor();
                tooltip.addPara(Constants.root_i18n.get("difficulty_desc_base") + "%s / %s", 0.0f, hl, new String[]{"" + this.difficulty.minRules, "" + this.difficulty.maxRules});
                tooltip.addPara(Constants.root_i18n.get("difficulty_desc_value") + "%s", 0.0f, hl, new String[]{(int)(this.difficulty.extraValueMultiplier * 100.0f) + "%"});
                if (UNGP_ChallengeManager.isDifficultyEnough(this.difficulty)) {
                    tooltip.addPara(Constants.root_i18n.get("difficulty_desc_max"), hl, 5.0f);
                }
            }
        }
    }
}

