/*
 * Decompiled with CFR 0.152.
 */
package ungp.scripts.campaign.specialist.skills;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.characters.CharacterStatsSkillEffect;
import com.fs.starfarer.api.characters.FleetTotalItem;
import com.fs.starfarer.api.characters.FleetTotalSource;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import ungp.api.rules.tags.UNGP_PlayerCharacterStatsSkillTag;
import ungp.api.rules.tags.UNGP_PlayerShipSkillTag;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;

public class UNGP_SpecialistSkills {

    public static class UNGP_SpecialistCharacterSkill
    extends BaseSkillEffectDescription
    implements CharacterStatsSkillEffect,
    FleetTotalSource {
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            for (UNGP_PlayerCharacterStatsSkillTag tag : UNGP_RulesManager.PLAYER_CHARACTER_SKILL_TAGS_ITG) {
                tag.apply(stats);
            }
        }

        public void unapply(MutableCharacterStatsAPI stats, String id) {
            for (UNGP_RulesManager.URule rule : UNGP_RulesManager.getAllRulesCopy()) {
                if (!(rule.getRuleEffect() instanceof UNGP_PlayerCharacterStatsSkillTag)) continue;
                ((UNGP_PlayerCharacterStatsSkillTag)((Object)rule.getRuleEffect())).unapply(stats);
            }
        }

        public FleetTotalItem getFleetTotalItem() {
            return this.getOPTotal();
        }
    }

    public static class UNGP_SpecialistShipSkill
    extends BaseSkillEffectDescription
    implements ShipSkillEffect,
    FleetTotalSource {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            FleetDataAPI fleetData = null;
            FleetMemberAPI member = stats.getFleetMember();
            if (UNGP_SpecialistShipSkill.isInCampaign()) {
                fleetData = Global.getSector().getPlayerFleet().getFleetData();
            } else if (member != null && (fleetData = member.getFleetDataForStats()) == null) {
                fleetData = member.getFleetData();
            }
            for (UNGP_PlayerShipSkillTag tag : UNGP_RulesManager.PLAYER_SHIP_SKILL_TAGS_ITG) {
                tag.apply(fleetData, member, stats, hullSize);
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            for (UNGP_RulesManager.URule rule : UNGP_RulesManager.getAllRulesCopy()) {
                if (!(rule.getRuleEffect() instanceof UNGP_PlayerShipSkillTag)) continue;
                ((UNGP_PlayerShipSkillTag)((Object)rule.getRuleEffect())).unapply(stats, hullSize);
            }
        }

        public FleetTotalItem getFleetTotalItem() {
            return this.getOPTotal();
        }
    }
}

