/*
 * Decompiled with CFR 0.152.
 */
package ungp.scripts.campaign.specialist.rules;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.UIComponentAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import ungp.api.rules.UNGP_RuleEffectAPI;
import ungp.api.rules.tags.UNGP_CampaignListenerTag;
import ungp.api.rules.tags.UNGP_CampaignTag;
import ungp.api.rules.tags.UNGP_CombatInitTag;
import ungp.api.rules.tags.UNGP_CombatTag;
import ungp.api.rules.tags.UNGP_EconomyTag;
import ungp.api.rules.tags.UNGP_PlayerCharacterStatsSkillTag;
import ungp.api.rules.tags.UNGP_PlayerFleetMemberTag;
import ungp.api.rules.tags.UNGP_PlayerFleetTag;
import ungp.api.rules.tags.UNGP_PlayerShipSkillTag;
import ungp.api.rules.tags.UNGP_TweakBeforeApplyTag;
import ungp.scripts.campaign.UNGP_InGameData;
import ungp.scripts.campaign.specialist.UNGP_SpecialistManager;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeInfo;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeManager;
import ungp.scripts.campaign.specialist.economy.UNGP_EconomyListener;
import ungp.scripts.campaign.specialist.rules.UNGP_RuleInfoLoader;
import ungp.scripts.ui.RuleDescBackgroundPlugin;
import ungp.scripts.utils.Constants;
import ungp.scripts.utils.UNGPUtils;
import ungp.scripts.utils.UNGP_Feedback;

public class UNGP_RulesManager {
    private static final Color POSITIVE_COLOR = new Color(50, 255, 50);
    private static final Color NEGATIVE_COLOR = new Color(255, 50, 50);
    private static final Color GOLDEN_COLOR = new Color(255, 215, 0);
    private static final Color MILESTONE_COLOR = new Color(158, 41, 255);
    private static final Logger LOGGER = Global.getLogger(UNGP_RulesManager.class);
    private static List<URule> ALL_RULES = new ArrayList<URule>();
    public static List<URule> ACTIVATED_RULES_IN_THIS_GAME = new ArrayList<URule>();
    public static List<URule> COMBAT_RULES_IN_THIS_GAME = new ArrayList<URule>();
    public static List<URule> CAMPAIGN_RULES_IN_THIS_GAME = new ArrayList<URule>();
    public static List<UNGP_EconomyTag> ECONOMY_TAGS_ITG = new ArrayList<UNGP_EconomyTag>();
    public static List<UNGP_CampaignTag> CAMPAIGN_TAGS_ITG = new ArrayList<UNGP_CampaignTag>();
    public static List<UNGP_PlayerFleetTag> PLAYER_FLEET_TAGS_ITG = new ArrayList<UNGP_PlayerFleetTag>();
    public static List<UNGP_PlayerFleetMemberTag> PLAYER_FLEET_MEMBER_TAGS_ITG = new ArrayList<UNGP_PlayerFleetMemberTag>();
    public static List<UNGP_PlayerShipSkillTag> PLAYER_SHIP_SKILL_TAGS_ITG = new ArrayList<UNGP_PlayerShipSkillTag>();
    public static List<UNGP_PlayerCharacterStatsSkillTag> PLAYER_CHARACTER_SKILL_TAGS_ITG = new ArrayList<UNGP_PlayerCharacterStatsSkillTag>();
    private static boolean needUpdateCache = false;
    private static boolean isSpecialistMode = false;
    private static UNGP_SpecialistSettings.Difficulty globalDifficulty = null;

    public static void initOrReloadRules() {
        UNGP_RulesManager.loadAllRules(UNGP_RuleInfoLoader.loadAllRuleInformation());
    }

    public static void tagAllChallengeProviders() {
        List<UNGP_ChallengeInfo> challengesCopy = UNGP_ChallengeManager.getChallengeInfosCopy();
        for (UNGP_ChallengeInfo challengeInfo : challengesCopy) {
            for (URule rule : challengeInfo.getRulesRequired()) {
                rule.isMilestoneProvider = true;
            }
        }
    }

    public static void updateCacheNextFrame() {
        needUpdateCache = true;
    }

    public static boolean isCacheNeedUpdate() {
        return needUpdateCache;
    }

    public static void updateRulesCache() {
        UNGP_InGameData inGameData = UNGP_InGameData.getDataInSave();
        if (inGameData != null) {
            LOGGER.info((Object)"Start updating rule caches...");
            ACTIVATED_RULES_IN_THIS_GAME.clear();
            COMBAT_RULES_IN_THIS_GAME.clear();
            CAMPAIGN_RULES_IN_THIS_GAME.clear();
            CAMPAIGN_TAGS_ITG.clear();
            ECONOMY_TAGS_ITG.clear();
            PLAYER_FLEET_TAGS_ITG.clear();
            PLAYER_FLEET_MEMBER_TAGS_ITG.clear();
            PLAYER_SHIP_SKILL_TAGS_ITG.clear();
            PLAYER_CHARACTER_SKILL_TAGS_ITG.clear();
            List<URule> activatedRules = inGameData.getActivatedRules();
            CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
            MutableCharacterStatsAPI playerStats = Global.getSector().getPlayerStats();
            for (URule uRule : ALL_RULES) {
                uRule.isMilestoneRollLocked = true;
                UNGP_RuleEffectAPI uNGP_RuleEffectAPI = uRule.getRuleEffect();
                uNGP_RuleEffectAPI.unapplyGlobalStats();
                if (uNGP_RuleEffectAPI instanceof UNGP_CampaignListenerTag) {
                    Class listenerClass = ((UNGP_CampaignListenerTag)((Object)uNGP_RuleEffectAPI)).getClassOfListener();
                    Global.getSector().getListenerManager().removeListenerOfClass(listenerClass);
                }
                if (uNGP_RuleEffectAPI instanceof UNGP_PlayerFleetTag && playerFleet != null) {
                    ((UNGP_PlayerFleetTag)((Object)uNGP_RuleEffectAPI)).unapplyPlayerFleetStats(playerFleet);
                }
                if (!(uNGP_RuleEffectAPI instanceof UNGP_EconomyTag)) continue;
                UNGP_EconomyListener.unapplyMarkets((UNGP_EconomyTag)((Object)uNGP_RuleEffectAPI));
            }
            ArrayList<UNGP_TweakBeforeApplyTag> beforeApplyTags = new ArrayList<UNGP_TweakBeforeApplyTag>();
            for (URule uRule : activatedRules) {
                UNGP_RuleEffectAPI effect = uRule.getRuleEffect();
                if (!(effect instanceof UNGP_TweakBeforeApplyTag)) continue;
                beforeApplyTags.add((UNGP_TweakBeforeApplyTag)((Object)effect));
            }
            List<URule> list = List.copyOf(activatedRules);
            for (UNGP_TweakBeforeApplyTag tag : beforeApplyTags) {
                tag.tweakBeforeApply(activatedRules, list);
            }
            UNGP_RulesManager.updateRollableMilestoneRules(inGameData);
            HashSet<URule> hashSet = new HashSet<URule>(activatedRules);
            activatedRules.clear();
            activatedRules.addAll(hashSet);
            UNGP_SpecialistSettings.Difficulty difficulty = inGameData.getDifficulty();
            for (URule rule : activatedRules) {
                ACTIVATED_RULES_IN_THIS_GAME.add(rule);
                UNGP_RuleEffectAPI effect = rule.getRuleEffect();
                effect.updateDifficultyCache(difficulty);
                effect.applyGlobalStats();
                if (effect instanceof UNGP_CampaignListenerTag) {
                    Global.getSector().getListenerManager().addListener(((UNGP_CampaignListenerTag)((Object)effect)).getListener(), true);
                }
                if (effect instanceof UNGP_CombatTag || effect instanceof UNGP_CombatInitTag) {
                    COMBAT_RULES_IN_THIS_GAME.add(rule);
                } else {
                    CAMPAIGN_RULES_IN_THIS_GAME.add(rule);
                }
                if (effect instanceof UNGP_PlayerFleetTag && playerFleet != null) {
                    ((UNGP_PlayerFleetTag)((Object)effect)).applyPlayerFleetStats(playerFleet);
                    PLAYER_FLEET_TAGS_ITG.add((UNGP_PlayerFleetTag)((Object)effect));
                }
                if (effect instanceof UNGP_PlayerFleetMemberTag) {
                    PLAYER_FLEET_MEMBER_TAGS_ITG.add((UNGP_PlayerFleetMemberTag)((Object)effect));
                }
                if (effect instanceof UNGP_EconomyTag) {
                    ECONOMY_TAGS_ITG.add((UNGP_EconomyTag)((Object)effect));
                }
                if (effect instanceof UNGP_CampaignTag) {
                    CAMPAIGN_TAGS_ITG.add((UNGP_CampaignTag)((Object)effect));
                }
                if (effect instanceof UNGP_PlayerShipSkillTag) {
                    PLAYER_SHIP_SKILL_TAGS_ITG.add((UNGP_PlayerShipSkillTag)((Object)effect));
                }
                if (!(effect instanceof UNGP_PlayerCharacterStatsSkillTag)) continue;
                PLAYER_CHARACTER_SKILL_TAGS_ITG.add((UNGP_PlayerCharacterStatsSkillTag)((Object)effect));
            }
            if (!ECONOMY_TAGS_ITG.isEmpty()) {
                UNGP_EconomyListener.addListener();
                UNGP_EconomyListener.applyMarkets();
            }
            UNGP_RulesManager.setStaticDifficulty(difficulty);
            inGameData.saveActivatedRules(activatedRules);
            UNGP_SpecialistManager.updateCachedSpecialistMode(inGameData.isHardMode());
            UNGP_ChallengeManager.updateChallengeProgress(inGameData);
            UNGP_RulesManager.updateSpecialistSkills(playerStats);
            if (playerFleet != null) {
                playerFleet.forceSync();
            }
            LOGGER.info((Object)"Rule caches update completed.");
        }
        needUpdateCache = false;
    }

    private static void updateSpecialistSkills(MutableCharacterStatsAPI stats) {
        if (stats == null) {
            return;
        }
        if (PLAYER_SHIP_SKILL_TAGS_ITG.isEmpty()) {
            stats.setSkillLevel("UNGP_specialist_player_ship_skill", 0.0f);
        } else {
            stats.setSkillLevel("UNGP_specialist_player_ship_skill", 1.0f);
        }
        if (PLAYER_CHARACTER_SKILL_TAGS_ITG.isEmpty()) {
            stats.setSkillLevel("UNGP_specialist_player_character_skill", 0.0f);
        } else {
            stats.setSkillLevel("UNGP_specialist_player_character_skill", 1.0f);
        }
        stats.refreshCharacterStatsEffects();
    }

    public static UNGP_SpecialistSettings.Difficulty getGlobalDifficulty() {
        return globalDifficulty;
    }

    public static List<URule> getAllRulesCopy() {
        return new ArrayList<URule>(ALL_RULES);
    }

    public static void updateRollableMilestoneRules(UNGP_InGameData dataInSave) {
        for (String completedChallenge : dataInSave.getCompletedChallenges()) {
            URule rule;
            UNGP_ChallengeInfo info = UNGP_ChallengeManager.getChallengeInfo(completedChallenge);
            if (info == null || (rule = info.getMilestoneToUnlock()) == null) continue;
            rule.isMilestoneRollLocked = false;
        }
    }

    public static void addRuleItemTooltip(TooltipMakerAPI tooltip, URule rule, boolean isExpanded) {
        rule.addDetailsToTooltip(tooltip, isExpanded, false);
    }

    public static TooltipMakerAPI.TooltipCreator createRuleItemTooltip(final URule rule) {
        return new TooltipMakerAPI.TooltipCreator(){

            public boolean isTooltipExpandable(Object tooltipParam) {
                return rule.isTooltipExpandable();
            }

            public float getTooltipWidth(Object tooltipParam) {
                return UNGP_RulesManager.getCommonWidth();
            }

            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                UNGP_RulesManager.addRuleItemTooltip(tooltip, rule, expanded);
            }
        };
    }

    public static float getCommonWidth() {
        return 400.0f;
    }

    public static String getRuleTypeName(boolean isMilestone, boolean isGolden, boolean isPositive) {
        StringBuilder sb = new StringBuilder();
        if (isMilestone) {
            if (isGolden) {
                sb.append(Constants.rules_i18n.get("prefix_golden"));
                sb.append(Constants.rules_i18n.get("middle_space"));
            }
            sb.append(Constants.rules_i18n.get("prefix_milestone"));
        } else if (isGolden) {
            sb.append(Constants.rules_i18n.get("prefix_golden"));
        } else if (isPositive) {
            sb.append(Constants.rules_i18n.get("prefix_positive"));
        } else {
            sb.append(Constants.rules_i18n.get("prefix_negative"));
        }
        sb.append(Constants.rules_i18n.get("middle_space"));
        sb.append(Constants.rules_i18n.get("suffix_rule"));
        return sb.toString();
    }

    private static void loadAllRules(List<UNGP_RuleInfoLoader.UNGP_RuleInfo> ruleInfos) {
        ALL_RULES.clear();
        for (UNGP_RuleInfoLoader.UNGP_RuleInfo info : ruleInfos) {
            ALL_RULES.add(new URule(info));
        }
        UNGP_RulesManager.loadPickTimes();
    }

    public static void loadPickTimes() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                String url = Constants.rules_i18n.get("pick_times_collection_url");
                try {
                    URL connURL = new URL(url);
                    HttpsURLConnection conn = (HttpsURLConnection)connURL.openConnection();
                    UNGP_Feedback.setHttpProtocol(conn);
                    InputStream stream = conn.getInputStream();
                    Scanner scanner = new Scanner(stream, "utf-8").useDelimiter("\\A");
                    if (scanner.hasNext()) {
                        String collectionText = scanner.next();
                        try {
                            JSONObject jsonObject = new JSONObject(collectionText);
                            for (URule rule : ALL_RULES) {
                                rule.setPickedTimes(jsonObject.optInt(rule.getId(), -1));
                            }
                            LOGGER.info((Object)"Successfully loaded the pick times of rules from deep sync...");
                        }
                        catch (JSONException e) {
                            LOGGER.warn((Object)"Error loading json...");
                        }
                    }
                    stream.close();
                }
                catch (IOException e) {
                    LOGGER.warn((Object)("Error loading rules' pick times, but it doesn't matter...\n" + e));
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public static String getPNRuleString(boolean isPositive) {
        return UNGP_RulesManager.getRuleTypeName(false, false, isPositive);
    }

    public static String getGoldenRuleString() {
        return UNGP_RulesManager.getRuleTypeName(false, true, true);
    }

    public static String getRuleIconSpriteName(boolean isMilestone, boolean isGolden, boolean isPositive) {
        StringBuilder sb = new StringBuilder("graphics/ungp/icons/");
        if (isMilestone) {
            if (isGolden) {
                sb.append("golden");
                sb.append("_");
            }
            sb.append("milestone");
        } else if (isGolden) {
            sb.append("golden");
        } else {
            sb.append(isPositive ? "positive" : "negative");
        }
        sb.append("_icon.png");
        return sb.toString();
    }

    public static Color getPNColor(boolean isPositive) {
        if (isPositive) {
            return POSITIVE_COLOR;
        }
        return NEGATIVE_COLOR;
    }

    public static Color getGoldenColor() {
        return GOLDEN_COLOR;
    }

    public static Color getMilestoneColor() {
        return MILESTONE_COLOR;
    }

    public static Color getHighlightColor(boolean isPositive) {
        return isPositive ? Misc.getPositiveHighlightColor() : Misc.getNegativeHighlightColor();
    }

    public static void setStaticDifficulty(UNGP_SpecialistSettings.Difficulty difficulty) {
        globalDifficulty = difficulty;
    }

    public static List<URule> getAvailableRules(List<String> completedChallenges) {
        ArrayList<String> unlockedRuleIds = new ArrayList<String>();
        for (String completedChallenge : completedChallenges) {
            String mileStoneRuleId;
            UNGP_ChallengeInfo challengeInfo = UNGP_ChallengeManager.getChallengeInfo(completedChallenge);
            if (challengeInfo == null || (mileStoneRuleId = challengeInfo.getMilestoneToUnlock().getId()).isEmpty()) continue;
            unlockedRuleIds.add(mileStoneRuleId);
        }
        ArrayList<URule> availableRules = new ArrayList<URule>();
        for (URule rule : ALL_RULES) {
            if (rule.isMilestone()) {
                if (!unlockedRuleIds.contains(rule.getId())) continue;
                availableRules.add(rule);
                continue;
            }
            availableRules.add(rule);
        }
        return availableRules;
    }

    public static final class URule {
        private String buffID;
        private UNGP_RuleInfoLoader.UNGP_RuleInfo ruleInfo;
        private boolean isMilestoneRollLocked = true;
        private boolean isMilestoneProvider = false;
        private boolean isDescAffectedByLevel;
        private int pickedTimes = -1;

        public void setPickedTimes(int pickedTimes) {
            this.pickedTimes = pickedTimes;
        }

        public int getPickedTimes() {
            return this.pickedTimes;
        }

        URule(UNGP_RuleInfoLoader.UNGP_RuleInfo info) {
            this.buffID = "ungp_" + info.getId();
            this.ruleInfo = info;
            this.ruleInfo.getEffectPlugin().setRule(this);
            this.isDescAffectedByLevel = this.isDescAffectedByLevel();
        }

        public String getId() {
            return this.ruleInfo.getId();
        }

        public String getCodexEntryId() {
            return "UNGP_codex_rule_" + this.getId();
        }

        @Deprecated
        public String getBuffID() {
            return this.buffID;
        }

        public String getName() {
            return this.ruleInfo.getName();
        }

        public String getSpritePath() {
            return this.ruleInfo.getSpritePath();
        }

        public boolean isDefaultSource() {
            return UNGPUtils.isEmpty(this.ruleInfo.getSource());
        }

        @Deprecated
        public boolean isBonus() {
            return this.ruleInfo.isBonus();
        }

        public boolean isPositive() {
            return this.ruleInfo.isBonus();
        }

        public boolean isGolden() {
            return this.ruleInfo.isGolden();
        }

        public Color getCorrectColor() {
            if (this.isMilestone()) {
                if (this.isGolden()) {
                    return UNGP_RulesManager.getGoldenColor();
                }
                return UNGP_RulesManager.getMilestoneColor();
            }
            if (this.isGolden()) {
                return UNGP_RulesManager.getGoldenColor();
            }
            return UNGP_RulesManager.getPNColor(this.isPositive());
        }

        public Color getTooltipTitleColor() {
            return Misc.interpolateColor((Color)this.getCorrectColor(), (Color)Misc.getTextColor(), (float)0.8f);
        }

        public Color getCostColor() {
            return this.getCost() >= 0 ? Misc.getHighlightColor() : Misc.getNegativeHighlightColor();
        }

        public String getRuleTypeName() {
            return UNGP_RulesManager.getRuleTypeName(this.isMilestone(), this.isGolden(), this.isPositive());
        }

        public String getRuleTypeCharacter() {
            if (this.isGolden()) {
                return "G";
            }
            if (this.isMilestone()) {
                return "M";
            }
            return this.isPositive() ? "P" : "N";
        }

        public void addPreDesc(TooltipMakerAPI tooltip, float pad) {
            TooltipMakerAPI image = tooltip.beginImageWithText(UNGP_RulesManager.getRuleIconSpriteName(this.isMilestone(), this.isGolden(), this.isPositive()), 16.0f);
            image.addPara(this.getRuleTypeName(), this.getCorrectColor(), 0.0f);
            tooltip.addImageWithText(pad * 0.5f);
            if (!this.isDefaultSource()) {
                tooltip.setParaFontVictor14();
                tooltip.addPara(Constants.rules_i18n.get("rule_source") + this.ruleInfo.getSource(), Misc.getGrayColor(), pad * 0.5f);
                tooltip.setParaFontDefault();
            }
        }

        public void addDesc(TooltipMakerAPI tooltip, float pad, String prefix, UNGP_SpecialistSettings.Difficulty difficulty) {
            String[] values = difficulty == null ? this.getDescriptionParams(UNGP_SpecialistSettings.Difficulty.GAMMA) : this.getDescriptionParams(difficulty);
            Color highlightColor = this.isPositive() ? Misc.getHighlightColor() : Misc.getNegativeHighlightColor();
            tooltip.addPara(prefix + this.ruleInfo.getDesc(), pad, highlightColor, values);
        }

        public void addDesc(TooltipMakerAPI tooltip, float pad, String prefix) {
            this.addDesc(tooltip, pad, prefix, UNGP_RulesManager.getGlobalDifficulty());
        }

        public void addDescToItem(TooltipMakerAPI tooltip, float pad, String prefix, boolean isExpanded) {
            if (!this.isDescAffectedByLevel) {
                tooltip.addPara(Constants.rules_i18n.get("front_desc"), pad * 0.5f, Misc.getBasePlayerColor(), Misc.getHighlightColor(), new String[]{Constants.rules_i18n.get("any")});
                this.addDesc(tooltip, pad, prefix, null);
            } else {
                UNGP_SpecialistSettings.Difficulty difficulty = UNGP_RulesManager.getGlobalDifficulty();
                if (isExpanded) {
                    for (UNGP_SpecialistSettings.Difficulty itemDifficulty : UNGP_SpecialistSettings.Difficulty.values()) {
                        tooltip.addPara(Constants.rules_i18n.get("front_desc"), pad * 0.5f, difficulty == itemDifficulty ? Misc.getGrayColor() : Misc.getBasePlayerColor(), itemDifficulty.color, new String[]{itemDifficulty.name});
                        this.addDesc(tooltip, pad, prefix, itemDifficulty);
                        tooltip.addSpacer(pad * 0.5f);
                    }
                } else {
                    tooltip.addPara(Constants.rules_i18n.get("front_desc"), pad * 0.5f, Misc.getBasePlayerColor(), difficulty.color, new String[]{difficulty.name});
                    this.addDesc(tooltip, pad, prefix, difficulty);
                }
            }
        }

        public String[] getDescriptionParams(UNGP_SpecialistSettings.Difficulty difficulty) {
            String[] values = new String[10];
            for (int i = 0; i < 10; ++i) {
                values[i] = this.getRuleEffect().getDescriptionParams(i, difficulty);
            }
            return values;
        }

        public boolean isDescAffectedByLevel() {
            String lastCompared = null;
            for (UNGP_SpecialistSettings.Difficulty difficulty : UNGP_SpecialistSettings.Difficulty.values()) {
                String[] values = this.getDescriptionParams(difficulty);
                StringBuilder sb = new StringBuilder();
                for (String value : values) {
                    sb.append(value);
                }
                if (lastCompared == null) {
                    lastCompared = sb.toString();
                    continue;
                }
                String compared = sb.toString();
                if (lastCompared.contentEquals(compared)) continue;
                return true;
            }
            return false;
        }

        public void addRollDesc(TooltipMakerAPI tooltip, float pad, String prefix) {
            if (!this.isBasicallyRollable()) {
                tooltip.addPara(prefix + Constants.rules_i18n.get("not_rollable"), Misc.getGrayColor(), pad);
            }
        }

        public void addChallengeRelatedDesc(TooltipMakerAPI tooltip, float pad, String prefix, boolean isExpanded, boolean isCodex) {
            Color grayColor = Misc.getGrayColor();
            if (this.isMilestone()) {
                List<UNGP_ChallengeInfo> challengesCopy = UNGP_ChallengeManager.getChallengeInfosCopy();
                ArrayList<UNGP_ChallengeInfo> provider = new ArrayList<UNGP_ChallengeInfo>();
                for (UNGP_ChallengeInfo challengeInfo : challengesCopy) {
                    if (!challengeInfo.getMilestoneToUnlock().equals(this)) continue;
                    provider.add(challengeInfo);
                }
                if (!provider.isEmpty()) {
                    tooltip.addPara(Constants.rules_i18n.get("milestone_tip"), Misc.getBasePlayerColor(), pad);
                    tooltip.addSpacer(10.0f);
                    tooltip.setBulletedListMode(prefix);
                    for (UNGP_ChallengeInfo challengeInfo : provider) {
                        String sb = challengeInfo.getName() + " : " + challengeInfo.getConnectedRuleNames();
                        tooltip.addPara(sb, grayColor, 5.0f);
                    }
                }
            } else {
                List<UNGP_ChallengeInfo> challengesCopy = UNGP_ChallengeManager.getChallengeInfosCopy();
                ArrayList<UNGP_ChallengeInfo> provider = new ArrayList<UNGP_ChallengeInfo>();
                for (UNGP_ChallengeInfo challengeInfo : challengesCopy) {
                    if (!challengeInfo.getRulesRequired().contains(this)) continue;
                    provider.add(challengeInfo);
                }
                if (!provider.isEmpty()) {
                    boolean hasUncompletedChallenges = false;
                    boolean difficultyEnough = UNGP_ChallengeManager.isDifficultyEnough(UNGP_RulesManager.getGlobalDifficulty());
                    tooltip.addPara(Constants.rules_i18n.get("challenge_tip"), Misc.getBasePlayerColor(), pad);
                    tooltip.addSpacer(10.0f);
                    for (UNGP_ChallengeInfo challengeInfo : provider) {
                        tooltip.setBulletedListMode(prefix);
                        boolean isChallengeCompleted = !UNGP_ChallengeManager.getTemporaryCompletedChallenges().isEmpty() && UNGP_ChallengeManager.getTemporaryCompletedChallenges().contains(challengeInfo.getId());
                        tooltip.addSpacer(5.0f);
                        if (isCodex) {
                            tooltip.addPara(challengeInfo.getName(), UNGP_RulesManager.getMilestoneColor(), 0.0f);
                        } else if (isChallengeCompleted) {
                            tooltip.addPara(challengeInfo.getName() + " - " + Constants.rules_i18n.get("challenge_tip_completed"), grayColor, 0.0f);
                        } else {
                            tooltip.addPara(challengeInfo.getName() + " - %s", 0.0f, UNGP_RulesManager.getMilestoneColor(), Misc.getNegativeHighlightColor(), new String[]{Constants.rules_i18n.get("challenge_tip_uncompleted")});
                            hasUncompletedChallenges = true;
                        }
                        if (!isExpanded) continue;
                        tooltip.setBulletedListMode(prefix + "  -");
                        challengeInfo.showChallengeDetails(tooltip, grayColor, null);
                    }
                    if (hasUncompletedChallenges && !difficultyEnough && !isCodex) {
                        tooltip.setBulletedListMode(prefix);
                        tooltip.addPara(Constants.rules_i18n.get("challenge_tip_difficultyNotMeet"), 5.0f, Misc.getNegativeHighlightColor(), grayColor, new String[]{UNGP_SpecialistSettings.Difficulty.ALPHA.name, UNGP_SpecialistSettings.Difficulty.OMEGA.name}).setHighlightColors(new Color[]{UNGP_SpecialistSettings.Difficulty.ALPHA.color, UNGP_SpecialistSettings.Difficulty.OMEGA.color});
                    }
                }
            }
            tooltip.setBulletedListMode(null);
        }

        public void addChallengeRelatedDesc(TooltipMakerAPI tooltip, float pad, String detailPrefix, boolean showMore) {
            this.addChallengeRelatedDesc(tooltip, pad, detailPrefix, showMore, false);
        }

        public void addDetailsToTooltip(TooltipMakerAPI tooltip, boolean isExpanded, boolean isCodex) {
            float pad = 18.0f;
            String bulletPrefix = "        ";
            RuleDescBackgroundPlugin.addToTooltip(tooltip, this, isCodex);
            tooltip.setTitleOrbitronLarge();
            tooltip.addTitle(this.getName(), this.getTooltipTitleColor());
            this.addPreDesc(tooltip, pad);
            this.addDescToItem(tooltip, pad, bulletPrefix, isExpanded);
            this.addRollDesc(tooltip, pad, bulletPrefix);
            this.addChallengeRelatedDesc(tooltip, pad, bulletPrefix, isExpanded, isCodex);
            this.addCostAndPickTimes(tooltip, pad);
            if (!isCodex) {
                tooltip.setCodexEntryId(this.getId());
            }
        }

        public boolean isTooltipExpandable() {
            return this.isMilestoneProvider || this.isDescAffectedByLevel;
        }

        public void addDesc(TooltipMakerAPI tooltip, float pad) {
            this.addDesc(tooltip, pad, "");
        }

        public void addShortDesc(TooltipMakerAPI tooltip, float pad) {
            tooltip.addPara(this.ruleInfo.getShortDesc(), pad);
        }

        public Object[] generateCombatTips(UNGP_SpecialistSettings.Difficulty difficulty) {
            ArrayList<Object> messageList = new ArrayList<Object>();
            String originDesc = this.ruleInfo.getDesc();
            String[] unformulatedDesc = originDesc.split("%s");
            Color baseColor = UNGP_RulesManager.getPNColor(this.isPositive());
            Color hlColor = this.isPositive() ? Misc.getHighlightColor() : Misc.getNegativeHighlightColor();
            for (int i = 0; i < unformulatedDesc.length; ++i) {
                String hlString;
                String baseString = unformulatedDesc[i];
                if (baseString != null && !baseString.isEmpty()) {
                    messageList.add(baseColor);
                    messageList.add(baseString);
                }
                if ((hlString = this.getRuleEffect().getDescriptionParams(i, difficulty)) == null || hlString.isEmpty()) continue;
                messageList.add(hlColor);
                messageList.add(this.getRuleEffect().getDescriptionParams(i, difficulty));
            }
            return messageList.toArray();
        }

        public void addCostAndPickTimes(TooltipMakerAPI tooltip, float pad) {
            String costString;
            Color highlight;
            UIComponentAPI spacer = tooltip.addSpacer(this.pickedTimes > 0 ? pad - 12.0f : pad);
            LabelAPI para = null;
            if (this.pickedTimes > 0) {
                tooltip.setParaFontVictor14();
                para = tooltip.addPara(Constants.rules_i18n.get("pick_times_desc"), 0.0f, Misc.getGrayColor(), Misc.getStoryOptionColor(), new String[]{Constants.rules_i18n.get("button_feedback"), "" + this.pickedTimes});
                para.setAlignment(Alignment.RMID);
                para.setOpacity(0.8f);
                para.getPosition().inBR(0.0f, 5.0f);
                tooltip.setParaFontDefault();
            }
            int cost = this.getCost();
            Color baseColor = Misc.getBasePlayerColor();
            if (cost > 0) {
                highlight = UNGP_RulesManager.getHighlightColor(true);
                costString = "+" + cost;
            } else if (cost == 0) {
                highlight = Misc.getHighlightColor();
                costString = "" + cost;
            } else {
                highlight = UNGP_RulesManager.getHighlightColor(false);
                costString = "" + cost;
            }
            tooltip.setParaOrbitronLarge();
            LabelAPI costLabel = tooltip.addPara(Constants.rules_i18n.get("cost_point"), 0.0f, baseColor, highlight, new String[]{costString});
            if (para != null) {
                costLabel.getPosition().belowLeft(spacer, costLabel.getPosition().getHeight() - 8.0f);
            }
            tooltip.setParaFontDefault();
        }

        public int getCost() {
            return this.ruleInfo.getCost();
        }

        public String getCostString() {
            int cost = this.getCost();
            return cost > 0 ? "+" + cost : String.valueOf(cost);
        }

        public UNGP_RuleEffectAPI getRuleEffect() {
            return this.ruleInfo.getEffectPlugin();
        }

        public UNGP_RuleInfoLoader.UNGP_RuleInfo getRuleInfo() {
            return this.ruleInfo;
        }

        public String getExtra1() {
            return this.ruleInfo.getExtra1();
        }

        public String getExtra2() {
            return this.ruleInfo.getExtra2();
        }

        public boolean hasTag(String tag) {
            return this.ruleInfo.getTags().contains(tag);
        }

        public boolean hasTag(Tags tag) {
            return this.ruleInfo.getTags().contains(tag.id);
        }

        public static URule getByID(String id) {
            for (URule rule : ALL_RULES) {
                if (!rule.getId().contentEquals(id)) continue;
                return rule;
            }
            return null;
        }

        public boolean isRollable() {
            if (!this.isBasicallyRollable()) {
                return false;
            }
            if (this.isMilestone()) {
                return !this.isMilestoneRollLocked;
            }
            return true;
        }

        private boolean isBasicallyRollable() {
            return !this.hasTag(Tags.NO_ROLL);
        }

        public boolean isMilestone() {
            return this.hasTag(Tags.MILESTONE);
        }

        public static enum Tags {
            NO_ROLL("no_roll"),
            MILESTONE("milestone");

            private final String id;

            private Tags(String id) {
                this.id = id;
            }
        }
    }

    public static class UNGP_RuleSorter
    implements Comparator<URule> {
        @Override
        public int compare(URule o1, URule o2) {
            int compare = Boolean.compare(!o1.isPositive(), !o2.isPositive());
            if (compare == 0 && (compare = Boolean.compare(o1.isGolden(), o2.isGolden())) == 0) {
                compare = Boolean.compare(!o1.isMilestone(), !o2.isMilestone());
                if (compare == 0 && (compare = Integer.compare(Math.abs(o1.getCost()), Math.abs(o2.getCost()))) == 0) {
                    compare = o1.getId().compareTo(o2.getId());
                }
            }
            compare = -compare;
            return compare;
        }
    }
}

