/*
 * Decompiled with CFR 0.152.
 */
package ungp.scripts.campaign.specialist.rules;

import java.util.ArrayList;
import java.util.List;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;

public class UNGP_RulePickHelper {
    public static List<UnmetReason> generateUnmetReasons(List<UNGP_RulesManager.URule> rules, UNGP_SpecialistSettings.Difficulty difficulty) {
        ArrayList<UnmetReason> reasons = new ArrayList<UnmetReason>();
        if (rules.isEmpty()) {
            reasons.add(new UnmetReason(UnmetReasonType.EMPTY_RULES));
            return reasons;
        }
        if (difficulty == null) {
            reasons.add(new UnmetReason(UnmetReasonType.GENERAL));
            return reasons;
        }
        int cost = 0;
        for (UNGP_RulesManager.URule rule : rules) {
            cost += rule.getCost();
        }
        if (cost < 0) {
            reasons.add(new UnmetReason(UnmetReasonType.WRONG_COST));
        }
        int size = rules.size();
        int goldenRuleSize = 0;
        for (UNGP_RulesManager.URule rule : rules) {
            if (!rule.isGolden()) continue;
            ++goldenRuleSize;
        }
        if (goldenRuleSize > 1) {
            reasons.add(new UnmetReason(UnmetReasonType.GOLDEN_MORE_THAN_ONE));
        }
        if (size > difficulty.maxRules) {
            reasons.add(new UnmetReason(UnmetReasonType.TOO_MUCH_RULES));
        }
        if (size < difficulty.minRules) {
            reasons.add(new UnmetReason(UnmetReasonType.TOO_FEW_RULES));
        }
        return reasons;
    }

    public static boolean hasUnmetReasons(List<UNGP_RulesManager.URule> rules, UNGP_SpecialistSettings.Difficulty difficulty) {
        return !UNGP_RulePickHelper.generateUnmetReasons(rules, difficulty).isEmpty();
    }

    public static class UnmetReason {
        private UnmetReasonType type;
        private Object[] params;

        public UnmetReason(UnmetReasonType type, Object ... params) {
            this.type = type;
            this.params = params;
        }

        public UnmetReason(UnmetReasonType type) {
            this.type = type;
        }

        public UnmetReasonType getType() {
            return this.type;
        }
    }

    public static enum UnmetReasonType {
        WRONG_COST("unmet_wrong_cost"),
        GOLDEN_MORE_THAN_ONE("unmet_golden_more_than_one"),
        TOO_FEW_RULES("unmet_too_few_rules"),
        TOO_MUCH_RULES("unmet_too_much_rules"),
        EMPTY_RULES("unmet_empty_rules"),
        GENERAL("unmet_general");

        final String i18n_key;

        public String getI18nKey() {
            return this.i18n_key;
        }

        private UnmetReasonType(String i18n_key) {
            this.i18n_key = i18n_key;
        }
    }
}

