/*
 * Decompiled with CFR 0.152.
 */
package ungp.scripts.campaign.specialist.intel;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomUIPanelPlugin;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.CustomPanelAPI;
import com.fs.starfarer.api.ui.CutStyle;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.PositionAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.UIComponentAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Set;
import ungp.scripts.campaign.UNGP_InGameData;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeManager;
import ungp.scripts.campaign.specialist.dialog.UNGP_RepickRulesDialog;
import ungp.scripts.campaign.specialist.intel.UNGP_SpecialistBackgroundUI;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;
import ungp.scripts.ui.HorizontalButtonGroup;
import ungp.scripts.ui.UIRect;
import ungp.scripts.utils.Constants;
import ungp.scripts.utils.UNGP_Feedback;

public class UNGP_SpecialistIntel
extends BaseIntelPlugin {
    private static final String KEY = "UNGP_SI";
    private static final String FEED_BACK = "UNGP_feedBack";
    private static final Object OPTION_ID_DETAILS = new Object();
    private static final Object OPTION_ID_TIPS = new Object();
    private static Object checkedButton = OPTION_ID_DETAILS;
    private transient ButtonAPI simulationCheckBox = null;

    public UNGP_SpecialistIntel() {
        this.setImportant(true);
    }

    public static UNGP_SpecialistIntel getInstance() {
        IntelInfoPlugin intel = Global.getSector().getIntelManager().getFirstIntel(UNGP_SpecialistIntel.class);
        return (UNGP_SpecialistIntel)intel;
    }

    public void notifyPlayerAboutToOpenIntelScreen() {
        UNGP_SpecialistBackgroundUI.cleanBGUI();
        checkedButton = OPTION_ID_DETAILS;
    }

    public void createLargeDescription(CustomPanelAPI panel, float width, float height) {
        TooltipMakerAPI image;
        UNGP_SpecialistBackgroundUI.resumeTicking();
        CustomPanelAPI customPanel = panel.createCustomPanel(width, height, (CustomUIPanelPlugin)new UNGP_SpecialistBackgroundUI());
        panel.addComponent((UIComponentAPI)customPanel);
        Color positiveColor = Misc.getHighlightColor();
        boolean showDetails = checkedButton == OPTION_ID_DETAILS;
        UNGP_InGameData inGameData = UNGP_InGameData.getDataInSave();
        ArrayList<UNGP_RulesManager.URule> bonusRules = new ArrayList<UNGP_RulesManager.URule>();
        ArrayList<UNGP_RulesManager.URule> notBonusRules = new ArrayList<UNGP_RulesManager.URule>();
        for (UNGP_RulesManager.URule rule : UNGP_RulesManager.ACTIVATED_RULES_IN_THIS_GAME) {
            if (rule.isPositive()) {
                bonusRules.add(rule);
                continue;
            }
            notBonusRules.add(rule);
        }
        bonusRules.sort(new UNGP_RulesManager.UNGP_RuleSorter());
        notBonusRules.sort(new UNGP_RulesManager.UNGP_RuleSorter());
        ArrayList<UNGP_RulesManager.URule> combatRules = new ArrayList<UNGP_RulesManager.URule>();
        ArrayList<UNGP_RulesManager.URule> campaignRules = new ArrayList<UNGP_RulesManager.URule>();
        for (UNGP_RulesManager.URule rule : bonusRules) {
            if (UNGP_RulesManager.CAMPAIGN_RULES_IN_THIS_GAME.contains(rule)) {
                campaignRules.add(rule);
            }
            if (!UNGP_RulesManager.COMBAT_RULES_IN_THIS_GAME.contains(rule)) continue;
            combatRules.add(rule);
        }
        for (UNGP_RulesManager.URule rule : notBonusRules) {
            if (UNGP_RulesManager.CAMPAIGN_RULES_IN_THIS_GAME.contains(rule)) {
                campaignRules.add(rule);
            }
            if (!UNGP_RulesManager.COMBAT_RULES_IN_THIS_GAME.contains(rule)) continue;
            combatRules.add(rule);
        }
        float contentShrink = 20.0f;
        UIRect fullScreen = new UIRect(0.0f, 0.0f, width, height);
        UIRect[] fullScreenSplits = fullScreen.splitVertically(120.0f);
        UIRect titleRect = fullScreenSplits[0];
        UIRect[] titleRectSplits = titleRect.splitHorizontally(0.35f, 0.35f, 0.3f);
        UIRect levelTitle = titleRectSplits[0].shrink(contentShrink);
        TooltipMakerAPI tooltip = levelTitle.beginTooltip(panel, false);
        UNGP_SpecialistSettings.Difficulty difficulty = inGameData.getDifficulty();
        TooltipMakerAPI imageMaker = tooltip.beginImageWithText(difficulty.spritePath, 80.0f);
        imageMaker.setParaOrbitronLarge();
        imageMaker.addPara(Constants.root_i18n.get("rulepick_level"), 0.0f, difficulty.color, new String[]{difficulty.name});
        imageMaker.setParaFontDefault();
        tooltip.addImageWithText(0.0f);
        levelTitle.addTooltip();
        UIRect checkBoxRect = titleRectSplits[1].shrink(contentShrink);
        tooltip = checkBoxRect.beginTooltip(panel, false);
        final float checkBoxRectWidth = checkBoxRect.getWidth();
        float checkBoxRectHeight = checkBoxRect.getHeight();
        ButtonAPI button_details = tooltip.addAreaCheckbox(Constants.rules_i18n.get("button_details"), OPTION_ID_DETAILS, Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Misc.getBrightPlayerColor(), checkBoxRectWidth, checkBoxRectHeight * 0.4f, 0.0f);
        tooltip.addTooltipToPrevious(new TooltipMakerAPI.TooltipCreator(){

            public boolean isTooltipExpandable(Object tooltipParam) {
                return false;
            }

            public float getTooltipWidth(Object tooltipParam) {
                return checkBoxRectWidth * 0.4f;
            }

            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                tooltip.addPara(Constants.rules_i18n.get("button_details_tooltip"), 0.0f);
            }
        }, TooltipMakerAPI.TooltipLocation.LEFT);
        button_details.setChecked(checkedButton == OPTION_ID_DETAILS);
        ButtonAPI button_tips = tooltip.addAreaCheckbox(Constants.rules_i18n.get("button_tips"), OPTION_ID_TIPS, Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Misc.getBrightPlayerColor(), checkBoxRectWidth, checkBoxRectHeight * 0.4f, checkBoxRectHeight * 0.2f);
        tooltip.addTooltipToPrevious(new TooltipMakerAPI.TooltipCreator(){

            public boolean isTooltipExpandable(Object tooltipParam) {
                return false;
            }

            public float getTooltipWidth(Object tooltipParam) {
                return checkBoxRectWidth * 0.4f;
            }

            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                tooltip.addPara(Constants.rules_i18n.get("button_tips_tooltip"), 0.0f);
            }
        }, TooltipMakerAPI.TooltipLocation.LEFT);
        button_tips.setChecked(checkedButton == OPTION_ID_TIPS);
        checkBoxRect.addTooltip();
        UIRect repickRect = titleRectSplits[2].shrink(contentShrink);
        tooltip = repickRect.beginTooltip(panel, false);
        tooltip.addPara(Constants.rules_i18n.get("current_cycle") + "%s", 0.0f, positiveColor, new String[]{"" + Global.getSector().getClock().getCycle()}).setAlignment(Alignment.RMID);
        boolean lockedBecauseOfChallenges = UNGP_ChallengeManager.isRepickLockedByChallenges();
        if (lockedBecauseOfChallenges) {
            tooltip.addPara(Constants.rules_i18n.get("repick_blocked"), Misc.getNegativeHighlightColor(), 0.0f).setAlignment(Alignment.RMID);
        } else {
            tooltip.addPara(Constants.rules_i18n.get("current_times_to_refresh") + "%s", 0.0f, positiveColor, new String[]{Constants.rules_i18n.get("repick_rules"), "" + inGameData.getTimesToChangeSpecialistMode()}).setAlignment(Alignment.RMID);
        }
        Color buttonBase = Misc.getBasePlayerColor();
        Color buttonDark = Misc.getDarkPlayerColor();
        HorizontalButtonGroup horizontalButtonGroup = new HorizontalButtonGroup();
        float repickRectWidth = repickRect.getWidth();
        float buttonPad = 10.0f;
        ButtonAPI uploadButton = tooltip.addButton(Constants.rules_i18n.get("button_feedback"), (Object)FEED_BACK, Misc.getStoryOptionColor(), Misc.getStoryDarkColor(), Alignment.MID, CutStyle.C2_MENU, repickRectWidth * 0.3f, repickRect.getHeight() * 0.35f, 20.0f);
        uploadButton.setEnabled(!UNGP_Feedback.isFeedbackSent());
        ButtonAPI repickButton = tooltip.addButton(Constants.rules_i18n.get("repick_rules"), (Object)KEY, buttonBase, buttonDark, Alignment.MID, CutStyle.C2_MENU, repickRectWidth * 0.7f - buttonPad, repickRect.getHeight() * 0.35f, 20.0f);
        repickButton.setEnabled(!lockedBecauseOfChallenges && inGameData.getTimesToChangeSpecialistMode() > 0);
        horizontalButtonGroup.addButton(uploadButton);
        horizontalButtonGroup.addButton(repickButton);
        horizontalButtonGroup.updateTooltip(tooltip, buttonPad);
        repickRect.addTooltip();
        UIRect contentRect = fullScreenSplits[1];
        UIRect[] contentRectSplits = contentRect.splitHorizontally(0.35f, 0.35f, 0.3f);
        UIRect positiveRect = contentRectSplits[0];
        UIRect[] positiveRectSplits = positiveRect.splitVertically(30.0f);
        UIRect positiveRectTitle = positiveRectSplits[0].shrink(contentShrink);
        tooltip = positiveRectTitle.beginTooltip(panel, false);
        tooltip.setParaOrbitronLarge();
        tooltip.addPara(UNGP_RulesManager.getPNRuleString(true), UNGP_RulesManager.getPNColor(true), 0.0f);
        tooltip.setParaFontDefault();
        this.addLine(tooltip, positiveRectTitle.getWidth() - 5.0f, 3.0f);
        positiveRectTitle.addTooltip();
        UIRect positiveRectContent = positiveRectSplits[1].shrink(contentShrink);
        tooltip = positiveRectContent.beginTooltip(panel, true);
        for (UNGP_RulesManager.URule uRule : bonusRules) {
            TooltipMakerAPI iconMaker = tooltip.beginImageWithText(uRule.getSpritePath(), 64.0f);
            iconMaker.addPara(uRule.getName(), uRule.getCorrectColor(), 0.0f);
            if (showDetails) {
                uRule.addDesc(iconMaker, 0.0f);
                tooltip.addImageWithText(10.0f);
                tooltip.addTooltipToPrevious(UNGP_RulesManager.createRuleItemTooltip(uRule), TooltipMakerAPI.TooltipLocation.BELOW);
                continue;
            }
            if (!uRule.getRuleEffect().addIntelTips(iconMaker)) continue;
            tooltip.addImageWithText(10.0f);
        }
        positiveRectContent.addTooltip();
        UIRect negativeRect = contentRectSplits[1];
        UIRect[] negativeRectSplits = negativeRect.splitVertically(30.0f);
        UIRect negativeRectTitle = negativeRectSplits[0].shrink(contentShrink);
        tooltip = negativeRectTitle.beginTooltip(panel, false);
        tooltip.setParaOrbitronLarge();
        tooltip.addPara(UNGP_RulesManager.getPNRuleString(false), UNGP_RulesManager.getPNColor(false), 0.0f);
        tooltip.setParaFontDefault();
        this.addLine(tooltip, negativeRectTitle.getWidth() - 5.0f, 3.0f);
        negativeRectTitle.addTooltip();
        UIRect negativeRectContent = negativeRectSplits[1].shrink(contentShrink);
        tooltip = negativeRectContent.beginTooltip(panel, true);
        for (UNGP_RulesManager.URule rule : notBonusRules) {
            TooltipMakerAPI iconMaker = tooltip.beginImageWithText(rule.getSpritePath(), 64.0f);
            iconMaker.addPara(rule.getName(), rule.getCorrectColor(), 0.0f);
            if (showDetails) {
                rule.addDesc(iconMaker, 0.0f);
                tooltip.addImageWithText(10.0f);
                tooltip.addTooltipToPrevious(UNGP_RulesManager.createRuleItemTooltip(rule), TooltipMakerAPI.TooltipLocation.BELOW);
                continue;
            }
            if (!rule.getRuleEffect().addIntelTips(iconMaker)) continue;
            tooltip.addImageWithText(10.0f);
        }
        negativeRectContent.addTooltip();
        UIRect gameStateRect = contentRectSplits[2];
        UIRect[] gameStateRectSplits = gameStateRect.splitVertically(30.0f);
        UIRect gameStateRectTitle = gameStateRectSplits[0].shrink(contentShrink);
        tooltip = gameStateRectTitle.beginTooltip(panel, false);
        tooltip.setParaOrbitronLarge();
        tooltip.addPara(Constants.rules_i18n.get("suited_state"), Misc.getButtonTextColor(), 0.0f);
        float f = tooltip.computeStringWidth(Constants.rules_i18n.get("suited_state")) + 10.0f;
        PositionAPI titlePos = tooltip.getPrev().getPosition();
        tooltip.setParaFontDefault();
        this.simulationCheckBox = tooltip.addCheckbox(20.0f, titlePos.getHeight(), Constants.rules_i18n.get("enable_in_simulation"), ButtonAPI.UICheckboxSize.SMALL, 0.0f);
        this.simulationCheckBox.getPosition().inTL(f, 0.0f);
        this.simulationCheckBox.setChecked(UNGP_SpecialistSettings.isRulesEnabledInSimulation());
        tooltip.addSpacer(0.0f).getPosition().inTL(titlePos.getX(), titlePos.getHeight());
        this.addLine(tooltip, gameStateRectTitle.getWidth() - 5.0f, 3.0f);
        gameStateRectTitle.addTooltip();
        UIRect uIRect = gameStateRectSplits[1].shrink(contentShrink);
        tooltip = uIRect.beginTooltip(panel, true);
        tooltip.addSpacer(5.0f);
        if (!campaignRules.isEmpty()) {
            tooltip.setParaOrbitronLarge();
            tooltip.addPara(Constants.rules_i18n.get("campaign_state"), 0.0f);
            tooltip.setParaFontDefault();
            tooltip.addSpacer(5.0f);
            for (UNGP_RulesManager.URule rule : campaignRules) {
                image = tooltip.beginImageWithText(rule.getSpritePath(), 16.0f);
                image.addPara(rule.getName(), rule.getCorrectColor(), 0.0f);
                tooltip.addImageWithText(2.0f);
            }
            tooltip.setBulletedListMode(null);
        }
        if (!combatRules.isEmpty()) {
            tooltip.setParaOrbitronLarge();
            tooltip.addPara(Constants.rules_i18n.get("combat_state"), 10.0f);
            tooltip.setParaFontDefault();
            tooltip.addSpacer(5.0f);
            for (UNGP_RulesManager.URule rule : combatRules) {
                image = tooltip.beginImageWithText(rule.getSpritePath(), 16.0f);
                image.addPara(rule.getName(), rule.getCorrectColor(), 0.0f);
                tooltip.addImageWithText(2.0f);
            }
            tooltip.setBulletedListMode(null);
        }
        uIRect.addTooltip();
    }

    private void addLine(TooltipMakerAPI tooltip, float width, float pad) {
        Color color = new Color(77, 150, 154, 200);
        LabelAPI heading = tooltip.addSectionHeading("", color, color, Alignment.MID, pad);
        heading.getPosition().setSize(width, 1.0f);
    }

    public void reportPlayerClickedOn() {
        if (this.simulationCheckBox != null) {
            UNGP_SpecialistSettings.setRulesEnabledInSimulation(this.simulationCheckBox.isChecked());
        }
    }

    public boolean doesButtonHaveConfirmDialog(Object buttonId) {
        if (buttonId == FEED_BACK) {
            return true;
        }
        return super.doesButtonHaveConfirmDialog(buttonId);
    }

    public void createConfirmationPrompt(Object buttonId, TooltipMakerAPI prompt) {
        if (buttonId == FEED_BACK) {
            prompt.addPara(Constants.rules_i18n.get("button_feedback_tips"), 0.0f, Misc.getStoryOptionColor(), new String[]{"1"});
            prompt.addPara(Constants.rules_i18n.get("button_feedback_tips_detailed"), Misc.getGrayColor(), 20.0f).italicize();
        }
        super.createConfirmationPrompt(buttonId, prompt);
    }

    public void buttonPressConfirmed(Object buttonId, IntelUIAPI ui) {
        if (buttonId == KEY) {
            ui.showDialog(null, (InteractionDialogPlugin)new UNGP_RepickRulesDialog(ui, (IntelInfoPlugin)this));
            UNGP_SpecialistBackgroundUI.stopTicking();
        }
        if (buttonId == FEED_BACK) {
            UNGP_Feedback.sendPlayerRulesToServer(UNGP_InGameData.getDataInSave().getActivatedRules());
            UNGP_Feedback.setFeedBackSent();
            Global.getSoundPlayer().playUISound("UNGP_deep_sync", 1.0f, 1.0f);
            Global.getSector().getPlayerStats().addStoryPoints(1);
            ui.updateUIForItem((IntelInfoPlugin)this);
        }
        if (buttonId == OPTION_ID_DETAILS || buttonId == OPTION_ID_TIPS) {
            checkedButton = buttonId;
            ui.updateUIForItem((IntelInfoPlugin)this);
        }
    }

    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color c = this.getTitleColor(mode);
        float pad = 3.0f;
        float opad = 10.0f;
        if (this.listInfoParam == null) {
            info.addPara(this.getName(), c, 0.0f);
            this.bullet(info);
            info.addPara(this.getDesc(), g, pad);
        } else {
            RuleMessage message = (RuleMessage)this.listInfoParam;
            info.addPara(message.rule.getName(), c, 0.0f);
            this.bullet(info);
            info.addPara(message.text, pad, g, h, message.highlights);
        }
        this.unindent(info);
    }

    public String getDesc() {
        return Constants.rules_i18n.get("mode_desc");
    }

    public String getName() {
        return Constants.rules_i18n.get("mode_name");
    }

    public String getIcon() {
        if (this.listInfoParam == null) {
            return UNGP_SpecialistSettings.getSpecialistModeIconPath();
        }
        RuleMessage message = (RuleMessage)this.listInfoParam;
        return message.rule.getSpritePath();
    }

    public Set<String> getIntelTags(SectorMapAPI map) {
        Set tags = super.getIntelTags(map);
        tags.add("ungp");
        return tags;
    }

    public String getCommMessageSound() {
        if (this.isSendingUpdate()) {
            return UNGP_SpecialistIntel.getSoundStandardUpdate();
        }
        return "ui_specialist_on";
    }

    public IntelInfoPlugin.IntelSortTier getSortTier() {
        return IntelInfoPlugin.IntelSortTier.TIER_0;
    }

    public boolean hasSmallDescription() {
        return false;
    }

    public boolean hasLargeDescription() {
        return true;
    }

    public static class RuleMessage {
        UNGP_RulesManager.URule rule;
        String text;
        String[] highlights;

        public RuleMessage(UNGP_RulesManager.URule rule, String text, String ... highlights) {
            this.rule = rule;
            this.text = text;
            this.highlights = highlights;
        }

        public void send() {
            UNGP_SpecialistIntel.getInstance().sendUpdateIfPlayerHasIntel(this, false);
        }
    }
}

