/*
 * Decompiled with CFR 0.152.
 */
package ungp.scripts.campaign.specialist.intel;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCustomUIPanelPlugin;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.ui.PositionAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.opengl.GL11;

public class UNGP_SpecialistBackgroundUI
extends BaseCustomUIPanelPlugin {
    public static final Color ABOVE_BG_COLOR = new Color(25, 255, 140);
    public static final Color BOTTOM_BG_COLOR = new Color(255, 26, 106);
    private static float uiElapsed = 0.0f;
    private static float uiLoopVolume = 0.0f;
    private PositionAPI p;
    private SpriteAPI seamless_bg = Global.getSettings().getSprite("fx", "UNGP_specialist_bg_seamless");
    private SpriteAPI ring_bg0 = Global.getSettings().getSprite("fx", "UNGP_specialist_bg_seamless_ring0");
    private SpriteAPI ring_bg1 = Global.getSettings().getSprite("fx", "UNGP_specialist_bg_seamless_ring1");
    private SpriteAPI ring_bg2 = Global.getSettings().getSprite("fx", "UNGP_specialist_bg_seamless_ring2");
    private SpriteAPI corner = Global.getSettings().getSprite("fx", "UNGP_specialist_bg_corner");
    private float halfSize = this.corner.getWidth() / 2.0f;
    private float extraAlpha = 1.0f;
    private static boolean ticking = true;

    public UNGP_SpecialistBackgroundUI() {
        this.ring_bg0.setSize(650.0f, 650.0f);
        this.ring_bg0.setAdditiveBlend();
        this.ring_bg1.setSize(650.0f, 650.0f);
        this.ring_bg1.setAdditiveBlend();
        this.ring_bg2.setSize(650.0f, 650.0f);
        this.ring_bg2.setAdditiveBlend();
    }

    public UNGP_SpecialistBackgroundUI(float extraAlpha) {
        this();
        this.extraAlpha = extraAlpha;
    }

    public static void cleanBGUI() {
        if (uiElapsed > 100000.0f) {
            uiElapsed = Misc.random.nextFloat() * 1000.0f;
        }
        uiLoopVolume = 0.0f;
        ticking = true;
    }

    public void positionChanged(PositionAPI position) {
        this.p = position;
    }

    public void renderBelow(float alphaMult) {
        if (this.p == null) {
            return;
        }
        float x = this.p.getX();
        float y = this.p.getY();
        float w = this.p.getWidth();
        float h = this.p.getHeight();
        alphaMult *= this.extraAlpha;
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)2960);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3553);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL11.glStencilFunc((int)519, (int)16, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7681);
        GL11.glStencilMask((int)255);
        GL11.glClearStencil((int)0);
        GL11.glClear((int)1024);
        Misc.renderQuad((float)x, (float)y, (float)w, (float)h, (Color)Color.black, (float)1.0f);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glStencilFunc((int)514, (int)16, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
        GL11.glStencilMask((int)0);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)7);
        Color color = BOTTOM_BG_COLOR;
        GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * alphaMult * 0.08f)));
        GL11.glVertex2f((float)x, (float)y);
        GL11.glVertex2f((float)(x + w), (float)y);
        color = ABOVE_BG_COLOR;
        GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * alphaMult * 0.08f)));
        GL11.glVertex2f((float)(x + w), (float)(y + h));
        GL11.glVertex2f((float)x, (float)(y + h));
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glBindTexture((int)3553, (int)this.seamless_bg.getTextureId());
        float addOnTexX = w / this.seamless_bg.getWidth();
        float addOnTexY = h / this.seamless_bg.getHeight();
        color = Color.cyan;
        for (int i = 0; i < 2; ++i) {
            GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * alphaMult * (0.06f + 0.06f * (float)i))));
            float progress = uiElapsed * (0.05f + 0.1f * (float)i);
            GL11.glBegin((int)7);
            float v = (float)i * 0.2f + 0.1595f;
            float v2 = (float)i * 0.4f + 0.3215f;
            GL11.glTexCoord2f((float)(v + progress), (float)(v2 + progress));
            GL11.glVertex2f((float)x, (float)y);
            GL11.glTexCoord2f((float)(v + progress), (float)(v2 + progress + addOnTexY));
            GL11.glVertex2f((float)x, (float)(y + h));
            GL11.glTexCoord2f((float)(v + progress + addOnTexX), (float)(v2 + progress + addOnTexY));
            GL11.glVertex2f((float)(x + w), (float)(y + h));
            GL11.glTexCoord2f((float)(v + progress + addOnTexX), (float)(v2 + progress));
            GL11.glVertex2f((float)(x + w), (float)y);
            GL11.glEnd();
        }
        Color interpolateColor = Misc.interpolateColor((Color)Color.cyan, (Color)Color.red, (float)((float)((Math.sin(uiElapsed * 0.5f) + 1.0) / 2.0)));
        Color interpolateColor2 = Misc.interpolateColor((Color)Color.red, (Color)Color.cyan, (float)((float)((Math.cos(uiElapsed * 0.5f) + 1.0) / 2.0)));
        this.ring_bg0.setAlphaMult(alphaMult * 0.4f);
        this.ring_bg0.setAngle(MathUtils.clampAngle((float)(uiElapsed * 30.0f)));
        this.ring_bg0.setColor(interpolateColor);
        this.ring_bg0.renderAtCenter(x + w * 0.9f, y + h * 0.2f);
        this.ring_bg1.setAlphaMult(alphaMult * 0.4f);
        this.ring_bg1.setAngle(MathUtils.clampAngle((float)(uiElapsed * -10.0f)));
        this.ring_bg1.setColor(Color.cyan);
        this.ring_bg1.renderAtCenter(x + w * 0.9f, y + h * 0.2f);
        this.ring_bg2.setAlphaMult(alphaMult * 0.4f);
        this.ring_bg2.setAngle(MathUtils.clampAngle((float)(uiElapsed * -30.0f)));
        this.ring_bg2.setColor(interpolateColor2);
        this.ring_bg2.renderAtCenter(x + w * 0.9f, y + h * 0.2f);
        this.corner.setAngle(90.0f);
        this.corner.renderAtCenter(x + this.halfSize, y + this.halfSize);
        this.corner.setAngle(0.0f);
        this.corner.renderAtCenter(x + this.halfSize, y + h - this.halfSize);
        this.corner.setAngle(-90.0f);
        this.corner.renderAtCenter(x + w - this.halfSize, y + h - this.halfSize);
        this.corner.setAngle(-180.0f);
        this.corner.renderAtCenter(x + w - this.halfSize, y + this.halfSize);
        GL11.glDisable((int)2960);
        GL11.glStencilFunc((int)519, (int)0, (int)255);
        GL11.glPopAttrib();
    }

    public void render(float alphaMult) {
    }

    public void advance(float amount) {
        uiElapsed += amount;
        if (ticking) {
            if ((uiLoopVolume += amount) > 1.0f) {
                uiLoopVolume = 1.0f;
            }
            Global.getSoundPlayer().playUILoop("ui_specialist_intel_loop", 1.0f, uiLoopVolume * 0.5f);
            Global.getSector().getCampaignUI().suppressMusic(0.8f);
        } else if ((uiLoopVolume -= amount) < 0.0f) {
            uiLoopVolume = 0.0f;
        }
    }

    public static void stopTicking() {
        ticking = false;
    }

    public static void resumeTicking() {
        ticking = true;
    }
}

