/*
 * Decompiled with CFR 0.152.
 */
package ungp.scripts.campaign.specialist.intel;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignClockAPI;
import com.fs.starfarer.api.campaign.CustomUIPanelPlugin;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.ui.CustomPanelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.UIComponentAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import ungp.scripts.campaign.UNGP_InGameData;
import ungp.scripts.campaign.UNGP_Settings;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeInfo;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeManager;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeProgress;
import ungp.scripts.campaign.specialist.intel.UNGP_SpecialistBackgroundUI;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;
import ungp.scripts.ui.UIRect;
import ungp.scripts.utils.Constants;

public class UNGP_ChallengeIntel
extends BaseIntelPlugin {
    private List<UNGP_ChallengeProgress> underGoingChallenge;
    private int monthChecker;
    private int dayChecker;

    public UNGP_ChallengeIntel(List<UNGP_ChallengeProgress> progresses) {
        Global.getSector().addScript((EveryFrameScript)this);
        this.monthChecker = Global.getSector().getClock().getMonth();
        this.dayChecker = Global.getSector().getClock().getDay();
        this.underGoingChallenge = progresses;
    }

    protected void notifyEnded() {
        super.notifyEnded();
        Global.getSector().removeScript((EveryFrameScript)this);
    }

    public void updateChallengeProgress(UNGP_InGameData inGameData) {
        ArrayList<String> activeRuleIds = new ArrayList<String>();
        int positiveRuleAmount = 0;
        List<UNGP_RulesManager.URule> activatedRules = inGameData.getActivatedRules();
        for (UNGP_RulesManager.URule rule : activatedRules) {
            activeRuleIds.add(rule.getId());
            if (!rule.isPositive()) continue;
            ++positiveRuleAmount;
        }
        boolean shouldLockRepick = false;
        for (UNGP_ChallengeProgress progress : this.underGoingChallenge) {
            if (progress.getState() != UNGP_ChallengeProgress.ProgressState.RUNNING) continue;
            UNGP_ChallengeInfo challengeInfo = UNGP_ChallengeManager.getChallengeInfo(progress.getChallengeId());
            if (challengeInfo.canReselectRules() && challengeInfo.shouldBeCancelled(positiveRuleAmount, activeRuleIds)) {
                progress.setState(UNGP_ChallengeProgress.ProgressState.CANCELLED);
            }
            if (progress.getState() == UNGP_ChallengeProgress.ProgressState.CANCELLED) {
                this.sendUpdateIfPlayerHasIntel(progress, false);
                continue;
            }
            boolean isCompleted = true;
            isCompleted &= challengeInfo.getDurationByMonth() <= progress.getElapsedMonth();
            if (challengeInfo.isNeedMaxLevel()) {
                isCompleted &= UNGP_Settings.reachMaxLevel();
            }
            if (challengeInfo.getDpToDefeat() > 0) {
                isCompleted &= (float)challengeInfo.getDpToDefeat() <= progress.getDefeatedDp();
            }
            if (isCompleted) {
                progress.setState(UNGP_ChallengeProgress.ProgressState.COMPLETED);
            }
            if (isCompleted) {
                inGameData.completeChallenge(progress.getChallengeId());
                this.sendUpdateIfPlayerHasIntel(progress, false);
                continue;
            }
            if (challengeInfo.canReselectRules()) continue;
            shouldLockRepick = true;
        }
        UNGP_ChallengeManager.setRepickLock(shouldLockRepick);
    }

    protected void advanceImpl(float amount) {
        CampaignClockAPI clock = Global.getSector().getClock();
        int curMonth = clock.getMonth();
        int curDay = clock.getDay();
        if (curMonth != this.monthChecker) {
            this.monthChecker = curMonth;
            for (UNGP_ChallengeProgress progress : this.underGoingChallenge) {
                if (progress.getState() != UNGP_ChallengeProgress.ProgressState.RUNNING) continue;
                progress.advanceMonth();
            }
        }
        if (curDay != this.dayChecker) {
            this.dayChecker = curDay;
            UNGP_InGameData inGameData = UNGP_InGameData.getDataInSave();
            this.updateChallengeProgress(inGameData);
        }
    }

    public void createLargeDescription(CustomPanelAPI panel, float width, float height) {
        TooltipMakerAPI imageTooltip;
        UNGP_RulesManager.URule unlockRule;
        UNGP_ChallengeInfo challengeInfo;
        UNGP_SpecialistBackgroundUI.resumeTicking();
        CustomPanelAPI customPanel = panel.createCustomPanel(width, height, (CustomUIPanelPlugin)new UNGP_SpecialistBackgroundUI());
        panel.addComponent((UIComponentAPI)customPanel);
        UIRect fullScreenRect = new UIRect(0.0f, 0.0f, width, height).shrink(40.0f);
        TooltipMakerAPI tooltip = fullScreenRect.beginTooltip(panel, true);
        ArrayList<UNGP_ChallengeProgress> runningProgress = new ArrayList<UNGP_ChallengeProgress>();
        ArrayList<UNGP_ChallengeProgress> cancelledProgress = new ArrayList<UNGP_ChallengeProgress>();
        ArrayList<UNGP_ChallengeProgress> completedProgress = new ArrayList<UNGP_ChallengeProgress>();
        for (UNGP_ChallengeProgress progress : this.underGoingChallenge) {
            switch (progress.getState()) {
                case RUNNING: {
                    runningProgress.add(progress);
                    break;
                }
                case CANCELLED: {
                    cancelledProgress.add(progress);
                    break;
                }
                case COMPLETED: {
                    completedProgress.add(progress);
                }
            }
        }
        Color grayColor = Misc.getGrayColor();
        if (!runningProgress.isEmpty()) {
            tooltip.setParaOrbitronLarge();
            tooltip.addPara(Constants.rules_i18n.get("challenge_intel_running"), Misc.getPositiveHighlightColor(), 0.0f);
            tooltip.setParaFontDefault();
            for (UNGP_ChallengeProgress progress : runningProgress) {
                challengeInfo = UNGP_ChallengeManager.getChallengeInfo(progress.getChallengeId());
                challengeInfo.createTooltip(tooltip, 10.0f, progress);
            }
        }
        if (!cancelledProgress.isEmpty()) {
            tooltip.addSpacer(20.0f);
            tooltip.setParaOrbitronLarge();
            tooltip.addPara(Constants.rules_i18n.get("challenge_intel_cancelled"), Misc.getNegativeHighlightColor(), 0.0f);
            tooltip.setParaFontDefault();
            for (UNGP_ChallengeProgress progress : cancelledProgress) {
                challengeInfo = UNGP_ChallengeManager.getChallengeInfo(progress.getChallengeId());
                unlockRule = challengeInfo.getMilestoneToUnlock();
                if (unlockRule == null) continue;
                imageTooltip = tooltip.beginImageWithText(unlockRule.getSpritePath(), 64.0f);
                imageTooltip.addPara(challengeInfo.getName(), grayColor, 0.0f);
                tooltip.addImageWithText(10.0f);
            }
        }
        if (!completedProgress.isEmpty()) {
            tooltip.addSpacer(20.0f);
            tooltip.setParaOrbitronLarge();
            tooltip.addPara(Constants.rules_i18n.get("challenge_intel_completed"), Misc.getHighlightColor(), 0.0f);
            tooltip.setParaFontDefault();
            for (UNGP_ChallengeProgress progress : completedProgress) {
                challengeInfo = UNGP_ChallengeManager.getChallengeInfo(progress.getChallengeId());
                unlockRule = challengeInfo.getMilestoneToUnlock();
                if (unlockRule == null) continue;
                imageTooltip = tooltip.beginImageWithText(unlockRule.getSpritePath(), 64.0f);
                imageTooltip.addPara(challengeInfo.getName(), Misc.getHighlightColor(), 0.0f);
                tooltip.addImageWithText(10.0f);
            }
        }
        fullScreenRect.addTooltip();
    }

    public boolean hasLargeDescription() {
        return true;
    }

    public boolean hasSmallDescription() {
        return false;
    }

    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color c = this.getTitleColor(mode);
        float pad = 3.0f;
        float opad = 10.0f;
        if (this.listInfoParam instanceof UNGP_ChallengeProgress) {
            UNGP_ChallengeProgress progress = (UNGP_ChallengeProgress)this.listInfoParam;
            UNGP_ChallengeInfo challengeInfo = UNGP_ChallengeManager.getChallengeInfo(progress.getChallengeId());
            Color nameColor = c;
            String desc = "";
            switch (progress.getState()) {
                case RUNNING: {
                    nameColor = UNGP_RulesManager.getMilestoneColor();
                    desc = Constants.rules_i18n.get("challenge_intel_running");
                    break;
                }
                case CANCELLED: {
                    nameColor = Misc.getNegativeHighlightColor();
                    desc = Constants.rules_i18n.get("challenge_intel_cancelled");
                    break;
                }
                case COMPLETED: {
                    nameColor = h;
                    desc = Constants.rules_i18n.get("challenge_intel_completed");
                }
            }
            info.addPara(challengeInfo.getName(), nameColor, 0.0f);
            this.bullet(info);
            info.addPara(desc, g, pad);
            this.unindent(info);
        } else {
            info.addPara(this.getName(), Misc.getNegativeHighlightColor(), 0.0f);
            this.bullet(info);
            info.addPara(this.getDesc(), g, pad);
            this.unindent(info);
        }
    }

    public String getDesc() {
        return Constants.rules_i18n.get("challenge_intel_desc");
    }

    public String getName() {
        return Constants.rules_i18n.get("challenge_intel_name");
    }

    public String getIcon() {
        UNGP_ChallengeProgress progress;
        UNGP_ChallengeInfo challengeInfo;
        UNGP_RulesManager.URule rule;
        if (this.listInfoParam instanceof UNGP_ChallengeProgress && (rule = (challengeInfo = UNGP_ChallengeManager.getChallengeInfo((progress = (UNGP_ChallengeProgress)this.listInfoParam).getChallengeId())).getMilestoneToUnlock()) != null) {
            return rule.getSpritePath();
        }
        return Global.getSettings().getSpriteName("icons", "UNGP_specialist_mode_logo");
    }

    public Set<String> getIntelTags(SectorMapAPI map) {
        Set tags = super.getIntelTags(map);
        tags.add("ungp");
        return tags;
    }

    public IntelInfoPlugin.IntelSortTier getSortTier() {
        return IntelInfoPlugin.IntelSortTier.TIER_0;
    }

    public List<UNGP_ChallengeProgress> getUnderGoingChallenges() {
        return this.underGoingChallenge;
    }
}

