/*
 * Decompiled with CFR 0.152.
 */
package ungp.scripts.campaign.specialist.challenges;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ungp.scripts.campaign.UNGP_InGameData;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeInfo;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeLoader;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeProgress;
import ungp.scripts.campaign.specialist.intel.UNGP_ChallengeIntel;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;

public class UNGP_ChallengeManager {
    private static final Map<String, UNGP_ChallengeInfo> ID_TO_CHALLENGE_INFO_MAP = new HashMap<String, UNGP_ChallengeInfo>();
    public static final String LOCK_REPICK_KEY = "UNGP_challenge_lockRepick";
    private static final transient List<String> TEMPORARY_COMPLETED_CHALLENGES = new ArrayList<String>();

    public static void updateChallengeProgress(UNGP_InGameData inGameData) {
        if (Global.getSector().getIntelManager().hasIntelOfClass(UNGP_ChallengeIntel.class)) {
            UNGP_ChallengeIntel challengeIntel = (UNGP_ChallengeIntel)Global.getSector().getIntelManager().getFirstIntel(UNGP_ChallengeIntel.class);
            challengeIntel.updateChallengeProgress(inGameData);
        }
    }

    public static List<UNGP_ChallengeProgress> getUndergoingChallenges() {
        if (Global.getSector().getIntelManager().hasIntelOfClass(UNGP_ChallengeIntel.class)) {
            UNGP_ChallengeIntel challengeIntel = (UNGP_ChallengeIntel)Global.getSector().getIntelManager().getFirstIntel(UNGP_ChallengeIntel.class);
            return challengeIntel.getUnderGoingChallenges();
        }
        return new ArrayList<UNGP_ChallengeProgress>();
    }

    public static void initOrReloadChallengeInfos() {
        ID_TO_CHALLENGE_INFO_MAP.clear();
        ID_TO_CHALLENGE_INFO_MAP.putAll(UNGP_ChallengeLoader.loadAllInfos());
    }

    public static UNGP_ChallengeIntel confirmChallenges(UNGP_InGameData inGameData) {
        if (!UNGP_ChallengeManager.isDifficultyEnough(inGameData.getDifficulty())) {
            return null;
        }
        Global.getSector().getPersistentData().put("UNGP_challenge_start", true);
        if (!Global.getSector().getIntelManager().hasIntelOfClass(UNGP_ChallengeIntel.class)) {
            ArrayList<UNGP_ChallengeProgress> challengeProgresses = new ArrayList<UNGP_ChallengeProgress>();
            List<UNGP_ChallengeInfo> runnableChallenges = UNGP_ChallengeManager.getRunnableChallenges(inGameData);
            for (UNGP_ChallengeInfo challenge : runnableChallenges) {
                UNGP_ChallengeProgress progress = new UNGP_ChallengeProgress(challenge.getId());
                challengeProgresses.add(progress);
            }
            if (!challengeProgresses.isEmpty()) {
                UNGP_ChallengeIntel challengeIntel = new UNGP_ChallengeIntel(challengeProgresses);
                Global.getSector().getIntelManager().addIntel((IntelInfoPlugin)challengeIntel);
                return challengeIntel;
            }
        }
        return null;
    }

    public static List<UNGP_ChallengeInfo> getRunnableChallenges(UNGP_InGameData inGameData) {
        return UNGP_ChallengeManager.getRunnableChallenges(inGameData.getDifficulty(), inGameData.getActivatedRules(), inGameData.getCompletedChallenges());
    }

    public static List<UNGP_ChallengeInfo> getRunnableChallenges(UNGP_SpecialistSettings.Difficulty difficulty, List<UNGP_RulesManager.URule> rules, List<String> completedChallenges) {
        rules = new ArrayList<UNGP_RulesManager.URule>(rules);
        if (!UNGP_ChallengeManager.isDifficultyEnough(difficulty)) {
            return new ArrayList<UNGP_ChallengeInfo>();
        }
        ArrayList<String> activeRuleIds = new ArrayList<String>();
        int positiveRuleAmount = 0;
        for (UNGP_RulesManager.URule rule : rules) {
            activeRuleIds.add(rule.getId());
            if (!rule.isPositive()) continue;
            ++positiveRuleAmount;
        }
        List<UNGP_ChallengeInfo> challengeInfosCopy = UNGP_ChallengeManager.getChallengeInfosCopy();
        ArrayList<UNGP_ChallengeInfo> runnableChallenges = new ArrayList<UNGP_ChallengeInfo>();
        for (UNGP_ChallengeInfo challengeInfo : challengeInfosCopy) {
            if (completedChallenges.contains(challengeInfo.getId()) || challengeInfo.isAbovePositiveLimitation(positiveRuleAmount) || !challengeInfo.isRulesRequiredIncluded(activeRuleIds)) continue;
            runnableChallenges.add(challengeInfo);
        }
        return runnableChallenges;
    }

    public static boolean isDifficultyEnough(UNGP_SpecialistSettings.Difficulty difficulty) {
        return difficulty == UNGP_SpecialistSettings.Difficulty.ALPHA || difficulty == UNGP_SpecialistSettings.Difficulty.OMEGA;
    }

    public static boolean isChallengesStarted() {
        return Global.getSector().getPersistentData().containsKey("UNGP_challenge_start");
    }

    public static boolean isRepickLockedByChallenges() {
        Map persistentData = Global.getSector().getPersistentData();
        Boolean locked = (Boolean)persistentData.get(LOCK_REPICK_KEY);
        return locked != null && locked != false;
    }

    public static void setRepickLock(boolean lock) {
        Global.getSector().getPersistentData().put(LOCK_REPICK_KEY, lock);
    }

    public static UNGP_ChallengeInfo getChallengeInfo(String id) {
        return ID_TO_CHALLENGE_INFO_MAP.get(id);
    }

    public static List<UNGP_ChallengeInfo> getChallengeInfosCopy() {
        return new ArrayList<UNGP_ChallengeInfo>(ID_TO_CHALLENGE_INFO_MAP.values());
    }

    public static void setTemporaryCompletedChallenges(List<String> challenges) {
        TEMPORARY_COMPLETED_CHALLENGES.clear();
        TEMPORARY_COMPLETED_CHALLENGES.addAll(challenges);
    }

    public static List<String> getTemporaryCompletedChallenges() {
        return TEMPORARY_COMPLETED_CHALLENGES;
    }
}

