/*
 * Decompiled with CFR 0.152.
 */
package ungp.scripts.campaign.specialist.challenges;

import com.fs.starfarer.api.Global;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeInfo;

public class UNGP_ChallengeLoader {
    public static final String EMPTY = "[EMPTY]";
    private static final String FILE_PATH = "data/campaign/UNGP_challenges.csv";

    public static Map<String, UNGP_ChallengeInfo> loadAllInfos() {
        HashMap<String, UNGP_ChallengeInfo> challengeInfoMap = new HashMap<String, UNGP_ChallengeInfo>();
        try {
            JSONArray challengeInfos = Global.getSettings().getMergedSpreadsheetDataForMod("id", FILE_PATH, "ungp");
            int len = challengeInfos.length();
            for (int i = 0; i < len; ++i) {
                String milestoneToUnlock;
                boolean canReselectRules;
                boolean needMaxLevel;
                int dpToDefeat;
                int durationByMonth;
                int positiveLimitation;
                String name;
                UNGP_ChallengeInfo challengeInfo;
                String rulesRequired;
                JSONObject row = challengeInfos.getJSONObject(i);
                String id = row.optString("id", EMPTY);
                if (UNGP_ChallengeLoader.isEmpty(id) || UNGP_ChallengeLoader.isEmpty(rulesRequired = row.optString("rulesRequired", EMPTY))) continue;
                ArrayList<String> rulesRequiredList = new ArrayList<String>();
                if (!UNGP_ChallengeLoader.isEmpty(rulesRequired)) {
                    String[] tagArray;
                    for (String s : tagArray = rulesRequired.split(",")) {
                        rulesRequiredList.add(s.trim());
                    }
                }
                if (!(challengeInfo = new UNGP_ChallengeInfo(id, name = row.optString("name", EMPTY), rulesRequiredList, positiveLimitation = row.optInt("positiveLimitation", -1), durationByMonth = row.optInt("durationByMonth", -1), dpToDefeat = row.optInt("dpToDefeat", -1), needMaxLevel = row.optBoolean("needMaxLevel", true), canReselectRules = row.optBoolean("canReselectRules", true), milestoneToUnlock = row.optString("milestoneToUnlock", ""))).isValid()) continue;
                challengeInfoMap.put(id, challengeInfo);
            }
        }
        catch (Exception e) {
            Global.getLogger(UNGP_ChallengeLoader.class).error((Object)e);
            throw new RuntimeException("Failed to load UNGP challenges:", e);
        }
        return challengeInfoMap;
    }

    public static boolean isEmpty(String target) {
        return target == null || target.isEmpty() || target.contentEquals(EMPTY);
    }
}

