/*
 * Decompiled with CFR 0.152.
 */
package ungp.scripts.campaign.specialist.challenges;

import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeProgress;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;
import ungp.scripts.utils.Constants;

public final class UNGP_ChallengeInfo {
    private String id;
    private String name;
    private List<UNGP_RulesManager.URule> rulesRequired;
    private int positiveLimitation;
    private int durationByMonth;
    private int dpToDefeat;
    private boolean needMaxLevel;
    private boolean canReselectRules;
    private UNGP_RulesManager.URule milestoneToUnlock;
    private boolean isValid = true;

    public UNGP_ChallengeInfo(String id, String name, List<String> rulesRequired, int positiveLimitation, int durationByMonth, int dpToDefeat, boolean needMaxLevel, boolean canReselectRules, String milestoneToUnlock) {
        this.id = id;
        this.name = name;
        this.positiveLimitation = positiveLimitation;
        this.durationByMonth = durationByMonth;
        this.needMaxLevel = needMaxLevel;
        this.canReselectRules = canReselectRules;
        this.dpToDefeat = dpToDefeat;
        this.rulesRequired = new ArrayList<UNGP_RulesManager.URule>();
        for (String ruleID : rulesRequired) {
            UNGP_RulesManager.URule rule = UNGP_RulesManager.URule.getByID(ruleID);
            if (rule != null) {
                this.rulesRequired.add(rule);
                continue;
            }
            this.isValid = false;
            return;
        }
        UNGP_RulesManager.URule mileStoneUnlock = UNGP_RulesManager.URule.getByID(milestoneToUnlock);
        if (mileStoneUnlock == null) {
            this.isValid = false;
            return;
        }
        this.milestoneToUnlock = mileStoneUnlock;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<UNGP_RulesManager.URule> getRulesRequired() {
        return this.rulesRequired;
    }

    public boolean isRulesRequiredIncluded(List<String> rules) {
        ArrayList<String> rulesRequiredIDs = new ArrayList<String>();
        for (UNGP_RulesManager.URule rule : this.rulesRequired) {
            rulesRequiredIDs.add(rule.getId());
        }
        return rules.containsAll(rulesRequiredIDs);
    }

    public int getPositiveLimitation() {
        return this.positiveLimitation;
    }

    public boolean isPositiveLimited() {
        return this.positiveLimitation != -1;
    }

    public boolean isAbovePositiveLimitation(int ruleAmount) {
        return this.isPositiveLimited() && ruleAmount > this.positiveLimitation;
    }

    public boolean shouldBeCancelled(int positiveRuleAmount, List<String> currentRuleIDs) {
        return this.isAbovePositiveLimitation(positiveRuleAmount) || !this.isRulesRequiredIncluded(currentRuleIDs);
    }

    public int getDurationByMonth() {
        return this.durationByMonth;
    }

    public int getDpToDefeat() {
        return this.dpToDefeat;
    }

    public boolean isNeedMaxLevel() {
        return this.needMaxLevel;
    }

    public UNGP_RulesManager.URule getMilestoneToUnlock() {
        return this.milestoneToUnlock;
    }

    public String getConnectedRuleNames() {
        StringBuilder sb = new StringBuilder();
        for (UNGP_RulesManager.URule rule : this.rulesRequired) {
            sb.append(rule.getName()).append("+");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public String getConnectedRuleNamesReplacedWithEscapeCharacter() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.rulesRequired.size(); ++i) {
            sb.append(" %s ");
            sb.append("+");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public String[] getRuleNames() {
        String[] array = new String[this.rulesRequired.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.rulesRequired.get(i).getName();
        }
        return array;
    }

    public Color[] getRuleColors() {
        Color[] array = new Color[this.rulesRequired.size()];
        for (int i = 0; i < array.length; ++i) {
            UNGP_RulesManager.URule rule = this.rulesRequired.get(i);
            array[i] = rule.getCorrectColor().darker();
        }
        return array;
    }

    public void createTooltip(TooltipMakerAPI tooltip, float pad, UNGP_ChallengeProgress progress) {
        UNGP_RulesManager.URule unlockRule = this.milestoneToUnlock;
        if (unlockRule != null) {
            TooltipMakerAPI imageTooltip = tooltip.beginImageWithText(unlockRule.getSpritePath(), 64.0f);
            imageTooltip.addPara(this.name, UNGP_RulesManager.getMilestoneColor(), 0.0f);
            Color grayColor = Misc.getGrayColor();
            this.showChallengeDetails(imageTooltip, grayColor, progress);
            tooltip.addImageWithText(pad);
        }
    }

    public void showChallengeDetails(TooltipMakerAPI tooltip, Color color, UNGP_ChallengeProgress progress) {
        tooltip.addPara(Constants.rules_i18n.get("challenge_tip_rules_prefix") + this.getConnectedRuleNamesReplacedWithEscapeCharacter(), 5.0f, color, color, this.getRuleNames()).setHighlightColors(this.getRuleColors());
        if (this.getDurationByMonth() == -1) {
            tooltip.addPara(Constants.rules_i18n.get("challenge_tip_desc0_1"), color, 0.0f);
        } else {
            tooltip.addPara(Constants.rules_i18n.get("challenge_tip_desc0_0"), color, 0.0f);
            if (this.isNeedMaxLevel()) {
                tooltip.addPara(Constants.rules_i18n.get("challenge_tip_desc1"), color, 0.0f);
            }
        }
        if (this.getDpToDefeat() > 0) {
            if (progress != null) {
                tooltip.addPara(Constants.rules_i18n.format("challenge_tip_desc4", "" + this.getDpToDefeat()) + "(" + (int)progress.getDefeatedDp() + "/" + this.getDpToDefeat() + ")", color, 0.0f);
            } else {
                tooltip.addPara(Constants.rules_i18n.format("challenge_tip_desc4", "" + this.getDpToDefeat()), color, 0.0f);
            }
        }
        if (this.getPositiveLimitation() >= 0) {
            tooltip.addPara(Constants.rules_i18n.format("challenge_tip_desc2", "" + this.getPositiveLimitation()), color, 0.0f);
        }
        if (!this.canReselectRules()) {
            tooltip.addPara(Constants.rules_i18n.get("challenge_tip_desc3"), color, 0.0f);
        }
    }

    public boolean canReselectRules() {
        return this.canReselectRules;
    }

    public boolean isValid() {
        return this.isValid;
    }
}

