/*
 * Decompiled with CFR 0.152.
 */
package ungp.scripts.campaign.intel;

import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.Set;
import ungp.scripts.campaign.background.UNGP_Background;
import ungp.scripts.campaign.background.UNGP_BackgroundManager;
import ungp.scripts.utils.Constants;

public class UNGP_BackgroundIntel
extends BaseIntelPlugin {
    private SectorEntityToken systemLocation;

    public UNGP_BackgroundIntel(StarSystemAPI system) {
        this.systemLocation = system == null ? null : system.getHyperspaceAnchor();
    }

    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        info.addSectionHeading(Constants.backgrounds_i18n.get("background"), Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Alignment.MID, 0.0f);
        UNGP_Background background = UNGP_BackgroundManager.getPlayerBackground();
        if (background != null) {
            background.addShortDescTooltipWithIcon(info, 10.0f);
        }
    }

    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        UNGP_Background background = UNGP_BackgroundManager.getPlayerBackground();
        if (background != null) {
            info.addPara(background.getName(), background.getNameColor(), 0.0f);
        }
    }

    public String getIcon() {
        UNGP_Background background = UNGP_BackgroundManager.getPlayerBackground();
        if (background != null) {
            return background.getSpritePath();
        }
        return null;
    }

    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.systemLocation;
    }

    public Set<String> getIntelTags(SectorMapAPI map) {
        Set tags = super.getIntelTags(map);
        tags.add("ungp");
        return tags;
    }
}

