/*
 * Decompiled with CFR 0.152.
 */
package ungp.scripts.campaign.inherit;

import com.fs.starfarer.api.Global;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;
import org.lazywizard.lazylib.JSONUtils;
import ungp.api.saves.UNGP_DataSaverAPI;
import ungp.scripts.campaign.inherit.UNGP_InheritData;

public class UNGP_InheritManager {
    public static UNGP_InheritData InheritData_slot0 = null;
    public static UNGP_InheritData InheritData_slot1 = null;
    public static UNGP_InheritData InheritData_slot2 = null;
    private static final String FILE_NAME_PREFIX = "UNGP_inherit";

    public static boolean loadAllSlots() {
        InheritData_slot0 = UNGP_InheritManager.load(0);
        InheritData_slot1 = UNGP_InheritManager.load(1);
        InheritData_slot2 = UNGP_InheritManager.load(2);
        if (InheritData_slot0 == null && InheritData_slot1 == null && InheritData_slot2 == null) {
            InheritData_slot0 = UNGP_InheritData.createEmptyData();
            return true;
        }
        return false;
    }

    public static void clearSlots() {
        InheritData_slot0 = null;
        InheritData_slot1 = null;
        InheritData_slot2 = null;
    }

    public static UNGP_InheritData getDataFromSlot(int slotID) {
        if (slotID == 0) {
            return InheritData_slot0;
        }
        if (slotID == 1) {
            return InheritData_slot1;
        }
        if (slotID == 2) {
            return InheritData_slot2;
        }
        return null;
    }

    public static void saveDataToSlot(UNGP_InheritData inheritData, int slotID) {
        try {
            JSONUtils.CommonDataJSONObject jsonObject = new JSONUtils.CommonDataJSONObject(UNGP_InheritManager.getSaveFileName(slotID));
            jsonObject.put("ungp_id", (Object)inheritData.ungp_id);
            jsonObject.put("lastPlayerName", (Object)inheritData.lastPlayerName);
            jsonObject.put("cycle", inheritData.cycle);
            jsonObject.put("completedChallenges", inheritData.completedChallenges);
            for (UNGP_DataSaverAPI dataSaver : inheritData.dataSavers) {
                dataSaver.saveDataToSavepointSlot((JSONObject)jsonObject);
            }
            jsonObject.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static UNGP_InheritData load(int slotID) {
        UNGP_InheritData inheritData = new UNGP_InheritData();
        try {
            JSONUtils.CommonDataJSONObject jsonObject = JSONUtils.loadCommonJSON((String)UNGP_InheritManager.getSaveFileName(slotID));
            if (!jsonObject.has("cycle")) {
                return null;
            }
            inheritData.ungp_id = jsonObject.optString("ungp_id", "[Empty]");
            inheritData.lastPlayerName = jsonObject.optString("lastPlayerName", "[Anonymous]");
            inheritData.cycle = jsonObject.getInt("cycle");
            inheritData.completedChallenges = new ArrayList<String>();
            inheritData.dataSavers = new ArrayList<UNGP_DataSaverAPI>();
            for (UNGP_DataSaverAPI saverInstance : UNGP_InheritData.getSaverInstancesCopy()) {
                UNGP_DataSaverAPI emptySaver = saverInstance.createEmptySaver();
                emptySaver.loadDataFromSavepointSlot((JSONObject)jsonObject);
                inheritData.dataSavers.add(emptySaver);
            }
            JSONArray array = jsonObject.optJSONArray("completedChallenges");
            if (array != null) {
                for (int i = 0; i < array.length(); ++i) {
                    inheritData.completedChallenges.add(array.getString(i));
                }
            }
            return inheritData;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static boolean savePointsExist() {
        return Global.getSettings().fileExistsInCommon(UNGP_InheritManager.getSaveFileName(0)) || Global.getSettings().fileExistsInCommon(UNGP_InheritManager.getSaveFileName(1)) || Global.getSettings().fileExistsInCommon(UNGP_InheritManager.getSaveFileName(2));
    }

    private static String getSaveFileName(int slotID) {
        Object fileName = FILE_NAME_PREFIX;
        if (slotID > 0) {
            fileName = (String)fileName + slotID;
        }
        return fileName;
    }
}

