/*
 * Decompiled with CFR 0.152.
 */
package ungp.scripts.campaign.inherit;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;
import ungp.api.saves.UNGP_DataSaverAPI;
import ungp.scripts.campaign.UNGP_InGameData;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeInfo;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeManager;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;
import ungp.scripts.utils.Constants;

public class UNGP_InheritData {
    private static final List<UNGP_DataSaverAPI> SAVER_INSTANCES = new ArrayList<UNGP_DataSaverAPI>();
    public static final String DEFAULT_NAME = "[Anonymous]";
    public static final String BULLETED_PREFIX = "       ";
    public String ungp_id;
    public String lastPlayerName;
    public int cycle;
    public List<String> completedChallenges;
    public List<UNGP_DataSaverAPI> dataSavers;
    private static final String SAVER_CLASS_PATH = "data/campaign/UNGP_dataSavers.csv";

    public static UNGP_InheritData createInheritData(UNGP_InGameData inGameData) {
        UNGP_InheritData inheritData = new UNGP_InheritData();
        inheritData.ungp_id = UUID.randomUUID().toString();
        inheritData.lastPlayerName = Global.getSector().getPlayerPerson().getNameString();
        inheritData.cycle = inGameData.getCurCycle() + 1;
        inheritData.completedChallenges = new ArrayList<String>(inGameData.getCompletedChallenges());
        inheritData.dataSavers = new ArrayList<UNGP_DataSaverAPI>();
        for (UNGP_DataSaverAPI saverInstance : SAVER_INSTANCES) {
            inheritData.dataSavers.add(saverInstance.createSaverBasedOnCurrentGame(inGameData));
        }
        return inheritData;
    }

    public static UNGP_InheritData createEmptyData() {
        UNGP_InheritData inheritData = new UNGP_InheritData();
        inheritData.ungp_id = UUID.randomUUID().toString();
        inheritData.lastPlayerName = Constants.root_i18n.get("defaultSlotName");
        inheritData.cycle = 1;
        inheritData.completedChallenges = new ArrayList<String>();
        inheritData.dataSavers = new ArrayList<UNGP_DataSaverAPI>();
        for (UNGP_DataSaverAPI saverInstance : SAVER_INSTANCES) {
            inheritData.dataSavers.add(saverInstance.createEmptySaver());
        }
        return inheritData;
    }

    public void addInheritTooltip(TooltipMakerAPI root) {
        this.addDescriptionTooltip(root, "inheritData");
    }

    public void addRecordTooltip(TooltipMakerAPI root, UNGP_SpecialistSettings.Difficulty difficulty) {
        this.addDescriptionTooltip(root, "inGameData");
    }

    public void addDescriptionTooltip(TooltipMakerAPI root, String descKey) {
        TooltipMakerAPI section;
        Color hl = Misc.getHighlightColor();
        if (!this.lastPlayerName.contentEquals(DEFAULT_NAME)) {
            section = root.beginImageWithText("graphics/icons/reports/officers24.png", 24.0f);
            section.addPara(Constants.root_i18n.get(descKey + "_0") + "%s", 0.0f, hl, new String[]{"" + this.cycle});
            section.addPara(Constants.root_i18n.get(descKey + "_1") + "%s", 3.0f, hl, new String[]{this.lastPlayerName});
            root.addImageWithText(5.0f);
        }
        for (UNGP_DataSaverAPI dataSaver : this.dataSavers) {
            dataSaver.addSaverInfo(root, descKey);
        }
        section = root.beginImageWithText("graphics/icons/reports/hazard_pay2.png", 24.0f);
        section.addPara(Constants.root_i18n.get(descKey + "_4"), 3.0f);
        root.addImageWithText(5.0f);
        root.setBulletedListMode(BULLETED_PREFIX);
        if (this.completedChallenges.isEmpty()) {
            root.addPara(Constants.root_i18n.get("challenge_empty"), Misc.getGrayColor(), 5.0f);
        } else {
            for (String challengeId : this.completedChallenges) {
                UNGP_ChallengeInfo challengeInfo = UNGP_ChallengeManager.getChallengeInfo(challengeId);
                if (challengeInfo == null) continue;
                root.addPara(challengeInfo.getName(), UNGP_RulesManager.getMilestoneColor(), 5.0f);
            }
        }
        root.setBulletedListMode(null);
    }

    public Color getColorByCycle() {
        if (this.cycle < 5) {
            return Misc.getButtonTextColor();
        }
        if (this.cycle < 10) {
            return UNGP_SpecialistSettings.Difficulty.GAMMA.color;
        }
        if (this.cycle < 25) {
            return UNGP_SpecialistSettings.Difficulty.BETA.color;
        }
        if (this.cycle < 50) {
            return UNGP_SpecialistSettings.Difficulty.ALPHA.color;
        }
        if (this.cycle < 100) {
            return UNGP_SpecialistSettings.Difficulty.OMEGA.color;
        }
        return UNGP_RulesManager.getGoldenColor();
    }

    public String getPrefixByCycle() {
        if (this.cycle < 5) {
            return "";
        }
        if (this.cycle < 10) {
            return "I - ";
        }
        if (this.cycle < 25) {
            return "II - ";
        }
        if (this.cycle < 50) {
            return "III - ";
        }
        if (this.cycle < 100) {
            return "IV - ";
        }
        return "V - ";
    }

    public <T extends UNGP_DataSaverAPI> T getFirstSaverOfClass(Class<T> saverClass) {
        for (UNGP_DataSaverAPI dataSaver : this.dataSavers) {
            if (!saverClass.isInstance(dataSaver)) continue;
            return (T)dataSaver;
        }
        return null;
    }

    public static List<UNGP_DataSaverAPI> getSaverInstancesCopy() {
        return new ArrayList<UNGP_DataSaverAPI>(SAVER_INSTANCES);
    }

    public static void loadAllSavers() {
        try {
            ClassLoader classLoader = Global.getSettings().getScriptClassLoader();
            JSONArray ruleInfos = Global.getSettings().getMergedSpreadsheetDataForMod("id", SAVER_CLASS_PATH, "ungp");
            int len = ruleInfos.length();
            for (int i = 0; i < len; ++i) {
                JSONObject row = ruleInfos.getJSONObject(i);
                String saverClassName = row.getString("saverClass");
                Class<?> saverClass = classLoader.loadClass(saverClassName);
                SAVER_INSTANCES.add((UNGP_DataSaverAPI)saverClass.newInstance());
            }
        }
        catch (Exception e) {
            Global.getLogger(UNGP_InheritData.class).error((Object)e);
            throw new RuntimeException("Failed to load UNGP ungp.data savers:", e);
        }
    }
}

