/*
 * Decompiled with CFR 0.152.
 */
package ungp.scripts.campaign.everyframe;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.HashMap;

public final class UNGP_UITimeScript
implements EveryFrameScript {
    private boolean isPaused = false;
    private long systemTime;
    private HashMap<String, IntervalUtil> intervalMap = new HashMap();

    public UNGP_UITimeScript() {
        this.reset();
    }

    public static UNGP_UITimeScript getInstance() {
        for (EveryFrameScript transientScript : Global.getSector().getTransientScripts()) {
            if (!(transientScript instanceof UNGP_UITimeScript)) continue;
            return (UNGP_UITimeScript)transientScript;
        }
        UNGP_UITimeScript script = new UNGP_UITimeScript();
        Global.getSector().addTransientScript((EveryFrameScript)script);
        return script;
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return true;
    }

    public void advance(float amount) {
        if (this.isPaused) {
            return;
        }
        if (this.intervalMap.isEmpty()) {
            return;
        }
        long curSystemTime = System.nanoTime();
        long diff = curSystemTime - this.systemTime;
        float deltaTime = Math.min((float)diff / 1.0E9f, 1.0f);
        for (IntervalUtil interval : this.intervalMap.values()) {
            if (!(deltaTime < interval.getIntervalDuration())) continue;
            interval.advance(deltaTime);
        }
        this.systemTime = curSystemTime;
    }

    public void setPaused(boolean paused) {
        this.isPaused = paused;
        this.reset();
    }

    public static float getFactor(String intervalID) {
        IntervalUtil intervalUtil = UNGP_UITimeScript.getInstance().intervalMap.get(intervalID);
        if (intervalUtil != null) {
            return Math.min(intervalUtil.getElapsed() / intervalUtil.getIntervalDuration(), 1.0f);
        }
        return 0.0f;
    }

    public void reset() {
        this.systemTime = System.nanoTime();
    }

    public static void addInterval(String id, IntervalUtil interval) {
        UNGP_UITimeScript script = UNGP_UITimeScript.getInstance();
        script.intervalMap.put(id, interval);
        script.reset();
    }

    public static void removeInterval(String id) {
        UNGP_UITimeScript script = UNGP_UITimeScript.getInstance();
        script.intervalMap.remove(id);
    }
}

