/*
 * Decompiled with CFR 0.152.
 */
package ungp.scripts.campaign.everyframe;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignUIAPI;
import com.fs.starfarer.api.campaign.CoreUITabId;
import com.fs.starfarer.api.campaign.listeners.CampaignInputListener;
import com.fs.starfarer.api.campaign.listeners.CampaignUIRenderingListener;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lazywizard.lazylib.FastTrig;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Rectangle;
import ungp.scripts.campaign.UNGP_Settings;
import ungp.scripts.campaign.specialist.UNGP_SpecialistManager;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;
import ungp.scripts.campaign.specialist.intel.UNGP_SpecialistIntel;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;
import ungp.scripts.utils.UNGP_Progress;

public class UNGP_SpecialistWidgetPlugin
implements EveryFrameScript,
CampaignUIRenderingListener,
CampaignInputListener {
    private static final float BASIC_ICON_ALPHA = 0.4f;
    private static final float SMALL_ICON_SIZE = 32.0f;
    private static final Rectangle WIDGET_RECT = new Rectangle(10, (int)Global.getSettings().getScreenHeightPixels() - 120, 80, 80);
    private UNGP_Progress moveOverAndWaitProgress = new UNGP_Progress(0.2f);
    private SpriteAPI layer0 = Global.getSettings().getSprite("fx", "UNGP_specialist_icon_layer0");
    private SpriteAPI layer1 = Global.getSettings().getSprite("fx", "UNGP_specialist_icon_layer1");
    private float targetIconAlphaMult = 0.0f;
    private float currentIconAlphaMult = 0.0f;
    private float elapsed = 0.0f;
    private boolean enabled = true;

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return true;
    }

    public UNGP_SpecialistWidgetPlugin() {
        Global.getSector().getListenerManager().addListener((Object)this, true);
        UNGP_SpecialistWidgetPlugin.updateUI();
    }

    public static void updateUI() {
        List transientScripts = Global.getSector().getTransientScripts();
        for (EveryFrameScript script : transientScripts) {
            if (!(script instanceof UNGP_SpecialistWidgetPlugin)) continue;
            ((UNGP_SpecialistWidgetPlugin)script).enabled = UNGP_Settings.isLeftTopSpecialistWidgetShown();
            break;
        }
    }

    public static boolean inWidgetRect(int x, int y) {
        return WIDGET_RECT.contains(x, y);
    }

    public void advance(float amount) {
        if (!this.enabled) {
            return;
        }
        if (!UNGP_SpecialistManager.isSpecialistMode()) {
            return;
        }
        if (Global.getSector().isFastForwardIteration()) {
            return;
        }
        if (Global.getSector().isPaused()) {
            return;
        }
        this.elapsed += amount;
        this.targetIconAlphaMult = 0.4f;
        if (UNGP_SpecialistWidgetPlugin.inWidgetRect(Mouse.getX(), Mouse.getY())) {
            this.targetIconAlphaMult = 0.4f + this.moveOverAndWaitProgress.getProgress() * 0.6f;
            this.moveOverAndWaitProgress.advance(amount);
        } else {
            this.moveOverAndWaitProgress.reset();
        }
        this.targetIconAlphaMult = Math.min(1.0f, Math.max(0.0f, this.targetIconAlphaMult));
        this.currentIconAlphaMult = Misc.interpolate((float)this.currentIconAlphaMult, (float)this.targetIconAlphaMult, (float)(5.0f * amount));
    }

    private void renderIcons(List<UNGP_RulesManager.URule> bonusRules, float y) {
        for (int i = 0; i < bonusRules.size(); ++i) {
            float x = (float)WIDGET_RECT.getX() + (float)i * 35.0f;
            SpriteAPI icon = Global.getSettings().getSprite(bonusRules.get(i).getSpritePath());
            icon.setSize(32.0f, 32.0f);
            icon.setAlphaMult(0.7f);
            icon.render(x, y);
        }
    }

    public int getListenerInputPriority() {
        return 1000;
    }

    public void processCampaignInputPreCore(List<InputEventAPI> events) {
    }

    public void processCampaignInputPreFleetControl(List<InputEventAPI> events) {
        if (UNGP_SpecialistManager.isSpecialistMode()) {
            for (InputEventAPI event : events) {
                if (event.isConsumed() || !event.isLMBDownEvent() || !UNGP_SpecialistWidgetPlugin.inWidgetRect(event.getX(), event.getY())) continue;
                Global.getSector().getCampaignUI().showCoreUITab(CoreUITabId.INTEL, (Object)UNGP_SpecialistIntel.getInstance());
                Global.getSoundPlayer().playUISound("ui_button_pressed", 1.0f, 1.0f);
                event.consume();
                break;
            }
        }
    }

    public void processCampaignInputPostCore(List<InputEventAPI> events) {
    }

    public void renderInUICoordsBelowUI(ViewportAPI viewport) {
    }

    public void renderInUICoordsAboveUIBelowTooltips(ViewportAPI viewport) {
    }

    public void renderInUICoordsAboveUIAndTooltips(ViewportAPI viewport) {
        if (!this.enabled) {
            return;
        }
        if (!UNGP_SpecialistManager.isSpecialistMode()) {
            return;
        }
        CampaignUIAPI campaignUI = Global.getSector().getCampaignUI();
        if (campaignUI.isShowingDialog() || campaignUI.isShowingMenu() || campaignUI.getCurrentCoreTab() != null) {
            return;
        }
        UNGP_SpecialistSettings.Difficulty difficulty = UNGP_RulesManager.getGlobalDifficulty();
        float alphaMult = viewport.getAlphaMult();
        GL11.glBlendFunc((int)770, (int)771);
        float iconCenterX = (float)WIDGET_RECT.getX() + (float)WIDGET_RECT.getWidth() / 2.0f;
        float iconCenterY = (float)WIDGET_RECT.getY() + (float)WIDGET_RECT.getHeight() / 2.0f;
        float size = (float)(110.0 * (1.0 + (double)0.1f * FastTrig.sin((double)this.elapsed)));
        this.layer0.setAngle(MathUtils.clampAngle((float)(this.elapsed * 60.0f)));
        this.layer0.setAlphaMult(this.currentIconAlphaMult * alphaMult);
        this.layer0.setWidth(size);
        this.layer0.setHeight(size);
        this.layer0.setAdditiveBlend();
        this.layer0.renderAtCenter(iconCenterX, iconCenterY);
        size = (float)(128.0 * (1.0 + (double)0.1f * FastTrig.cos((double)this.elapsed)));
        this.layer1.setAngle(MathUtils.clampAngle((float)(-this.elapsed * 30.0f)));
        this.layer1.setAlphaMult(this.currentIconAlphaMult * 0.6f * alphaMult);
        this.layer1.setWidth(size);
        this.layer1.setHeight(size);
        this.layer1.setColor(difficulty.color);
        this.layer1.setAdditiveBlend();
        this.layer1.renderAtCenter(iconCenterX, iconCenterY);
        this.layer1.setColor(Color.white);
        this.layer1.setAngle(MathUtils.clampAngle((float)(this.elapsed * 30.0f)));
        this.layer1.setSize(size * 1.5f, size * 1.5f);
        this.layer1.setAlphaMult(this.currentIconAlphaMult * 0.4f * alphaMult);
        this.layer1.renderAtCenter(iconCenterX, iconCenterY);
        size = 64.0f;
        SpriteAPI character = Global.getSettings().getSprite(difficulty.spritePath);
        character.setSize(size, size);
        character.setAlphaMult((float)((double)0.8f + (double)0.2f * FastTrig.cos((double)(this.elapsed + 233.0f))) * alphaMult);
        character.renderAtCenter(iconCenterX, iconCenterY);
        if (UNGP_SpecialistWidgetPlugin.inWidgetRect(Mouse.getX(), Mouse.getY()) && this.moveOverAndWaitProgress.getProgress() > 0.7f) {
            ArrayList<UNGP_RulesManager.URule> bonusRules = new ArrayList<UNGP_RulesManager.URule>();
            ArrayList<UNGP_RulesManager.URule> notBonusRules = new ArrayList<UNGP_RulesManager.URule>();
            for (UNGP_RulesManager.URule rule : UNGP_RulesManager.ACTIVATED_RULES_IN_THIS_GAME) {
                if (rule.isPositive()) {
                    bonusRules.add(rule);
                    continue;
                }
                notBonusRules.add(rule);
            }
            Collections.sort(bonusRules, new UNGP_RulesManager.UNGP_RuleSorter());
            Collections.sort(notBonusRules, new UNGP_RulesManager.UNGP_RuleSorter());
            float iconGroup_y = (float)WIDGET_RECT.getY() - 5.0f - 32.0f;
            this.renderIcons(bonusRules, iconGroup_y);
            this.renderIcons(notBonusRules, iconGroup_y -= 37.0f);
        }
    }
}

