/*
 * Decompiled with CFR 0.152.
 */
package ungp.scripts.campaign.everyframe;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.BuffManagerAPI;
import com.fs.starfarer.api.campaign.CampaignClockAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.List;
import org.lwjgl.input.Keyboard;
import ungp.api.rules.tags.UNGP_CampaignTag;
import ungp.api.rules.tags.UNGP_PlayerFleetMemberTag;
import ungp.api.rules.tags.UNGP_PlayerFleetTag;
import ungp.scripts.campaign.UNGP_InGameData;
import ungp.scripts.campaign.UNGP_Settings;
import ungp.scripts.campaign.specialist.UNGP_PlayerFleetMemberBuff;
import ungp.scripts.campaign.specialist.UNGP_SpecialistManager;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;
import ungp.scripts.campaign.ui.UNGP_InteractionDialog;
import ungp.scripts.utils.Constants;

public class UNGP_CampaignPlugin
implements EveryFrameScript {
    private static final String KEY = "UNGP_cam";
    private static final float BASE_BUFF_DURATION = 0.1f;
    private UNGP_InGameData inGameData;
    private IntervalUtil inheritChecker = new IntervalUtil(1.0f, 1.0f);
    private int oneDayChecker = -1;
    private int oneYearChecker = -1;
    private int oneMonthChecker = -1;
    private float newGameCheckDays = 0.1f;
    private boolean newGameChecked = false;
    private boolean shouldShowDialog = false;

    public static UNGP_CampaignPlugin getInstance() {
        UNGP_CampaignPlugin plugin = (UNGP_CampaignPlugin)Global.getSector().getPersistentData().get(KEY);
        if (plugin != null) {
            return plugin;
        }
        throw new RuntimeException("Something wrong with UNGP, you may best reboot your game...");
    }

    public UNGP_CampaignPlugin() {
        this.inGameData = new UNGP_InGameData();
        Global.getSector().getPersistentData().put(KEY, this);
        CampaignClockAPI clock = Global.getSector().getClock();
        this.oneDayChecker = clock.getDay();
        this.oneMonthChecker = clock.getMonth();
        this.oneYearChecker = clock.getCycle();
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return true;
    }

    public void advance(float amount) {
        if (UNGP_RulesManager.isCacheNeedUpdate()) {
            UNGP_RulesManager.updateRulesCache();
        }
        boolean isPaused = Global.getSector().isPaused();
        SectorAPI sector = Global.getSector();
        CampaignClockAPI clock = sector.getClock();
        if (!isPaused && !this.inGameData.isPassedInheritTime()) {
            float days = clock.convertToDays(amount);
            if (!this.newGameChecked) {
                if (this.newGameCheckDays > 0.0f) {
                    this.newGameCheckDays -= days;
                } else {
                    this.newGameChecked = true;
                    sector.getCampaignUI().showConfirmDialog(Constants.root_i18n.get("gameStartMessage"), Constants.root_i18n.get("confirm"), Constants.root_i18n.get("cancel"), new Script(){

                        public void run() {
                            UNGP_CampaignPlugin.this.shouldShowDialog = true;
                        }
                    }, null);
                }
            }
            this.inheritChecker.advance(days);
            if (this.inheritChecker.intervalElapsed()) {
                this.inGameData.setPassedInheritTime(true);
            }
        }
        if (!sector.getCampaignUI().isShowingDialog()) {
            if (Keyboard.isKeyDown((int)UNGP_Settings.getShowMenuKey1()) && Keyboard.isKeyDown((int)UNGP_Settings.getShowMenuKey2())) {
                this.shouldShowDialog = true;
            }
            if (this.shouldShowDialog && this.showUNGPDialog()) {
                this.shouldShowDialog = false;
            }
        }
        if (!UNGP_SpecialistManager.isSpecialistMode()) {
            return;
        }
        int currentDay = clock.getDay();
        int currentYear = clock.getCycle();
        int currentMonth = clock.getMonth();
        TempCampaignParams params = new TempCampaignParams();
        if (currentDay != this.oneDayChecker) {
            this.oneDayChecker = currentDay;
            params.oneDayPassed = true;
            if (Global.getSettings().isDevMode()) {
                for (int i = 0; i < 10; ++i) {
                    this.inGameData.addTimesToChangeSpecialistMode();
                }
            }
        }
        if (currentMonth != this.oneMonthChecker) {
            this.oneMonthChecker = currentMonth;
            params.oneMonthPassed = true;
        }
        if (currentYear != this.oneYearChecker) {
            this.oneYearChecker = currentYear;
            params.oneYearPassed = true;
            this.inGameData.addTimesToChangeSpecialistMode();
        }
        if (isPaused) {
            amount = 0.0f;
        }
        for (UNGP_CampaignTag uNGP_CampaignTag : UNGP_RulesManager.CAMPAIGN_TAGS_ITG) {
            uNGP_CampaignTag.advanceInCampaign(amount, params);
        }
        CampaignFleetAPI playerFleet = sector.getPlayerFleet();
        if (playerFleet == null) {
            return;
        }
        for (UNGP_PlayerFleetTag tag : UNGP_RulesManager.PLAYER_FLEET_TAGS_ITG) {
            tag.applyPlayerFleetStats(playerFleet);
        }
        if (!UNGP_RulesManager.PLAYER_FLEET_MEMBER_TAGS_ITG.isEmpty()) {
            boolean bl;
            boolean bl2 = false;
            List members = playerFleet.getFleetData().getMembersListCopy();
            for (FleetMemberAPI member : members) {
                BuffManagerAPI buffManager = member.getBuffManager();
                for (UNGP_PlayerFleetMemberTag tag : UNGP_RulesManager.PLAYER_FLEET_MEMBER_TAGS_ITG) {
                    if (!tag.canApply(member)) continue;
                    BuffManagerAPI.Buff test = buffManager.getBuff(tag.getBuffID());
                    if (test instanceof UNGP_PlayerFleetMemberBuff) {
                        UNGP_PlayerFleetMemberBuff buff = (UNGP_PlayerFleetMemberBuff)test;
                        buff.setDur(0.1f);
                        buff.setTag(tag);
                        continue;
                    }
                    buffManager.addBuff((BuffManagerAPI.Buff)new UNGP_PlayerFleetMemberBuff(tag, 0.1f));
                    bl = true;
                }
            }
            if (bl || UNGP_PlayerFleetMemberBuff.isShouldForceSyncNextStep()) {
                playerFleet.forceSync();
                UNGP_PlayerFleetMemberBuff.completeForceSync();
            }
        }
    }

    public boolean showUNGPDialog() {
        this.newGameChecked = true;
        return Global.getSector().getCampaignUI().showInteractionDialog((InteractionDialogPlugin)new UNGP_InteractionDialog(this.inGameData), (SectorEntityToken)Global.getSector().getPlayerFleet());
    }

    public UNGP_InGameData getInGameData() {
        return this.inGameData;
    }

    public static class TempCampaignParams {
        private boolean oneDayPassed = false;
        private boolean oneMonthPassed = false;
        private boolean oneYearPassed = false;

        public boolean isOneYearPassed() {
            return this.oneYearPassed;
        }

        public boolean isOneMonthPassed() {
            return this.oneMonthPassed;
        }

        public boolean isOneDayPassed() {
            return this.oneDayPassed;
        }
    }
}

