/*
 * Decompiled with CFR 0.152.
 */
package ungp.scripts.campaign.background;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import ungp.api.backgrounds.UNGP_BackgroundPluginAPI;
import ungp.impl.backgrounds.UNGP_Nothing;
import ungp.scripts.campaign.background.UNGP_Background;
import ungp.scripts.utils.UNGPUtils;

public class UNGP_BackgroundManager {
    public static final String MEM_PLAYER_BACKGROUND_KEY = "$UNGP_player_background";
    private static final String FILE_PATH = "data/campaign/UNGP_backgrounds.csv";
    private static final Map<String, UNGP_Background> BACKGROUND_MAP = new HashMap<String, UNGP_Background>();
    private static UNGP_Background DEFAULT_BACKGROUND;

    public static void loadAllBackgrounds() {
        ClassLoader classLoader = Global.getSettings().getScriptClassLoader();
        try {
            JSONArray backgroundJsonRows = Global.getSettings().getMergedSpreadsheetDataForMod("id", FILE_PATH, "ungp");
            int len = backgroundJsonRows.length();
            for (int i = 0; i < len; ++i) {
                SpriteAPI sprite;
                JSONObject row = backgroundJsonRows.getJSONObject(i);
                String id = row.optString("id", "[EMPTY]");
                if (UNGPUtils.isEmpty(id)) continue;
                String name = row.optString("name", "[EMPTY]");
                float order = (float)row.optDouble("order", 10000.0);
                String shortDesc = row.optString("short", "[EMPTY]");
                String desc = row.optString("desc", "[EMPTY]");
                if (UNGPUtils.isEmpty(desc)) {
                    desc = shortDesc;
                }
                String spritePath = row.optString("spritePath", "[EMPTY]");
                String extra1 = row.optString("extra1", "[EMPTY]");
                String extra2 = row.optString("extra2", "[EMPTY]");
                String source = row.optString("source", "[EMPTY]");
                String effectPluginName = row.getString("effectPlugin");
                String tags = row.optString("tags", "[EMPTY]");
                ArrayList<String> tagList = new ArrayList<String>();
                if (!UNGPUtils.isEmpty(tags)) {
                    String[] tagArray;
                    for (String s : tagArray = tags.split(",")) {
                        tagList.add(s.trim());
                    }
                }
                UNGP_BackgroundPluginAPI backgroundPlugin = null;
                if (!UNGPUtils.isEmpty(effectPluginName)) {
                    Class<?> effectClass = classLoader.loadClass(effectPluginName);
                    backgroundPlugin = (UNGP_BackgroundPluginAPI)effectClass.newInstance();
                } else {
                    backgroundPlugin = new UNGP_Nothing();
                }
                if (UNGPUtils.isEmpty(spritePath)) {
                    spritePath = "graphics/portraits/portrait_generic.png";
                }
                if ((sprite = Global.getSettings().getSprite(spritePath)) == null || sprite.getHeight() < 1.0f) {
                    Global.getSettings().loadTexture(spritePath);
                }
                UNGP_Background background = new UNGP_Background(id, order, name, shortDesc, desc, spritePath, source, extra1, extra2, tagList, backgroundPlugin);
                BACKGROUND_MAP.put(id, background);
                if (!id.contentEquals("nothing")) continue;
                DEFAULT_BACKGROUND = background;
            }
        }
        catch (Exception e) {
            Global.getLogger(UNGP_BackgroundManager.class).error((Object)e);
            throw new RuntimeException("Failed to load UNGP backgrounds:", e);
        }
        if (DEFAULT_BACKGROUND == null) {
            throw new RuntimeException("Failed to find default UNGP background: nothing");
        }
    }

    public static List<UNGP_Background> getSortedBackgroundsCopy() {
        ArrayList<UNGP_Background> backgrounds = new ArrayList<UNGP_Background>(BACKGROUND_MAP.values());
        Collections.sort(backgrounds, new Comparator<UNGP_Background>(){

            @Override
            public int compare(UNGP_Background o1, UNGP_Background o2) {
                return Float.compare(o1.getOrder(), o2.getOrder());
            }
        });
        return backgrounds;
    }

    public static UNGP_Background getDefaultBackground() {
        return DEFAULT_BACKGROUND;
    }

    public static UNGP_Background getPlayerBackground() {
        MemoryAPI memoryWithoutUpdate = Global.getSector().getCharacterData().getMemoryWithoutUpdate();
        if (memoryWithoutUpdate.contains(MEM_PLAYER_BACKGROUND_KEY)) {
            return BACKGROUND_MAP.get(memoryWithoutUpdate.getString(MEM_PLAYER_BACKGROUND_KEY));
        }
        return DEFAULT_BACKGROUND;
    }

    public static void setPlayerBackground(UNGP_Background background) {
        Global.getSector().getCharacterData().getMemoryWithoutUpdate().set(MEM_PLAYER_BACKGROUND_KEY, (Object)background.getId());
    }
}

