/*
 * Decompiled with CFR 0.152.
 */
package ungp.scripts.campaign.background;

import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import ungp.api.backgrounds.UNGP_BackgroundPluginAPI;
import ungp.scripts.campaign.inherit.UNGP_InheritData;
import ungp.scripts.utils.Constants;
import ungp.scripts.utils.UNGPUtils;

public class UNGP_Background {
    private String id;
    private float order;
    private String name;
    private String shortDescription;
    private String description;
    private String spritePath;
    private String source;
    private String extra1;
    private String extra2;
    private List<String> tags;
    private UNGP_BackgroundPluginAPI plugin;

    public UNGP_Background(String id, float order, String name, String shortDescription, String description, String spritePath, String source, String extra1, String extra2, List<String> tags, UNGP_BackgroundPluginAPI plugin) {
        this.id = id;
        this.order = order;
        this.name = name;
        this.shortDescription = shortDescription;
        this.description = description;
        this.spritePath = spritePath;
        this.source = source;
        this.extra1 = extra1;
        this.extra2 = extra2;
        this.tags = tags;
        this.plugin = plugin;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public float getOrder() {
        return this.order;
    }

    public UNGP_BackgroundPluginAPI getPlugin() {
        return this.plugin;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getSpritePath() {
        return this.spritePath;
    }

    public String getSource() {
        return this.source;
    }

    public String getExtra1() {
        return this.extra1;
    }

    public String getExtra2() {
        return this.extra2;
    }

    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }

    public Color getNameColor() {
        if (this.plugin != null && this.plugin.getOverrideNameColor() != null) {
            return this.plugin.getOverrideNameColor();
        }
        return Misc.getBasePlayerColor();
    }

    public void addShortDescTooltipWithIcon(TooltipMakerAPI tooltip, float pad) {
        TooltipMakerAPI imageWithText = tooltip.beginImageWithText(this.getSpritePath(), 64.0f);
        imageWithText.setParaOrbitronLarge();
        imageWithText.addPara(this.getName(), this.getNameColor(), 10.0f);
        imageWithText.getPrev().getPosition().setXAlignOffset(7.0f);
        imageWithText.setParaFontDefault();
        imageWithText.addPara(this.getShortDescription(), Misc.getGrayColor(), 5.0f);
        imageWithText.addSpacer(10.0f);
        tooltip.addImageWithText(pad);
    }

    public void addShortDescTooltip(TooltipMakerAPI tooltip) {
        tooltip.addPara(this.getName(), this.getNameColor(), 10.0f);
        tooltip.addPara(this.getShortDescription(), 5.0f);
    }

    public void addDescriptionTooltip(TooltipMakerAPI tooltip, UNGP_InheritData pickedInheritData) {
        this.addDescriptionTooltip(tooltip, pickedInheritData, true);
    }

    public void addDescriptionTooltip(TooltipMakerAPI tooltip, UNGP_InheritData pickedInheritData, boolean showLimit) {
        TooltipMakerAPI imageWithText = tooltip.beginImageWithText(this.getSpritePath(), 64.0f);
        imageWithText.setParaOrbitronLarge();
        imageWithText.addPara(this.getName(), this.getNameColor(), 0.0f);
        if (!UNGPUtils.isEmpty(this.source)) {
            imageWithText.setParaSmallInsignia();
            imageWithText.addPara(Constants.backgrounds_i18n.get("source") + this.getSource(), Misc.getGrayColor(), 0.0f);
        }
        imageWithText.setParaFontDefault();
        imageWithText.addPara(this.getDescription(), Misc.getBrightPlayerColor(), 5.0f).italicize();
        tooltip.addImageWithText(0.0f);
        UNGP_BackgroundPluginAPI plugin = this.getPlugin();
        if (plugin != null) {
            plugin.addPostDescTooltip(tooltip, pickedInheritData);
            tooltip.addSpacer(10.0f);
            this.addOverallBonusTooltip(tooltip, pickedInheritData, showLimit);
        }
    }

    public void addOverallBonusTooltip(TooltipMakerAPI tooltip, UNGP_InheritData pickedInheritData, boolean showLimit) {
        this.plugin.addInheritCreditsAndBPsTooltip(tooltip, pickedInheritData);
        tooltip.addSpacer(5.0f);
        this.plugin.addBonusTooltip(tooltip, pickedInheritData, showLimit);
        if (showLimit) {
            tooltip.addSpacer(10.0f);
            tooltip.setParaOrbitronLarge();
            tooltip.addPara(Constants.root_i18n.get("inheritData_0") + "%s", 0.0f, Misc.getBasePlayerColor(), Misc.getHighlightColor(), new String[]{"" + pickedInheritData.cycle});
            tooltip.setParaFontDefault();
        }
    }

    public static class BackgroundTooltipCreator
    implements TooltipMakerAPI.TooltipCreator {
        private UNGP_Background background;
        private UNGP_InheritData pickedInheritData;
        private float width;

        public BackgroundTooltipCreator(UNGP_Background background, UNGP_InheritData pickedInheritData, float width) {
            this.background = background;
            this.pickedInheritData = pickedInheritData;
            this.width = width;
        }

        public boolean isTooltipExpandable(Object tooltipParam) {
            return false;
        }

        public float getTooltipWidth(Object tooltipParam) {
            return this.width;
        }

        public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
            this.background.addDescriptionTooltip(tooltip, this.pickedInheritData);
        }
    }
}

