/*
 * Decompiled with CFR 0.152.
 */
package ungp.scripts.campaign;

import com.fs.starfarer.api.combat.MutableStat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import ungp.scripts.campaign.UNGP_Settings;
import ungp.scripts.campaign.everyframe.UNGP_CampaignPlugin;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;
import ungp.scripts.utils.UNGPUtils;

public final class UNGP_InGameData {
    private int curCycle = 1;
    private UNGP_SpecialistSettings.Difficulty difficulty = null;
    private boolean isRecorded = false;
    private boolean inherited = false;
    private boolean passedInheritTime = false;
    private boolean isHardMode = false;
    private float timesToChangeSpecialistMode = 0.0f;
    private MutableStat changeTimeStat = new MutableStat(1.0f);
    private List<String> activatedRuleIDs = new ArrayList<String>();
    private List<String> completedChallenges = new ArrayList<String>();

    public static UNGP_InGameData getDataInSave() {
        return UNGP_CampaignPlugin.getInstance().getInGameData();
    }

    public int getTimesToChangeSpecialistMode() {
        return (int)this.timesToChangeSpecialistMode;
    }

    public void reduceTimesToChangeSpecialistMode() {
        this.timesToChangeSpecialistMode -= 1.0f;
    }

    public void addTimesToChangeSpecialistMode() {
        float timeToAdd = this.changeTimeStat.getModifiedValue();
        this.timesToChangeSpecialistMode += timeToAdd;
    }

    public void completeChallenge(String id) {
        this.completedChallenges.add(id);
        UNGPUtils.clearDuplicatedIdsInList(this.completedChallenges);
    }

    public void saveActivatedRules(List<UNGP_RulesManager.URule> newRules) {
        ArrayList<String> oldRules = new ArrayList<String>(this.activatedRuleIDs);
        this.activatedRuleIDs.clear();
        HashSet<String> ruleSet = new HashSet<String>();
        for (UNGP_RulesManager.URule rule : newRules) {
            String ruleId = rule.getId();
            ruleSet.add(ruleId);
            oldRules.remove(ruleId);
        }
        for (String ruleId : oldRules) {
            UNGP_RulesManager.URule rule = UNGP_RulesManager.URule.getByID(ruleId);
            if (rule == null) continue;
            rule.getRuleEffect().cleanUp();
        }
        this.activatedRuleIDs.addAll(ruleSet);
    }

    public List<UNGP_RulesManager.URule> getActivatedRules() {
        ArrayList<UNGP_RulesManager.URule> results = new ArrayList<UNGP_RulesManager.URule>();
        for (UNGP_RulesManager.URule rule : UNGP_RulesManager.getAllRulesCopy()) {
            if (!this.activatedRuleIDs.contains(rule.getId())) continue;
            results.add(rule);
        }
        return results;
    }

    public boolean couldStartRecord() {
        if (!this.isRecorded()) {
            if (UNGP_Settings.isNoLevelLimit()) {
                return true;
            }
            return UNGP_Settings.reachMaxLevel();
        }
        return UNGP_Settings.isNoTimesLimit();
    }

    public UNGP_SpecialistSettings.Difficulty getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(UNGP_SpecialistSettings.Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    public int getCurCycle() {
        return this.curCycle;
    }

    public boolean isHardMode() {
        return this.isHardMode;
    }

    public void setHardMode(boolean hardMode) {
        this.isHardMode = hardMode;
    }

    public boolean isRecorded() {
        return this.isRecorded;
    }

    public void setRecorded(boolean recorded) {
        this.isRecorded = recorded;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    public boolean isPassedInheritTime() {
        return this.passedInheritTime;
    }

    public void setPassedInheritTime(boolean passedInheritTime) {
        this.passedInheritTime = passedInheritTime;
    }

    public void setCurCycle(int curCycle) {
        this.curCycle = curCycle;
    }

    public MutableStat getChangeTimeStat() {
        return this.changeTimeStat;
    }

    public List<String> getCompletedChallenges() {
        return this.completedChallenges;
    }

    public void setCompletedChallenges(List<String> completedChallenges) {
        this.completedChallenges = new ArrayList<String>(completedChallenges);
    }
}

