/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.saves;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.MutableValue;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import ungp.api.saves.UNGP_DataSaverAPI;
import ungp.scripts.campaign.UNGP_InGameData;
import ungp.scripts.utils.Constants;

public class UNGP_CreditsDataSaver
implements UNGP_DataSaverAPI {
    protected int credits;

    @Override
    public UNGP_DataSaverAPI createSaverBasedOnCurrentGame(UNGP_InGameData inGameData) {
        UNGP_CreditsDataSaver dataSaver = new UNGP_CreditsDataSaver();
        dataSaver.credits = (int)Global.getSector().getPlayerFleet().getCargo().getCredits().get();
        return dataSaver;
    }

    @Override
    public UNGP_DataSaverAPI createEmptySaver() {
        return new UNGP_CreditsDataSaver();
    }

    @Override
    public void loadDataFromSavepointSlot(JSONObject jsonObject) throws JSONException {
        this.credits = jsonObject.optInt("credits", 0);
        if (this.getCredits() == 0 && jsonObject.has("inheritCredits")) {
            this.credits = jsonObject.optInt("inheritCredits", 0);
        }
    }

    @Override
    public void saveDataToSavepointSlot(JSONObject jsonObject) throws JSONException {
        jsonObject.put("credits", this.getCredits());
    }

    @Override
    public void startInheritDataFromSaver(TooltipMakerAPI root, Map<String, Object> params) {
        float inheritCreditsPercent = ((Float)params.get("inheritCreditsFactor")).floatValue();
        int creditsInherited = (int)((float)this.getCredits() * inheritCreditsPercent);
        MutableValue mutableCredits = Global.getSector().getPlayerFleet().getCargo().getCredits();
        float curCredits = mutableCredits.get();
        if (2.1474836E9f - curCredits < (float)creditsInherited) {
            mutableCredits.set(2.1474836E9f);
        } else {
            mutableCredits.add((float)creditsInherited);
        }
        if (Global.getSector().getCampaignUI().isShowingDialog()) {
            AddRemoveCommodity.addCreditsGainText((int)creditsInherited, (TextPanelAPI)Global.getSector().getCampaignUI().getCurrentInteractionDialog().getTextPanel());
        }
    }

    @Override
    public void addSaverInfo(TooltipMakerAPI root, String descKey) {
        TooltipMakerAPI section = root.beginImageWithText("graphics/icons/reports/generic_income.png", 24.0f);
        section.addPara(Constants.root_i18n.get(descKey + "_2"), 3.0f);
        root.addImageWithText(5.0f);
        root.addPara("       " + Misc.getDGSCredits((float)this.getCredits()), Misc.getHighlightColor(), 5.0f);
    }

    public int getCredits() {
        return this.credits;
    }

    public void addCredits(int credits) {
        this.credits = Integer.MAX_VALUE - this.credits <= credits ? Integer.MAX_VALUE : (this.credits += credits);
    }
}

